/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.FacConstants;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.ReportFile;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.util.AS400Enhanced;

public abstract class ReportFileHelper {
    public static String getFileName(String[] args, String fileName, String fileType) {
        String contextName = BatchJobHelper.getContextName(args);
        String environment = BatchJobHelper.getEnvironment(args);
        String company = BatchJobHelper.getCompany(args).replace('/', '-');
        String user = BatchJobHelper.getUser(args);
        String pathName = "";
        if (contextName != null) {
            pathName = "/home" + contextName + '/';
        }
        return pathName + LanguageHelper.getString("nl.ibs.fac.language", fileName) + ';' + environment + '-' + company + ';' + user + ';' + Calendar.getInstance().getTimeInMillis() + '.' + fileType;
    }

    public static String[] getDetailsFromFileName(String fileName) {
        String[] result = new String[]{fileName, null, null};
        try {
            int i = fileName.indexOf(59);
            if (i > -1) {
                int j = fileName.indexOf(59, i + 1);
                result[1] = fileName.substring(i + 1, j);
                int k = fileName.indexOf(59, j + 1);
                result[2] = fileName.substring(j + 1, k);
                int l = fileName.indexOf(".", k + 1);
                result[0] = fileName.substring(0, i) + fileName.substring(l);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static List getUserFiles(LoginHelper loginHelper) throws Exception {
        ArrayList<ReportFile> result = new ArrayList<ReportFile>();
        AS400Enhanced as400 = loginHelper.getAs400();
        IFSFile home = new IFSFile((AS400)as400, "/home" + FacConstants.getContextName());
        String[] files = home.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                IFSFile ifsFile = new IFSFile((AS400)as400, home, files[i]);
                ReportFile reportFile = new ReportFile(ifsFile);
                if (!loginHelper.getUser().equals(reportFile.getUser())) continue;
                result.add(reportFile);
            }
        }
        return result;
    }

    public static List getFiles(LoginHelper loginHelper) throws Exception {
        ArrayList<ReportFile> result = new ArrayList<ReportFile>();
        AS400Enhanced as400 = loginHelper.getAs400();
        IFSFile home = new IFSFile((AS400)as400, "/home" + FacConstants.getContextName());
        String[] files = home.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                IFSFile ifsFile = new IFSFile((AS400)as400, home, files[i]);
                result.add(new ReportFile(ifsFile));
            }
        }
        return result;
    }

    public static byte[] getBytes(LoginHelper loginHelper, String fileName) throws Exception {
        IFSFileInputStream stream = new IFSFileInputStream((AS400)loginHelper.getAs400(), "/home" + FacConstants.getContextName() + '/' + fileName);
        byte[] data = new byte[stream.available()];
        stream.read(data);
        stream.close();
        return data;
    }

    public static boolean delete(LoginHelper loginHelper, String fileName) throws Exception {
        return new IFSFile((AS400)loginHelper.getAs400(), "/home" + FacConstants.getContextName() + '/' + fileName).delete();
    }
}

