/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import nl.ibs.fac.BaseDepreciationCalculator;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Valuation;

public class WOZDepreciationCalculator
extends BaseDepreciationCalculator {
    private static final long serialVersionUID = 3316638207131664754L;

    public WOZDepreciationCalculator(Asset theAsset, Company theCompany, int theNumberOfPeriods, boolean theCredit, int theYearTo, int thePeriodTo, Valuation theValuation, boolean fullInterestIn1stPeriod) throws Exception {
        super(fullInterestIn1stPeriod);
        this.onePeriod = true;
        this.asset = theAsset;
        this.valuation = theValuation;
        this.initialize(this.asset.getDBData(), theCompany, theNumberOfPeriods, theCredit, theYearTo, thePeriodTo);
        this.setValuationAttributes(theValuation);
        this.validate();
        this.initializeCurrentPeriod();
    }

    public Collection calculate(int year, int period) throws Exception {
        this.values = new ArrayList();
        if (this.lastPeriod || PeriodHelper.isBefore(year, period, this.currentYear, this.currentPeriod)) {
            this.initializeCalculationValues();
            this.currentDepreciationAmount = null;
            this.currentInterestAmount = null;
            this.currentInterestPercentage = null;
            this.values.clear();
            this.values.add(new CalculationValue(this.currentReasonCode, this.currentYear, this.currentPeriod, this.currentDepreciationAmount, this.currentInterestAmount, this.asset, this.valuation, this.bookValue, this.acquisitionTotal, this.totalDepreciationAmount, this.totalInterestAmount, this.valPreviousBookvalueBalance, this.currentInterestPercentage, this.correction445, false, new BigDecimal("0")));
            return this.values;
        }
        if (this.firstTime) {
            if (!this.validateAssetState(this.valuation)) {
                return this.values;
            }
            this.validate();
            if (!this.doDepreciationCalculation && !this.doInterestCalculation) {
                return this.values;
            }
        }
        this.calculate();
        this.firstTime = !this.onePeriod;
        return this.values;
    }

    public int getCurrentPeriod() {
        return this.currentPeriod;
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    public void setCurrentDepreciationAmount(BigDecimal currentDepreciationAmount) {
        this.currentDepreciationAmount = currentDepreciationAmount;
        if (currentDepreciationAmount.doubleValue() == 0.0) {
            ++this.currentRemainingLife;
        }
    }
}

