/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.InvestmentBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;

public class AP2AcquisitionValueAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -907358665318269176L;
    public static final String PAGE = AP2AcquisitionValueAdapter.class.getName();
    public static final String RETURNPAGE = "AP2AcquisitionValueAdapterReturnPage";
    public static final String RETURNMETHOD = "AP2AcquisitionValueAdapterReturnMethod";
    private Company company;
    private Asset asset;
    private Window window;
    private FieldGroup investmentPanel = new FieldGroup();
    private BookYearPeriodGrid facYearPeriod;
    private BookYearPeriodGrid finYearPeriod;
    private FACDecimalField transactionValue = new FACDecimalField("Label.Amount", 15, 2);
    private Field description = new Field("Label.Description");
    private FieldGroup fgFBI;
    private InvestmentBP investmentBP;

    public AP2AcquisitionValueAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.investmentBP = new InvestmentBP(this.company, this.numberOfPeriods, "FAC");
        this.facYearPeriod = new BookYearPeriodGrid("Label.FACStartPeriod", "" + this.company.getCurrentBookYear(), this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.finYearPeriod = new BookYearPeriodGrid("Label.BookPeriod", false);
        this.investmentPanel.add((ESPGridLayout)this.facYearPeriod);
        this.investmentPanel.add((ESPGridLayout)this.finYearPeriod);
        this.transactionValue.setMandatory(true);
        this.investmentPanel.add((Field)this.transactionValue);
        this.description.setLength(30);
        this.description.setMaxLength(30);
        this.investmentPanel.add(this.description);
        FloatBar fb = new FloatBar();
        Action ok = new Action("Button.OK", null, null, this.getProcessAdapterPageName(PAGE), "createInvestment");
        ok.setDefault(true);
        ok.setValidationEnabled(true);
        fb.addAction(ok);
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("close"));
        this.fgFBI = new FieldGroup();
        this.fgFBI.forceBorder(false);
        this.fgFBI.add(fb);
    }

    public DataObject ap2AcquisitionValueForm(DataObject object) throws Exception {
        this.asset = (Asset)this.getProcess().getAttribute("ap2AcquisitionValueAsset");
        String message = this.investmentBP.hasNotPostedTransactions(this.asset);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        String[] yps = this.investmentBP.retrieveYearsAndPeriods(this.asset, null);
        this.facYearPeriod.setValues(yps[0], yps[1]);
        this.finYearPeriod.setValues(yps[2], yps[3]);
        this.transactionValue.setValue();
        this.transactionValue.requestFocus(true);
        this.description.setValue();
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "close");
        this.window.setLabel("Title.AdditionalInvestment");
        this.window.add(this.investmentPanel);
        this.window.add(this.fgFBI);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject createInvestment(DataObject object) throws Exception {
        this.investmentPanel.removeInvalidTags();
        boolean error = false;
        String[] messages = null;
        messages = this.investmentBP.validateFACYearAndPeriod(this.asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue());
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.facYearPeriod.setInvalidTag();
        }
        if ((messages = this.investmentBP.validateFINYearAndPeriod(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax))) != null) {
            error = true;
            this.addErrors(object, messages);
            this.finYearPeriod.setInvalidTag();
        }
        if ((messages = this.investmentBP.validateInvestmentValue(this.transactionValue.getBigDecimal())) != null) {
            error = true;
            this.addErrors(object, messages);
            this.transactionValue.setInvalidTag();
        }
        if (error) {
            return object;
        }
        String message = this.investmentBP.createInvestment(this.asset, false, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.description.getValue(), this.transactionValue.getBigDecimal(), null, true, this.loginHelper.getUser(), true, null, -1, -1);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        return this.close(object);
    }

    private void addErrors(DataObject object, String[] errors) throws Exception {
        for (int i = 0; i < errors.length; ++i) {
            if (errors[i] == null || errors[i].trim().length() <= 0) continue;
            object.addUIObject((UIObject)new Message(errors[i], "error"));
        }
    }

    public DataObject close(DataObject object) throws Exception {
        this.window.closeWindow(object);
        object.addUIObject((UIObject)new RedirectAction((String)this.getProcess().getAttribute(RETURNPAGE), (String)this.getProcess().getAttribute(RETURNMETHOD), this.getProcess().getProcessId()));
        return object;
    }
}

