/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.sql.Driver;
import nl.ibs.esp.dataobject.BinaryObject;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.fac.FacDBConfigProperties;
import nl.ibs.fac.FixVersion;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.session.StartStopServlet;

public class AboutAdapter
extends nl.ibs.esp.adapter.AboutAdapter {
    private static final long serialVersionUID = 169495837976489499L;

    public AboutAdapter(DataObject object) throws Exception {
        super(object);
        Action jobLog = new Action("jobLog").setAdapter(AboutAdapter.class.getName()).setMethod("jobLog");
        jobLog.setIsDownloadAction(true);
        this.addApplicationInfo("Label.ObjectLibrary", StartStopServlet.getObjectLibrary());
        this.addApplicationInfo("Label.ObjectLibraryVersion", StartStopServlet.getObjectLibraryVersion());
        this.addSystemInfo("Label.LogRoot", StartStopServlet.getLogRoot());
        this.addAction(jobLog);
    }

    protected String[][] getExtraInfo() {
        String[][] extraInfo = null;
        extraInfo = new String[][]{{"Label.Database", "Label.JDBCDriver", this.getDriverDescription()}, {"Label.Database", "Label.DBURL", FacDBConfigProperties.getURL()}, {"Label.Database", "Label.DBSchema", StartStopServlet.getLibrary()}, {"Label.Database", "Label.DBUser", FacDBConfigProperties.getUser()}};
        return extraInfo;
    }

    private String getDriverDescription() {
        String driver = FacDBConfigProperties.getJDBCDriver();
        String driverDescription = null;
        try {
            Driver driverClass = (Driver)Class.forName(driver).newInstance();
            driverDescription = driver;
            driverDescription = driverDescription + (driverClass.jdbcCompliant() ? " JDBC compliant, " : " NOT JDBC compliant, version ");
            driverDescription = driverDescription + driverClass.getMajorVersion() + "." + driverClass.getMinorVersion() + " ";
        }
        catch (Exception e) {
            return null;
        }
        return driverDescription;
    }

    public DataObject jobLog(DataObject object) throws Exception {
        LoginHelper loginHelper = (LoginHelper)object.getSessionAttribute(LoginHelper.LOGINHELPER);
        BinaryObject bobj = new BinaryObject(loginHelper.getAs400().getJobMessages(new StringBuffer()).toString().getBytes(), "application/vnd.ms-excel", object);
        bobj.openSaveAsDialog("JobLog.csv");
        return bobj;
    }

    public String getDescription() {
        return this.translate("Process.About");
    }

    public String getShortDescription() {
        return "Process.About.short";
    }

    public String getProcessIconUrl() {
        return "info.png";
    }

    protected String getApplicationName() {
        return "Fixed Assets Control";
    }

    protected String getApplicationVersion() {
        String version = "2025.01.001";
        String fixVersion = FixVersion.getFixVersion();
        if (fixVersion != null) {
            version = version + " FIX " + fixVersion;
        }
        if (this.dataObject.getSessionAttribute("GOV") != null) {
            version = version + " - " + "GOV";
        }
        return version;
    }

    protected String getUserDescription() {
        return "";
    }

    protected String getUserId() {
        return "";
    }
}

