/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.adapters.EnvironmentReferenceField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.boadapters.UserBO;
import nl.ibs.fac.db.User;

public class ActiveEnvironmentAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -4804098490284234493L;
    public static final String PAGE = ActiveEnvironmentAdapter.class.getName();
    private Window window;
    private FieldGroup fg;
    private EnvironmentReferenceField environmentReferenceField;
    private FloatBar fb;
    private User user;

    public ActiveEnvironmentAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        this.window = new Window(this.finish.getPageid(), this.finish.getMethod());
        this.fg = new FieldGroup();
        this.environmentReferenceField = new EnvironmentReferenceField();
        this.fb = new FloatBar();
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.window.setLabel("Title.ActiveEnvironment");
        this.window.setTop("10%");
        this.window.setRight("15%");
        this.user = (User)UserBO.get(this.loginHelper.getUser())[0];
        this.environmentReferenceField.setReadonly(this.user != null && this.user.getOneEnvironment());
        this.environmentReferenceField.setSelectableOnly(true);
        this.environmentReferenceField.setMandatory(true);
        this.environmentReferenceField.setValue(this.env);
        this.fg.add((Field)this.environmentReferenceField);
        this.window.add(this.fg);
        Action activate = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("activate");
        activate.setDefault(true);
        activate.setValidationEnabled(true);
        this.fb.addAction(activate);
        this.fb.addAction(this.finish);
        this.window.add(this.fb);
    }

    public DataObject show(DataObject object) throws Exception {
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject activate(DataObject object) throws Exception {
        if (this.activateEnvironment(object, this.environmentReferenceField.getEnvironment())) {
            return this.finish(object);
        }
        return object;
    }
}

