/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.language.TranslationHelperImpl;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Image;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.JournalingsTermEnum;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.AdditionalJournalingDataBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.AdditionalJournalingData;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.queries.AdditionalJournalingDataQuery;

public class AdditionalJournalingDataAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -2489088945387672539L;
    public static final String PAGE = AdditionalJournalingDataAdapter.class.getName();
    private CommonTable.SearchPanel searchPanel;
    private String[] fisNames;
    private String[] fisLabels;
    private String[] fisTypes;
    private short[] fisSizes;
    private Transformer[] fisTransformers;
    private String[] fisTooltips;
    private String[] fmsNames;
    private String[] fmsLabels;
    private String[] fmsTypes;
    private short[] fmsSizes;
    private Transformer[] fmsTransformers;
    private String[] fmsTooltips;
    private ODBTable table = null;
    private Action[] rowActions;
    private Action[] headerActions;
    private FloatBar fbShow;
    private FloatBar fbCreate;
    private FloatBar fbEdit;
    private FloatBar fbDelete;
    private Action closeWindow = new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("closeWindow");
    private Map inputComponents = new HashMap();
    private String[] searchAndFilterNames;
    private String[] searchAndFilterLabels;
    private Company company;
    private AdditionalJournalingData additionalJournalingData;
    private String[] finShortTexts = new String[5];
    private String[] finTexts = new String[5];
    private Window window;
    private FieldGroup fg1;
    private FieldGroup fg2;
    private ComboBox cbAccountingPrinciple = new ComboBox("Label.AccountingPrinciple");
    private AssetTypeReferenceField rfAssetType;
    private ComboBox cbJournalingTerms;
    private FinancialReferenceField[] dimensions = new FinancialReferenceField[5];
    private CheckBox cbSuppressStatNumbers;

    public AdditionalJournalingDataAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize();
    }

    private void initialize() throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.finShortTexts[0] = this.env.getShortName1();
        this.finShortTexts[1] = this.env.getShortName2();
        this.finShortTexts[2] = this.env.getShortName3();
        this.finShortTexts[3] = this.env.getShortName4();
        this.finShortTexts[4] = this.env.getShortName5();
        this.finTexts[0] = this.env.getName1();
        this.finTexts[1] = this.env.getName2();
        this.finTexts[2] = this.env.getName3();
        this.finTexts[3] = this.env.getName4();
        this.finTexts[4] = this.env.getName5();
        this.fisNames = new String[]{"typeId", "accountingPrinciple", "journalingTerm", "suppressStatNumbers", "fixedDimension1", "fixedDimension2", "fixedDimension3", "fixedDimension4", "fixedDimension5"};
        this.fisLabels = new String[]{"Label.Type", "Label.AccountingPrinciple", "Label.JournalingTerm", "Label.SuppressStatNumbers", this.finShortTexts[0], this.finShortTexts[1], this.finShortTexts[2], this.finShortTexts[3], this.finShortTexts[4]};
        this.fisTypes = new String[]{null, null, "text", null, null, null, null, null, null};
        this.fisSizes = new short[]{80, 30, 120, 30, 100, 100, 100, 100, 100};
        this.fisTransformers = new Transformer[]{null, new AccountingPrincipleImageTransformer(), new JournalingTermIdTransformer(), new SuppressStatNumbersImageTransformer(), new NumericIdTransformer(), new NumericIdTransformer(), new NumericIdTransformer(), new NumericIdTransformer(), new NumericIdTransformer()};
        this.fisTooltips = new String[]{"Label.AccountingPrinciple", "Label.SuppressStatNumbers"};
        this.fmsNames = new String[]{"typeId", "accountingPrinciple", "journalingTerm", "fixedDimension1", "fixedDimension2", "fixedDimension3", "fixedDimension4"};
        this.fmsLabels = new String[]{"Label.Type", "Label.AccountingPrinciple", "Label.JournalingTerm", this.finShortTexts[0], this.finShortTexts[1], this.finShortTexts[2], this.finShortTexts[3]};
        this.fmsTypes = new String[]{null, null, "text", null, null, null, null};
        this.fmsSizes = new short[]{80, 30, 120, 100, 100, 100, 100};
        this.fmsTransformers = new Transformer[]{null, new AccountingPrincipleImageTransformer(), new JournalingTermIdTransformer(), null, null, null, null};
        this.fmsTooltips = new String[]{"Label.AccountingPrinciple"};
        this.searchAndFilterNames = new String[]{"typeId", "accountingPrinciple", "journalingTerm"};
        this.searchAndFilterLabels = new String[]{"Label.Type", "Label.AccountingPrinciple", "Label.JournalingTerm"};
        this.inputComponents.put("typeId", new AssetTypeReferenceField(this.dbData, this.companyId));
        ComboBox cbAP = new ComboBox("Label.AccountingPrinciple");
        cbAP.addOption(this.env.getAPName1(), "1");
        if (this.company.getAccountingPrinciple2Usage() != 0) {
            cbAP.addOption(this.env.getAPName2(), "2");
        }
        this.inputComponents.put("accountingPrinciple", cbAP);
        ComboBox cbJT = EnumHelper.createComboBox("Label.JournalingTerm", JournalingsTermEnum.getCollection(), true);
        this.inputComponents.put("journalingTerm", cbJT);
        this.fbShow = new FloatBar();
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("refresh");
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createForm");
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("deleteForm");
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        this.fbShow.addAction(this.finish);
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("editForm");
        this.rowActions = new Action[]{edit, confirmDelete};
        this.headerActions = new Action[]{refresh, create};
        this.fbCreate = new FloatBar();
        Action createOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("create");
        createOK.setDefault(true);
        createOK.setValidationEnabled(true);
        this.fbCreate.addAction(createOK);
        this.fbCreate.addAction(this.closeWindow);
        this.fbEdit = new FloatBar();
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("edit");
        editOK.setDefault(true);
        editOK.setValidationEnabled(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.closeWindow);
        this.fbDelete = new FloatBar();
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("delete");
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.closeWindow);
        this.fg1 = new FieldGroup();
        this.cbAccountingPrinciple.addOption(this.env.getAPName1(), "1");
        if (this.company.getAccountingPrinciple2Usage() != 0) {
            this.cbAccountingPrinciple.addOption(this.env.getAPName2(), "2");
        }
        if (this.governmentActivated) {
            this.cbAccountingPrinciple.addOption(this.env.getAPName3(), "3");
        }
        this.fg1.add(this.cbAccountingPrinciple);
        this.rfAssetType = new AssetTypeReferenceField(this.dbData, this.companyId, false);
        this.fg1.add((Field)this.rfAssetType);
        this.cbJournalingTerms = JournalingsTermEnum.createComboBox("Label.JournalingTerm", JournalingsTermEnum.getCollection(), false);
        this.fg1.add(this.cbJournalingTerms);
        this.fg2 = new FieldGroup();
        for (int i = 0; i < 5; ++i) {
            this.dimensions[i] = this.env.getOperationArea().length() == 0 ? new FISReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.company) : (i < 4 ? new FMSReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.company) : new FMSReferenceField(this.loginHelper, "", i, this.company));
            this.fg2.add((Field)this.dimensions[i]);
        }
        this.cbSuppressStatNumbers = new CheckBox("Label.SuppressStatNumbers");
        this.fg2.add(this.cbSuppressStatNumbers);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.AdditionalJournalingData", "screen_name"));
        if (this.table == null) {
            if (this.env.getOperationArea().length() == 0) {
                this.createFISTable();
            } else {
                this.createFMSTable();
            }
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createFISTable() throws Exception {
        AdditionalJournalingDataQuery query = new AdditionalJournalingDataQuery(this.dbData, this.companyId);
        this.table = new ODBTable(AdditionalJournalingData.class, (ODBQuery)query, new String[]{"typeId", "accountingPrinciple", "journalingTerm"}, 12);
        this.table.setName("AJDA_FIS");
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(this.fisNames);
        this.table.setColumnLabels(this.fisLabels);
        this.table.setColumnTypes(this.fisTypes);
        this.table.setColumnSizes(this.fisSizes);
        this.table.setInputComponents(this.inputComponents);
        this.table.setDisplayTransformers(this.fisTransformers);
        this.table.setSortable(true);
        this.table.setSelectable(false);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(this.searchAndFilterNames, this.searchAndFilterLabels);
        this.searchPanel.setCSSClass("headerPanel");
        Action filterAction = this.table.createFilterAction(this.searchAndFilterNames, this.searchAndFilterLabels, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])this.fisTooltips);
    }

    private void createFMSTable() throws Exception {
        this.table = new ODBTable(AdditionalJournalingData.class, (ODBQuery)new AdditionalJournalingDataQuery(this.dbData, this.companyId), new String[]{"typeId", "accountingPrinciple", "journalingTerm"}, 12);
        this.table.setName("AJDA_FMS");
        this.table.setColumnNames(this.fmsNames);
        this.table.setColumnLabels(this.fmsLabels);
        this.table.setColumnTypes(this.fmsTypes);
        this.table.setColumnSizes(this.fmsSizes);
        this.table.setInputComponents(this.inputComponents);
        this.table.setDisplayTransformers(this.fmsTransformers);
        this.table.setSortable(true);
        this.table.setSelectable(false);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(this.searchAndFilterNames, this.searchAndFilterLabels);
        this.searchPanel.setCSSClass("headerPanel");
        Action filterAction = this.table.createFilterAction(this.searchAndFilterNames, this.searchAndFilterLabels, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])this.fmsTooltips);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject createForm(DataObject object) throws Exception {
        this.additionalJournalingData = null;
        this.cbAccountingPrinciple.setReadonly(false);
        AssetTypeReferenceField rfAssetTypeNew = new AssetTypeReferenceField(this.dbData, this.companyId, false);
        this.fg1.replaceUIObject((UIObject)this.rfAssetType, (UIObject)rfAssetTypeNew);
        this.rfAssetType = rfAssetTypeNew;
        this.rfAssetType.setReadonly(false);
        this.rfAssetType.setMandatory(true);
        this.cbJournalingTerms.setReadonly(false);
        this.cbJournalingTerms.setSelectedOptionValue("10");
        for (int i = 0; i < 5; ++i) {
            this.dimensions[i].setReadonly(false);
            this.dimensions[i].setValue();
        }
        this.cbSuppressStatNumbers.setReadonly(false);
        this.cbSuppressStatNumbers.setValue(false);
        this.hideSuperfluousAttributes();
        this.window = this.createWindow();
        this.window.setLabel("Button.Create");
        this.window.add(this.fbCreate);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        Object[] objects;
        String message = this.validate();
        if (message != null) {
            this.window.add(new Message(message, "error"));
            return object;
        }
        String fixedDimId5 = "";
        if (this.env.getOperationArea().length() != 0) {
            fixedDimId5 = this.dimensions[4].getFormattedId();
        }
        if ((objects = AdditionalJournalingDataBO.create(this.dbData, this.companyId, this.rfAssetType.getValue(), Integer.parseInt(this.cbAccountingPrinciple.getSelectedOptionValue()), Integer.parseInt(this.cbJournalingTerms.getSelectedOptionValue()), 0, this.dimensions[0].getFormattedId(), this.dimensions[1].getFormattedId(), this.dimensions[2].getFormattedId(), this.dimensions[3].getFormattedId(), fixedDimId5, this.cbSuppressStatNumbers.getValueAsBoolean()))[0] == null) {
            message = (String)objects[1];
            this.window.add(new Message(message, "error"));
            return object;
        }
        this.window.closeWindow(object);
        return this.refresh(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.additionalJournalingData = (AdditionalJournalingData)TableHelper.getSelectedItem((DataObject)object);
        for (int i = 0; i < 5; ++i) {
            this.dimensions[i].setReadonly(false);
        }
        this.cbSuppressStatNumbers.setReadonly(false);
        this.setValues();
        this.hideSuperfluousAttributes();
        this.window = this.createWindow();
        this.window.setLabel("Button.Edit");
        this.window.add(this.fbEdit);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = this.validate();
        if (message != null) {
            this.window.add(new Message(message, "error"));
            return object;
        }
        String fixedDimId5 = "";
        if (this.env.getOperationArea().length() != 0) {
            fixedDimId5 = this.dimensions[4].getFormattedId();
        }
        if ((message = AdditionalJournalingDataBO.update(this.additionalJournalingData, this.dimensions[0].getFormattedId(), this.dimensions[1].getFormattedId(), this.dimensions[2].getFormattedId(), this.dimensions[3].getFormattedId(), fixedDimId5, this.cbSuppressStatNumbers.getValueAsBoolean())) != null) {
            this.window.add(new Message(message, "error"));
            return object;
        }
        this.window.closeWindow(object);
        return this.refresh(object);
    }

    private String validate() throws Exception {
        String message = null;
        if ("".equals(this.dimensions[0].getValue()) && "".equals(this.dimensions[1].getValue()) && "".equals(this.dimensions[2].getValue()) && "".equals(this.dimensions[3].getValue()) && "".equals(this.dimensions[4].getValue()) && !this.cbSuppressStatNumbers.getValueAsBoolean()) {
            message = "at_least_one_off_the_attributes_should_have_a_value";
        }
        return message;
    }

    public DataObject deleteForm(DataObject object) throws Exception {
        this.additionalJournalingData = (AdditionalJournalingData)TableHelper.getSelectedItem((DataObject)object);
        for (int i = 0; i < 5; ++i) {
            this.dimensions[i].setReadonly(true);
        }
        this.cbSuppressStatNumbers.setReadonly(true);
        this.setValues();
        this.hideSuperfluousAttributes();
        this.window = this.createWindow();
        this.window.setLabel("Button.Delete");
        this.window.add(this.fbDelete);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = AdditionalJournalingDataBO.delete(this.additionalJournalingData);
        if (message != null) {
            this.window.add(new Message(message, "error"));
            return object;
        }
        this.window.closeWindow(object);
        return this.refresh(object);
    }

    private void setValues() throws Exception {
        this.cbAccountingPrinciple.setReadonly(true);
        AssetTypeReferenceField rfAssetTypeNew = new AssetTypeReferenceField(this.dbData, this.companyId, false);
        this.fg1.replaceUIObject((UIObject)this.rfAssetType, (UIObject)rfAssetTypeNew);
        this.rfAssetType = rfAssetTypeNew;
        this.rfAssetType.setReadonly(true);
        this.rfAssetType.setMandatory(false);
        this.cbJournalingTerms.setReadonly(true);
        this.cbAccountingPrinciple.setSelectedOptionValue("" + this.additionalJournalingData.getAccountingPrinciple());
        this.rfAssetType.setValue(this.additionalJournalingData.getTypeId());
        this.rfAssetType.validate();
        this.cbJournalingTerms.setSelectedOptionValue("" + this.additionalJournalingData.getJournalingTerm());
        this.dimensions[0].setValue(this.additionalJournalingData.getFixedDimension1().trim());
        this.dimensions[1].setValue(this.additionalJournalingData.getFixedDimension2().trim());
        this.dimensions[2].setValue(this.additionalJournalingData.getFixedDimension3().trim());
        this.dimensions[3].setValue(this.additionalJournalingData.getFixedDimension4().trim());
        this.dimensions[4].setValue(this.additionalJournalingData.getFixedDimension5().trim());
        this.cbSuppressStatNumbers.setValue(this.additionalJournalingData.getSuppressStatNumbers());
    }

    private void hideSuperfluousAttributes() throws Exception {
        this.dimensions[4].setHidden(false);
        this.cbSuppressStatNumbers.setHidden(false);
        if (this.env.getOperationArea().length() != 0) {
            this.dimensions[4].setHidden(true);
            this.cbSuppressStatNumbers.setHidden(true);
        }
    }

    private Window createWindow() throws Exception {
        Window window = new Window();
        window.add(this.fg1);
        window.add(this.fg2);
        return window;
    }

    public DataObject closeWindow(DataObject object) throws Exception {
        this.window.closeWindow(object);
        return object;
    }

    class JournalingTermIdTransformer
    implements Transformer {
        private static final long serialVersionUID = 1L;

        JournalingTermIdTransformer() {
        }

        public Object transform(Object object) {
            int jt = (Integer)object;
            return JournalingsTermEnum.getValue(jt);
        }
    }

    class SuppressStatNumbersImageTransformer
    implements Transformer {
        private static final long serialVersionUID = 1L;

        SuppressStatNumbersImageTransformer() {
        }

        public Object transform(Object object) {
            boolean suppress = (Boolean)object;
            if (!suppress) {
                return "";
            }
            return new Image(TranslationHelperImpl.getInstance().translate("Label.SuppressStatNumbers"), "page_red.png").setHeight("16").setAlignment("center");
        }
    }

    class AccountingPrincipleImageTransformer
    implements Transformer {
        private static final long serialVersionUID = 1L;

        AccountingPrincipleImageTransformer() {
        }

        public Object transform(Object object) {
            int ap = (Integer)object;
            if (ap == 1) {
                return "";
            }
            try {
                if (!AdditionalJournalingDataAdapter.this.governmentActivated) {
                    return new Image(AdditionalJournalingDataAdapter.this.env.getAPName2(), "page.png").setHeight("16").setAlignment("center");
                }
                return new Image(AdditionalJournalingDataAdapter.this.env.getAPName3(), "page.png").setHeight("16").setAlignment("center");
            }
            catch (Exception e) {
                return "";
            }
        }
    }
}

