/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.HashMap;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.AnalysisCodeField;
import nl.ibs.fac.adapters.AnalysisGroupAdapter;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.AnalysisCodeBO;
import nl.ibs.fac.boadapters.AssetAnalysisCodeBO;
import nl.ibs.fac.db.AnalysisCode;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.queries.AnalysisCodeQuery;

public class AnalysisCodeAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 2605518608580975174L;
    public static final String PAGE = AnalysisCodeAdapter.class.getName();
    public static final String ANALYSISGROUP = "analysisGroup";
    private AnalysisGroup analysisGroup;
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES = new String[]{"code", "description"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description"};
    private static final short[] SIZES = new short[]{100, 500};
    private static final String[] TYPES = new String[]{null, null};
    private static final Transformer[] TRANSFORMERS = new Transformer[]{null, null};
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();
    private static final String REFRESH = "refresh";
    public static final String START_ACTION = "initDependingFields";
    public static final String SHOW = "show";
    private static final String CREATEFORM = "initCreateForm";
    private static final String CREATE = "create";
    private static final String EDITFORM = "editForm";
    private static final String EDIT = "edit";
    private static final String CONFIRMDELETE = "confirmDelete";
    private static final String DELETE = "delete";
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbCreate = new FloatBar();
    private FloatBar fbEdit = new FloatBar();
    private FloatBar fbDelete = new FloatBar();
    private Action[] rowActions;
    private Action[] headerActions;
    private Panel header;
    private FieldGroup group = new FieldGroup("Label.AnalysisCode");
    private Field id = new Field("Label.Id");
    private Field description = new Field("Label.Description");
    private AnalysisCode analysisCode;
    private Object[] analysisCodes;

    public AnalysisCodeAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        Action previous = new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(AnalysisGroupAdapter.PAGE)).setMethod(SHOW);
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEFORM);
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDITFORM);
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CONFIRMDELETE);
        this.fbShow.addAction(previous);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        this.fbShow.addAction(edit);
        this.fbShow.addAction(confirmDelete);
        this.fbShow.addAction(this.finish);
        this.rowActions = new Action[]{edit, confirmDelete};
        this.headerActions = new Action[]{refresh, create};
        Action createOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATE);
        createOK.setValidationEnabled(true);
        createOK.setDefault(true);
        this.fbCreate.addAction(createOK);
        this.fbCreate.addAction(this.cancel);
        this.fbCreate.addAction(this.finish);
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT);
        editOK.setValidationEnabled(true);
        editOK.setDefault(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.cancel);
        this.fbEdit.addAction(this.finish);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE);
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.fbDelete.addAction(this.finish);
        this.id.setHelpId("Label.AnalysisCodeId");
        this.group.add(this.id);
        this.description.setMandatory(true);
        this.description.setLength(50);
        this.description.setMaxLength(50);
        this.group.add(this.description);
    }

    public DataObject initDependingFields(DataObject object) throws Exception {
        this.analysisGroup = (AnalysisGroup)this.getProcess().getAttribute(ANALYSISGROUP);
        Field field = new Field("Label.AnalysisGroup");
        field.setValue(this.analysisGroup.getName());
        field.setReadonly(true);
        field.setLength(50);
        this.header = new HeaderPanel();
        this.header.setWidth(626);
        this.header.addUIObject((UIObject)field);
        if (this.analysisGroup.getAutoNumber()) {
            this.id.setMandatory(false);
            this.id.setHidden(true);
        } else {
            this.id.setMandatory(true);
            this.id.setHidden(false);
            this.id.setLength(this.analysisGroup.getLength());
            this.id.setMaxLength(this.analysisGroup.getLength());
            if (this.analysisGroup.getType().equals("N")) {
                this.id.setType("number");
            } else {
                this.id.setType("upper");
            }
        }
        this.table = null;
        return this.show(object);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.AnalysisCodes", "screen_name"));
        object.addUIObject((UIObject)this.header);
        if (this.table == null) {
            this.createTable();
        } else {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        AnalysisCodeQuery query = new AnalysisCodeQuery(this.dbData, this.analysisGroup);
        this.table = new ODBTable(AnalysisCode.class, (ODBQuery)query, new String[]{"code"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        if (this.analysisGroup.getType().equals("N")) {
            AnalysisCodeAdapter.TYPES[0] = "number";
            AnalysisCodeAdapter.TRANSFORMERS[0] = this.numericIdTransformer;
        } else {
            AnalysisCodeAdapter.TRANSFORMERS[0] = null;
            AnalysisCodeAdapter.TYPES[0] = null;
        }
        this.table.setColumnTypes(TYPES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        HashMap<String, AnalysisCodeField> inputComponents = new HashMap<String, AnalysisCodeField>();
        inputComponents.put("code", new AnalysisCodeField(this.analysisGroup));
        this.table.setInputComponents(inputComponents);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(NAMES, LABELS);
        Action filterAction = this.table.createFilterAction(NAMES, LABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject initCreateForm(DataObject object) throws Exception {
        this.id.setValue();
        this.id.setReadonly(false);
        this.id.requestFocus(true);
        this.description.setValue();
        return this.createForm(object);
    }

    public DataObject createForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateAnalysisCode", "screen_name"));
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.group);
        object.addUIObject((UIObject)this.fbCreate);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        Object[] result;
        String message;
        if ("number".equals(this.id.getType())) {
            try {
                if (Integer.parseInt(this.id.getValue()) <= 0) {
                    this.id.setInvalidTag();
                    object.addUIObject((UIObject)new Message("value_must_be_positive", "error"));
                    return object;
                }
            }
            catch (NumberFormatException nfe) {
                this.id.setInvalidTag();
                object.addUIObject((UIObject)new Message("not_a_number", "error"));
                return object;
            }
        }
        if ((message = (String)(result = AnalysisCodeBO.create(this.dbData, this.analysisGroup, this.id.getValue().trim(), this.description.getValue().trim()))[1]) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.analysisCode = (AnalysisCode)result[0];
        this.table.setPointer("code", (Object)this.analysisCode.getCode(), true);
        this.table.reload();
        return this.initCreateForm(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        boolean validSelection = this.getSelectedItems(object, false);
        if (!validSelection) {
            return object;
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.EditAnalysisCode", "screen_name"));
        String code = this.analysisCode.getCode().trim();
        if (this.analysisGroup.getType().equals("N")) {
            code = (String)this.numericIdTransformer.transform(code);
        }
        this.id.setValue(code);
        this.id.setReadonly(true);
        this.description.setValue(this.analysisCode.getDescription().trim());
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.group);
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = AnalysisCodeBO.update(this.analysisCode, this.description.getValue().trim());
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("code", (Object)this.analysisCode.getCode(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        boolean validSelection = this.getSelectedItems(object, true);
        for (int i = 0; i < this.analysisCodes.length; ++i) {
            AnalysisCode ac = (AnalysisCode)this.analysisCodes[i];
            if (!AssetAnalysisCodeBO.hasAssetsForAnalysisCode(ac)) continue;
            object.addUIObject((UIObject)new Message("code_to_delete_cannot_have_assets", "error"));
            return object;
        }
        if (!validSelection) {
            return object;
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteAnalysisCodes", "screen_name"));
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.analysisCodes.length);
        for (int i = 0; i < this.analysisCodes.length; ++i) {
            list.add(this.analysisCodes[i]);
        }
        CollectionTable table = new CollectionTable(AnalysisCode.class, list, 12);
        table.setName(PAGE);
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        if (this.analysisGroup.getType().equals("N")) {
            AnalysisCodeAdapter.TYPES[0] = "number";
            AnalysisCodeAdapter.TRANSFORMERS[0] = this.numericIdTransformer;
        } else {
            AnalysisCodeAdapter.TRANSFORMERS[0] = null;
            AnalysisCodeAdapter.TYPES[0] = null;
        }
        table.setColumnTypes(TYPES);
        table.setDisplayTransformers(TRANSFORMERS);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        for (int i = 0; i < this.analysisCodes.length; ++i) {
            AnalysisCode analysisCode = (AnalysisCode)this.analysisCodes[i];
            if (analysisCode == null || (message = AnalysisCodeBO.delete(analysisCode)) == null) continue;
            object.addUIObject((UIObject)new Message(message, "error"));
        }
        if (message != null) {
            return object;
        }
        this.table = null;
        return this.show(object);
    }

    private boolean getSelectedItems(DataObject object, boolean multipleSelectionAllowed) throws Exception {
        boolean validSelection = true;
        this.analysisCodes = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (this.analysisCodes.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            validSelection = false;
        }
        if (validSelection && !multipleSelectionAllowed && this.analysisCodes.length > 1) {
            object.addUIObject((UIObject)new Message("OnlyOneSelectionAllowed", "error"));
            validSelection = false;
        }
        if (validSelection && !multipleSelectionAllowed) {
            this.analysisCode = (AnalysisCode)this.analysisCodes[0];
        }
        return validSelection;
    }
}

