/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.Map;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FormattedField;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.AnalysisCodeReferenceField;
import nl.ibs.fac.adapters.AnalysisFieldHelper;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.queries.AnalysisGroupQuery;

public abstract class AnalysisGroupHelper {
    public static Object[] addAnalysisGroups(LoginHelper loginHelper, Environment env, Company dataSet, Map<String, Field> inputComponents, String[] searchNames, String[] searchLabels2) throws Exception {
        ArrayList<String> extraLabels = new ArrayList<String>();
        ArrayList<String> extraNames = new ArrayList<String>();
        for (AnalysisGroup ag : new AnalysisGroupQuery(dataSet.getDBData(), dataSet.getId()).fetchData(null, "name", null, 0)) {
            String name;
            FormattedField field;
            if (ag.getUsage() == 1) {
                field = new AnalysisCodeReferenceField(dataSet.getDBData(), ag);
                name = "assetAnalysisCode" + ag.getSeqNr();
            } else if (ag.getUsage() == 3) {
                int index;
                if (env.getOperationArea().length() == 0) {
                    index = 10;
                    if (ag.getSeqNr() == dataSet.getAGCreditorSequenceNbr()) {
                        index = 11;
                    }
                    field = new FISReferenceField(loginHelper, ag.getName(), index, dataSet);
                } else {
                    index = 10;
                    if (ag.getSeqNr() == dataSet.getAGCreditorSequenceNbr()) {
                        index = 11;
                    }
                    if (ag.getSeqNr() == dataSet.getAGRelationSequenceNbr()) {
                        index = 12;
                    }
                    field = new FMSReferenceField(loginHelper, ag.getName(), index, dataSet);
                }
                name = "assetValue" + ag.getSeqNr();
            } else {
                field = AnalysisFieldHelper.create(ag);
                name = "assetValue" + ag.getSeqNr();
            }
            extraLabels.add(ag.getName());
            extraNames.add(name);
            inputComponents.put(name, (Field)field);
        }
        Object[] objects = extraNames.toArray();
        String[] result = new String[searchNames.length + objects.length];
        System.arraycopy(searchNames, 0, result, 0, searchNames.length);
        System.arraycopy(objects, 0, result, searchNames.length, objects.length);
        searchNames = result;
        objects = extraLabels.toArray();
        result = new String[searchLabels2.length + objects.length];
        System.arraycopy(searchLabels2, 0, result, 0, searchLabels2.length);
        System.arraycopy(objects, 0, result, searchLabels2.length, objects.length);
        searchLabels2 = result;
        return new Object[]{searchNames, searchLabels2};
    }
}

