/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.Hashtable;
import nl.ibs.esp.adapter.Adapter;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.FacConstants;
import nl.ibs.fac.ui.ApplicationSettingsPanel;

public class ApplicationSettingAdapter
extends Adapter {
    private static final long serialVersionUID = -5983137869908036165L;
    public static final String SHOW = "show";
    private FloatBar buttonBar = new FloatBar();
    private Hashtable applicationSettings;
    private ApplicationSettingsPanel applicationSettingsPanel;

    public ApplicationSettingAdapter(DataObject object) throws Exception {
        super(object);
        this.setSingleton(true);
        this.applicationSettings = FacConstants.getProperties();
        this.applicationSettingsPanel = new ApplicationSettingsPanel(this.applicationSettings);
        Action save = new Action("button-ok", (Adapter)this, "save");
        save.setDefault(true);
        save.setValidationEnabled(true);
        this.buttonBar.addAction(save);
        this.buttonBar.addAction(new Action("button-exit", (Adapter)this, "finish"));
    }

    public DataObject main(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("settings", "screen_name"));
        object.addUIObject((UIObject)this.applicationSettingsPanel);
        object.addUIObject((UIObject)this.buttonBar);
        return object;
    }

    public DataObject save(DataObject object) throws Exception {
        FacConstants.setProperties(this.applicationSettings);
        return this.finish(object);
    }

    public String getDescription() {
        return this.translate(this.getShortDescription());
    }

    public String getShortDescription() {
        return "settings";
    }

    public String getProcessIconUrl() {
        return "cog.png";
    }

    public DataObject finish(DataObject dataObject) throws Exception {
        this.destroyAdapter(dataObject);
        dataObject.addUIObject((UIObject)new RedirectAction(dataObject.getConfiguration().getDefaultPage(), SHOW));
        return dataObject;
    }
}

