/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.DisinvestmentReasonCodeEnum;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.MainTransactionTypeEnum;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionDetailAdapter;
import nl.ibs.fac.adapters.ProofDisInvestmentAdapter;
import nl.ibs.fac.adapters.TransactionAdapter;
import nl.ibs.fac.adapters.TransactionTypeTransformer;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.bp.DisInvestmentBP;
import nl.ibs.fac.bp.InvestmentBP;
import nl.ibs.fac.bp.ProofDisInvestmentBP;
import nl.ibs.fac.bp.WriteOffBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.queries.TransactionQuery;

public class AssetAcquisitionTransactionAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -907358665318269176L;
    public static final String PAGE = AssetAcquisitionTransactionAdapter.class.getName();
    public static final String RETURNPAGE = "AssetAcquisitionTransactionAdapterReturnPage";
    public static final String RETURNMETHOD = "AssetAcquisitionTransactionAdapterReturnMethod";
    private Company company;
    private Asset asset;
    private ODBTable table = null;
    private static final String[] NAMES = new String[]{"bookYear", "period", "transactionType", "amount1", "description"};
    private static final String[] LABELS = new String[]{"Label.Year", "Label.Period.short", "Label.InvestmentOrDisInvestment", "Label.Amount", "Label.Description"};
    private static final short[] SIZES = new short[]{50, 30, 135, 130, 230};
    private static final String[] TYPES = new String[]{null, null, "text", null, null};
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private static final Transformer[] TRANSFORMERS = new Transformer[]{null, null, new TransactionTypeTransformer(), DECIMALTRANSFORMER, null};
    private Map<String, ComboBox> inputComponents = new HashMap<String, ComboBox>();
    private Action[] rowActions;
    private Action[] headerActions;
    private FloatBar fbShow = new FloatBar();
    private FieldGroup fgHeader;
    private FACDecimalField acquisitionValue;
    private Window window;
    private BookYearPeriodGrid facYearPeriod;
    private BookYearPeriodGrid finYearPeriod;
    private Field description = new Field("Label.Description");
    private FieldGroup investmentPanel = new FieldGroup();
    private FACDecimalField transactionValue = new FACDecimalField("Label.Amount", 15, 2);
    private Action investmentAction;
    private FieldGroup disInvestmentPanel = new FieldGroup();
    private FACDecimalField yieldValue = new FACDecimalField("Label.YieldValue", 15, 2);
    private ComboBox disinvestmentReason;
    private CheckBox partialDisInvestment = new CheckBox("Label.PartialDisInvestment");
    private PartialDisInvestmentChangeAction partialDisInvestmentChangeAction = new PartialDisInvestmentChangeAction();
    private FACDecimalField disInvestmentPartialAmount = new FACDecimalField("Label.DisInvestmentPartialAmount", 15, 2);
    private Action disInvestmentAction;
    private FieldGroup writeOffUndoWriteOffPanel = new FieldGroup();
    private FACDecimalField acqValue = new FACDecimalField("Label.AcquisitionValue", 15, 2);
    private FACDecimalField dprValue = new FACDecimalField("Label.TotalDepreciationAmount", 15, 2);
    private FloatBar writeOffUndoWriteOffFloatBar;
    private Action writeOffAction;
    private Action undoWriteOffAction;
    private FieldGroup fgFBI;
    private FieldGroup fgFBD;
    private FieldGroup fgFBW;
    private InvestmentBP investmentBP;
    private DisInvestmentBP disInvestmentBP;
    private WriteOffBP writeOffBP;
    private boolean investmentActionEnabled;

    public AssetAcquisitionTransactionAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.investmentBP = new InvestmentBP(this.company, this.numberOfPeriods, "FAC");
        this.disInvestmentBP = new DisInvestmentBP(this.company, this.numberOfPeriods, "FAC");
        this.writeOffBP = new WriteOffBP(this.company, this.numberOfPeriods);
        this.fbShow.alignment(1);
        this.undoWriteOffAction = new Action("Button.UndoWriteOff").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createUndoWriteOffPanel");
        this.writeOffAction = new Action("Button.WriteOff").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createWriteOffPanel");
        this.investmentAction = new Action("Button.Investment").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createInvestmentPanel");
        this.disInvestmentAction = new Action("Button.DisInvestment").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createDisInvestmentPanel");
        this.fbShow.addAction(this.undoWriteOffAction);
        this.fbShow.addAction(this.writeOffAction);
        this.fbShow.addAction(this.investmentAction);
        this.fbShow.addAction(this.disInvestmentAction);
        this.headerActions = new Action[0];
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(TransactionAdapter.PAGE)).setMethod("show");
        Action incomingFinancialTransaction = new Action("Button.IncomingFinancialTransaction").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionDetailAdapter.PAGE)).setMethod("showDetails");
        this.rowActions = new Action[]{details, incomingFinancialTransaction};
        ComboBox mtt = EnumHelper.createComboBox("Label.MainTransactionType", MainTransactionTypeEnum.getCollection(), true);
        mtt.setWidth("150");
        this.inputComponents.put("mainTransactionType", mtt);
        this.fgHeader = new FieldGroup("Label.AcquisitionValue");
        this.facYearPeriod = new BookYearPeriodGrid("Label.FACStartPeriod", "" + this.company.getCurrentBookYear(), "1900", this.bookYearMax, this.numberOfPeriods);
        this.finYearPeriod = new BookYearPeriodGrid("Label.BookPeriod", false);
        this.investmentPanel.add((ESPGridLayout)this.facYearPeriod);
        this.investmentPanel.add((ESPGridLayout)this.finYearPeriod);
        this.transactionValue.setMandatory(true);
        this.investmentPanel.add((Field)this.transactionValue);
        this.description.setLength(30);
        this.description.setMaxLength(30);
        this.investmentPanel.add(this.description);
        FloatBar fb = new FloatBar();
        Action ok = new Action("Button.OK", null, null, this.getProcessAdapterPageName(PAGE), "createInvestment");
        ok.setDefault(true);
        ok.setValidationEnabled(true);
        fb.addAction(ok);
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("close"));
        this.fgFBI = new FieldGroup();
        this.fgFBI.forceBorder(false);
        this.fgFBI.add(fb);
        this.disInvestmentPanel.add((ESPGridLayout)this.facYearPeriod);
        this.disInvestmentPanel.add((ESPGridLayout)this.finYearPeriod);
        this.yieldValue.setMandatory(true);
        this.disInvestmentPanel.add((Field)this.yieldValue);
        this.disInvestmentPanel.add(this.description);
        this.disinvestmentReason = EnumHelper.createComboBox("Label.DisinvestmentReason", DisinvestmentReasonCodeEnum.getCollection(this.env), false);
        if (!("".equals(this.env.getDIRCName1()) && "".equals(this.env.getDIRCName2()) && "".equals(this.env.getDIRCName3()) && "".equals(this.env.getDIRCName4()) && "".equals(this.env.getDIRCName5()))) {
            this.disInvestmentPanel.add(this.disinvestmentReason);
        }
        this.partialDisInvestment.setAction((Action)this.partialDisInvestmentChangeAction);
        this.disInvestmentPanel.add(this.partialDisInvestment);
        this.disInvestmentPanel.add((Field)this.disInvestmentPartialAmount);
        fb = new FloatBar();
        ok = new Action("Button.OK", null, null, this.getProcessAdapterPageName(PAGE), "createDisInvestment");
        ok.setDefault(true);
        ok.setValidationEnabled(true);
        fb.addAction(ok);
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("close"));
        this.fgFBD = new FieldGroup();
        this.fgFBD.forceBorder(false);
        this.fgFBD.add(fb);
        this.writeOffUndoWriteOffPanel.add((ESPGridLayout)this.facYearPeriod);
        this.writeOffUndoWriteOffPanel.add((ESPGridLayout)this.finYearPeriod);
        this.acqValue.setReadonly(true);
        this.writeOffUndoWriteOffPanel.add((Field)this.acqValue);
        this.dprValue.setReadonly(true);
        this.writeOffUndoWriteOffPanel.add((Field)this.dprValue);
        this.description.setLength(30);
        this.description.setMaxLength(30);
        this.writeOffUndoWriteOffPanel.add(this.description);
        this.writeOffUndoWriteOffFloatBar = new FloatBar();
        this.fgFBW = new FieldGroup();
        this.fgFBW.forceBorder(false);
        this.fgFBW.add(this.writeOffUndoWriteOffFloatBar);
    }

    public FieldGroup getHeader(Asset asset) throws Exception {
        this.asset = asset;
        this.fgHeader.removeUIObject((UIObject)this.acquisitionValue, false);
        this.acquisitionValue = new FACDecimalField("Label.TotalActivated", 15, 2);
        this.acquisitionValue.setValue(ValuationBO.getAcquisitionValue(asset));
        this.acquisitionValue.setReadonly(true);
        this.fgHeader.add((Field)this.acquisitionValue);
        return this.fgHeader;
    }

    public ODBTable getTable() throws Exception {
        this.createTable();
        return this.table;
    }

    public FloatBar getFloatBar() throws Exception {
        boolean enabled;
        this.fbShow.removeAction("Button.UndoWriteOff");
        this.fbShow.removeAction("Button.WriteOff");
        this.fbShow.removeAction("Button.Investment");
        this.fbShow.removeAction("Button.DisInvestment");
        this.investmentActionEnabled = false;
        boolean bl = enabled = this.asset.getState() == 2;
        if (enabled) {
            this.investmentActionEnabled = true;
            if (this.asset.getLoan()) {
                this.investmentActionEnabled = false;
            }
            for (Valuation valuation : this.asset.getValuationsCollection(null)) {
                if (!valuation.getPostedAcquisitionBalance().equals(valuation.getPostedDepreciationBalance())) {
                    enabled = false;
                }
                if (valuation.getDepreciationMethod() != 11) continue;
                this.investmentActionEnabled = false;
            }
        }
        if (enabled) {
            this.fbShow.addAction(this.writeOffAction);
        }
        boolean bl2 = enabled = this.asset.getState() == 2;
        if (enabled) {
            if (this.investmentActionEnabled) {
                this.fbShow.addAction(this.investmentAction);
            }
            this.fbShow.addAction(this.disInvestmentAction);
        } else if (this.asset.getState() == 7) {
            this.fbShow.addAction(this.undoWriteOffAction);
        }
        return this.fbShow;
    }

    private void createTable() throws Exception {
        TransactionQuery query = new TransactionQuery(this.dbData, this.asset);
        this.table = new ODBTable(Transaction.class, (ODBQuery)new TransactionQuery(this.dbData, this.asset), new String[]{"bookYear", "period", "documentNr", "seqNr"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setColumnTypes(TYPES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setInputComponents(this.inputComponents);
        this.table.setSortable(true);
        this.table.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.table, (Action[])this.headerActions, (Action[])this.rowActions, (TableRowMethod)new TransactionTableRowMethod());
        this.table.reload();
    }

    public DataObject createInvestmentPanel(DataObject object) throws Exception {
        String message = this.investmentBP.hasNotPostedTransactions(this.asset);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        String[] yps = this.investmentBP.retrieveYearsAndPeriods(this.asset, null);
        this.facYearPeriod.setValues(yps[0], yps[1]);
        this.finYearPeriod.setValues(yps[2], yps[3]);
        this.transactionValue.setValue();
        this.transactionValue.requestFocus(true);
        this.description.setValue();
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "close");
        this.window.setLabel("Title.AdditionalInvestment");
        this.window.add(this.investmentPanel);
        this.window.add(this.fgFBI);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject createInvestment(DataObject object) throws Exception {
        this.investmentPanel.removeInvalidTags();
        boolean error = false;
        String[] messages = null;
        messages = this.investmentBP.validateFACYearAndPeriod(this.asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue());
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.facYearPeriod.setInvalidTag();
        }
        if ((messages = this.investmentBP.validateFINYearAndPeriod(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax))) != null) {
            error = true;
            this.addErrors(object, messages);
            this.finYearPeriod.setInvalidTag();
        }
        if ((messages = this.investmentBP.validateInvestmentValue(this.transactionValue.getBigDecimal())) != null) {
            error = true;
            this.addErrors(object, messages);
            this.transactionValue.setInvalidTag();
        }
        if (error) {
            return object;
        }
        String message = this.investmentBP.createInvestment(this.asset, false, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.description.getValue(), this.transactionValue.getBigDecimal(), null, true, this.loginHelper.getUser(), false, null, -1, -1);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        return this.close(object);
    }

    public DataObject createDisInvestmentPanel(DataObject object) throws Exception {
        String message = this.disInvestmentBP.hasNotPostedTransactions(this.asset);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        String[] yps = this.disInvestmentBP.retrieveYearsAndPeriods(this.asset, null);
        this.facYearPeriod.setValues(yps[0], yps[1]);
        this.finYearPeriod.setValues(yps[2], yps[3]);
        this.finYearPeriod.setMandatory(false);
        this.yieldValue.setValue();
        this.yieldValue.requestFocus(true);
        this.description.setValue();
        this.partialDisInvestment.setValue(false);
        this.partialDisInvestment.setReadonly(!this.investmentActionEnabled);
        this.partialDisInvestmentChangeAction.execute(this.dataObject);
        this.disInvestmentPartialAmount.setValue();
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "close");
        this.window.setLabel("Title.DisInvestment");
        this.window.add(this.disInvestmentPanel);
        this.window.add(this.fgFBD);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject createDisInvestment(DataObject object) throws Exception {
        this.disInvestmentPanel.removeInvalidTags();
        boolean error = false;
        String[] messages = null;
        messages = this.disInvestmentBP.validateFACYearAndPeriod(this.asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.partialDisInvestment.getValueAsBoolean());
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.facYearPeriod.getBookYear().setInvalidTag();
            this.facYearPeriod.getPeriod().setInvalidTag();
        }
        if ((messages = this.disInvestmentBP.validateFINYearAndPeriod(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax))) != null) {
            error = true;
            this.addErrors(object, messages);
            this.finYearPeriod.getBookYear().setInvalidTag();
            this.finYearPeriod.getPeriod().setInvalidTag();
        }
        if (this.partialDisInvestment.getValueAsBoolean() && (messages = this.disInvestmentBP.validatePartialDisInvestmentValue(this.asset, this.disInvestmentPartialAmount.getBigDecimal(), this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue())) != null) {
            error = true;
            this.addErrors(object, messages);
            this.disInvestmentPartialAmount.setInvalidTag();
        }
        if (error) {
            return object;
        }
        BigDecimal disInvestmentValue = new BigDecimal("0");
        if (this.partialDisInvestment.getValueAsBoolean()) {
            disInvestmentValue = this.disInvestmentPartialAmount.getBigDecimal();
        }
        ProofDisInvestmentBP businesProcess = new ProofDisInvestmentBP(this.company, this.numberOfPeriods);
        businesProcess.calculateProofDisInvestmentValues(this.asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.yieldValue.getBigDecimal(), disInvestmentValue);
        this.getProcess().setAttribute("assetToDisInvest", (Object)this.asset);
        this.getProcess().setAttribute("proofDisInvestmentProcess", (Object)businesProcess);
        this.getProcess().setAttribute("ProofDisinvestmentAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("ProofDisinvestmentAdapterReturnMethod", (Object)"createDisInvestmentContinued");
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(ProofDisInvestmentAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    public DataObject createDisInvestmentContinued(DataObject object) throws Exception {
        String message;
        BigDecimal disInvestmentValue = new BigDecimal("0");
        if (this.partialDisInvestment.getValueAsBoolean()) {
            disInvestmentValue = this.disInvestmentPartialAmount.getBigDecimal();
        }
        if ((message = this.disInvestmentBP.createDisInvestment(this.asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.description.getValue(), this.yieldValue.getBigDecimal(), disInvestmentValue, null, true, this.loginHelper.getUser(), Integer.parseInt(this.disinvestmentReason.getValue()))) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        return this.close(object);
    }

    public DataObject createWriteOffPanel(DataObject object) throws Exception {
        String message = this.writeOffBP.hasNotPostedTransactions(this.asset);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        String[] yps = this.writeOffBP.retrieveYearsAndPeriodsForWriteOff(this.asset);
        this.facYearPeriod.setValues(yps[0], yps[1]);
        this.finYearPeriod.setValues(yps[2], yps[3]);
        this.acqValue.setValue(ValuationBO.getAcquisitionValue(this.asset));
        this.dprValue.setValue(ValuationBO.getDepreciationValue(this.asset));
        this.description.setValue();
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "close");
        this.window.setLabel("Label.WriteOff");
        this.window.add(this.writeOffUndoWriteOffPanel);
        Action ok = new Action("Button.OK", null, null, this.getProcessAdapterPageName(PAGE), "createWriteOff");
        ok.setDefault(true);
        ok.setValidationEnabled(true);
        this.writeOffUndoWriteOffFloatBar.removeAllUIObjects();
        this.writeOffUndoWriteOffFloatBar.addAction(ok);
        this.writeOffUndoWriteOffFloatBar.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("close"));
        this.window.add(this.fgFBW);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject createWriteOff(DataObject object) throws Exception {
        this.writeOffUndoWriteOffPanel.removeInvalidTags();
        boolean error = false;
        String[] messages = null;
        messages = this.writeOffBP.validateFACYearAndPeriodForWriteOff(this.asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue());
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.facYearPeriod.setInvalidTag();
        }
        if ((messages = this.writeOffBP.validateFINYearAndPeriod(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax))) != null) {
            error = true;
            this.addErrors(object, messages);
            this.finYearPeriod.setInvalidTag();
        }
        if (error) {
            return object;
        }
        String message = this.writeOffBP.createWriteOff(this.asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.description.getValue(), this.loginHelper.getUser());
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        return this.close(object);
    }

    public DataObject createUndoWriteOffPanel(DataObject object) throws Exception {
        String message = this.writeOffBP.hasNotPostedTransactions(this.asset);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        String[] yps = this.writeOffBP.retrieveYearsAndPeriodsForUndoWriteOff(this.asset);
        this.facYearPeriod.setValues(yps[0], yps[1]);
        this.finYearPeriod.setValues(yps[2], yps[3]);
        BigDecimal[] values = this.writeOffBP.retrieveUndoWriteOffValues(this.asset, this.asset.getDisinvestmentYear(), this.asset.getDisinvestmentPeriod(), 1);
        this.acqValue.setValue(values[0].negate());
        this.dprValue.setValue(values[1].negate());
        this.description.setValue();
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "close");
        this.window.setLabel("Label.UndoWriteOff");
        this.window.add(this.writeOffUndoWriteOffPanel);
        Action ok = new Action("Button.OK", null, null, this.getProcessAdapterPageName(PAGE), "createUndoWriteOff");
        ok.setDefault(true);
        ok.setValidationEnabled(true);
        this.writeOffUndoWriteOffFloatBar.removeAllUIObjects();
        this.writeOffUndoWriteOffFloatBar.addAction(ok);
        this.writeOffUndoWriteOffFloatBar.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("close"));
        this.window.add(this.fgFBW);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject createUndoWriteOff(DataObject object) throws Exception {
        this.writeOffUndoWriteOffPanel.removeInvalidTags();
        boolean error = false;
        String[] messages = null;
        messages = this.writeOffBP.validateFACYearAndPeriodForUndoWriteOff(this.asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue());
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.facYearPeriod.setInvalidTag();
        }
        if ((messages = this.writeOffBP.validateFINYearAndPeriod(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax))) != null) {
            error = true;
            this.addErrors(object, messages);
            this.finYearPeriod.setInvalidTag();
        }
        if (error) {
            return object;
        }
        String message = this.writeOffBP.createUndoWriteOff(this.asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.description.getValue(), this.loginHelper.getUser());
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        return this.close(object);
    }

    private void addErrors(DataObject object, String[] errors) throws Exception {
        for (int i = 0; i < errors.length; ++i) {
            if (errors[i] == null || errors[i].trim().length() <= 0) continue;
            object.addUIObject((UIObject)new Message(errors[i], "error"));
        }
    }

    public DataObject close(DataObject object) throws Exception {
        this.window.closeWindow(object);
        object.addUIObject((UIObject)new RedirectAction((String)this.getProcess().getAttribute(RETURNPAGE), (String)this.getProcess().getAttribute(RETURNMETHOD), this.getProcess().getProcessId()));
        return object;
    }

    private class TransactionTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 3287868136383717254L;

        private TransactionTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            Transaction transaction = (Transaction)row.getObject();
            ContextMenu menu = new ContextMenu();
            for (int i = 0; i < rowActions.length; ++i) {
                if (rowActions[i].getMethod().equals("showDetails") && transaction.getIncomingFinancialTransactionId() == null) continue;
                ContextAction rowAction = new ContextAction(rowActions[i].getName());
                rowAction.setAdapter(rowActions[i].getPageid());
                rowAction.setMethod(rowActions[i].getMethod());
                menu.addContextMenuItem(rowAction);
            }
            row.setContextMenu(menu);
        }
    }

    private class PartialDisInvestmentChangeAction
    extends Action {
        private static final long serialVersionUID = -2469839980448389112L;

        public PartialDisInvestmentChangeAction() {
            super("");
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if (AssetAcquisitionTransactionAdapter.this.partialDisInvestment.isChecked()) {
                AssetAcquisitionTransactionAdapter.this.disInvestmentPartialAmount.setHidden(false);
                AssetAcquisitionTransactionAdapter.this.disInvestmentPartialAmount.setMandatory(true);
                return true;
            }
            AssetAcquisitionTransactionAdapter.this.disInvestmentPartialAmount.setHidden(true);
            AssetAcquisitionTransactionAdapter.this.disInvestmentPartialAmount.setMandatory(false);
            AssetAcquisitionTransactionAdapter.this.disInvestmentPartialAmount.setValue();
            return true;
        }
    }
}

