/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.ObjectDataReader;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.AssetStateEnum;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.adapters.AP2AcquisitionValueAdapter;
import nl.ibs.fac.adapters.AdditionalDepreciationAdapter;
import nl.ibs.fac.adapters.AnalysisGroupHelper;
import nl.ibs.fac.adapters.AssetAcquisitionTransactionAdapter;
import nl.ibs.fac.adapters.AssetAssetTypeChangeAdapter;
import nl.ibs.fac.adapters.AssetDimensionPanels;
import nl.ibs.fac.adapters.AssetField;
import nl.ibs.fac.adapters.AssetPanels;
import nl.ibs.fac.adapters.AssetReportAdapter;
import nl.ibs.fac.adapters.AssetStateImageTransformer;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.adapters.InterCompanyMovementAdapter;
import nl.ibs.fac.adapters.MemoAdapter;
import nl.ibs.fac.adapters.MemoImageTransformer;
import nl.ibs.fac.adapters.MovementAdapter;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.ParentAssetAdapter;
import nl.ibs.fac.adapters.ParentAssetImageTransformer;
import nl.ibs.fac.adapters.ParentReferenceField;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.adapters.ValuationCorrectionAdapter;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetDataReader;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.AssetAssetTypeChangeBP;
import nl.ibs.fac.bp.MassRemoveBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.gov.adapters.ValuationMainAccountAdapter;
import nl.ibs.fac.queries.AssetQuery;
import nl.ibs.fac.reports.AssetToPDF;
import nl.ibs.util.Scrambler;

public class AssetAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -6979806971529627771L;
    public static final String PAGE = AssetAdapter.class.getName();
    private Company company;
    private String cId;
    private AssetPanels panels;
    private ODBTable table = null;
    protected CommonTable.SearchPanel searchPanel;
    private String[] names2;
    private String[] labels2;
    private String[] searchNames;
    private String[] searchLabels2;
    private short[] sizes2;
    private String[] types2;
    private Transformer[] transformers2;
    private static final String[] NAMES = new String[]{"id", "description", "typeId", "startUseYear", "startUsePeriod", "bookValue", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "parentId", "state", "hasMemo"};
    private static final String[] SEARCHNAMES = new String[]{"id", "description", "typeId", "startUseYear", "startUsePeriod", "bookValue", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "parentId", "state", "hasMemo"};
    private static final String[] TOOLTIPS = new String[]{"Label.ParentAsset", "Label.State", "Label.Memo"};
    private String[] searchLabels;
    private String[] labels;
    private static final int LEADING_LABELS = 6;
    private static final int FIN_DIM_LABELS = 5;
    private static final short[] SIZES = new short[]{80, 200, 80, 35, 25, 100, 80, 80, 80, 80, 80, 20, 20, 20};
    private String[] types = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private static Transformer[] transformers;
    private static final DecimalTransformer DECIMAL_TRANSFORMER;
    private static final NumericIdTransformer NUMERIC_ID_TRANSFORMER;
    private static final boolean[] COLUMNNOWRAPS;
    private static final boolean[] SORTABLE;
    private Map inputComponents = new HashMap();
    public static final String EDITFORM = "editForm";
    protected FloatBar fbShow = new FloatBar();
    private FloatBar fbEdit = new FloatBar();
    protected Action[] rowActions;
    protected Action[] headerActions;
    private CheckBox inclTrans = new CheckBox("Label.InclTransactions");
    private static final String CONFIRMDELETE = "confirmDelete";
    private static final String DELETE = "delete";
    private FloatBar fbDelete = new FloatBar();
    protected TableRowMethod tableRowMethod = null;
    private Object[] assets;
    private Asset asset;
    private String movementActionName = "Button.Edit";
    private String[] ids;
    private String[] dsc;
    private String valuationCorrectionActionName = "Button.Edit";
    private String additionalDepreciationActionName = "Button.AdditionalDepreciation";
    private String ap2AcquisitionValueActionName = "+";
    private static final String CLASSNAMEPDF;
    private static final String JOBNAME = "Job.Asset";
    private Action changeType;

    public AssetAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.searchLabels = new String[]{"Label.Id", "Label.Description", "Label.Type", "Label.Year", "Label.Period", "Label.BookValue", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5(), "Label.ParentAsset", "Label.State", "Label.Memo"};
        this.labels = new String[]{"Label.Id", "Label.Description", "Label.Type", "Label.Year", "Label.Period.short", "Label.BookValue", this.env.getShortName1(), this.env.getShortName2(), this.env.getShortName3(), this.env.getShortName4(), this.env.getShortName5(), "Label.ParentAsset", "Label.State", "Label.Memo"};
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        transformers = new Transformer[]{null, null, null, null, null, DECIMAL_TRANSFORMER, null, null, null, null, null, new ParentAssetImageTransformer(this.company), new AssetStateImageTransformer(), new MemoImageTransformer()};
        this.cId = this.companyId;
        if (this.dataSetId != null) {
            this.cId = this.dataSetId;
        }
        if (this.env.getOperationArea().trim().length() == 0) {
            for (int i = 0; i < 5; ++i) {
                AssetAdapter.transformers[6 + i] = NUMERIC_ID_TRANSFORMER;
                this.types[6 + i] = "number";
            }
        }
        this.modifyTableArrays();
        this.tableRowMethod = new AssetTableRowMethod();
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("refresh");
        this.fbShow.addAction(refresh);
        Action report = new Action("Button.Report").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("reportWindow");
        this.fbShow.addAction(report);
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CONFIRMDELETE);
        this.fbShow.addAction(this.finish);
        Action reportAll = new Action("Button.Report").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("reportAll");
        this.headerActions = new Action[]{refresh, reportAll};
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initEditForm");
        Action icMovement = new Action("Button.InterCompanyMovement").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initICMovement");
        Action memo = new Action("Label.Memo").setAdapter(this.getProcessAdapterPageName(MemoAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{edit, memo, report, icMovement, confirmDelete};
        this.getProcess().setAttribute("MemoAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("edit");
        editOK.setValidationEnabled(true);
        editOK.setDefault(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.cancel);
        this.fbEdit.addAction(this.finish);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE);
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.inputComponents.put("id", new AssetField(this.company, false));
        this.inputComponents.put("typeId", new AssetTypeReferenceField(this.dbData, this.cId));
        this.inputComponents.put("parentId", new ParentReferenceField(this.company, false));
        ComboBox state = EnumHelper.createComboBox("Label.State", AssetStateEnum.getCollection(), true);
        state.setWidth("180");
        this.inputComponents.put("state", state);
        Company dataSet = this.company;
        if (this.dataSetId != null) {
            dataSet = this.company.getDataSet();
        }
        AssetDimensionPanels dimensionPanels = new AssetDimensionPanels(this.loginHelper, this.dbData, this.env, this.company, false);
        FinancialReferenceField[] financialDimension = dimensionPanels.getFINDimensions();
        for (int i = 0; i < 5; ++i) {
            if (financialDimension[i] == null) continue;
            this.inputComponents.put(NAMES[i + 6], financialDimension[i]);
        }
        Object[] result = AnalysisGroupHelper.addAnalysisGroups(this.loginHelper, this.env, dataSet, this.inputComponents, this.searchNames, this.searchLabels2);
        this.searchNames = (String[])result[0];
        this.searchLabels2 = (String[])result[1];
        this.getProcess().setAttribute("AssetAssetTypeChangeAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("AssetAssetTypeChangeAdapterReturnMethod", (Object)"reload");
        this.changeType = new Action("Button.ChangeAssetType").setAdapter(this.getProcessAdapterPageName(AssetAssetTypeChangeAdapter.PAGE)).setMethod("show");
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.Assets", "screen_name"));
        this.asset = null;
        if (this.table == null) {
            this.createTable();
        } else {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    protected void createTable() throws Exception {
        AssetQuery query = new AssetQuery(this.dbData, this.companyId, null, new Boolean(true), false, new Boolean(false), false, false);
        this.table = new ODBTable((ObjectDataReader)new AssetDataReader(), (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setTextCodeSingleObject("Label.Asset");
        this.table.setTextCodeMultipleObjects("Label.Assets");
        this.table.setColumnNames(this.names2);
        this.table.setColumnLabels(this.labels2);
        this.table.setColumnSizes(this.sizes2);
        this.table.setColumnTypes(this.types2);
        this.table.setDisplayTransformers(this.transformers2);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setInputComponents(this.inputComponents);
        this.table.setColumnSortable(SORTABLE);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        this.table.orderByColumn("id");
        this.searchPanel = this.table.createSearch(this.searchNames, this.searchLabels2);
        this.searchPanel.setCSSClass("headerPanel");
        TableHelper.createMenu((CommonTable)this.table, (Action[])this.headerActions, (Action[])this.rowActions, (TableRowMethod)this.tableRowMethod);
        Action filterAction = this.table.createFilterAction(this.searchNames, this.searchLabels2, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
        this.getProcess().setAttribute("Table", (Object)this.table);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject initEditForm(DataObject object) throws Exception {
        this.asset = (Asset)TableHelper.getSelectedItem((DataObject)object);
        return this.initEditFormContinued(object);
    }

    public DataObject initEditFormContinued(DataObject object) throws Exception {
        if (AssetBO.hasNotPostedTransactions(this.asset)) {
            object.addUIObject((UIObject)new Message("asset_has_not_posted_transactions", "error"));
            return object;
        }
        Action action = null;
        boolean ok = new AssetAssetTypeChangeBP(this.company, this.numberOfPeriods).validateForChangeType(this.asset);
        if (ok) {
            this.getProcess().setAttribute("AssetAssetTypeChangeAdapterAsset", (Object)this.asset);
            action = this.changeType;
        }
        this.panels = new AssetPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.governmentActivated, this.asset, false, false, false, null, false, null, action);
        this.panels.setValues();
        if (this.governmentActivated && this.asset.getLoan()) {
            this.panels.updateSecondPanelLabels();
            this.panels.updateAccountingPrincipleForms(true);
            for (int index = 0; index < 3; ++index) {
                if (this.panels.depreciatableLife[index] == null) continue;
                this.panels.depreciatableLife[index].setReadonly(false);
            }
        }
        this.panels.fbMove.alignment(1);
        this.panels.fbMove.addAction(new Action(this.movementActionName).setAdapter(this.getProcessAdapterPageName(MovementAdapter.PAGE)).setMethod("movementForm"));
        AssetAcquisitionTransactionAdapter aatAdapter = (AssetAcquisitionTransactionAdapter)this.getProcess().getAdapterByName("nl.ibs.fac.adapters.AssetAcquisitionTransactionAdapter");
        this.panels.addAcquisitionTransactionTable(aatAdapter.getHeader(this.asset), aatAdapter.getTable(), aatAdapter.getFloatBar());
        this.getProcess().setAttribute("ParentAssetAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("ParentAssetAdapterReturnMethod", (Object)EDITFORM);
        if (this.asset.getState() > 2) {
            this.panels.fbParent.enableActions(false);
        } else {
            this.panels.fbParent.addAction(this.panels.getCreateParentAssetAction().setAdapter(this.getProcessAdapterPageName(ParentAssetAdapter.PAGE)).setMethod("initCreateForm"));
        }
        this.getProcess().setAttribute("AssetAcquisitionTransactionAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("AssetAcquisitionTransactionAdapterReturnMethod", (Object)"handleInvestmentDisinvestment");
        if (this.asset.getState() == 2) {
            this.getProcess().setAttribute("MovementAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
            this.getProcess().setAttribute("MovementAdapterReturnMethod", (Object)"handleMovement");
            this.getProcess().setAttribute("assetToMove", (Object)this.asset);
            this.getProcess().setAttribute("assetToMoveAssetType", (Object)this.asset.getAssetType());
            if (this.governmentActivated && this.asset.getLoan()) {
                this.getProcess().setAttribute("AdditionalDepreciationAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
                this.getProcess().setAttribute("AdditionalDepreciationAdapterReturnMethod", (Object)"handleAdditionalDepreciation");
                this.getProcess().setAttribute("additionalDepreciationAsset", (Object)this.asset);
                this.panels.addAdditionalDepreciationAction(new Action(this.additionalDepreciationActionName).setAdapter(this.getProcessAdapterPageName(AdditionalDepreciationAdapter.PAGE)).setMethod("additionalDepreciationForm"));
            } else {
                if (AssetBO.getLastDepreciatedPeriod(this.asset)[0] > 0) {
                    this.getProcess().setAttribute("ValuationCorrectionAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
                    this.getProcess().setAttribute("ValuationCorrectionAdapterReturnMethod", (Object)"handleValuationCorrection");
                    this.getProcess().setAttribute("correctionAsset", (Object)this.asset);
                    this.panels.addValuationCorrectionAction(new Action(this.valuationCorrectionActionName).setAdapter(this.getProcessAdapterPageName(ValuationCorrectionAdapter.PAGE)).setMethod("correctionForm"));
                }
                this.getProcess().setAttribute("AdditionalDepreciationAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
                this.getProcess().setAttribute("AdditionalDepreciationAdapterReturnMethod", (Object)"handleAdditionalDepreciation");
                this.getProcess().setAttribute("additionalDepreciationAsset", (Object)this.asset);
                this.panels.addAdditionalDepreciationAction(new Action(this.additionalDepreciationActionName).setAdapter(this.getProcessAdapterPageName(AdditionalDepreciationAdapter.PAGE)).setMethod("additionalDepreciationForm"));
            }
            if (this.governmentActivated && this.company.getUseValuationMainAccount()) {
                this.getProcess().setAttribute("asset", (Object)this.asset);
                this.panels.addMainAccountAction(new Action("Label.MainAccountScheme").setAdapter(this.getProcessAdapterPageName(ValuationMainAccountAdapter.PAGE)).setMethod("show"));
            }
            if (this.asset.getAssetType().getUseDifferentAcquisitionValues()) {
                this.getProcess().setAttribute("AP2AcquisitionValueAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
                this.getProcess().setAttribute("AP2AcquisitionValueAdapterReturnMethod", (Object)"handleAP2AcquisitionValue");
                this.getProcess().setAttribute("ap2AcquisitionValueAsset", (Object)this.asset);
                this.panels.addAP2AcquisitionValueAction(new Action(this.ap2AcquisitionValueActionName).setAdapter(this.getProcessAdapterPageName(AP2AcquisitionValueAdapter.PAGE)).setMethod("ap2AcquisitionValueForm"));
            }
        } else {
            this.panels.removeValuationCorrectionAction(this.valuationCorrectionActionName);
            this.panels.removeAdditionalDepreciationAction(this.additionalDepreciationActionName);
            if (this.governmentActivated && this.company.getUseValuationMainAccount()) {
                this.panels.removeMainAccountAction("Label.MainAccountScheme");
            }
            if (this.asset.getAssetType().getAccountingPrinciple2IsUsed()) {
                this.panels.removeAP2AcquisitionValueAction(this.ap2AcquisitionValueActionName);
            }
        }
        return this.editForm(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.handleNewParent();
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.EditAsset", "screen_name"));
        object.addUIObject((UIObject)this.panels.headerPanel);
        object.addUIObject((UIObject)this.panels.mainTabPanel);
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = this.panels.update();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("id", (Object)this.asset.getId(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject initICMovement(DataObject object) throws Exception {
        this.asset = (Asset)TableHelper.getSelectedItem((DataObject)object);
        this.getProcess().setAttribute("InterCompanyMovementAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("InterCompanyMovementAdapterReturnMethod", (Object)"reload");
        this.getProcess().setAttribute("InterCompanyMovementAsset", (Object)this.asset);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(InterCompanyMovementAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    public DataObject reload(DataObject object) throws Exception {
        return this.initEditFormContinued(object);
    }

    public DataObject reportWindow(DataObject object) throws Exception {
        Object[] assets = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (assets.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        Window window = new Window();
        window.setTop("10%");
        window.setRight("15%");
        window.setLabel("Label.PrintAsset");
        FieldGroup fg = new FieldGroup();
        this.inclTrans.setValue(false);
        fg.add(this.inclTrans);
        FloatBar fb = new FloatBar();
        fb.addAction(new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("report").putObject((Object)"assets", (Object)assets));
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("show"));
        fg.add(fb);
        window.add(fg);
        object.addUIObject((UIObject)window);
        return object;
    }

    public DataObject report(DataObject object) throws Exception {
        Object[] assets = (Object[])object.getExecutedActionObject().getObject((Object)"assets");
        for (int i = 0; i < assets.length; ++i) {
            this.asset = (Asset)assets[i];
            String[][] selections = new String[][]{{"User", this.loginHelper.getUser()}, {"System", this.loginHelper.getSystem()}, {"Password", Scrambler.scramble((String)this.loginHelper.getPassword())}, {"facLib", this.dbData.getSchema()}, {"governmentActivated", "" + this.governmentActivated}, {"Environment", this.env.getId()}, {"Company", this.companyId}, {"BookYear", this.bookYear}, {"FromAsset", this.asset.getId()}, {"ToAsset", this.asset.getId()}, {"PrintTransactions", this.inclTrans.getBoolean().toString()}};
            this.getProcess().setAttribute("selections", (Object)selections);
            this.getProcess().setAttribute("classNamePDF", (Object)CLASSNAMEPDF);
            this.getProcess().setAttribute("jobName", (Object)JOBNAME);
            this.getProcess().setAttribute("returnPage", (Object)PAGE);
            object = ((SubmitAdapter)this.getProcess().getAdapterByName(SubmitAdapter.PAGE)).submit(object);
        }
        return object;
    }

    public DataObject reportAll(DataObject object) throws Exception {
        this.getProcess().setAttribute("returnPage", (Object)PAGE);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(AssetReportAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    private void handleNewParent() throws Exception {
        Object newParentId = this.getProcess().getAttribute("NewParentId");
        if (newParentId != null) {
            this.panels.setNewParent(newParentId.toString(), this.getProcess().getAttribute("NewParentDescription").toString());
            this.getProcess().removeAttribute("NewParentId");
            this.getProcess().removeAttribute("NewParentDescription");
        }
    }

    public DataObject handleMovement(DataObject dataObject) throws Exception {
        Object object = this.getProcess().getAttribute("NewFinDimIds");
        if (object == null) {
            return this.editForm(dataObject);
        }
        this.ids = (String[])this.getProcess().getAttribute("NewFinDimIds");
        this.dsc = (String[])this.getProcess().getAttribute("NewFinDimDescriptions");
        for (int index = 0; index < 5; ++index) {
            if (this.ids[0].equals("")) continue;
            this.setFinDimValues(index);
        }
        this.getProcess().removeAttribute("NewFinDimIds");
        this.getProcess().removeAttribute("NewFinDimDescriptions");
        return this.editForm(dataObject);
    }

    public DataObject handleValuationCorrection(DataObject object) throws Exception {
        this.panels.setAPValues();
        return this.editForm(object);
    }

    public DataObject handleAdditionalDepreciation(DataObject object) throws Exception {
        this.panels.setAPValues();
        return this.editForm(object);
    }

    public DataObject handleAP2AcquisitionValue(DataObject object) throws Exception {
        this.panels.setAPValues();
        return this.editForm(object);
    }

    public DataObject handleInvestmentDisinvestment(DataObject object) throws Exception {
        AssetAcquisitionTransactionAdapter aatAdapter = (AssetAcquisitionTransactionAdapter)this.getProcess().getAdapterByName("nl.ibs.fac.adapters.AssetAcquisitionTransactionAdapter");
        this.panels.addAcquisitionTransactionTable(aatAdapter.getHeader(this.asset), aatAdapter.getTable(), aatAdapter.getFloatBar());
        this.panels.setAPValues();
        if (this.asset.getState() > 2) {
            this.panels.fbParent.enableActions(false);
            this.panels.parent.setReadonly(true);
        }
        return this.editForm(object);
    }

    private void setFinDimValues(int index) throws Exception {
        if (this.panels.dimensionPanels.financialDimension[index] != null) {
            this.panels.dimensionPanels.financialDimension[index].setValue(this.ids[index]);
            this.panels.dimensionPanels.financialDimension[index].setDescription(this.dsc[index]);
        }
    }

    private void modifyTableArrays() throws Exception {
        if (AssetBO.isIdNumeric(this.company, false)) {
            this.types[0] = "number";
            AssetAdapter.transformers[0] = NUMERIC_ID_TRANSFORMER;
        }
        int[] finDimUsage = new int[]{this.company.retrieveFinancialDimension1Usage(), this.company.retrieveFinancialDimension2Usage(), this.company.retrieveFinancialDimension3Usage(), this.company.retrieveFinancialDimension4Usage(), this.company.retrieveFinancialDimension5Usage()};
        int oldArrayLength = NAMES.length;
        int newArrayLength = NAMES.length;
        for (int i = 0; i < 5; ++i) {
            if (finDimUsage[i] != 0) continue;
            --newArrayLength;
        }
        if (newArrayLength == oldArrayLength) {
            this.names2 = NAMES;
            this.labels2 = this.labels;
            this.searchNames = SEARCHNAMES;
            this.searchLabels2 = this.searchLabels;
            this.sizes2 = SIZES;
            this.types2 = this.types;
            this.transformers2 = transformers;
            return;
        }
        this.names2 = new String[newArrayLength];
        this.labels2 = new String[newArrayLength];
        this.sizes2 = new short[newArrayLength];
        this.types2 = new String[newArrayLength];
        this.transformers2 = new Transformer[newArrayLength];
        int j = 0;
        for (int i = 0; i < oldArrayLength; ++i) {
            if (i >= 6 && i < 11 && finDimUsage[i - 6] == 0) continue;
            this.names2[j] = NAMES[i];
            this.labels2[j] = this.labels[i];
            this.sizes2[j] = SIZES[i];
            this.types2[j] = this.types[i];
            this.transformers2[j] = transformers[i];
            ++j;
        }
        this.searchNames = this.names2;
        this.searchLabels2 = this.labels2;
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.assets = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        for (int i = 0; i < this.assets.length; ++i) {
            Asset asset = (Asset)this.assets[i];
            if (asset == null) continue;
            if (AssetBO.hasNotPostedTransactions(asset)) {
                object.addUIObject((UIObject)new Message("asset_has_not_posted_transactions", "error"));
                return object;
            }
            for (Transaction transaction : TransactionBO.getTransactions(this.company.getCurrentTransactionBatch())) {
                if (!asset.getId().equals(transaction.getAssetId())) continue;
                object.addUIObject((UIObject)new Message("asset_has_not_posted_transactions", "error"));
                return object;
            }
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Label.DeleteAsset", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.assets.length);
        for (int i = 0; i < this.assets.length; ++i) {
            list.add(this.assets[i]);
        }
        CollectionTable table = new CollectionTable(Asset.class, list, 12);
        table.setName(PAGE + "_DLT");
        table.setColumnNames(this.names2);
        table.setColumnLabels(this.labels2);
        table.setColumnSizes(this.sizes2);
        table.setColumnTypes(this.types2);
        table.setDisplayTransformers(this.transformers2);
        table.setColumnNoWraps(COLUMNNOWRAPS);
        table.setColumnSortable(SORTABLE);
        table.setSortable(true);
        table.orderByColumn("id");
        table.reload();
        TableHelper.setHeaderTooltips((CommonTable)table, (String[])TOOLTIPS);
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        for (int i = 0; i < this.assets.length; ++i) {
            Asset asset = (Asset)this.assets[i];
            if (asset == null) continue;
            message = MassRemoveBP.removeDependentObjects(asset);
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return object;
            }
            asset.delete();
        }
        this.table = null;
        return this.show(object);
    }

    static {
        DECIMAL_TRANSFORMER = new DecimalTransformer();
        NUMERIC_ID_TRANSFORMER = new NumericIdTransformer();
        COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        SORTABLE = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        CLASSNAMEPDF = AssetToPDF.CLASSNAME;
    }

    private class AssetTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = -151294501518130837L;

        private AssetTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            Asset asset = (Asset)row.getObject();
            ContextMenu menu = new ContextMenu();
            for (int i = 0; i < rowActions.length; ++i) {
                if (rowActions[i].getLanguageCode().equals("Button.Delete") && asset.getState() < 4 || rowActions[i].getLanguageCode().equals("Button.InterCompanyMovement") && asset.getState() > 2) continue;
                ContextAction rowAction = new ContextAction(rowActions[i].getName());
                rowAction.setAdapter(rowActions[i].getPageid());
                rowAction.setMethod(rowActions[i].getMethod());
                menu.addContextMenuItem(rowAction);
            }
            row.setContextMenu(menu);
        }
    }
}

