/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.event.EventListener;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.UserErrorMessage;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.adapters.AssetPanels;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.bp.AssetAssetTypeChangeBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.gov.bp.GenericGovernmentBP;

public class AssetAssetTypeChangeAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 146384013799728790L;
    public static final String PAGE = AssetAssetTypeChangeAdapter.class.getName();
    public static final String RETURNPAGE = "AssetAssetTypeChangeAdapterReturnPage";
    public static final String RETURNMETHOD = "AssetAssetTypeChangeAdapterReturnMethod";
    public static final String ASSET = "AssetAssetTypeChangeAdapterAsset";
    private AssetAssetTypeChangeBP assetAssetTypeChangeBP;
    private Company company;
    private Asset asset;
    private FieldGroup fg;
    private BookYearPeriodGrid facYearPeriod;
    private BookYearPeriodGrid finYearPeriod;
    private AssetTypeReferenceField typeTo;
    protected TypeListener typeListener = new TypeListener();
    private AssetType assetType;
    private FloatBar fb = new FloatBar();
    private AssetPanels panels;
    private GenericGovernmentBP genericGovernmentBP;
    private FieldGroup maFieldGroup;
    private Window window;

    public AssetAssetTypeChangeAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.assetAssetTypeChangeBP = new AssetAssetTypeChangeBP(this.company, this.numberOfPeriods);
        if (this.company.getUseValuationMainAccount()) {
            this.genericGovernmentBP = new GenericGovernmentBP(this.company);
        }
        this.fg = new FieldGroup();
        this.typeTo = new AssetTypeReferenceField(this.dbData, this.companyId);
        this.typeTo.setLabel("Label.TypeNew");
        this.typeTo.setDescriptionLength(35);
        this.typeTo.setMandatory(true);
        this.typeTo.addOnChangeListener(this.typeListener);
        this.fg.add((Field)this.typeTo);
        this.facYearPeriod = new BookYearPeriodGrid("Label.FACStartPeriod", "" + this.company.getCurrentBookYear(), this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.finYearPeriod = new BookYearPeriodGrid("Label.BookPeriod", false);
        this.fg.add((ESPGridLayout)this.facYearPeriod);
        this.fg.add((ESPGridLayout)this.finYearPeriod);
        Action ok = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("validateForm");
        ok.setDefault(true);
        ok.setValidationEnabled(true);
        this.fb.addAction(ok);
        this.fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("closeWindow"));
    }

    public DataObject show(DataObject object) throws Exception {
        this.asset = (Asset)this.getProcess().getAttribute(ASSET);
        this.panels = new AssetPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.governmentActivated, null, false, false, false, null, false, null, null);
        this.maFieldGroup = null;
        this.typeTo.setValue();
        String[] yps = this.assetAssetTypeChangeBP.retrieveYearsAndPeriods(this.asset);
        this.facYearPeriod.setValues(yps[0], yps[1]);
        this.finYearPeriod.setValues(yps[2], yps[3]);
        return this.showContinued(object);
    }

    private void createWindow(DataObject object, String label) throws Exception {
        if (this.window != null) {
            this.closeWindow(object);
        }
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "closeWindow");
        this.window.setWidth(775);
        this.window.setLabel(object.translate("Title.ChangeAssetType", object.getLocale()) + " - " + object.translate(label, object.getLocale()));
        this.window.add(this.fg);
    }

    public DataObject closeWindow(DataObject object) throws Exception {
        this.window.closeWindow(object);
        return object;
    }

    public DataObject showContinued(DataObject object) throws Exception {
        this.createWindow(object, "Label.Common");
        this.typeTo.setReadonly(false);
        this.facYearPeriod.setReadonly(true);
        this.finYearPeriod.setReadonly(false);
        this.window.add(this.fb);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject validateForm(DataObject object) throws Exception {
        String[] messages = this.assetAssetTypeChangeBP.validateTypeTo(this.asset.getAssetType(), this.assetType);
        if (messages != null) {
            this.typeTo.setInvalidTag();
            throw new UserErrorMessage(messages[0]);
        }
        messages = this.assetAssetTypeChangeBP.validateFACYearAndPeriod(this.asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue());
        if (messages != null) {
            this.facYearPeriod.setInvalidTag();
            throw new UserErrorMessage(messages[0]);
        }
        messages = this.assetAssetTypeChangeBP.validateFINYearAndPeriod(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax));
        if (messages != null) {
            this.finYearPeriod.setInvalidTag();
            throw new UserErrorMessage(messages[0]);
        }
        return this.createDimensionsForm(object);
    }

    public DataObject createDimensionsForm(DataObject object) throws Exception {
        this.panels.setAsset(this.asset);
        this.panels.initializeType();
        this.panels.setAsset(null);
        return this.createDimensionsFormContinued(object);
    }

    public DataObject createDimensionsFormContinued(DataObject object) throws Exception {
        this.createWindow(object, "Label.Dimensions");
        this.typeTo.setReadonly(true);
        this.finYearPeriod.setReadonly(true);
        this.window.add(this.panels.finDimensionPanel);
        this.window.add(this.panels.facDimensionPanel);
        FloatBar fb = new FloatBar();
        Action action = new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showContinued");
        fb.addAction(action);
        action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleForm");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("closeWindow"));
        this.window.add(fb);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject createAccountingPrincipleFormNext(DataObject object) throws Exception {
        String message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        ++this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleFormPrevious(DataObject object) throws Exception {
        --this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleForm(DataObject object) throws Exception {
        this.createWindow(object, this.panels.getAccountingPrincipleTabText());
        this.panels.startDepreciation[this.panels.apTabCount].setValues(this.facYearPeriod.getBookYear().getValue(), this.facYearPeriod.getPeriod().getValue());
        this.panels.investmentYP.setValues(this.facYearPeriod.getBookYear().getValue(), this.facYearPeriod.getPeriod().getValue());
        this.panels.valuation[this.panels.apTabCount] = (Valuation)ValuationBO.get(this.dbData, this.company.getId(), this.asset.getCora(), this.asset.getId(), this.panels.ap[this.panels.apTabCount])[0];
        BigDecimal acquisitionBalance = this.panels.valuation[this.panels.apTabCount].getPostedAcquisitionBalance();
        this.panels.acquisitionValue.setValue(acquisitionBalance);
        this.window.add(this.panels.apPanels[this.panels.apTabCount]);
        FloatBar fbCreateAP = new FloatBar();
        Action action = this.panels.apTabCount == 0 ? new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createDimensionsFormContinued") : new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormPrevious");
        fbCreateAP.addAction(action);
        action = this.panels.apTabCount == this.panels.apTabCountMax ? (this.company.getUseValuationMainAccount() ? new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createMainAccountForm") : new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("changeAssetType")) : new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormNext");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fbCreateAP.addAction(action);
        fbCreateAP.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("closeWindow"));
        this.window.add(fbCreateAP);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject createMainAccountForm(DataObject object) throws Exception {
        String message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.createWindow(object, "Label.MainAccountSchemeData");
        if (this.maFieldGroup == null) {
            this.maFieldGroup = this.genericGovernmentBP.getInitialMainAccountFieldGroup(this.loginHelper, this.assetType, 1, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue());
        }
        this.window.add(this.maFieldGroup);
        FloatBar fb = new FloatBar();
        fb.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleForm"));
        Action action = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("changeAssetType");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("closeWindow"));
        this.window.add(fb);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject changeAssetType(DataObject object) throws Exception {
        String message;
        if (!this.company.getUseValuationMainAccount()) {
            message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return object;
            }
        } else {
            this.panels.mainAccountIds = this.genericGovernmentBP.getFormattedMainAccountIds();
        }
        if ((message = this.assetAssetTypeChangeBP.changeAssetType(this.asset, this.panels, this.assetType, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.panels.acquisitionValue.getBigDecimal(), this.loginHelper.getUser(), -1)) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        object.addUIObject((UIObject)new RedirectAction(this.getProcess().getAttribute(RETURNPAGE).toString(), this.getProcess().getAttribute(RETURNMETHOD).toString(), this.getProcess().getProcessId()));
        return object;
    }

    private class TypeListener
    implements EventListener {
        private static final long serialVersionUID = -8241496142961208972L;

        private TypeListener() {
        }

        public void event(UIObject object, String eventType) throws Exception {
            Object[] result = AssetTypeBO.get(AssetAssetTypeChangeAdapter.this.dbData, AssetAssetTypeChangeAdapter.this.companyId, AssetAssetTypeChangeAdapter.this.typeTo.getValue().trim());
            AssetAssetTypeChangeAdapter.this.assetType = (AssetType)result[0];
            if (AssetAssetTypeChangeAdapter.this.assetType == null) {
                AssetAssetTypeChangeAdapter.this.typeTo.setDescription("");
                return;
            }
            AssetAssetTypeChangeAdapter.this.typeTo.setDescription(AssetAssetTypeChangeAdapter.this.assetType.getDescription());
            AssetAssetTypeChangeAdapter.this.panels.setAssetType(AssetAssetTypeChangeAdapter.this.assetType);
            AssetAssetTypeChangeAdapter.this.panels.initializeType();
        }
    }
}

