/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.AssetPanels;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.ParentAssetAdapter;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.AssetBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.gov.bp.GenericGovernmentBP;

public class AssetCreateAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -612106853436130069L;
    public static final String PAGE = AssetCreateAdapter.class.getName();
    private Company company;
    private AssetPanels panels;
    private FloatBar fbCreate = new FloatBar();
    private GenericGovernmentBP genericGovernmentBP;
    private FieldGroup maFieldGroup = null;

    public AssetCreateAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        if (this.company.getUseValuationMainAccount()) {
            this.genericGovernmentBP = new GenericGovernmentBP(this.company);
        }
        Action createOK = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createDimensionsForm");
        createOK.setDefault(true);
        createOK.setValidationEnabled(true);
        this.fbCreate.addAction(createOK);
        this.fbCreate.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.maFieldGroup = null;
        this.panels = new AssetPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.governmentActivated, null, false, false, false, null, false, null, null);
        this.getProcess().setAttribute("ParentAssetAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("ParentAssetAdapterReturnMethod", (Object)"createCommonForm");
        this.panels.fbParent.addAction(this.panels.getCreateParentAssetAction().setAdapter(this.getProcessAdapterPageName(ParentAssetAdapter.PAGE)).setMethod("initCreateForm"));
        return this.createCommonForm(object);
    }

    public DataObject createCommonForm(DataObject object) throws Exception {
        this.handleNewParent();
        this.panels.id.setReadonly(this.panels.idReadOnly);
        this.panels.id.setLabel("");
        this.panels.description.setReadonly(false);
        this.panels.description.setLabel("");
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateAsset", "screen_name"));
        object.addUIObject((UIObject)new Header("Label.Common", "sub_screen_name"));
        object.addUIObject((UIObject)this.panels.firstPanel);
        object.addUIObject((UIObject)this.panels.secondPanel);
        object.addUIObject((UIObject)this.fbCreate);
        return object;
    }

    public DataObject createDimensionsForm(DataObject object) throws Exception {
        String message;
        if (!this.panels.id.isHidden()) {
            Object[] result;
            if ("number".equals(this.panels.id.getType())) {
                try {
                    if (Integer.parseInt(this.panels.id.getValue()) <= 0) {
                        this.panels.id.setInvalidTag();
                        object.addUIObject((UIObject)new Message("value_must_be_positive", "error"));
                        return object;
                    }
                }
                catch (NumberFormatException nfe) {
                    this.panels.id.setInvalidTag();
                    object.addUIObject((UIObject)new Message("not_a_number", "error"));
                    return object;
                }
            }
            if ((result = AssetBO.get(this.company, this.panels.id.getValue().trim(), false))[0] != null) {
                this.panels.id.setInvalidTag();
                object.addUIObject((UIObject)new Message("duplicate_key", "error"));
                return object;
            }
        }
        if ((message = this.panels.validateCommonForm()) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.panels.id.setReadonly(true);
        this.panels.id.setLabel("Label.Id");
        this.panels.id.setHelpId("Label.AssetId");
        this.panels.description.setReadonly(true);
        this.panels.description.setLabel("Label.Description");
        this.panels.initializeType();
        this.panels.copyStartUsePeriod();
        return this.createDimensionsFormContinued(object);
    }

    public DataObject createDimensionsFormContinued(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        Header header = new Header("Title.CreateAsset", "screen_name");
        header.setHelpId("Title.CreateAssetDimensions");
        object.addUIObject((UIObject)header);
        header = new Header("Label.Dimensions", "sub_screen_name");
        object.addUIObject((UIObject)header);
        object.addUIObject((UIObject)this.panels.headerPanel);
        object.addUIObject((UIObject)this.panels.finDimensionPanel);
        object.addUIObject((UIObject)this.panels.facDimensionPanel);
        FloatBar fb = new FloatBar();
        Action action = new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createCommonForm");
        fb.addAction(action);
        action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleForm");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(this.cancel);
        object.addUIObject((UIObject)fb);
        return object;
    }

    public DataObject createAccountingPrincipleFormNext(DataObject object) throws Exception {
        String message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        ++this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleFormPrevious(DataObject object) throws Exception {
        --this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleForm(DataObject object) throws Exception {
        this.panels.id.setReadonly(true);
        this.panels.description.setReadonly(true);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateAsset", "screen_name"));
        if (!this.env.getGovernmentActivated()) {
            object.addUIObject((UIObject)new Header(this.panels.getAccountingPrincipleTabText(), "sub_screen_name"));
        } else {
            object.addUIObject((UIObject)new Header("Label.Valuation_Short", "sub_screen_name"));
        }
        object.addUIObject((UIObject)this.panels.headerPanel);
        object.addUIObject((UIObject)this.panels.apPanels[this.panels.apTabCount]);
        this.panels.copyValues();
        FloatBar fbCreateAP = new FloatBar();
        Action action = this.panels.apTabCount == 0 ? new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createDimensionsFormContinued") : new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormPrevious");
        fbCreateAP.addAction(action);
        if (this.panels.apTabCount == this.panels.apTabCountMax) {
            if (!this.company.getUseValuationMainAccount()) {
                action = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("create");
                action.setDefault(true);
                action.setValidationEnabled(true);
                fbCreateAP.addAction(action);
            } else {
                action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createMainAccountForm");
                action.setDefault(true);
                action.setValidationEnabled(true);
                fbCreateAP.addAction(action);
            }
        } else {
            action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormNext");
            action.setDefault(true);
            action.setValidationEnabled(true);
            fbCreateAP.addAction(action);
        }
        fbCreateAP.addAction(this.cancel);
        object.addUIObject((UIObject)fbCreateAP);
        return object;
    }

    public DataObject createMainAccountForm(DataObject object) throws Exception {
        String message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        ++this.panels.apTabCount;
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateAsset", "screen_name"));
        object.addUIObject((UIObject)new Header("Label.MainAccounts", "sub_screen_name"));
        object.addUIObject((UIObject)this.panels.headerPanel);
        if (this.maFieldGroup == null) {
            this.maFieldGroup = this.genericGovernmentBP.getInitialMainAccountFieldGroup(this.loginHelper, this.panels.assetType, 1, this.panels.investmentYP.getBookYear().getIntValue(), this.panels.investmentYP.getPeriod().getIntValue());
        }
        object.addUIObject((UIObject)this.maFieldGroup);
        FloatBar fb = new FloatBar();
        fb.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormPrevious"));
        Action action = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("create");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(this.cancel);
        object.addUIObject((UIObject)fb);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        Object[] result;
        String message;
        if (!this.company.getUseValuationMainAccount()) {
            message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return object;
            }
        } else {
            this.panels.mainAccountIds = this.genericGovernmentBP.getFormattedMainAccountIds();
        }
        if ((message = (String)(result = new AssetBP(this.panels).create(null, null, true))[1]) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        return this.show(object);
    }

    private void handleNewParent() throws Exception {
        Object newParentId = this.getProcess().getAttribute("NewParentId");
        if (newParentId != null) {
            this.panels.setNewParent(newParentId.toString(), this.getProcess().getAttribute("NewParentDescription").toString());
            this.getProcess().removeAttribute("NewParentId");
            this.getProcess().removeAttribute("NewParentDescription");
        }
    }
}

