/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.ObjectDataReader;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.AssetStateEnum;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.adapters.AnalysisGroupHelper;
import nl.ibs.fac.adapters.AssetDimensionPanels;
import nl.ibs.fac.adapters.AssetField;
import nl.ibs.fac.adapters.AssetReportAdapter;
import nl.ibs.fac.adapters.AssetStateImageTransformer;
import nl.ibs.fac.adapters.AssetTransactionAdapter;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.adapters.MemoAdapter;
import nl.ibs.fac.adapters.MemoImageTransformer;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.ParentAssetImageTransformer;
import nl.ibs.fac.adapters.ParentReferenceField;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetDataReader;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.queries.AssetQuery;
import nl.ibs.fac.reports.AssetToPDF;
import nl.ibs.util.Scrambler;

public class AssetInfoAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 1333802943592674500L;
    public static final String PAGE = AssetInfoAdapter.class.getName();
    private Company company;
    private String cId;
    private ODBTable table = null;
    protected CommonTable.SearchPanel searchPanel;
    private String[] names2;
    private String[] labels2;
    private String[] searchNames;
    private String[] searchLabels2;
    private short[] sizes2;
    private String[] types2;
    private Transformer[] transformers2;
    private static final String[] NAMES = new String[]{"id", "description", "typeId", "startUseYear", "startUsePeriod", "bookValue", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "parentId", "state", "hasMemo"};
    private static final String[] SEARCHNAMES = new String[]{"id", "description", "typeId", "startUseYear", "startUsePeriod", "bookValue", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "parentId", "state"};
    private static final String[] TOOLTIPS = new String[]{"Label.ParentAsset", "Label.State", "Label.Memo"};
    private String[] searchLabels;
    private String[] labels;
    private static final int LEADING_LABELS = 6;
    private static final int FIN_DIM_LABELS = 5;
    private static final short[] SIZES = new short[]{80, 200, 80, 35, 25, 100, 80, 80, 80, 80, 80, 20, 20, 20};
    private String[] types = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, "text", null};
    private Transformer[] transformers;
    private static final DecimalTransformer DECIMAL_TRANSFORMER = new DecimalTransformer();
    private static final NumericIdTransformer NUMERIC_ID_TRANSFORMER = new NumericIdTransformer();
    private static final boolean[] COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] SORTABLE = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private Map inputComponents = new HashMap();
    protected TableRowMethod tableRowMethod = null;
    protected FloatBar fbShow = new FloatBar();
    private CheckBox inclTrans = new CheckBox("Label.InclTransactions");
    protected Action[] rowActions;
    protected Action[] headerActions;
    private Asset asset;
    private static final String CLASSNAMEPDF = AssetToPDF.CLASSNAME;
    private static final String JOBNAME = "Job.Asset";

    public AssetInfoAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.searchLabels = new String[]{"Label.Id", "Label.Description", "Label.Type", "Label.Year", "Label.Period", "Label.BookValue", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5(), "Label.ParentAsset", "Label.State"};
        this.labels = new String[]{"Label.Id", "Label.Description", "Label.Type", "Label.Year", "Label.Period.short", "Label.BookValue", this.env.getShortName1(), this.env.getShortName2(), this.env.getShortName3(), this.env.getShortName4(), this.env.getShortName5(), "Label.ParentAsset", "Label.State", "Label.Memo"};
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.transformers = new Transformer[]{null, null, null, null, null, DECIMAL_TRANSFORMER, null, null, null, null, null, new ParentAssetImageTransformer(this.company), new AssetStateImageTransformer(), new MemoImageTransformer()};
        this.cId = this.companyId;
        if (this.dataSetId != null) {
            this.cId = this.dataSetId;
        }
        if (this.env.getOperationArea().trim().length() == 0) {
            for (int i = 0; i < 5; ++i) {
                this.transformers[6 + i] = NUMERIC_ID_TRANSFORMER;
                this.types[6 + i] = "number";
            }
        }
        this.modifyTableArrays();
        this.inputComponents.put("id", new AssetField(this.company, false));
        this.inputComponents.put("typeId", new AssetTypeReferenceField(this.dbData, this.cId));
        this.inputComponents.put("parentId", new ParentReferenceField(this.company, false));
        ComboBox state = EnumHelper.createComboBox("Label.State", AssetStateEnum.getCollection(), true);
        state.setWidth("180");
        this.inputComponents.put("state", state);
        Company dataSet = this.company;
        if (this.dataSetId != null) {
            dataSet = this.company.getDataSet();
        }
        AssetDimensionPanels dimensionPanels = new AssetDimensionPanels(this.loginHelper, this.dbData, this.env, this.company, false);
        FinancialReferenceField[] financialDimension = dimensionPanels.getFINDimensions();
        for (int i = 0; i < 5; ++i) {
            if (financialDimension[i] == null) continue;
            this.inputComponents.put(NAMES[i + 6], financialDimension[i]);
        }
        Object[] result = AnalysisGroupHelper.addAnalysisGroups(this.loginHelper, this.env, dataSet, this.inputComponents, this.searchNames, this.searchLabels2);
        this.searchNames = (String[])result[0];
        this.searchLabels2 = (String[])result[1];
        this.getProcess().setAttribute("AssetTransactionAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("AssetTransactionAdapterReturnMethod", (Object)"show");
        this.getProcess().setAttribute("MemoAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.tableRowMethod = new AssetTableRowMethod();
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("refresh");
        Action transactions = new Action("Button.Transactions").setAdapter(this.getProcessAdapterPageName(AssetTransactionAdapter.PAGE)).setMethod("show");
        Action report = new Action("Button.Report").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("reportWindow");
        Action reportAll = new Action("Button.Report").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("reportAll");
        Action memo = new Action("Label.Memo").setAdapter(this.getProcessAdapterPageName(MemoAdapter.PAGE)).setMethod("show");
        this.fbShow = new FloatBar();
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(report);
        this.fbShow.addAction(this.finish);
        this.headerActions = new Action[]{refresh, reportAll};
        this.rowActions = new Action[]{transactions, report, memo};
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.asset = null;
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.AssetInfo", "screen_name"));
        if (this.table == null) {
            this.createTable();
        } else {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    protected void createTable() throws Exception {
        AssetQuery query = new AssetQuery(this.dbData, this.companyId, null, new Boolean(true), false, new Boolean(false), true, false);
        this.table = new ODBTable((ObjectDataReader)new AssetDataReader(), (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setTextCodeMultipleObjects("Label.Assets");
        this.table.setColumnNames(this.names2);
        this.table.setColumnLabels(this.labels2);
        this.table.setColumnSizes(this.sizes2);
        this.table.setColumnTypes(this.types2);
        this.table.setDisplayTransformers(this.transformers2);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setInputComponents(this.inputComponents);
        this.table.setColumnSortable(SORTABLE);
        this.table.setSortable(true);
        this.table.setSelectable(true);
        this.table.orderByColumn("id");
        this.searchPanel = this.table.createSearch(this.searchNames, this.searchLabels2);
        this.searchPanel.setCSSClass("headerPanel");
        TableHelper.createMenu((CommonTable)this.table, (Action[])this.headerActions, (Action[])this.rowActions, (TableRowMethod)this.tableRowMethod);
        Action filterAction = this.table.createFilterAction(this.searchNames, this.searchLabels2, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
        this.getProcess().setAttribute("Table", (Object)this.table);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject reportWindow(DataObject object) throws Exception {
        Object[] assets = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (assets.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        Window window = new Window();
        window.setTop("10%");
        window.setRight("15%");
        window.setLabel("Label.PrintAsset");
        FieldGroup fg = new FieldGroup();
        this.inclTrans.setValue(false);
        fg.add(this.inclTrans);
        FloatBar fb = new FloatBar();
        fb.addAction(new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("report").putObject((Object)"assets", (Object)assets));
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("show"));
        fg.add(fb);
        window.add(fg);
        object.addUIObject((UIObject)window);
        return object;
    }

    public DataObject report(DataObject object) throws Exception {
        Object[] assets = (Object[])object.getExecutedActionObject().getObject((Object)"assets");
        for (int i = 0; i < assets.length; ++i) {
            this.asset = (Asset)assets[i];
            String[][] selections = new String[][]{{"User", this.loginHelper.getUser()}, {"System", this.loginHelper.getSystem()}, {"Password", Scrambler.scramble((String)this.loginHelper.getPassword())}, {"facLib", this.dbData.getSchema()}, {"governmentActivated", "" + this.governmentActivated}, {"Environment", this.env.getId()}, {"Company", this.companyId}, {"BookYear", this.bookYear}, {"FromAsset", this.asset.getId()}, {"ToAsset", this.asset.getId()}, {"PrintTransactions", this.inclTrans.getBoolean().toString()}};
            this.getProcess().setAttribute("selections", (Object)selections);
            this.getProcess().setAttribute("classNamePDF", (Object)CLASSNAMEPDF);
            this.getProcess().setAttribute("jobName", (Object)JOBNAME);
            this.getProcess().setAttribute("returnPage", (Object)PAGE);
            object = ((SubmitAdapter)this.getProcess().getAdapterByName(SubmitAdapter.PAGE)).submit(object);
        }
        return object;
    }

    public DataObject reportAll(DataObject object) throws Exception {
        this.getProcess().setAttribute("returnPage", (Object)PAGE);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(AssetReportAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    private void modifyTableArrays() throws Exception {
        if (AssetBO.isIdNumeric(this.company, false)) {
            this.types[0] = "number";
            this.transformers[0] = NUMERIC_ID_TRANSFORMER;
        }
        int[] finDimUsage = new int[]{this.company.retrieveFinancialDimension1Usage(), this.company.retrieveFinancialDimension2Usage(), this.company.retrieveFinancialDimension3Usage(), this.company.retrieveFinancialDimension4Usage(), this.company.retrieveFinancialDimension5Usage()};
        int oldArrayLength = NAMES.length;
        int newArrayLength = NAMES.length;
        for (int i = 0; i < 5; ++i) {
            if (finDimUsage[i] != 0) continue;
            --newArrayLength;
        }
        if (newArrayLength == oldArrayLength) {
            this.names2 = NAMES;
            this.labels2 = this.labels;
            this.searchNames = SEARCHNAMES;
            this.searchLabels2 = this.searchLabels;
            this.sizes2 = SIZES;
            this.types2 = this.types;
            this.transformers2 = this.transformers;
            return;
        }
        this.names2 = new String[newArrayLength];
        this.searchLabels2 = new String[newArrayLength];
        this.labels2 = new String[newArrayLength];
        this.sizes2 = new short[newArrayLength];
        this.types2 = new String[newArrayLength];
        this.transformers2 = new Transformer[newArrayLength];
        int j = 0;
        for (int i = 0; i < oldArrayLength; ++i) {
            if (i >= 6 && i < 11 && finDimUsage[i - 6] == 0) continue;
            this.names2[j] = NAMES[i];
            this.labels2[j] = this.labels[i];
            this.sizes2[j] = SIZES[i];
            this.types2[j] = this.types[i];
            this.transformers2[j] = this.transformers[i];
            ++j;
        }
        this.searchNames = this.names2;
        this.searchLabels2 = this.labels2;
    }

    private class AssetTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = -8908212449829197540L;

        private AssetTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            Asset asset = (Asset)row.getObject();
            ContextMenu menu = new ContextMenu();
            for (int i = 0; i < rowActions.length; ++i) {
                if (rowActions[i].getLanguageCode().equals("Label.Memo") && !asset.getHasMemo()) continue;
                ContextAction rowAction = new ContextAction(rowActions[i].getName());
                rowAction.setAdapter(rowActions[i].getPageid());
                rowAction.setMethod(rowActions[i].getMethod());
                menu.addContextMenuItem(rowAction);
            }
            row.setContextMenu(menu);
        }
    }
}

