/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.event.EventListener;
import nl.ibs.esp.language.TranslationHelperImpl;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.DateSelectionField;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabActivateAction;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.UserErrorMessage;
import nl.ibs.fac.AssetStateEnum;
import nl.ibs.fac.DepreciationMethodEnum;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.InterestCalculationMethodEnum;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.StartPeriodHandlingEnum;
import nl.ibs.fac.adapters.AssetDimensionPanels;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.InterestTableReferenceField;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.ParentReferenceField;
import nl.ibs.fac.adapters.YearPercentageTableReferenceField;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetTypeAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.InterestTableBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.boadapters.WozValueBO;
import nl.ibs.fac.boadapters.YearPercentageTableBO;
import nl.ibs.fac.bp.AssetBP;
import nl.ibs.fac.bp.InvestmentBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.AssetTypeAccountingPrincipleDefault;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.TotalEstimationTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.db.WozValue;
import nl.ibs.fac.db.YearPercentageTable;
import nl.ibs.fac.gov.adapters.ActivationSchemeReferenceField;
import nl.ibs.fac.ui.MessageHelper;
import nl.ibs.jsql.DBData;

public class AssetPanels
implements Serializable {
    private static final long serialVersionUID = 7322526639635848716L;
    public LoginHelper loginHelper;
    private DBData dbData = null;
    private Environment env = null;
    public Company company = null;
    public String companyOrDataSetId;
    private Asset asset;
    private String bookYearMin = null;
    private String bookYearMax = null;
    public int numberOfPeriods;
    private boolean governmentActivated;
    public boolean isParent = false;
    public boolean currentCapitalization = false;
    public boolean isCreditClosing = false;
    private Credit theCredit;
    public Panel headerPanel;
    public FieldGroup firstPanel;
    private ESPGridLayout grid;
    public Field id = new Field("Label.Id", "upper");
    public boolean idReadOnly = false;
    protected NumericIdTransformer numericIdTransformer = null;
    public Field description = new Field("Label.Description");
    private Field state = new Field("Label.State");
    public AssetTypeReferenceField type;
    protected TypeListener typeListener = new TypeListener();
    public ActivationSchemeReferenceField asrf;
    public TotalEstimationTransaction activationSchemeTransaction = null;
    public AssetType assetType;
    private boolean assetTypeChanged = false;
    public ParentReferenceField parent;
    protected FieldGroup secondPanel;
    public CheckBox negativeInvestment = new CheckBox();
    public CheckBox loan = new CheckBox();
    public FACDecimalField acquisitionValue = new FACDecimalField("", 15, 2);
    public FACDecimalField payOffYearAmount = new FACDecimalField("", 15, 2);
    public DateSelectionField acquisitionDate = new DateSelectionField();
    public BookYearPeriodGrid investmentYP;
    public BookYearPeriodGrid historicalYP;
    public BookYearPeriodGrid bookYP;
    public Asset parentAsset;
    private Label secondPanelLabel1;
    private Label secondPanelLabel2;
    private Label secondPanelLabel3;
    private Label secondPanelLabel4;
    private Label secondPanelLabel5;
    public AssetDimensionPanels dimensionPanels;
    public FieldGroup finDimensionPanel;
    public FieldGroup facDimensionPanel;
    public FloatBar fbMove = new FloatBar();
    private FloatBar ap2AcquisitionValueFloatBar;
    private Tab apTab;
    private FloatBar fbAP = new FloatBar();
    public Panel[] apPanels = new Panel[3];
    private TabbedPanel apTabbedPanel;
    protected Tab[] apTabs = new Tab[3];
    public int[] ap = new int[4];
    public boolean useAccountingPrinciple2 = false;
    public FieldGroup[] values = new FieldGroup[3];
    public FACDecimalField[] acquTotal = new FACDecimalField[3];
    public FACDecimalField[] deprTotal = new FACDecimalField[3];
    public FACDecimalField[] bookTotal = new FACDecimalField[3];
    private Label[] deprTotalBELLabel = new Label[3];
    public FACDecimalField[] deprTotalBEL = new FACDecimalField[3];
    public NumberField[] depreciatableLife = new NumberField[3];
    public NumberField[] nbrOfDeprPers = new NumberField[3];
    public NumberField[] remainingLife = new NumberField[3];
    private FieldGroup[] depreciationGroups = new FieldGroup[3];
    public ComboBox[] depreciationMethod = new ComboBox[3];
    public FACDecimalField[] degressivePercentage = new FACDecimalField[3];
    public ODBQueryReferenceField[] yearPercentageTableId = new ODBQueryReferenceField[3];
    public ODBQueryReferenceField[] annuityInterestTableId = new ODBQueryReferenceField[3];
    public FACDecimalField[] annuityPercentage = new FACDecimalField[3];
    public ComboBox[] startPeriodHandlingMethod = new ComboBox[3];
    private StartPeriodHandlingMethodChangeAction[] startPeriodHandlingMethodChangeAction = new StartPeriodHandlingMethodChangeAction[3];
    public CheckBox[] depreciationPaused = new CheckBox[3];
    public FieldGroup[] depreciationGroups2 = new FieldGroup[3];
    public BookYearPeriodGrid[] startDepreciation = new BookYearPeriodGrid[3];
    public BookYearPeriodGrid[] lastDepreciated = new BookYearPeriodGrid[3];
    public FACDecimalField[] residualValue = new FACDecimalField[3];
    public FACDecimalField[] residualPercentage = new FACDecimalField[3];
    private Label[] beyondEconomicLifePercentageLabel = new Label[3];
    public FACDecimalField[] beyondEconomicLifePercentage = new FACDecimalField[3];
    private FieldGroup[] interestGroups = new FieldGroup[3];
    public ComboBox[] interestCalculationMethod = new ComboBox[3];
    public FACDecimalField[] interestPercentage = new FACDecimalField[3];
    public ODBQueryReferenceField[] interestTableId = new ODBQueryReferenceField[3];
    private DepreciationMethodChangeAction[] depreciationMethodChangeAction = new DepreciationMethodChangeAction[3];
    private InterestCalculationMethodChangeAction[] interestCalculationMethodChangeAction = new InterestCalculationMethodChangeAction[3];
    public BookYearPeriodGrid[] startInterest = new BookYearPeriodGrid[3];
    public int[] jtAp = new int[4];
    protected TabbedPanel mainTabPanel;
    protected String[] apTabTexts = new String[3];
    private String[] jtTabTexts = new String[4];
    private int mode = 0;
    private static final int NEW = 0;
    private static final int UPDATE = 1;
    public int apTabCount = 0;
    public int apTabCountMax = 0;
    public Valuation[] valuation = new Valuation[4];
    public Transaction transaction;
    public Transaction[] transactions = new Transaction[2];
    private Tab commonTab;
    private Tab dimTab;
    private Tab diTab;
    public FloatBar fbParent;
    private InvestmentBP investmentBP;
    private IncomingFinancialTransaction ift;
    private static final String GRID_FILL_NONE = ESPGridLayoutConstraints.GRID_FILL_NONE;
    private static final String GRID_ANCHOR_WEST = ESPGridLayoutConstraints.GRID_ANCHOR_WEST;
    public String[] mainAccountIds = null;
    private Action changeType;

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    public AssetPanels(LoginHelper loginHelper, DBData dbData, Environment env, Company company, String bookYearMin, String bookYearMax, int numberOfPeriods, boolean governmentActivated, Asset asset, boolean credit, boolean isParent, boolean currentCapitalization, IncomingFinancialTransaction ift, boolean isCreditClosing, Credit theCredit, Action changeType) throws Exception {
        this.loginHelper = loginHelper;
        this.dbData = dbData;
        this.env = env;
        this.bookYearMin = bookYearMin;
        this.bookYearMax = bookYearMax;
        this.numberOfPeriods = numberOfPeriods;
        this.governmentActivated = governmentActivated;
        this.company = company;
        this.companyOrDataSetId = company.getId();
        String dataSetId = company.getDataSetId();
        if (dataSetId != null) {
            this.companyOrDataSetId = dataSetId;
        }
        if (AssetBO.isIdNumeric(company, credit)) {
            this.numericIdTransformer = new NumericIdTransformer();
        }
        this.asset = asset;
        this.mode = asset == null ? 0 : 1;
        this.isParent = isParent;
        this.currentCapitalization = currentCapitalization;
        this.ift = ift;
        this.investmentBP = ift != null ? new InvestmentBP(company, numberOfPeriods, "FIN") : new InvestmentBP(company, numberOfPeriods, "FAC");
        this.isCreditClosing = isCreditClosing;
        this.theCredit = theCredit;
        this.changeType = changeType;
        boolean readOnly = asset != null && asset.getState() != 0;
        this.dimensionPanels = new AssetDimensionPanels(loginHelper, dbData, env, company, readOnly);
        this.initialize();
    }

    private void initialize() throws Exception {
        this.apTabTexts[0] = this.env.getAPShortName1();
        this.apTabTexts[1] = this.env.getAPShortName2();
        this.apTabTexts[2] = this.env.getAPShortName3();
        this.jtTabTexts[0] = this.env.getAPShortName1();
        this.jtTabTexts[1] = this.env.getAPShortName2();
        this.jtTabTexts[2] = this.env.getAPShortName3();
        this.jtTabTexts[3] = this.env.getAPShortName4();
        if (this.governmentActivated) {
            this.apTabTexts[0] = "Label.Details";
            this.jtTabTexts[0] = "Label.Details";
        }
        this.initializeCommonForm();
        if (this.isParent) {
            return;
        }
        this.initializeAccountingPrincipleForms();
        if (this.mode == 1) {
            this.mainTabPanel = new TabbedPanel();
            this.commonTab = new Tab("Label.Common");
            this.commonTab.add(this.firstPanel);
            if (this.changeType != null) {
                FloatBar fb = new FloatBar();
                fb.alignment(1);
                fb.addAction(this.changeType);
                this.commonTab.add(fb);
            }
            this.commonTab.add(this.secondPanel);
            this.mainTabPanel.add(this.commonTab, (TabActivateAction)new MainTabActivateAction(this.commonTab, this.mainTabPanel));
            this.dimTab = new Tab("Label.Dimensions");
            this.dimTab.add(this.dimensionPanels.financialPanel);
            if (this.asset.getState() == 2) {
                this.dimTab.add(this.fbMove);
            }
            this.dimTab.add(this.dimensionPanels.dimensionPanel);
            this.mainTabPanel.add(this.dimTab, (TabActivateAction)new MainTabActivateAction(this.dimTab, this.mainTabPanel));
            this.apTab = new Tab("Label.Valuation_Short");
            this.apTab.add(this.apTabbedPanel);
            this.fbAP.alignment(1);
            this.apTab.add(this.fbAP);
            this.mainTabPanel.add(this.apTab, (TabActivateAction)new MainTabActivateAction(this.apTab, this.mainTabPanel));
            this.diTab = new Tab("Label.InvestmentOrDisInvestment");
            this.mainTabPanel.add(this.diTab, (TabActivateAction)new MainTabActivateAction(this.diTab, this.mainTabPanel));
            if (this.asset.getState() < 2) {
                this.diTab.setHidden(true);
            }
        }
    }

    protected void addValuationCorrectionAction(Action action) {
        this.fbAP.addAction(action);
    }

    protected void removeValuationCorrectionAction(String actionName) {
        this.fbAP.removeAction(actionName);
    }

    protected void addAdditionalDepreciationAction(Action action) {
        this.fbAP.addAction(action);
    }

    protected void removeAdditionalDepreciationAction(String actionName) {
        this.fbAP.removeAction(actionName);
    }

    protected void addMainAccountAction(Action action) {
        this.fbAP.addAction(action);
    }

    protected void removeMainAccountAction(String actionName) {
        this.fbAP.removeAction(actionName);
    }

    protected void addAP2AcquisitionValueAction(Action action) {
        this.ap2AcquisitionValueFloatBar.addAction(action);
    }

    protected void removeAP2AcquisitionValueAction(String actionName) {
        this.ap2AcquisitionValueFloatBar.removeAction(actionName);
    }

    private void initializeCommonForm() throws Exception {
        this.id.setLength(10);
        this.id.setMaxLength(10);
        this.id.setHelpId("Label.AssetId");
        if (this.company.getAssetIdAuto()) {
            this.id.setMandatory(false);
            this.id.setHidden(true);
        } else {
            this.id.setReadonly(false);
            this.id.setMandatory(true);
            this.id.setHidden(false);
            this.id.setLength(this.company.getAssetIdLength());
            this.id.setMaxLength(this.company.getAssetIdLength());
        }
        if (AssetBO.isIdNumeric(this.company, false)) {
            this.id.setType("number");
        }
        this.idReadOnly = this.id.getReadonly();
        this.description.setLength(50);
        this.description.setMaxLength(50);
        this.state.setLength(50);
        this.state.setReadonly(true);
        this.type = new AssetTypeReferenceField(this.dbData, this.companyOrDataSetId, true);
        this.type.setDescriptionLength(35);
        this.type.addOnChangeListener(this.typeListener);
        if (this.mode == 1) {
            this.type.setSelectableOnly(true);
        }
        this.type.setMandatory(true);
        if (this.isCreditClosing) {
            this.asrf = new ActivationSchemeReferenceField(this, this.company, this.theCredit.getId());
            this.asrf.setDescriptionLength(35);
            this.asrf.setSelectableOnly(true);
            this.asrf.setMandatory(true);
            this.type.setMandatory(false);
        }
        this.parent = new ParentReferenceField(this.company, false);
        if (this.isParent) {
            this.firstPanel = new FieldGroup();
        } else {
            this.firstPanel = new FieldGroup();
            this.firstPanel.forceBorder(true);
            this.grid = new ESPGridLayout();
            this.grid.setPaddingBottom(0);
            this.grid.setPaddingTop(0);
            this.grid.setColumnWidths(new short[]{170, 20, 400});
        }
        this.parent.setLabel("");
        this.parent.setDescriptionLength(35);
        String sParent = TranslationHelperImpl.getInstance().translate("Label.ParentAsset");
        Label parentLabel = new Label(sParent);
        parentLabel.setHelpId("Label.ParentAsset");
        this.fbParent = new FloatBar();
        this.fbParent.addAction(this.getCreateParentAssetAction());
        this.headerPanel = new HeaderPanel();
        this.headerPanel.setWidth(611);
        this.headerPanel.addUIObject((UIObject)this.id);
        this.headerPanel.addUIObject((UIObject)this.description);
        this.headerPanel.addUIObject((UIObject)this.state);
        if (this.mode == 0) {
            this.state.setHidden(true);
            if (!this.isParent) {
                this.firstPanel.add(this.grid);
                if (!this.id.isHidden()) {
                    Label lAssetId = new Label("Label.Id");
                    lAssetId.setHelpId("Label.AsetId");
                    this.grid.add((UIObject)lAssetId, 0, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
                }
                this.id.setLabel("");
                this.grid.add((UIObject)this.id, 0, 2);
                this.grid.add((UIObject)new Label("Label.Description"), 1, 0, 1, 1, GRID_FILL_NONE, 1.0, 0.4, GRID_ANCHOR_WEST);
                this.description.setLabel("");
                this.grid.add((UIObject)this.description, 1, 2, 1, 1, GRID_FILL_NONE, 1.0, 0.5, GRID_ANCHOR_WEST);
                this.grid.add((UIObject)parentLabel, 2, 0, 1, 1, GRID_FILL_NONE, 1.0, 0.4, GRID_ANCHOR_WEST);
                this.grid.add((UIObject)this.fbParent, 2, 1, 1, 1, GRID_FILL_NONE, 1.0, 0.1, GRID_ANCHOR_WEST);
                this.grid.add((UIObject)this.parent, 2, 2, 1, 1, GRID_FILL_NONE, 1.0, 0.5, GRID_ANCHOR_WEST);
                if (!this.isCreditClosing) {
                    this.grid.add((UIObject)new Label("Label.Type"), 3, 0, 1, 1, GRID_FILL_NONE, 1.0, 0.4, GRID_ANCHOR_WEST);
                    this.type.setLabel("");
                    this.grid.add((UIObject)this.type, 3, 2, 1, 1, GRID_FILL_NONE, 1.0, 0.5, GRID_ANCHOR_WEST);
                } else {
                    this.grid.add((UIObject)new Label("Label.TypeActivationScheme"), 3, 0, 1, 1, GRID_FILL_NONE, 1.0, 0.4, GRID_ANCHOR_WEST);
                    this.asrf.setLabel("");
                    this.grid.add((UIObject)this.asrf, 3, 2, 1, 1, GRID_FILL_NONE, 1.0, 0.5, GRID_ANCHOR_WEST);
                }
            } else {
                this.firstPanel.add(this.id);
                this.firstPanel.add(this.description);
                this.firstPanel.add((Field)this.type);
            }
        } else if (!this.isParent) {
            this.state.setHidden(false);
            this.firstPanel.add(this.grid);
            this.grid.add((UIObject)parentLabel, 0, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
            this.grid.add((UIObject)this.fbParent, 0, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
            this.grid.add((UIObject)this.parent, 0, 2, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
            this.grid.add((UIObject)new Label("Label.Type"), 1, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
            this.type.setLabel("");
            this.grid.add((UIObject)this.type, 1, 2, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        } else {
            this.firstPanel.add(this.id);
            this.firstPanel.add(this.description);
            this.firstPanel.add((Field)this.type);
        }
        if (this.isParent) {
            return;
        }
        this.secondPanel = new FieldGroup("Label.Investment");
        String sInvestmentYP = "Label.InvestmentPeriod";
        if (this.currentCapitalization || this.asset != null && this.asset.getCurrentCapitalization()) {
            this.historicalYP = new BookYearPeriodGrid("Label.HistoricalPeriod", "", "1900", this.bookYearMax, this.numberOfPeriods);
            this.historicalYP.setMandatory(false);
            this.secondPanel.add((ESPGridLayout)this.historicalYP);
        }
        this.investmentYP = new BookYearPeriodGrid(sInvestmentYP, "" + this.company.getCurrentBookYear(), this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.secondPanel.add((ESPGridLayout)this.investmentYP);
        this.bookYP = new BookYearPeriodGrid("Label.BookPeriod", false);
        if (this.mode == 0) {
            this.secondPanel.add((ESPGridLayout)this.bookYP);
            String[] yps = this.investmentBP.retrieveYearsAndPeriods(null, this.ift);
            this.investmentYP.setValues(yps[0], yps[1]);
            this.bookYP.setValues(yps[2], yps[3]);
        } else if (this.asset.getState() == 0 && this.asset.getCurrentCapitalization()) {
            this.secondPanel.add((ESPGridLayout)this.bookYP);
        }
        ESPGridLayout secondPanelGrid = new ESPGridLayout();
        secondPanelGrid.setColumnWidths(new short[]{198, 0});
        secondPanelGrid.setPaddingBottom(0);
        secondPanelGrid.setPaddingTop(0);
        this.secondPanelLabel1 = new Label("Label.AcquisitionValue");
        secondPanelGrid.add((UIObject)this.secondPanelLabel1, 0, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.acquisitionValue.setDiscardLabel(true);
        this.acquisitionValue.setMandatory(true);
        secondPanelGrid.add((UIObject)this.acquisitionValue, 0, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.secondPanelLabel2 = new Label("Label.AcquisitionDate");
        secondPanelGrid.add((UIObject)this.secondPanelLabel2, 1, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.acquisitionDate.setDiscardLabel(true);
        this.acquisitionDate.setValue(new Date());
        this.acquisitionDate.setMandatory(true);
        secondPanelGrid.add((UIObject)this.acquisitionDate, 1, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.secondPanelLabel3 = new Label("Label.NegativeInvestment");
        secondPanelGrid.add((UIObject)this.secondPanelLabel3, 2, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.negativeInvestment.setDiscardLabel(true);
        secondPanelGrid.add((UIObject)this.negativeInvestment, 2, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.secondPanelLabel4 = new Label("Label.Loan");
        this.secondPanelLabel4.setHidden(true);
        secondPanelGrid.add((UIObject)this.secondPanelLabel4, 3, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.loan.setDiscardLabel(true);
        this.loan.setReadonly(true);
        this.loan.setHidden(true);
        secondPanelGrid.add((UIObject)this.loan, 3, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.secondPanelLabel5 = new Label("Label.PayOffYearAmount");
        this.secondPanelLabel5.setHidden(true);
        secondPanelGrid.add((UIObject)this.secondPanelLabel5, 4, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.payOffYearAmount.setDiscardLabel(true);
        this.payOffYearAmount.setHidden(true);
        secondPanelGrid.add((UIObject)this.payOffYearAmount, 4, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.secondPanel.add(secondPanelGrid);
    }

    public void updateSecondPanelLabels() throws Exception {
        this.secondPanelLabel1.setLanguageCode("Label.Amount");
        this.secondPanelLabel2.setLanguageCode("Label.EntryDate");
        this.secondPanelLabel3.setLanguageCode("Label.NegativeLoan");
        this.secondPanelLabel4.setHidden(false);
        this.secondPanelLabel5.setHidden(false);
        this.loan.setHidden(false);
        this.payOffYearAmount.setHidden(false);
    }

    public void addAcquisitionDataToFirstPanel(String label1, String label2, String label3, String label4) throws Exception {
        this.grid.add((UIObject)new Label(label1), 4, 0, 1, 1, "0", "17");
        this.acquisitionValue.setLabel("");
        this.grid.add((UIObject)this.acquisitionValue, 4, 2);
        this.grid.add((UIObject)new Label(label2), 5, 0, 1, 1, "0", "17");
        this.acquisitionDate.setLabel("");
        this.grid.add((UIObject)this.acquisitionDate, 5, 2);
        this.grid.add((UIObject)new Label(label3), 6, 0, 1, 1, "0", "17");
        this.negativeInvestment.setLabel("");
        this.grid.add((UIObject)this.negativeInvestment, 6, 2);
        if (label4 != null) {
            this.grid.add((UIObject)new Label(label4), 7, 0, 1, 1, "0", "17");
            this.payOffYearAmount.setLabel("");
            this.payOffYearAmount.setHidden(false);
            this.grid.add((UIObject)this.payOffYearAmount, 7, 2);
        }
    }

    public void setNewParent(String id, String description) throws Exception {
        this.parent.setValue(id);
        this.parent.setDescription(description);
    }

    public void copyStartUsePeriod() throws Exception {
        for (int i = 0; i < this.startDepreciation.length; ++i) {
            if (this.startDepreciation[i] == null) continue;
            this.startDepreciation[i].getBookYear().setValue((long)this.investmentYP.getBookYear().getIntValue());
            this.startDepreciation[i].getPeriod().setValue((long)this.investmentYP.getPeriod().getIntValue());
            this.startPeriodHandlingMethodChangeAction[i].execute(null);
        }
    }

    public void addAcquisitionTransactionTable(FieldGroup header, ODBTable table, FloatBar floatBar) throws Exception {
        this.diTab.removeAllUIObjects();
        this.diTab.add((Action)new MainTabActivateAction(this.diTab, this.mainTabPanel));
        this.diTab.add(header);
        this.diTab.add((Table)table);
        this.diTab.add(floatBar);
    }

    protected void setValues() throws Exception {
        this.setCommonValues();
        if (!this.isParent) {
            this.setAPValues();
            if (this.useAccountingPrinciple2) {
                this.apTabs[1].setHidden(false);
            } else {
                if (this.apTabs[1] != null) {
                    this.apTabs[1].setHidden(true);
                }
                this.apTabbedPanel.setActiveTab(this.apTabs[0]);
            }
        }
    }

    private void setCommonValues() throws Exception {
        String assetId = this.asset.getId();
        if (this.numericIdTransformer != null) {
            assetId = (String)this.numericIdTransformer.transform(assetId);
        }
        this.id.setValue(assetId);
        this.id.setHidden(false);
        this.id.setReadonly(true);
        this.description.setValue(this.asset.getDescription().trim());
        this.description.setReadonly(false);
        this.type.setValue(this.asset.getTypeId());
        if (this.asset.getState() == 0) {
            this.type.setReadonly(false);
        } else {
            this.type.setReadonly(true);
        }
        if (this.isParent) {
            return;
        }
        String parentId = this.asset.getParentId();
        if (parentId != null && parentId.trim().length() > 0 && this.numericIdTransformer != null) {
            parentId = (String)this.numericIdTransformer.transform(parentId);
        }
        this.parent.setValue(parentId);
        if (this.asset.getState() > 2) {
            this.parent.setReadonly(true);
        }
        this.investmentYP.setValues("" + this.asset.getStartUseYear(), "" + this.asset.getStartUsePeriod());
        this.negativeInvestment.setValue(this.asset.getNegativeInvestment());
        this.negativeInvestment.setReadonly(true);
        if (!this.asset.getNegativeInvestment()) {
            this.secondPanelLabel3.setHidden(true);
            this.negativeInvestment.setHidden(true);
        }
        this.loan.setValue(this.asset.getLoan());
        this.loan.setReadonly(true);
        if (!this.asset.getLoan()) {
            this.secondPanelLabel5.setHidden(true);
            this.loan.setHidden(true);
        }
        this.payOffYearAmount.setValue(this.asset.getPayOffYearAmount());
        this.acquisitionDate.setValue(this.asset.getAcquisitionDate());
        if (this.currentCapitalization) {
            Iterator iterator = TransactionBO.getTransactions(this.asset).iterator();
            while (iterator.hasNext()) {
                Transaction transaction;
                this.transactions[transaction.getAccountingPrinciple() - 1] = transaction = (Transaction)iterator.next();
            }
        }
        if (this.currentCapitalization || this.asset != null && this.asset.getCurrentCapitalization()) {
            this.historicalYP.setValues("" + this.asset.getHistoricalYear(), "" + this.asset.getHistoricalPeriod());
        }
        if (this.asset.getState() == 0) {
            this.transaction = TransactionBO.getFirstTransaction(this.asset, null);
            if (this.transaction != null) {
                this.acquisitionValue.setValue(this.transaction.getAmount1());
                this.bookYP.setValues("" + this.transaction.getBookYearForJournalization(), "" + this.transaction.getPeriodForJournalization());
            }
            this.acquisitionValue.setMandatory(true);
        } else {
            this.investmentYP.setReadonly(true);
            this.investmentYP.setMandatory(false);
            this.acquisitionValue.setReadonly(true);
            this.acquisitionValue.setMandatory(false);
            this.acquisitionDate.setReadonly(true);
            this.acquisitionDate.setMandatory(false);
        }
    }

    public void copyValues() throws Exception {
        this.acquTotal[this.apTabCount].setValue(this.acquisitionValue.getValue());
        if (this.bookTotal[this.apTabCount].getValue().equals("")) {
            this.bookTotal[this.apTabCount].setValue(this.acquisitionValue.getValue());
        }
    }

    public void copyValuesForCreditClosing(BigDecimal unAllocatedDeprValue) throws Exception {
        this.acquTotal[this.apTabCount].setValue(this.acquisitionValue.getValue());
        this.deprTotal[this.apTabCount].setValue(unAllocatedDeprValue);
        this.bookTotal[this.apTabCount].setValue(this.acquisitionValue.getBigDecimal().subtract(unAllocatedDeprValue));
        if (unAllocatedDeprValue.doubleValue() != 0.0) {
            this.remainingLife[this.apTabCount].setValue();
        }
    }

    protected void setAPValues() throws Exception {
        String assetState = AssetStateEnum.getValue(this.asset.getState());
        if (this.asset.getState() == 4 || this.asset.getState() == 5 || this.asset.getState() == 7) {
            assetState = assetState + " (" + this.asset.getDisinvestmentYear() + "-" + this.asset.getDisinvestmentPeriod() + ")";
        } else if (this.asset.getState() == 2) {
            assetState = assetState + " (" + this.asset.getStartUseYear() + "-" + this.asset.getStartUsePeriod() + ")";
        }
        this.state.setValue(assetState);
        for (int i = 0; i <= this.apTabCountMax; ++i) {
            if (this.asset.getState() == 0) {
                this.acquTotal[i].setValue(this.acquisitionValue.getValue());
                this.bookTotal[i].setValue(this.acquisitionValue.getValue());
                this.depreciatableLife[i].setNullable(false);
                this.remainingLife[i].setNullable(false);
            }
            this.valuation[i] = (Valuation)ValuationBO.get(this.dbData, this.company.getId(), this.asset.getCora(), this.asset.getId(), this.ap[i])[0];
            if (this.ap[i] == 2) {
                boolean bl = this.useAccountingPrinciple2 = this.valuation[i] != null;
            }
            if (this.valuation[i] != null) {
                this.setAPValues(this.valuation, i);
            }
            this.modifyFieldAttributes();
        }
    }

    public void setAPValues(Valuation[] valuation, int i) throws Exception {
        if (this.asset == null || this.asset.getState() != 0) {
            BigDecimal acquisitionBalance = valuation[i].getPostedAcquisitionBalance();
            this.acquTotal[i].setValue(acquisitionBalance);
            this.acquisitionValue.setValue(acquisitionBalance);
        }
        BigDecimal depreciationBalance = valuation[i].getPostedDepreciationBalance();
        this.deprTotal[i].setValue(depreciationBalance);
        if (this.assetType.getDepreciateBeyondEconomicLife()) {
            this.deprTotalBEL[i].setValue(ValuationBO.getDepreciationValueBeyondEconomicLife(valuation[i]));
            this.beyondEconomicLifePercentage[i].setValue(valuation[i].getBeyondEconomicLifePercentage());
        } else {
            this.beyondEconomicLifePercentage[i].setHidden(true);
            this.beyondEconomicLifePercentageLabel[i].setHidden(true);
            this.deprTotalBELLabel[i].setHidden(true);
            this.deprTotalBEL[i].setHidden(true);
        }
        this.bookTotal[i].setValue(this.acquTotal[i].getBigDecimal().subtract(depreciationBalance));
        this.depreciationMethod[i].setSelectedOptionValue("" + valuation[i].getDepreciationMethod());
        this.yearPercentageTableId[i].setValue(valuation[i].getYearPercentageTableId());
        YearPercentageTable yearPercentageTable = valuation[i].getYearPercentageTable();
        if (yearPercentageTable != null) {
            this.yearPercentageTableId[i].setDescription(yearPercentageTable.getDescription());
        }
        this.degressivePercentage[i].setValue(valuation[i].getDegressivePercentage());
        this.annuityPercentage[i].setValue(valuation[i].getAnnuityPercentage());
        this.annuityInterestTableId[i].setValue(valuation[i].getAnnuityInterestTableId());
        InterestTable interestTable = valuation[i].getAnnuityInterestTable();
        if (interestTable != null) {
            this.annuityInterestTableId[i].setDescription(interestTable.getDescription());
        }
        this.startPeriodHandlingMethod[i].setSelectedOptionValue("" + valuation[i].getStartPeriodHandlingMethod());
        this.startDepreciation[i].getBookYear().setValue((long)valuation[i].getStartDepreciationBookYear());
        this.startDepreciation[i].getPeriod().setValue((long)valuation[i].getStartDepreciationPeriod());
        if (valuation[i].getLastDepreciationBookYear() != 0) {
            this.lastDepreciated[i].getBookYear().setValue((long)valuation[i].getLastDepreciationBookYear());
            this.lastDepreciated[i].getPeriod().setValue((long)valuation[i].getLastDepreciationPeriod());
        }
        this.depreciatableLife[i].setValue((long)valuation[i].getDepreciatableLife());
        this.nbrOfDeprPers[i].setValue((long)valuation[i].getNumberOfDepreciatedPeriods());
        this.remainingLife[i].setValue((long)(valuation[i].getDepreciatableLife() - valuation[i].getNumberOfDepreciatedPeriods()));
        this.residualValue[i].setValue(valuation[i].getResidualValue());
        this.residualPercentage[i].setValue(valuation[i].getResidualPercentage());
        this.depreciationPaused[i].setValue(valuation[i].getDepreciationPaused());
        this.interestCalculationMethod[i].setSelectedOptionValue("" + valuation[i].getInterestCalculationMethod());
        this.interestTableId[i].setValue(valuation[i].getInterestTableId());
        interestTable = valuation[i].getInterestTable();
        if (interestTable != null) {
            this.interestTableId[i].setDescription(interestTable.getDescription());
        }
        this.interestPercentage[i].setValue(valuation[i].getInterestPercentage());
        if (valuation[i].getInterestBookYear() != 0) {
            this.startInterest[i].getBookYear().setValue((long)valuation[i].getInterestBookYear());
            this.startInterest[i].getPeriod().setValue((long)valuation[i].getInterestPeriod());
        }
        if (!(this.currentCapitalization || valuation[i].getLastDepreciationBookYear() == 0 && valuation[i].getPostedDepreciationBalance().doubleValue() == 0.0 && this.asset.getState() == 2)) {
            this.apTabs[i].setReadonly();
            if (this.asset.getState() <= 2) {
                this.depreciationPaused[i].setReadonly(false);
            }
            this.interestPercentage[i].setReadonly(false);
            this.beyondEconomicLifePercentage[i].setReadonly(false);
        }
    }

    private void getAccountingPrincipleDefaultsFromType() throws Exception {
        for (int i = 0; i <= this.apTabCountMax; ++i) {
            if (this.activationSchemeTransaction == null) {
                this.getAccountingPrincipleDefaultFromType(i);
                continue;
            }
            this.getAccountingPrincipleDefaultFromActivationSchemeTransaction(i);
        }
    }

    public void setAssetType(AssetType assetType) throws Exception {
        this.assetType = assetType;
        this.assetTypeChanged = true;
    }

    private void getAccountingPrincipleDefaultFromType(int i) throws Exception {
        AssetTypeAccountingPrincipleDefault assetTypeAccountingPrincipleDefault = (AssetTypeAccountingPrincipleDefault)AssetTypeAccountingPrincipleDefaultBO.get(this.dbData, this.companyOrDataSetId, this.assetType.getId(), this.ap[i])[0];
        if (assetTypeAccountingPrincipleDefault != null && i <= this.apTabCountMax) {
            if (this.assetType.getDepreciateBeyondEconomicLife()) {
                this.beyondEconomicLifePercentage[i].setValue(assetTypeAccountingPrincipleDefault.getBeyondEconomicLifePercentage());
            } else {
                this.beyondEconomicLifePercentageLabel[i].setHidden(true);
                this.beyondEconomicLifePercentage[i].setHidden(true);
                this.deprTotalBELLabel[i].setHidden(true);
                this.deprTotalBEL[i].setHidden(true);
            }
            this.depreciationMethod[i].setSelectedOptionValue("" + assetTypeAccountingPrincipleDefault.getDepreciationMethod());
            this.degressivePercentage[i].setValue(assetTypeAccountingPrincipleDefault.getDegressivePercentage());
            this.annuityPercentage[i].setValue(assetTypeAccountingPrincipleDefault.getAnnuityPercentage());
            this.annuityInterestTableId[i].setValue(assetTypeAccountingPrincipleDefault.getAnnuityInterestTableId());
            InterestTable interestTable = assetTypeAccountingPrincipleDefault.getAnnuityInterestTable();
            if (interestTable != null) {
                this.annuityInterestTableId[i].setDescription(interestTable.getDescription());
            }
            this.yearPercentageTableId[i].setValue(assetTypeAccountingPrincipleDefault.getYearPercentageTableId());
            YearPercentageTable yearPercentageTable = assetTypeAccountingPrincipleDefault.getYearPercentageTable();
            if (yearPercentageTable != null) {
                this.yearPercentageTableId[i].setDescription(yearPercentageTable.getDescription());
            }
            if (!this.currentCapitalization) {
                this.startPeriodHandlingMethod[i].setSelectedOptionValue("" + assetTypeAccountingPrincipleDefault.getStartPeriodHandlingMethod());
            }
            this.depreciatableLife[i].setValue((long)assetTypeAccountingPrincipleDefault.getDepreciatableLife());
            this.remainingLife[i].setValue((long)assetTypeAccountingPrincipleDefault.getDepreciatableLife());
            this.residualValue[i].setValue(assetTypeAccountingPrincipleDefault.getResidualValue());
            this.residualPercentage[i].setValue(assetTypeAccountingPrincipleDefault.getResidualPercentage());
            this.interestCalculationMethod[i].setSelectedOptionValue("" + assetTypeAccountingPrincipleDefault.getInterestCalculationMethod());
            this.interestTableId[i].setValue(assetTypeAccountingPrincipleDefault.getInterestTableId());
            interestTable = assetTypeAccountingPrincipleDefault.getInterestTable();
            if (interestTable != null) {
                this.interestTableId[i].setDescription(interestTable.getDescription());
            }
            this.interestPercentage[i].setValue(assetTypeAccountingPrincipleDefault.getInterestPercentage());
        }
    }

    private void getAccountingPrincipleDefaultFromActivationSchemeTransaction(int i) throws Exception {
        if (i <= this.apTabCountMax) {
            this.depreciationMethod[i].setSelectedOptionValue("" + this.activationSchemeTransaction.getDepreciationMethod());
            this.degressivePercentage[i].setValue(this.activationSchemeTransaction.getDegressivePercentage());
            this.annuityPercentage[i].setValue(this.activationSchemeTransaction.getAnnuityPercentage());
            this.annuityInterestTableId[i].setValue(this.activationSchemeTransaction.getAnnuityInterestTableId());
            InterestTable interestTable = this.activationSchemeTransaction.getAnnuityInterestTable();
            if (interestTable != null) {
                this.annuityInterestTableId[i].setDescription(interestTable.getDescription());
            }
            this.yearPercentageTableId[i].setValue(this.activationSchemeTransaction.getYearPercentageTableId());
            YearPercentageTable yearPercentageTable = this.activationSchemeTransaction.getYearPercentageTable();
            if (yearPercentageTable != null) {
                this.yearPercentageTableId[i].setDescription(yearPercentageTable.getDescription());
            }
            this.startPeriodHandlingMethod[i].setSelectedOptionValue("" + this.activationSchemeTransaction.getStartPeriodHandlingMethod());
            this.depreciatableLife[i].setValue((long)this.activationSchemeTransaction.getDepreciatableLife());
            this.remainingLife[i].setValue((long)this.activationSchemeTransaction.getDepreciatableLife());
            this.residualValue[i].setValue(this.activationSchemeTransaction.getResidualValue());
            this.residualPercentage[i].setValue(this.activationSchemeTransaction.getResidualPercentage());
            this.interestCalculationMethod[i].setSelectedOptionValue("" + this.activationSchemeTransaction.getInterestCalculationMethod());
            this.interestTableId[i].setValue(this.activationSchemeTransaction.getInterestTableId());
            interestTable = this.activationSchemeTransaction.getInterestTable();
            if (interestTable != null) {
                this.interestTableId[i].setDescription(interestTable.getDescription());
            }
            this.interestPercentage[i].setValue(this.activationSchemeTransaction.getInterestPercentage());
        }
    }

    public void initializeType() throws Exception {
        this.finDimensionPanel = this.dimensionPanels.initializeFINDimensionPanel(this.asset, this.assetType, this.ift, this.theCredit);
        boolean facDimensionsReadOnly = false;
        if (this.asset != null && this.asset.getState() > 2) {
            facDimensionsReadOnly = true;
        }
        this.facDimensionPanel = this.dimensionPanels.initializeFACDimensionPanel(this.asset, this.assetType, facDimensionsReadOnly, this.theCredit);
        if (this.isParent) {
            return;
        }
        if (this.mode == 0) {
            this.useAccountingPrinciple2 = this.assetType.getAccountingPrinciple2IsUsed();
            this.initializeAccountingPrincipleForms();
            this.getAccountingPrincipleDefaultsFromType();
        }
        this.modifyFieldAttributes();
    }

    protected void modifyFieldAttributes() throws Exception {
        for (int i = 0; i <= this.apTabCountMax; ++i) {
            this.depreciationMethodChangeAction[i].execute(null);
            this.interestCalculationMethodChangeAction[i].execute(null);
            this.startPeriodHandlingMethodChangeAction[i].execute(null);
        }
    }

    public String getAccountingPrincipleTabText() {
        return this.apTabTexts[this.ap[this.apTabCount] - 1];
    }

    private void initializeAccountingPrincipleForms() throws Exception {
        this.apTabCount = 0;
        this.apTabbedPanel = new TabbedPanel();
        this.initializeAccountingPrincipleForm(0, 1);
        this.apTabCountMax = 0;
        if (this.mode == 1 || this.useAccountingPrinciple2) {
            this.initializeAccountingPrincipleForm(++this.apTabCountMax, 2);
        }
    }

    private void initializeAccountingPrincipleForm(int tabNumber, int accountingPrinciple) throws Exception {
        if (this.mode == 0) {
            this.apPanels[tabNumber] = new Panel();
        } else {
            this.apTabs[tabNumber] = new Tab(this.apTabTexts[accountingPrinciple - 1]);
            this.apTabbedPanel.add(this.apTabs[tabNumber], (TabActivateAction)new APTabActivateAction(this.apTabs[tabNumber], this.apTabbedPanel));
        }
        this.values[tabNumber] = new FieldGroup();
        this.values[tabNumber].forceBorder(true);
        ESPGridLayout grid = new ESPGridLayout();
        grid.setColumnWidths(new short[]{166, 30, 150, 150, 80});
        this.values[tabNumber].add(grid);
        grid.add((UIObject)new Label("Label.AcquisitionValue"), 0, 0, 1, 1, "0", "17");
        this.acquTotal[tabNumber] = new FACDecimalField("", 15, 2);
        this.acquTotal[tabNumber].setReadonly(true);
        grid.add((UIObject)this.acquTotal[tabNumber], 0, 2);
        grid.add((UIObject)new Label("Label.Depreciations"), 1, 0, 1, 1, "0", "17");
        this.deprTotal[tabNumber] = new FACDecimalField("", 15, 2);
        grid.add((UIObject)this.deprTotal[tabNumber], 1, 2);
        grid.add((UIObject)new Label("Label.BookValue"), 2, 0, 1, 1, "0", "17");
        this.bookTotal[tabNumber] = new FACDecimalField("", 15, 2);
        this.bookTotal[tabNumber].setReadonly(true);
        grid.add((UIObject)this.bookTotal[tabNumber], 2, 2);
        this.deprTotalBELLabel[tabNumber] = new Label("Label.DepreciationsBeyondEconomicLife");
        grid.add((UIObject)this.deprTotalBELLabel[tabNumber], 3, 0, 1, 1, "0", "17");
        this.deprTotalBEL[tabNumber] = new FACDecimalField("", 15, 2);
        if (this.company.getProcessParameters().getDepreciateBeyondEconomicLife()) {
            grid.add((UIObject)this.deprTotalBEL[tabNumber], 3, 2);
        }
        grid.add((UIObject)new Label("Label.DepreciationLife"), 0, 3, 1, 1, "0", "17");
        this.depreciatableLife[tabNumber] = new NumberField("", 4, true);
        this.depreciatableLife[tabNumber].setMinValue(new BigInteger("0"), true);
        this.depreciatableLife[tabNumber].setMandatory(true);
        grid.add((UIObject)this.depreciatableLife[tabNumber], 0, 4);
        grid.add((UIObject)new Label("Label.DepreciatedPeriods"), 1, 3, 1, 1, "0", "17");
        this.nbrOfDeprPers[tabNumber] = new NumberField("", 4, true);
        this.nbrOfDeprPers[tabNumber].setMinValue(new BigInteger("0"), true);
        this.nbrOfDeprPers[tabNumber].setReadonly(true);
        grid.add((UIObject)this.nbrOfDeprPers[tabNumber], 1, 4);
        grid.add((UIObject)new Label("Label.RemainingLife"), 2, 3, 1, 1, "0", "17");
        this.remainingLife[tabNumber] = new NumberField("", 4, true);
        this.remainingLife[tabNumber].setMinValue(new BigInteger("0"), true);
        if (this.currentCapitalization) {
            this.remainingLife[tabNumber].setMandatory(true);
        } else {
            this.remainingLife[tabNumber].setReadonly(true);
        }
        grid.add((UIObject)this.remainingLife[tabNumber], 2, 4);
        if (this.mode == 1 && tabNumber == 1) {
            this.ap2AcquisitionValueFloatBar = new FloatBar();
            grid.add((UIObject)this.ap2AcquisitionValueFloatBar, 0, 1, 1, 1, "0", "17");
        }
        if (this.currentCapitalization) {
            if (this.mode == 0) {
                this.deprTotal[tabNumber].setNullable(false);
                this.deprTotal[tabNumber].setValue("0");
                this.deprTotal[tabNumber].setMandatory(true);
                this.deprTotalBEL[tabNumber].setNullable(false);
                this.deprTotalBEL[tabNumber].setValue("0");
                this.deprTotalBEL[tabNumber].setMandatory(true);
                this.depreciatableLife[tabNumber].setNullable(false);
                this.remainingLife[tabNumber].setNullable(false);
            } else {
                this.deprTotal[tabNumber].setMandatory(false);
                this.deprTotalBEL[tabNumber].setMandatory(false);
            }
        } else {
            this.deprTotal[tabNumber].setReadonly(true);
            this.deprTotalBEL[tabNumber].setReadonly(true);
        }
        if (!this.assetTypeChanged) {
            this.addFieldGroupAP(this.values[tabNumber], tabNumber);
        }
        this.depreciationGroups[tabNumber] = new FieldGroup("Label.Depreciations");
        this.ap[tabNumber] = accountingPrinciple;
        this.depreciationMethod[tabNumber] = EnumHelper.createComboBox("Label.DepreciationMethod", DepreciationMethodEnum.getCollection(), false);
        if (this.mode == 1) {
            this.depreciationMethod[tabNumber].setSelectedOptionValue("99");
        }
        this.depreciationMethod[tabNumber].setWidth("225");
        this.depreciationMethodChangeAction[tabNumber] = new DepreciationMethodChangeAction(tabNumber);
        this.depreciationMethod[tabNumber].add((Action)this.depreciationMethodChangeAction[tabNumber]);
        this.depreciationGroups[tabNumber].add(this.depreciationMethod[tabNumber]);
        this.yearPercentageTableId[tabNumber] = new YearPercentageTableReferenceField(this.dbData);
        this.depreciationGroups[tabNumber].add((Field)this.yearPercentageTableId[tabNumber]);
        this.degressivePercentage[tabNumber] = new FACDecimalField("Label.Percentage", 5, 2);
        this.degressivePercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.degressivePercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.depreciationGroups[tabNumber].add((Field)this.degressivePercentage[tabNumber]);
        this.annuityInterestTableId[tabNumber] = new InterestTableReferenceField(this.dbData, this.numberOfPeriods);
        this.depreciationGroups[tabNumber].add((Field)this.annuityInterestTableId[tabNumber]);
        this.annuityPercentage[tabNumber] = new FACDecimalField("Label.Percentage", 6, 3);
        this.annuityPercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.annuityPercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.depreciationGroups[tabNumber].add((Field)this.annuityPercentage[tabNumber]);
        this.startPeriodHandlingMethod[tabNumber] = EnumHelper.createComboBox("Label.StartPeriodHandlingPolicy", StartPeriodHandlingEnum.getCollection(), false);
        if (this.currentCapitalization) {
            this.startPeriodHandlingMethod[tabNumber].removeOption(this.startPeriodHandlingMethod[tabNumber].getOptionByValue("4"));
            this.startPeriodHandlingMethod[tabNumber].removeOption(this.startPeriodHandlingMethod[tabNumber].getOptionByValue("3"));
            this.startPeriodHandlingMethod[tabNumber].removeOption(this.startPeriodHandlingMethod[tabNumber].getOptionByValue("2"));
            this.startPeriodHandlingMethod[tabNumber].removeOption(this.startPeriodHandlingMethod[tabNumber].getOptionByValue("6"));
            this.startPeriodHandlingMethod[tabNumber].removeOption(this.startPeriodHandlingMethod[tabNumber].getOptionByValue("5"));
        } else if (this.numberOfPeriods > 12) {
            this.startPeriodHandlingMethod[tabNumber].removeOption(this.startPeriodHandlingMethod[tabNumber].getOptionByValue("4"));
            this.startPeriodHandlingMethod[tabNumber].removeOption(this.startPeriodHandlingMethod[tabNumber].getOptionByValue("6"));
        }
        this.startPeriodHandlingMethod[tabNumber].setWidth("225");
        this.startPeriodHandlingMethodChangeAction[tabNumber] = new StartPeriodHandlingMethodChangeAction(tabNumber);
        this.startPeriodHandlingMethod[tabNumber].add((Action)this.startPeriodHandlingMethodChangeAction[tabNumber]);
        this.depreciationGroups[tabNumber].add(this.startPeriodHandlingMethod[tabNumber]);
        this.depreciationPaused[tabNumber] = new CheckBox("Label.DepreciationPaused");
        this.depreciationGroups[tabNumber].add(this.depreciationPaused[tabNumber]);
        this.addFieldGroupAP(this.depreciationGroups[tabNumber], tabNumber);
        this.depreciationGroups2[tabNumber] = new FieldGroup("");
        this.startDepreciation[tabNumber] = new BookYearPeriodGrid("Label.PeriodFrom", "" + this.company.getCurrentBookYear(), this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.startInterest[tabNumber] = new BookYearPeriodGrid("Label.InterestStartPeriod", "" + this.company.getCurrentBookYear(), this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.lastDepreciated[tabNumber] = new BookYearPeriodGrid("Label.LastDepreciated", true);
        this.depreciationGroups2[tabNumber].add((ESPGridLayout)this.startDepreciation[tabNumber]);
        this.depreciationGroups2[tabNumber].add((ESPGridLayout)this.startInterest[tabNumber]);
        if (this.mode == 1) {
            this.depreciationGroups2[tabNumber].add((ESPGridLayout)this.lastDepreciated[tabNumber]);
        }
        grid = new ESPGridLayout();
        grid.setPaddingBottom(0);
        grid.setPaddingTop(0);
        grid.setColumnWidths(new short[]{198, 0});
        this.depreciationGroups2[tabNumber].add(grid);
        if (this.assetTypeChanged) {
            grid.add((UIObject)new Label("Label.DepreciationLife"), 0, 0, 1, 1, "0", "17");
            grid.add((UIObject)this.depreciatableLife[tabNumber], 0, 1);
        }
        Label label = new Label("Label.ResidualValuePercentage");
        grid.add((UIObject)label, 1, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.residualPercentage[tabNumber] = new FACDecimalField("", 5, 2);
        this.residualPercentage[tabNumber].setDiscardLabel(true);
        this.residualPercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.residualPercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        grid.add((UIObject)this.residualPercentage[tabNumber], 1, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        label = new Label("Label.ResidualValueAmount");
        grid.add((UIObject)label, 2, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.residualValue[tabNumber] = new FACDecimalField("", 15, 2);
        this.residualValue[tabNumber].setDiscardLabel(true);
        grid.add((UIObject)this.residualValue[tabNumber], 2, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.beyondEconomicLifePercentageLabel[tabNumber] = new Label("Label.BeyondEconomicLifePercentage");
        grid.add((UIObject)this.beyondEconomicLifePercentageLabel[tabNumber], 3, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.beyondEconomicLifePercentage[tabNumber] = new FACDecimalField("", 5, 2);
        this.beyondEconomicLifePercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.beyondEconomicLifePercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.beyondEconomicLifePercentage[tabNumber].setValue(new BigDecimal("0.00"));
        grid.add((UIObject)this.beyondEconomicLifePercentage[tabNumber], 3, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.addFieldGroupAP(this.depreciationGroups2[tabNumber], tabNumber);
        this.interestGroups[tabNumber] = new FieldGroup("Label.Interest");
        this.interestCalculationMethod[tabNumber] = EnumHelper.createComboBox("Label.InterestCalculationMethod", InterestCalculationMethodEnum.getCollection(), false);
        this.interestCalculationMethod[tabNumber].setWidth("225");
        this.interestCalculationMethodChangeAction[tabNumber] = new InterestCalculationMethodChangeAction(tabNumber);
        this.interestCalculationMethod[tabNumber].add((Action)this.interestCalculationMethodChangeAction[tabNumber]);
        this.interestGroups[tabNumber].add(this.interestCalculationMethod[tabNumber]);
        this.interestTableId[tabNumber] = new InterestTableReferenceField(this.dbData, this.numberOfPeriods);
        this.interestGroups[tabNumber].add((Field)this.interestTableId[tabNumber]);
        this.interestPercentage[tabNumber] = new FACDecimalField("Label.Percentage", 6, 3);
        this.interestPercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.interestPercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.interestGroups[tabNumber].add((Field)this.interestPercentage[tabNumber]);
        this.startInterest[tabNumber].getBookYear().setValue();
        this.startInterest[tabNumber].setMandatory(false);
        this.addFieldGroupAP(this.interestGroups[tabNumber], tabNumber);
    }

    private void addFieldGroupAP(FieldGroup fieldGroup, int tabNumber) throws Exception {
        if (this.mode == 0) {
            this.apPanels[tabNumber].addUIObject((UIObject)fieldGroup);
        } else {
            this.apTabs[tabNumber].add(fieldGroup);
        }
    }

    public void updateAccountingPrincipleForms(boolean forLoan) throws Exception {
        for (int index = 0; index < this.values.length; ++index) {
            this.updateAccountingPrincipleForm(index, forLoan);
        }
    }

    private void updateAccountingPrincipleForm(int index, boolean forLoan) throws Exception {
        FieldGroup fg = this.values[index];
        if (fg == null) {
            return;
        }
        ESPGridLayout grid = (ESPGridLayout)fg.getUIObjects(ESPGridLayout.class, true).get(0);
        ArrayList objects = grid.getUIObjects(Label.class, true);
        this.updateAccountingPrincipleForm(objects.get(0), forLoan, "Label.AcquisitionValue", "Label.LoanAmount");
        this.updateAccountingPrincipleForm(objects.get(1), forLoan, "Label.Depreciations", "Label.PayOffs");
        this.updateAccountingPrincipleForm(objects.get(2), forLoan, "Label.BookValue", "Label.RestLoan");
        this.updateAccountingPrincipleForm(objects.get(4), forLoan, "Label.DepreciationLife", "Label.Duration");
        this.updateAccountingPrincipleForm(objects.get(5), forLoan, "Label.DepreciatedPeriods", "");
        this.updateAccountingPrincipleForm(objects.get(6), forLoan, "Label.RemainingLife", "");
        this.nbrOfDeprPers[index].setHidden(forLoan);
        this.remainingLife[index].setHidden(forLoan);
        fg = this.depreciationGroups2[index];
        ArrayList grids = fg.getUIObjects(ESPGridLayout.class, true);
        grid = (ESPGridLayout)grids.get(grids.size() - 1);
        objects = grid.getUIObjects(Label.class, true);
        this.updateAccountingPrincipleForm(objects.get(0), forLoan, "Label.ResidualValuePercentage", "");
        this.updateAccountingPrincipleForm(objects.get(1), forLoan, "Label.ResidualValueAmount", "");
        this.residualValue[index].setHidden(forLoan);
        this.residualPercentage[index].setHidden(forLoan);
    }

    private void updateAccountingPrincipleForm(Object object, boolean forLoan, String txt1, String txt2) throws Exception {
        UIObject uio = (UIObject)object;
        if (forLoan) {
            uio.setLanguageCode(txt2);
        } else {
            uio.setLanguageCode(txt1);
        }
    }

    public String validateCommonForm() throws Exception {
        WozValue wozValue;
        this.type.removeInvalidTag();
        this.parent.removeInvalidTag();
        this.acquisitionValue.removeInvalidTag();
        this.investmentYP.removeInvalidTags();
        this.bookYP.removeInvalidTags();
        this.type.validate();
        this.assetType = this.type.getAssetType();
        this.parent.validate();
        this.parentAsset = this.parent.getParentAsset();
        if (this.mode == 1 && this.parentAsset != null && (wozValue = WozValueBO.getLastWozValue(this.dbData, this.company.getId(), "A", this.asset.getId())) != null) {
            this.parentAsset = null;
            this.parent.setValue(this.parentAsset);
            this.parent.setInvalidTag();
            throw new UserErrorMessage("asset_has_own_WOZ_data");
        }
        if (this.acquisitionValue.getReadonly()) {
            return null;
        }
        this.investmentYP.validateAll();
        String[] messages = this.investmentBP.validateFACYearAndPeriod(null, this.investmentYP.getBookYear().getIntValue(), this.investmentYP.getPeriod().getIntValue());
        if (messages != null) {
            this.investmentYP.setInvalidTag();
            throw new UserErrorMessage(messages[0]);
        }
        this.bookYP.validateAll();
        messages = this.investmentBP.validateFINYearAndPeriod(this.bookYP.getBookYear().getIntValue(), this.bookYP.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax));
        if (messages != null) {
            this.bookYP.setInvalidTag();
            throw new UserErrorMessage(messages[0]);
        }
        this.acquisitionValue.validate();
        if (this.negativeInvestment.isChecked()) {
            if (this.acquisitionValue.getBigDecimal().doubleValue() > 0.0) {
                this.acquisitionValue.setInvalidTag();
                throw MessageHelper.createMessage("tmp-number-not-smaller-then", this.acquisitionValue.getLabel(), "0");
            }
        } else if (this.acquisitionValue.getBigDecimal().doubleValue() < 0.0) {
            this.acquisitionValue.setInvalidTag();
            throw MessageHelper.createMessage("tmp-number-not-greater-then", this.acquisitionValue.getLabel(), "0");
        }
        return null;
    }

    public String validateAccountingPrincipleForm(int tabNumber) throws Exception {
        Object[] result;
        if (this.mode == 0) {
            this.apPanels[tabNumber].removeInvalidTags();
            this.apPanels[tabNumber].validateAll();
        } else {
            if (this.apTabs[tabNumber].isHidden()) {
                return null;
            }
            this.apTabs[tabNumber].removeInvalidTags();
            this.apTabs[tabNumber].validateAll();
        }
        if (this.currentCapitalization) {
            if (this.deprTotal[tabNumber].getDoubleValue() != 0.0 && this.remainingLife[tabNumber].getIntValue() > this.depreciatableLife[tabNumber].getIntValue()) {
                this.remainingLife[tabNumber].setInvalidTag();
                return "remainingLife_must_be_less_than_depreciatableLife";
            }
            this.bookTotal[tabNumber].setValue(this.acquTotal[tabNumber].getBigDecimal().subtract(this.deprTotal[tabNumber].getBigDecimal()));
            this.nbrOfDeprPers[tabNumber].setValue((long)(this.depreciatableLife[tabNumber].getIntValue() - this.remainingLife[tabNumber].getIntValue()));
        }
        if (PeriodHelper.isBefore(this.startDepreciation[tabNumber].getBookYear().getIntValue(), this.startDepreciation[tabNumber].getPeriod().getIntValue(), this.investmentYP.getBookYear().getIntValue(), this.investmentYP.getPeriod().getIntValue())) {
            this.startDepreciation[tabNumber].setInvalidTag();
            return "startDepreciation_before_investmentYP";
        }
        if (this.startInterest[tabNumber].getBookYear().getIntValue() > 0 && PeriodHelper.isBefore(this.startInterest[tabNumber].getBookYear().getIntValue(), this.startInterest[tabNumber].getPeriod().getIntValue(), this.investmentYP.getBookYear().getIntValue(), this.investmentYP.getPeriod().getIntValue())) {
            this.startInterest[tabNumber].setInvalidTag();
            return "startInterest_before_investmentYP";
        }
        String id = this.yearPercentageTableId[tabNumber].getValue().trim();
        if (id.length() > 0) {
            Object[] result2 = YearPercentageTableBO.get(this.dbData, id);
            String message = (String)result2[1];
            if (message != null) {
                this.yearPercentageTableId[tabNumber].setInvalidTag();
                return message;
            }
            YearPercentageTable table = (YearPercentageTable)result2[0];
            int maxPeriodsAllowed = table.getActualYears() * this.numberOfPeriods;
            if (this.depreciatableLife[tabNumber].getIntValue() > maxPeriodsAllowed) {
                message = TranslationHelperImpl.getInstance().translate("depr_life_greater_than_table_periods") + " (" + maxPeriodsAllowed + ")";
                this.yearPercentageTableId[tabNumber].setInvalidTag();
                this.depreciatableLife[tabNumber].setInvalidTag();
                return message;
            }
            int minPeriodsAllowed = (table.getActualYears() - 1) * this.numberOfPeriods + 1;
            if (this.depreciatableLife[tabNumber].getIntValue() < minPeriodsAllowed) {
                message = TranslationHelperImpl.getInstance().translate("depr_life_less_than_table_periods") + " (" + minPeriodsAllowed + ")";
                this.yearPercentageTableId[tabNumber].setInvalidTag();
                this.depreciatableLife[tabNumber].setInvalidTag();
                return message;
            }
        }
        if (!"0".equals(this.interestCalculationMethod[tabNumber].getValue())) {
            String message;
            boolean precentageFilled;
            id = this.interestTableId[tabNumber].getValue().trim();
            boolean idFilled = id.length() > 0;
            boolean bl = precentageFilled = this.interestPercentage[tabNumber].getDoubleValue() > 0.0;
            if (!idFilled && !precentageFilled) {
                this.interestTableId[tabNumber].setInvalidTag();
                this.interestPercentage[tabNumber].setInvalidTag();
                return "provide_one_value";
            }
            if (idFilled && precentageFilled) {
                this.interestTableId[tabNumber].setInvalidTag();
                this.interestPercentage[tabNumber].setInvalidTag();
                return "provide_only_one_value";
            }
            if (idFilled && (message = (String)(result = InterestTableBO.get(this.dbData, id, this.numberOfPeriods))[1]) != null) {
                this.interestTableId[tabNumber].setInvalidTag();
                return message;
            }
        }
        if ("2".equals(this.depreciationMethod[tabNumber].getValue()) && this.degressivePercentage[tabNumber].getDoubleValue() == 0.0) {
            this.degressivePercentage[tabNumber].setInvalidTag();
            return "value_must_be_positive";
        }
        if ("11".equals(this.depreciationMethod[tabNumber].getValue())) {
            String message;
            boolean precentageFilled;
            id = this.annuityInterestTableId[tabNumber].getValue().trim();
            boolean idFilled = id.length() > 0;
            boolean bl = precentageFilled = this.annuityPercentage[tabNumber].getDoubleValue() > 0.0;
            if (idFilled && precentageFilled) {
                this.annuityInterestTableId[tabNumber].setInvalidTag();
                this.annuityPercentage[tabNumber].setInvalidTag();
                return "provide_only_one_value";
            }
            if (!idFilled && !precentageFilled) {
                this.annuityInterestTableId[tabNumber].setInvalidTag();
                this.annuityPercentage[tabNumber].setInvalidTag();
                return "provide_one_value";
            }
            if (idFilled && (message = (String)(result = InterestTableBO.get(this.dbData, id, this.numberOfPeriods))[1]) != null) {
                this.annuityInterestTableId[tabNumber].setInvalidTag();
                return message;
            }
            if (this.depreciatableLife[tabNumber].getIntValue() % this.company.getNumberOfPeriods() != 0) {
                this.depreciatableLife[tabNumber].setInvalidTag();
                String message2 = TranslationHelperImpl.getInstance().translate("depreciatableLife_in_complete_years");
                return message2 + " " + this.numberOfPeriods;
            }
        }
        if (this.residualValue[tabNumber].getDoubleValue() != 0.0 && this.residualPercentage[tabNumber].getDoubleValue() > 0.0) {
            this.residualValue[tabNumber].setInvalidTag();
            this.residualPercentage[tabNumber].setInvalidTag();
            return "provide_only_one_value";
        }
        if (this.mode == 0) {
            if (!this.negativeInvestment.getValueAsBoolean()) {
                if (this.acquTotal[tabNumber].getDoubleValue() - this.deprTotal[tabNumber].getDoubleValue() < 0.0) {
                    this.deprTotal[tabNumber].setInvalidTag();
                    return "deprTotal_more_than_acquTotal";
                }
            } else if (this.acquTotal[tabNumber].getDoubleValue() - this.deprTotal[tabNumber].getDoubleValue() > 0.0) {
                this.deprTotal[tabNumber].setInvalidTag();
                return "deprTotal_less_than_acquTotal";
            }
        }
        boolean depreciationPausedNotAllowed = false;
        if (this.lastDepreciated[tabNumber].getBookYear().getIntValue() == 0 && !this.startPeriodHandlingMethod[tabNumber].getValue().equals("1")) {
            depreciationPausedNotAllowed = true;
        }
        if (this.startPeriodHandlingMethod[tabNumber].getValue().equals("3") && this.lastDepreciated[tabNumber].getBookYear().getIntValue() == this.investmentYP.getBookYear().getIntValue() && this.lastDepreciated[tabNumber].getPeriod().getIntValue() < 12) {
            depreciationPausedNotAllowed = true;
        }
        if (this.startPeriodHandlingMethod[tabNumber].getValue().equals("4") && this.lastDepreciated[tabNumber].getBookYear().getIntValue() == this.investmentYP.getBookYear().getIntValue() && (this.investmentYP.getPeriod().getIntValue() >= 7 || this.lastDepreciated[tabNumber].getPeriod().getIntValue() < 7) && this.lastDepreciated[tabNumber].getPeriod().getIntValue() != 12) {
            depreciationPausedNotAllowed = true;
        }
        if ("12".equals(this.depreciationMethod[tabNumber].getValue()) || "11".equals(this.depreciationMethod[tabNumber].getValue())) {
            depreciationPausedNotAllowed = true;
        }
        if (depreciationPausedNotAllowed && this.depreciationPaused[tabNumber].getValueAsBoolean()) {
            this.depreciationPaused[tabNumber].setInvalidTag();
            return "depreciationPaused_not_allowed_for_current_depreciation_period";
        }
        return null;
    }

    private String validateAll() throws Exception {
        String message = this.validateCommonForm();
        if (message != null) {
            return message;
        }
        for (int i = 0; i <= this.apTabCountMax; ++i) {
            message = this.validateAccountingPrincipleForm(i);
            if (message == null) continue;
            this.mainTabPanel.setActiveTabByName("Label.Valuation_Short");
            this.apTabbedPanel.setActiveTab(this.apTabs[i]);
            return message;
        }
        return null;
    }

    protected String update() throws Exception {
        String message;
        if (!this.isParent && (message = this.validateAll()) != null) {
            return message;
        }
        return new AssetBP(this).update(this.asset);
    }

    public Action getCreateParentAssetAction() throws Exception {
        this.fbParent.removeAction("+");
        Action action = new Action("+");
        action.setTooltip(TranslationHelperImpl.getInstance().translate("Button.CreateParentAsset"));
        return action;
    }

    private class StartPeriodHandlingMethodChangeAction
    extends Action {
        private static final long serialVersionUID = -1954436578272498089L;
        private int tabNumber;

        public StartPeriodHandlingMethodChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            AssetPanels.this.startDepreciation[this.tabNumber].setReadonly(true);
            if (AssetPanels.this.lastDepreciated[this.tabNumber].getBookYear().getIntValue() == 0) {
                if (AssetPanels.this.startPeriodHandlingMethod[this.tabNumber].getValue().equals("1")) {
                    if (AssetPanels.this.valuation[this.tabNumber] == null) {
                        AssetPanels.this.startDepreciation[this.tabNumber].setReadonly(false);
                    } else if (AssetPanels.this.valuation[this.tabNumber].getPostedDepreciationBalance().doubleValue() == 0.0) {
                        AssetPanels.this.startDepreciation[this.tabNumber].setReadonly(false);
                    }
                    return true;
                }
                if (AssetPanels.this.startPeriodHandlingMethod[this.tabNumber].getValue().equals("4") || AssetPanels.this.startPeriodHandlingMethod[this.tabNumber].getValue().equals("3")) {
                    AssetPanels.this.startDepreciation[this.tabNumber].getBookYear().setValue(AssetPanels.this.investmentYP.getBookYear().getValue());
                    AssetPanels.this.startDepreciation[this.tabNumber].getPeriod().setValue(AssetPanels.this.investmentYP.getPeriod().getValue());
                } else if (AssetPanels.this.startPeriodHandlingMethod[this.tabNumber].getValue().equals("2")) {
                    int[] yp = PeriodHelper.determineStartDepreciationPeriod(AssetPanels.this.numberOfPeriods, AssetPanels.this.acquisitionDate.getValueAsDate(), AssetPanels.this.investmentYP.getBookYear().getIntValue(), AssetPanels.this.investmentYP.getPeriod().getIntValue(), AssetPanels.this.company.getProcessParameters().getStartMonth(), AssetPanels.this.company.getProcessParameters().getCalendarYearCorrection());
                    AssetPanels.this.startDepreciation[this.tabNumber].getBookYear().setValue((long)yp[0]);
                    AssetPanels.this.startDepreciation[this.tabNumber].getPeriod().setValue((long)yp[1]);
                } else if (AssetPanels.this.startPeriodHandlingMethod[this.tabNumber].getValue().equals("6")) {
                    if (AssetPanels.this.investmentYP.getPeriod().getIntValue() > 6) {
                        AssetPanels.this.startDepreciation[this.tabNumber].getBookYear().setValue((long)(AssetPanels.this.investmentYP.getBookYear().getIntValue() + 1));
                        AssetPanels.this.startDepreciation[this.tabNumber].getPeriod().setValue(1L);
                    } else {
                        AssetPanels.this.startDepreciation[this.tabNumber].getBookYear().setValue(AssetPanels.this.investmentYP.getBookYear().getValue());
                        AssetPanels.this.startDepreciation[this.tabNumber].getPeriod().setValue(7L);
                    }
                } else if (AssetPanels.this.startPeriodHandlingMethod[this.tabNumber].getValue().equals("5")) {
                    AssetPanels.this.startDepreciation[this.tabNumber].getBookYear().setValue((long)(AssetPanels.this.investmentYP.getBookYear().getIntValue() + 1));
                    AssetPanels.this.startDepreciation[this.tabNumber].getPeriod().setValue(1L);
                }
            }
            return true;
        }
    }

    private class InterestCalculationMethodChangeAction
    extends Action {
        private static final long serialVersionUID = -4099934352056207581L;
        private int tabNumber;

        public InterestCalculationMethodChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if ("0".equals(AssetPanels.this.interestCalculationMethod[this.tabNumber].getValue())) {
                AssetPanels.this.interestTableId[this.tabNumber].setHidden(true);
                AssetPanels.this.interestTableId[this.tabNumber].setValue();
                AssetPanels.this.interestPercentage[this.tabNumber].setHidden(true);
                AssetPanels.this.interestPercentage[this.tabNumber].setValue();
                AssetPanels.this.startInterest[this.tabNumber].setHidden(true);
                AssetPanels.this.startInterest[this.tabNumber].getBookYear().setValue();
                AssetPanels.this.startInterest[this.tabNumber].getPeriod().setValue();
                return true;
            }
            AssetPanels.this.interestTableId[this.tabNumber].setHidden(false);
            AssetPanels.this.interestPercentage[this.tabNumber].setHidden(false);
            AssetPanels.this.startInterest[this.tabNumber].setHidden(false);
            return true;
        }
    }

    private class DepreciationMethodChangeAction
    extends Action {
        private static final long serialVersionUID = -7988927228620312875L;
        private int tabNumber;

        public DepreciationMethodChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if (AssetPanels.this.mode == 0 || AssetPanels.this.currentCapitalization || AssetPanels.this.mode == 1 && AssetPanels.this.valuation[this.tabNumber] != null && AssetPanels.this.valuation[this.tabNumber].getLastDepreciationBookYear() == 0 && AssetPanels.this.valuation[this.tabNumber].getPostedDepreciationBalance().doubleValue() == 0.0 && AssetPanels.this.asset.getState() == 2) {
                AssetPanels.this.startPeriodHandlingMethod[this.tabNumber].setReadonly(false);
                AssetPanels.this.interestCalculationMethod[this.tabNumber].setReadonly(false);
            }
            if ("99".equals(AssetPanels.this.depreciationMethod[this.tabNumber].getValue())) {
                AssetPanels.this.startDepreciation[this.tabNumber].getPeriod().setMinValue(new BigInteger("0"), true);
                AssetPanels.this.startDepreciation[this.tabNumber].getPeriod().setMandatory(false);
                AssetPanels.this.startDepreciation[this.tabNumber].getBookYear().setMandatory(false);
                AssetPanels.this.depreciatableLife[this.tabNumber].setMandatory(false);
                AssetPanels.this.remainingLife[this.tabNumber].setMandatory(false);
            } else {
                AssetPanels.this.startDepreciation[this.tabNumber].getPeriod().setMinValue(new BigInteger("1"), true);
                AssetPanels.this.startDepreciation[this.tabNumber].getPeriod().setMandatory(true);
                AssetPanels.this.startDepreciation[this.tabNumber].getBookYear().setMandatory(true);
                AssetPanels.this.depreciatableLife[this.tabNumber].setMandatory(true);
                if (AssetPanels.this.currentCapitalization) {
                    AssetPanels.this.remainingLife[this.tabNumber].setMandatory(true);
                }
            }
            if ("3".equals(AssetPanels.this.depreciationMethod[this.tabNumber].getValue())) {
                AssetPanels.this.yearPercentageTableId[this.tabNumber].setMandatory(true);
                AssetPanels.this.yearPercentageTableId[this.tabNumber].setHidden(false);
                AssetPanels.this.degressivePercentage[this.tabNumber].setMandatory(false);
                AssetPanels.this.degressivePercentage[this.tabNumber].setHidden(true);
                AssetPanels.this.degressivePercentage[this.tabNumber].setValue();
                AssetPanels.this.annuityPercentage[this.tabNumber].setMandatory(false);
                AssetPanels.this.annuityPercentage[this.tabNumber].setHidden(true);
                AssetPanels.this.annuityPercentage[this.tabNumber].setValue();
                AssetPanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
                AssetPanels.this.annuityInterestTableId[this.tabNumber].setValue();
                return true;
            }
            if ("11".equals(AssetPanels.this.depreciationMethod[this.tabNumber].getValue())) {
                if (AssetPanels.this.mode == 0 || AssetPanels.this.currentCapitalization || AssetPanels.this.mode == 1 && AssetPanels.this.valuation[this.tabNumber].getLastDepreciationBookYear() == 0 && AssetPanels.this.asset.getState() == 2) {
                    AssetPanels.this.startPeriodHandlingMethod[this.tabNumber].setSelectedOptionValue("1");
                    AssetPanels.this.startPeriodHandlingMethod[this.tabNumber].setReadonly(true);
                    AssetPanels.this.interestCalculationMethod[this.tabNumber].setSelectedOptionValue("0");
                    AssetPanels.this.interestCalculationMethod[this.tabNumber].setReadonly(true);
                    AssetPanels.this.interestCalculationMethodChangeAction[this.tabNumber].execute(null);
                }
                AssetPanels.this.yearPercentageTableId[this.tabNumber].setMandatory(false);
                AssetPanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
                AssetPanels.this.yearPercentageTableId[this.tabNumber].setValue();
                AssetPanels.this.degressivePercentage[this.tabNumber].setMandatory(false);
                AssetPanels.this.degressivePercentage[this.tabNumber].setHidden(true);
                AssetPanels.this.degressivePercentage[this.tabNumber].setValue();
                AssetPanels.this.annuityPercentage[this.tabNumber].setHidden(false);
                AssetPanels.this.annuityInterestTableId[this.tabNumber].setHidden(false);
                return true;
            }
            if ("2".equals(AssetPanels.this.depreciationMethod[this.tabNumber].getValue())) {
                AssetPanels.this.yearPercentageTableId[this.tabNumber].setMandatory(false);
                AssetPanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
                AssetPanels.this.yearPercentageTableId[this.tabNumber].setValue();
                AssetPanels.this.degressivePercentage[this.tabNumber].setMandatory(true);
                AssetPanels.this.degressivePercentage[this.tabNumber].setHidden(false);
                AssetPanels.this.annuityPercentage[this.tabNumber].setMandatory(false);
                AssetPanels.this.annuityPercentage[this.tabNumber].setHidden(true);
                AssetPanels.this.annuityPercentage[this.tabNumber].setValue();
                AssetPanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
                AssetPanels.this.annuityInterestTableId[this.tabNumber].setValue();
                return true;
            }
            AssetPanels.this.yearPercentageTableId[this.tabNumber].setMandatory(false);
            AssetPanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
            AssetPanels.this.yearPercentageTableId[this.tabNumber].setValue();
            AssetPanels.this.degressivePercentage[this.tabNumber].setMandatory(false);
            AssetPanels.this.degressivePercentage[this.tabNumber].setHidden(true);
            AssetPanels.this.degressivePercentage[this.tabNumber].setValue();
            AssetPanels.this.annuityPercentage[this.tabNumber].setMandatory(false);
            AssetPanels.this.annuityPercentage[this.tabNumber].setHidden(true);
            AssetPanels.this.annuityPercentage[this.tabNumber].setValue();
            AssetPanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
            AssetPanels.this.annuityInterestTableId[this.tabNumber].setValue();
            return true;
        }
    }

    private class APTabActivateAction
    extends TabActivateAction {
        private static final long serialVersionUID = 4698365794179208227L;

        public APTabActivateAction(Tab tab, TabbedPanel tabbedPanel) {
            super(tab, tabbedPanel);
        }

        public boolean execute(DataObject object) throws Exception {
            object.removeMessages();
            int tabNumber = this.getActiveAccountingPrincipleTabIndex();
            String message = AssetPanels.this.validateAccountingPrincipleForm(tabNumber);
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return true;
            }
            super.execute(object);
            return true;
        }

        private int getActiveAccountingPrincipleTabIndex() {
            String tabName = AssetPanels.this.apTabbedPanel.getActiveTabName();
            for (int i = 0; i <= AssetPanels.this.apTabCountMax; ++i) {
                if (!AssetPanels.this.apTabTexts[i].equals(tabName)) continue;
                return i;
            }
            return AssetPanels.this.apTabCount;
        }
    }

    private class MainTabActivateAction
    extends TabActivateAction {
        private static final long serialVersionUID = 2298792855932187199L;

        private MainTabActivateAction(Tab tab, TabbedPanel tabbedPanel) {
            super(tab, tabbedPanel);
        }

        public boolean execute(DataObject object) throws Exception {
            String message;
            object.removeMessages();
            if ("Label.Common".equals(AssetPanels.this.mainTabPanel.getActiveTabName()) && (message = AssetPanels.this.validateCommonForm()) != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                AssetPanels.this.mainTabPanel.setActiveTabByName("Label.Common");
                return true;
            }
            if ("Label.Dimensions".equals(AssetPanels.this.mainTabPanel.getActiveTabName())) {
                AssetPanels.this.dimensionPanels.validateDimensionForm();
            }
            if ("Label.Valuation_Short".equals(AssetPanels.this.mainTabPanel.getActiveTabName())) {
                for (int i = 0; i <= AssetPanels.this.apTabCountMax; ++i) {
                    String message2 = AssetPanels.this.validateAccountingPrincipleForm(i);
                    if (message2 == null) continue;
                    object.addUIObject((UIObject)new Message(message2, "error"));
                    AssetPanels.this.mainTabPanel.setActiveTabByName("Label.Valuation_Short");
                    AssetPanels.this.apTabbedPanel.setActiveTab(AssetPanels.this.apTabs[i]);
                    return true;
                }
            }
            super.execute(object);
            AssetPanels.this.description.setReadonly(true);
            if ("Label.Common".equals(AssetPanels.this.mainTabPanel.getActiveTabName())) {
                AssetPanels.this.description.setReadonly(false);
            }
            return true;
        }
    }

    private class TypeListener
    implements EventListener {
        private static final long serialVersionUID = -8241496142961208972L;

        private TypeListener() {
        }

        public void event(UIObject object, String eventType) throws Exception {
            Object[] result = AssetTypeBO.get(AssetPanels.this.dbData, AssetPanels.this.companyOrDataSetId, AssetPanels.this.type.getValue().trim());
            AssetPanels.this.assetType = (AssetType)result[0];
            if (AssetPanels.this.assetType == null) {
                AssetPanels.this.type.setDescription("");
                return;
            }
            AssetPanels.this.type.setDescription(AssetPanels.this.assetType.getDescription());
            if (AssetPanels.this.mode == 1) {
                AssetPanels.this.initializeType();
            }
        }
    }
}

