/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FormattedField;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.UserErrorMessage;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.queries.AssetQuery;
import nl.ibs.jeelog.Log;

public class AssetReferenceField
extends ODBQueryReferenceField
implements FormattedField {
    private static final long serialVersionUID = -3792947446619680604L;
    private static final String[] NAMES = new String[]{"id", "description"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description"};
    private static final short[] SIZES = new short[]{100, 500};
    private Transformer transformer = null;
    private Company company;
    private boolean activated;
    private boolean credit;
    private Asset asset;
    private Boolean parentAsset;

    public AssetReferenceField(Company company, Boolean parentAsset, Boolean subAsset, boolean activated, boolean credit) throws Exception {
        this(company, parentAsset, subAsset, activated, credit, null);
    }

    public AssetReferenceField(Company company, Boolean parentAsset, Boolean subAsset, boolean activated, boolean credit, Boolean loan) throws Exception {
        super(LABELS[0], "upper", (ODBQuery)new AssetQuery(company.getDBData(), company.getId(), parentAsset, subAsset, activated, new Boolean(false), false, credit, loan), Asset.class);
        this.company = company;
        this.parentAsset = parentAsset;
        this.activated = activated;
        this.credit = credit;
        this.setName(((Object)((Object)this)).getClass().getName());
        this.setTableFields(NAMES);
        this.setTableHeaderLabels(LABELS);
        this.setValueField(NAMES[0]);
        this.setDescriptionField(NAMES[1]);
        this.setTableKeys(new String[]{NAMES[0]});
        this.setTableHeaderSizes(SIZES);
        this.setLength(10);
        this.setMaxLength(10);
        this.setDescriptionLength(50);
        this.setSearchFields(NAMES);
        this.setSearchFieldLabels(LABELS);
        if (AssetBO.isIdNumeric(company, credit)) {
            this.setType("number");
            this.setTableColumnTypes(new String[]{"number", null});
            this.transformer = new NumericIdTransformer();
            this.setTableTransformers(new Transformer[]{this.transformer, null});
        }
    }

    public Field setValue(String value) {
        if (this.transformer != null) {
            value = (String)this.transformer.transform((Object)value);
        }
        return super.setValue(value);
    }

    protected void beforeSelectWindowHook(DataObject object) throws Exception {
        this.commonTable = null;
        this.setReloadNeeded(true);
    }

    protected boolean selectedValueExecuteHook(DataObject object) {
        Asset asset = (Asset)this.getSelectedObject();
        try {
            this.setValue(asset.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void validate() throws Exception {
        super.validate();
        if (this.getValue().trim().length() == 0) {
            this.setDescription("");
            return;
        }
        Object[] result = AssetBO.get(this.company, this.getValue().trim(), this.credit);
        if (result[1] != null) {
            this.setInvalidTag();
            throw new UserErrorMessage((String)result[1]);
        }
        this.asset = (Asset)result[0];
        if (Boolean.TRUE.equals(this.parentAsset) && this.asset.getParentAsset() && !this.asset.getSubAsset()) {
            Log.debug((String)"a parent asset is never activated");
        } else if (this.asset.getState() == 0 || this.activated && this.asset.getState() != 2) {
            this.setInvalidTag();
            throw new UserErrorMessage("key_not_found");
        }
        this.setDescription(this.asset.getDescription());
    }

    public Asset getAsset() {
        return this.asset;
    }

    public String getFormattedId() throws Exception {
        return AssetBO.formatId(this.company, this.getValue(), this.credit);
    }
}

