/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.reports.AssetToPDF;
import nl.ibs.fac.reports.CreditToPDF;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.Scrambler;

public class AssetReportAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -298094475227683409L;
    public static final String PAGE = AssetReportAdapter.class.getName();
    private static final String SUBMIT = "submit";
    private String title = "Title.AssetReport";
    private String classNamePDF = AssetToPDF.CLASSNAME;
    private String jobName = "Job.Asset";
    private Panel selectionPanel = null;
    private AssetSelection assetSelection = null;
    protected boolean credit = false;
    protected boolean parent = false;
    protected boolean currentCapitalization = false;

    public AssetReportAdapter(ESPProcess process, DataObject object, boolean credit, boolean parent, boolean currentCapitalization) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.credit = credit;
        this.parent = parent;
        this.currentCapitalization = currentCapitalization;
        if (credit) {
            this.title = "Title.CreditReport";
            this.jobName = "Job.Credit";
            this.classNamePDF = CreditToPDF.CLASSNAME;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.assetSelection = new AssetSelection(object, this.credit);
        this.assetSelection.setSelectionAttribute(25, new Boolean(this.currentCapitalization).toString());
        this.assetSelection.setDisplayAttributes(true, true, true, false, false, false, true, true, false, true, false, false, false);
        this.selectionPanel = this.assetSelection.getSelectionPanel(this.loginHelper);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(this.title, "screen_name"));
        object.addUIObject((UIObject)this.selectionPanel);
        FloatBar fbShow = new FloatBar();
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        fbShow.addAction(ok);
        fbShow.addAction(((SubmitAdapter)this.getProcess().getAdapterByName(SubmitAdapter.PAGE)).getReturnAction());
        fbShow.addAction(this.finish);
        object.addUIObject((UIObject)fbShow);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair("User", this.loginHelper.getUser()));
        list.add(new NameValuePair("System", this.loginHelper.getSystem()));
        list.add(new NameValuePair("Password", Scrambler.scramble((String)this.loginHelper.getPassword())));
        list.add(new NameValuePair("facLib", this.dbData.getSchema()));
        list.add(new NameValuePair("Environment", this.env.getId()));
        list.add(new NameValuePair("Company", this.companyId));
        list.add(new NameValuePair("BookYear", this.bookYear));
        list.add(new NameValuePair("governmentActivated", "" + this.governmentActivated));
        list.add(new NameValuePair("PrintTransactions", Boolean.toString(this.assetSelection.getIncludeTransactions())));
        list.add(new NameValuePair(AssetSelection.ASSETSELECTION, this.assetSelection.getStringRepresentation()[0]));
        list.add(new NameValuePair(AssetSelection.ASSETSELECTION + "2", this.assetSelection.getStringRepresentation()[1]));
        this.assetSelection.save();
        if (this.parent) {
            list.add(new NameValuePair("isParent", ""));
        }
        if (this.currentCapitalization) {
            list.add(new NameValuePair("currentCapitalization", ""));
        }
        this.getProcess().setAttribute("backPage", (Object)PAGE);
        this.getProcess().setAttribute("selections", (Object)NameValuePair.getStringArray(list));
        this.getProcess().setAttribute("title", (Object)this.title);
        this.getProcess().setAttribute("classNamePDF", (Object)this.classNamePDF);
        this.getProcess().setAttribute("jobName", (Object)this.jobName);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "showInWindow", this.getProcess().getProcessId()));
        return object;
    }
}

