/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.BookYearField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.ReportAdapterHelper;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.gov.reports.GOVAssetSheetToCSV;
import nl.ibs.fac.gov.reports.GOVAssetSheetToPDF;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.AssetSheetToCSV;
import nl.ibs.fac.reports.AssetSheetToPDF;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.Scrambler;

public class AssetSheetReportAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 3708988390053786317L;
    public static final String PAGE = AssetSheetReportAdapter.class.getName();
    private static final String SUBMIT = "submit";
    private String title = "MenuItem.AssetSheet";
    private String classNameCSV = AssetSheetToCSV.CLASSNAME;
    private String classNamePDF = AssetSheetToPDF.CLASSNAME;
    private String classNameCSV_GOV = GOVAssetSheetToCSV.CLASSNAME;
    private String classNamePDF_GOV = GOVAssetSheetToPDF.CLASSNAME;
    private String jobName = "Job.AssetSheet";
    private Panel panel = new HeaderPanel();
    private Field bookYearForReport;
    private NumberField fromPeriodForReport;
    private NumberField toPeriodForReport;
    private FieldGroup subPanel = new FieldGroup("Label.Common");
    private CheckBox inclDisinvested;
    private CheckBox exclBookValueZero;
    private ComboBox accountingPrinciple;
    private AccountingPrincipleChangeAction accountingPrincipleChangeAction;
    private ComboBox reportType;
    private ReportTypeChangeAction reportTypeChangeAction;
    private CheckBox justTotals;
    private CheckBox generalTotal;
    private Panel selectionPanel = null;
    private AssetSelection assetSelection = null;
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbShowSelectionPanel = new FloatBar();
    private boolean[] asda = new boolean[]{true, true, true, false, false, false, false, false, false, true, true, false, true};

    public AssetSheetReportAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        Company company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.panel.setWidth(590);
        this.bookYearForReport = new BookYearField("Label.BookYear", this.bookYear, this.bookYearMin, this.bookYearMax);
        this.panel.addUIObject((UIObject)this.bookYearForReport);
        this.fromPeriodForReport = ReportAdapterHelper.retrieveFromPeriodNumberField(company, this.numberOfPeriods);
        this.panel.addUIObject((UIObject)this.fromPeriodForReport);
        this.toPeriodForReport = ReportAdapterHelper.retrieveToPeriodNumberField(company, this.numberOfPeriods);
        this.panel.addUIObject((UIObject)this.toPeriodForReport);
        this.accountingPrinciple = ReportAdapterHelper.retrieveAccountingPrincipleComboBox(this.env, company, this.governmentActivated);
        if (this.accountingPrinciple.getOptions().size() > 1) {
            if (this.governmentActivated) {
                this.accountingPrincipleChangeAction = new AccountingPrincipleChangeAction();
                this.accountingPrinciple.add((Action)this.accountingPrincipleChangeAction);
            }
            this.subPanel.add(this.accountingPrinciple);
        }
        this.reportType = ReportAdapterHelper.retrieveReportTypeComboBox(false);
        this.reportTypeChangeAction = new ReportTypeChangeAction();
        this.reportType.add((Action)this.reportTypeChangeAction);
        this.subPanel.add(this.reportType);
        this.justTotals = new CheckBox(LanguageHelper.getString("nl.ibs.fac.language", "JustTotals"));
        this.subPanel.add(this.justTotals);
        this.generalTotal = new CheckBox("Label.PrintGeneralTotal", false);
        this.subPanel.add(this.generalTotal);
        this.inclDisinvested = !this.governmentActivated ? new CheckBox("Label.IncludeDisinvested", false) : new CheckBox("Label.IncludeDisinvestedOrClosed", false);
        this.subPanel.add(this.inclDisinvested);
        this.exclBookValueZero = new CheckBox("Label.ExclBookValueZero", false);
        this.subPanel.add(this.exclBookValueZero);
        Action next = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showSelectionPanel");
        next.setValidationEnabled(true);
        next.setDefault(true);
        this.fbShow.addAction(next);
        this.fbShow.addAction(this.finish);
        this.fbShowSelectionPanel.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("show"));
        Action ok = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        this.fbShowSelectionPanel.addAction(ok);
        this.fbShowSelectionPanel.addAction(this.finish);
        if (this.accountingPrincipleChangeAction != null) {
            this.accountingPrincipleChangeAction.execute(object);
        }
        this.reportTypeChangeAction.execute(object);
        this.assetSelection = new AssetSelection(object, false);
        this.assetSelection.hideFieldGroup = true;
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(this.title, "screen_name"));
        this.panel.setReadonly(false);
        object.addUIObject((UIObject)this.panel);
        this.subPanel.setReadonly(false);
        object.addUIObject((UIObject)this.subPanel);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject showSelectionPanel(DataObject object) throws Exception {
        this.assetSelection.setDisplayAttributes(this.asda[0], this.asda[1], this.asda[2], this.asda[3], this.asda[4], this.asda[5], this.asda[6], this.asda[7], this.asda[8], this.asda[9], this.asda[10], this.asda[11], this.asda[12]);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(this.title, "screen_name"));
        this.panel.setReadonly(true);
        object.addUIObject((UIObject)this.panel);
        this.subPanel.setReadonly(true);
        object.addUIObject((UIObject)this.subPanel);
        this.selectionPanel = this.assetSelection.getSelectionPanel(this.loginHelper);
        object.addUIObject((UIObject)this.selectionPanel);
        object.addUIObject((UIObject)this.fbShowSelectionPanel);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair("User", this.loginHelper.getUser()));
        list.add(new NameValuePair("System", this.loginHelper.getSystem()));
        list.add(new NameValuePair("Password", Scrambler.scramble((String)this.loginHelper.getPassword())));
        list.add(new NameValuePair("facLib", this.dbData.getSchema()));
        list.add(new NameValuePair("Environment", this.env.getId()));
        list.add(new NameValuePair("Company", this.companyId));
        list.add(new NameValuePair("BookYear", this.bookYear));
        list.add(new NameValuePair("governmentActivated", "" + this.governmentActivated));
        list.add(new NameValuePair("BookYearForReport", this.bookYearForReport.getValue()));
        list.add(new NameValuePair("PeriodFrom", this.fromPeriodForReport.getValue()));
        list.add(new NameValuePair("PeriodTo", this.toPeriodForReport.getValue()));
        list.add(new NameValuePair("AccountingPrinciple", this.accountingPrinciple.getSelectedOptionValue()));
        this.assetSelection.fldInclDisinvested.setValue(this.inclDisinvested.getValueAsBoolean());
        this.assetSelection.fldExclBookValueZero.setValue(this.exclBookValueZero.getValueAsBoolean());
        this.assetSelection.fldJustTotals.setValue(this.justTotals.getValueAsBoolean());
        this.assetSelection.fldGrandTotal.setValue(this.generalTotal.getValueAsBoolean());
        list.add(new NameValuePair(AssetSelection.ASSETSELECTION, this.assetSelection.getStringRepresentation()[0]));
        list.add(new NameValuePair(AssetSelection.ASSETSELECTION + "2", this.assetSelection.getStringRepresentation()[1]));
        this.assetSelection.save();
        this.getProcess().setAttribute("selections", (Object)NameValuePair.getStringArray(list));
        this.getProcess().setAttribute("title", (Object)this.title);
        this.getProcess().removeAttribute("classNameCSV");
        this.getProcess().removeAttribute("classNamePDF");
        if ("CSV".equals(this.reportType.getValue())) {
            if (this.governmentActivated) {
                this.getProcess().setAttribute("classNameCSV", (Object)this.classNameCSV_GOV);
            } else {
                this.getProcess().setAttribute("classNameCSV", (Object)this.classNameCSV);
            }
        } else if (this.governmentActivated) {
            this.getProcess().setAttribute("classNamePDF", (Object)this.classNamePDF_GOV);
        } else {
            this.getProcess().setAttribute("classNamePDF", (Object)this.classNamePDF);
        }
        this.getProcess().setAttribute("jobName", (Object)this.jobName);
        this.getProcess().setAttribute("backPage", (Object)PAGE);
        this.getProcess().setAttribute("backMethod", (Object)"showSelectionPanel");
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "showInWindow", this.getProcess().getProcessId()));
        return object;
    }

    private class AccountingPrincipleChangeAction
    extends Action {
        private static final long serialVersionUID = 1L;

        public boolean execute(DataObject dataObject) throws Exception {
            if ("1".equals(AssetSheetReportAdapter.this.accountingPrinciple.getValue()) || "2".equals(AssetSheetReportAdapter.this.accountingPrinciple.getValue())) {
                if (!"CSV".equals(AssetSheetReportAdapter.this.reportType.getValue())) {
                    AssetSheetReportAdapter.this.justTotals.setHidden(false);
                    AssetSheetReportAdapter.this.generalTotal.setHidden(false);
                    ((AssetSheetReportAdapter)AssetSheetReportAdapter.this).asda[0] = true;
                    ((AssetSheetReportAdapter)AssetSheetReportAdapter.this).asda[1] = true;
                }
            } else {
                AssetSheetReportAdapter.this.justTotals.setValue(false);
                AssetSheetReportAdapter.this.justTotals.setHidden(true);
                AssetSheetReportAdapter.this.generalTotal.setValue(false);
                AssetSheetReportAdapter.this.generalTotal.setHidden(true);
                ((AssetSheetReportAdapter)AssetSheetReportAdapter.this).asda[0] = false;
                ((AssetSheetReportAdapter)AssetSheetReportAdapter.this).asda[1] = false;
            }
            return true;
        }
    }

    private class ReportTypeChangeAction
    extends Action {
        private static final long serialVersionUID = 1L;

        public boolean execute(DataObject dataObject) throws Exception {
            if ("CSV".equals(AssetSheetReportAdapter.this.reportType.getValue())) {
                AssetSheetReportAdapter.this.justTotals.setValue(false);
                AssetSheetReportAdapter.this.justTotals.setHidden(true);
                AssetSheetReportAdapter.this.generalTotal.setValue(false);
                AssetSheetReportAdapter.this.generalTotal.setHidden(true);
                ((AssetSheetReportAdapter)AssetSheetReportAdapter.this).asda[9] = false;
                ((AssetSheetReportAdapter)AssetSheetReportAdapter.this).asda[10] = false;
                ((AssetSheetReportAdapter)AssetSheetReportAdapter.this).asda[11] = true;
            } else if ("1".equals(AssetSheetReportAdapter.this.accountingPrinciple.getValue()) || "2".equals(AssetSheetReportAdapter.this.accountingPrinciple.getValue())) {
                AssetSheetReportAdapter.this.justTotals.setHidden(false);
                AssetSheetReportAdapter.this.generalTotal.setHidden(false);
                ((AssetSheetReportAdapter)AssetSheetReportAdapter.this).asda[9] = true;
                ((AssetSheetReportAdapter)AssetSheetReportAdapter.this).asda[10] = true;
                ((AssetSheetReportAdapter)AssetSheetReportAdapter.this).asda[11] = false;
            }
            return true;
        }
    }
}

