/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.language.TranslationHelperImpl;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.DateSelectionField;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabActivateAction;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.AssetStateEnum;
import nl.ibs.fac.ComparisonValue;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.TransactionTypeEnum;
import nl.ibs.fac.adapters.AssetDimensionPanels;
import nl.ibs.fac.adapters.AssetPanels;
import nl.ibs.fac.adapters.AssetReferenceField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionDetailAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionImageTransformer;
import nl.ibs.fac.adapters.ProofDepreciationAdapter;
import nl.ibs.fac.adapters.TransactionAdapter;
import nl.ibs.fac.adapters.TransactionAggregationInfoAdapter;
import nl.ibs.fac.adapters.TransactionStateImageTransformer;
import nl.ibs.fac.adapters.TransactionTypeTransformer;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.boadapters.WozValueBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.db.WozValue;
import nl.ibs.fac.gov.adapters.BBVCategoryImageTransformer;
import nl.ibs.fac.gov.adapters.ValuationMainAccountAdapter;
import nl.ibs.fac.gov.boadapters.CreditBO;
import nl.ibs.fac.queries.TransactionQuery;

public class AssetTransactionAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -8826064995555118543L;
    private static final Class CLASS = AssetTransactionAdapter.class;
    public static final String PAGE = CLASS.getName();
    public static final String RETURNPAGE = "AssetTransactionAdapterReturnPage";
    public static final String RETURNMETHOD = "AssetTransactionAdapterReturnMethod";
    private Company company;
    private Asset asset;
    private Panel headerPanel;
    private AssetReferenceField assetReferenceField;
    private Field state = new Field("Label.State");
    private AssetPanels panels;
    private TabbedPanel apTabbedPanel;
    private Tab[] apTabs = new Tab[3];
    private ODBTable table;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES = new String[]{"FACYearAndPeriod", "transactionType", "valueForAmount1", "valueForAmount2", "valueForAmount3", "description", "documentAndSequenceNumber", "bookingIndicator", "state", "incomingFinancialTransaction"};
    private String[] LABELS = new String[]{"Label.Period", "Label.TransactionType", "Label.Acquisition", "Label.Depreciation", "Label.Interest", "Label.Description", "Label.TransNbrShort", "Label.BookingIndicator", "Label.State", "Label.IncomingFinancialTransaction"};
    private static final String[] TOOLTIPS = new String[]{"Label.BookingIndicator", "Label.State", "Label.IncomingFinancialTransaction"};
    private static final short[] SIZES = new short[]{80, 150, 120, 120, 120, 180, 100, 20, 20, 20};
    private static final String[] TYPES = new String[]{null, "text", null, null, null, null, null, null, null, null};
    private static final ZeroBigDecimalToBlankTransformer DECIMALTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
    private static final Transformer[] TRANSFORMERS = new Transformer[]{null, new TransactionTypeTransformer(), DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, null, null, new BBVCategoryImageTransformer(), new TransactionStateImageTransformer(), new IncomingFinancialTransactionImageTransformer()};
    private static final boolean[] COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] SORTABLE = new boolean[]{false, true, false, false, false, true, false, true, true, true};
    private static final String[] SEARCH_NAMES = new String[]{"bookYear", "transactionType", "description", "documentNr"};
    private static final String[] SEARCH_LABELS = new String[]{"Label.Year", "Label.TransactionType", "Label.Description", "Label.Transaction"};
    private Map<String, ComboBox> inputComponents = new HashMap<String, ComboBox>();
    private static final String REFRESH = "refresh";
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbAP = new FloatBar();
    private Action proofDepreciate;
    private Action[] rowActions;
    private Action[] headerActions;
    private boolean allTransactions = false;
    private Action changeView;
    private String currentTabName;

    public AssetTransactionAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.headerPanel = new HeaderPanel();
        this.assetReferenceField = new AssetReferenceField(this.company, null, null, false, false);
        this.assetReferenceField.setLabel("Label.Asset");
        this.assetReferenceField.setReadonly(true);
        this.headerPanel.addUIObject((UIObject)this.assetReferenceField);
        this.state.setReadonly(true);
        this.state.setLength(25);
        this.headerPanel.addUIObject((UIObject)this.state);
        Action back = new Action("Button.Back").setAdapter((String)this.getProcess().getAttribute(RETURNPAGE)).setMethod((String)this.getProcess().getAttribute(RETURNMETHOD));
        Action showCurrentMainAccounts = null;
        if (this.company.getUseValuationMainAccount()) {
            showCurrentMainAccounts = new Action("Label.MainAccountScheme").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showCurrentMainAccounts");
        }
        Action showValuation = new Action("Button.Valuation").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showValuation");
        this.proofDepreciate = new Action("Button.FutureDepreciations").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("proofDepreciate");
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        this.changeView = new Action("Button.IncludingSystemtransactions").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("changeView");
        Action showAssetDetails = new Action("Button.BasicData").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showAssetDetails");
        this.fbShow.addAction(back);
        this.fbShow.addAction(this.changeView);
        this.fbShow.addAction(showAssetDetails);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(this.finish);
        this.fbAP.alignment(1);
        this.fbAP.addAction(showValuation);
        if (this.company.getUseValuationMainAccount()) {
            this.fbAP.addAction(showCurrentMainAccounts);
        }
        this.fbAP.addAction(this.proofDepreciate);
        this.headerActions = new Action[]{refresh, this.changeView, showAssetDetails};
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(TransactionAdapter.PAGE)).setMethod("show");
        Action incomingFinancialTransaction = new Action("Button.IncomingFinancialTransaction").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionDetailAdapter.PAGE)).setMethod("showDetails");
        Action aggregatedTransactions = new Action("Button.AggregatedTransactions").setAdapter(this.getProcessAdapterPageName(TransactionAggregationInfoAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{details, incomingFinancialTransaction, aggregatedTransactions};
        ComboBox comboBox = EnumHelper.createComboBox("Label.TransactionType", TransactionTypeEnum.getCollection(), true);
        comboBox.setWidth("170");
        this.inputComponents.put("transactionType", comboBox);
    }

    public DataObject show(DataObject object) throws Exception {
        WozValue wozValue;
        Object myObject = TableHelper.getSelectedItem((DataObject)object);
        if (myObject instanceof Asset) {
            this.asset = (Asset)myObject;
        } else if (myObject instanceof ComparisonValue) {
            ComparisonValue cv = (ComparisonValue)myObject;
            this.asset = (Asset)AssetBO.get(this.company, cv.getAcquisitionAccount(), false)[0];
        }
        this.getProcess().setAttribute("asset", (Object)this.asset);
        this.proofDepreciate.setEnabled(true);
        if (this.asset.getState() != 2) {
            this.proofDepreciate.setTooltip(TranslationHelperImpl.getInstance().translate("invalid_state"));
            this.proofDepreciate.setEnabled(false);
        } else if (this.asset.getParentId() != null && this.asset.getParentId().trim().length() > 0 && (wozValue = WozValueBO.getLastWozValue(this.dbData, this.companyId, "A", this.asset.getParentId())) != null) {
            this.proofDepreciate.setTooltip(TranslationHelperImpl.getInstance().translate("parent_has_woz_limit_value"));
            this.proofDepreciate.setEnabled(false);
        }
        this.assetReferenceField.setValue(this.asset.getId());
        this.assetReferenceField.setDescription(this.asset.getDescription());
        String assetState = AssetStateEnum.getValue(this.asset.getState());
        if (this.asset.getState() == 4 || this.asset.getState() == 5 || this.asset.getState() == 7) {
            assetState = assetState + " (" + this.asset.getDisinvestmentYear() + "-" + this.asset.getDisinvestmentPeriod() + ")";
        } else if (this.asset.getState() == 2) {
            assetState = assetState + " (" + this.asset.getStartUseYear() + "-" + this.asset.getStartUsePeriod() + ")";
        }
        this.state.setValue(assetState);
        this.panels = new AssetPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.governmentActivated, this.asset, false, false, false, null, false, null, null);
        this.panels.setValues();
        if (this.asset.getLoan()) {
            this.panels.updateAccountingPrincipleForms(true);
        }
        this.currentTabName = null;
        return this.refresh(object);
    }

    public DataObject showInternal(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.ViewAssetTransactions", "screen_name"));
        object.addUIObject((UIObject)this.headerPanel);
        if (this.table == null) {
            this.apTabbedPanel = new TabbedPanel();
            for (int i = 0; i <= this.panels.apTabCountMax; ++i) {
                if (this.panels.apTabs[i].isHidden()) continue;
                this.apTabs[i] = new Tab(this.panels.apTabTexts[i]);
                this.createTable(object, this.panels.ap[i]);
                this.apTabs[i].add((Panel)this.searchPanel);
                this.apTabs[i].add((Table)this.table);
                this.apTabs[i].add(this.fbAP);
                this.apTabbedPanel.add(this.apTabs[i], (TabActivateAction)new MyTabActivateAction(this.apTabs[i], this.apTabbedPanel));
            }
        }
        if (this.currentTabName != null && this.currentTabName.trim().length() > 0) {
            this.apTabbedPanel.setActiveTabByName(this.currentTabName);
        }
        object.addUIObject((UIObject)this.apTabbedPanel);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject changeView(DataObject object) throws Exception {
        this.currentTabName = this.apTabbedPanel.getActiveTabName();
        if (this.allTransactions) {
            this.allTransactions = false;
            this.changeView.setLabel("Button.IncludingSystemtransactions");
        } else {
            this.allTransactions = true;
            this.changeView.setLabel("Button.ExcludingSystemtransactions");
        }
        return this.refresh(object);
    }

    private void createTable(DataObject object, int accountingPrinciple) throws Exception {
        if (this.governmentActivated) {
            if (this.asset.getLoan()) {
                this.LABELS[2] = "Label.Loan";
                this.LABELS[3] = "Label.PayOff";
            } else {
                this.LABELS[2] = "Label.Acquisition";
                this.LABELS[3] = "Label.Depreciation";
            }
        }
        TransactionQuery query = new TransactionQuery(this.dbData, this.asset, accountingPrinciple, this.allTransactions);
        this.table = new ODBTable(Transaction.class, (ODBQuery)query, new String[]{"bookYear", "period", "documentNr", "seqNr"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(this.LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setColumnTypes(TYPES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setColumnSortable(SORTABLE);
        this.table.setInputComponents(this.inputComponents);
        this.table.setSortable(true);
        this.table.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.table, (Action[])this.headerActions, (Action[])this.rowActions, (TableRowMethod)new TransactionTableRowMethod());
        this.searchPanel = this.table.createSearch(SEARCH_NAMES, SEARCH_LABELS);
        Action filterAction = this.table.createFilterAction(SEARCH_NAMES, SEARCH_LABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.showInternal(object);
    }

    public DataObject showAssetDetails(DataObject object) throws Exception {
        String label3;
        String label2;
        String label1;
        int sequenceNr1stTransaction;
        int documentNr1stTransaction;
        Field field;
        Object[] objects;
        AssetType type = this.asset.getAssetType();
        WozValue wozValue = WozValueBO.getLastWozValue(this.dbData, this.companyId, "A", this.asset.getId());
        Window window = new Window();
        window.setTop("10%");
        window.setRight("15%");
        window.setLabel("Activum " + this.asset.getId() + " - " + object.translate("Button.BasicData", object.getLocale()));
        TabbedPanel tabbedPanel = new TabbedPanel();
        Tab commonTab = new Tab("Label.Common");
        tabbedPanel.add(commonTab);
        Tab dimensionTab = new Tab("Label.Dimensions");
        tabbedPanel.add(dimensionTab);
        FieldGroup fg = new FieldGroup("");
        ReferenceField rf = new ReferenceField("Label.Asset");
        rf.setLength(10);
        rf.setDescriptionLength(40);
        rf.setReadonly(true);
        rf.setValue(this.asset.getId());
        rf.setDescription(this.asset.getDescription());
        fg.add((Field)rf);
        if (this.asset.getParent() != null) {
            rf = new ReferenceField("Label.ParentAsset");
            rf.setLength(10);
            rf.setDescriptionLength(40);
            rf.setReadonly(true);
            rf.setValue(this.asset.getParentId());
            rf.setDescription(this.asset.getParent().getDescription());
            fg.add((Field)rf);
        }
        rf = new ReferenceField("Label.Type");
        rf.setLength(10);
        rf.setDescriptionLength(40);
        rf.setReadonly(true);
        rf.setValue(type.getId());
        rf.setDescription(type.getDescription());
        fg.add((Field)rf);
        if (this.asset.getCreditId() != null && (objects = CreditBO.get(this.company, this.asset.getCreditId()))[0] != null) {
            Credit credit = (Credit)objects[0];
            rf = new ReferenceField("Label.Credit");
            rf.setLength(10);
            rf.setDescriptionLength(40);
            rf.setReadonly(true);
            rf.setValue(this.asset.getCreditId());
            rf.setDescription(credit.getDescription());
            fg.add((Field)rf);
        }
        commonTab.add(fg);
        dimensionTab.add(fg);
        boolean isLoan = this.asset.getLoan();
        fg = new FieldGroup("");
        DateSelectionField dsField = new DateSelectionField("Label.AcquisitionDate");
        dsField.setLength(10);
        dsField.setReadonly(true);
        dsField.setValue(this.asset.getAcquisitionDate());
        if (this.asset.getCurrentCapitalization() && this.asset.getCreditId() == null) {
            field = new Field("Label.CurrentAsset", "text", null, object.translate("Label.Yes", object.getLocale()), 10);
            field.setReadonly(true);
            fg.add(field);
            field = new Field("Label.HistAcqPeriod", "text", null, PeriodHelper.toString(this.asset.getHistoricalYear(), this.asset.getHistoricalPeriod()), 10);
            field.setReadonly(true);
            fg.add(field);
            dsField.setLabel("Label.HistAcqDate");
            fg.add((Field)dsField);
        } else {
            fg.add((Field)dsField);
        }
        if (isLoan) {
            dsField.setLabel("Label.EntryDate");
        }
        field = new Field("Label.FACStartPeriod", "text", null, PeriodHelper.toString(this.asset.getStartUseYear(), this.asset.getStartUsePeriod()), 10);
        field.setReadonly(true);
        fg.add(field);
        if (wozValue != null) {
            field = new Field("Label.CurrentWOZValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(wozValue.getWOZAmount()), 15);
            field.setType("decimal");
            field.setReadonly(true);
            fg.add(field);
        }
        if (this.asset.getNegativeInvestment()) {
            field = new Field("Label.NegativeInvestment", "text", null, object.translate("Label.Yes", object.getLocale()), 10);
            field.setReadonly(true);
            fg.add(field);
        }
        if (isLoan) {
            field = new Field("Label.Loan", "text", null, object.translate("Label.Yes", object.getLocale()), 10);
            field.setReadonly(true);
            fg.add(field);
            field = new Field("Label.PayOffYearAmount", "decimal", null, (String)DECIMALTRANSFORMER.transform(this.asset.getPayOffYearAmount()), 15);
            field.setType("decimal");
            field.setReadonly(true);
            fg.add(field);
        }
        commonTab.add(fg);
        Valuation valuation = (Valuation)ValuationBO.get(this.dbData, this.companyId, "A", this.asset.getId(), 1)[0];
        BigDecimal acquisitionValue = valuation.getPostedAcquisitionBalance();
        if (this.asset.getState() == 0) {
            documentNr1stTransaction = valuation.getDocumentNr1stTransaction();
            sequenceNr1stTransaction = valuation.getSeqNr1stTransaction();
            acquisitionValue = ((Transaction)TransactionBO.get(this.dbData, this.companyId, documentNr1stTransaction, sequenceNr1stTransaction)[0]).getAmount1();
        }
        fg = !this.governmentActivated ? new FieldGroup(this.env.getAPName1()) : new FieldGroup();
        if (isLoan) {
            label1 = "Label.LoanAmount";
            label2 = "Label.PayOffs";
            label3 = "Label.RestLoan";
        } else {
            label1 = "Label.AcquisitionValue";
            label2 = "Label.Depreciations";
            label3 = "Label.BookValue";
        }
        field = new Field(label1, "decimal", null, (String)DECIMALTRANSFORMER.transform(acquisitionValue), 15);
        field.setType("decimal");
        field.setReadonly(true);
        fg.add(field);
        field = new Field(label2, "decimal", null, (String)DECIMALTRANSFORMER.transform(valuation.getPostedDepreciationBalance()), 15);
        field.setType("decimal");
        field.setReadonly(true);
        fg.add(field);
        field = new Field(label3, "decimal", null, (String)DECIMALTRANSFORMER.transform(acquisitionValue.subtract(valuation.getPostedDepreciationBalance())), 15);
        field.setType("decimal");
        field.setReadonly(true);
        fg.add(field);
        if (wozValue != null) {
            field = new Field("Label.LimitValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(wozValue.getLimitAmount1()), 15);
            field.setType("decimal");
            field.setReadonly(true);
            fg.add(field);
        }
        commonTab.add(fg);
        valuation = (Valuation)ValuationBO.get(this.dbData, this.companyId, "A", this.asset.getId(), 2)[0];
        if (valuation != null) {
            acquisitionValue = valuation.getPostedAcquisitionBalance();
            if (this.asset.getState() == 0) {
                documentNr1stTransaction = valuation.getDocumentNr1stTransaction();
                sequenceNr1stTransaction = valuation.getSeqNr1stTransaction();
                acquisitionValue = ((Transaction)TransactionBO.get(this.dbData, this.companyId, documentNr1stTransaction, sequenceNr1stTransaction)[0]).getAmount1();
            }
            fg = new FieldGroup(this.env.getAPName2());
            field = new Field(label1, "decimal", null, (String)DECIMALTRANSFORMER.transform(acquisitionValue), 15);
            field.setType("decimal");
            field.setReadonly(true);
            fg.add(field);
            field = new Field(label2, "decimal", null, (String)DECIMALTRANSFORMER.transform(valuation.getPostedDepreciationBalance()), 15);
            field.setType("decimal");
            field.setReadonly(true);
            fg.add(field);
            field = new Field(label3, "decimal", null, (String)DECIMALTRANSFORMER.transform(acquisitionValue.subtract(valuation.getPostedDepreciationBalance())), 15);
            field.setType("decimal");
            field.setReadonly(true);
            fg.add(field);
            if (wozValue != null) {
                field = new Field("Label.LimitValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(wozValue.getLimitAmount2()), 15);
                field.setType("decimal");
                field.setReadonly(true);
                fg.add(field);
            }
            commonTab.add(fg);
        }
        AssetDimensionPanels dimensionPanels = new AssetDimensionPanels(this.loginHelper, this.dbData, this.env, this.company, true);
        dimensionTab.add(dimensionPanels.initializeFINDimensionPanel(this.asset, this.asset.getAssetType(), null, null));
        dimensionTab.add(dimensionPanels.initializeFACDimensionPanel(this.asset, this.asset.getAssetType(), true, null));
        Panel panel = new Panel();
        panel.addUIObject((UIObject)tabbedPanel);
        window.add(panel);
        object.addUIObject((UIObject)window);
        return object;
    }

    public DataObject showCurrentMainAccounts(DataObject object) throws Exception {
        ValuationMainAccountAdapter vmaAdapter = (ValuationMainAccountAdapter)this.getProcess().getAdapterByName("nl.ibs.fac.gov.adapters.ValuationMainAccountAdapter");
        object = vmaAdapter.showInfoWindow(object);
        return object;
    }

    public DataObject showValuation(DataObject object) throws Exception {
        Window window = new Window();
        window.setTop("10%");
        window.setRight("15%");
        String sAP = "";
        sAP = this.apTabbedPanel.getActiveTabName().trim().equals(this.env.getAPShortName2()) ? this.env.getAPName2() : this.env.getAPName1();
        window.setLabel(object.translate("Label.Valuation", object.getLocale()) + " - " + sAP);
        Tab apTab = this.panels.apTabs[this.getActiveAccountingPrincipleTabIndex()];
        for (FieldGroup fg : apTab.getUIObjects(FieldGroup.class, false)) {
            fg.setReadonly();
            window.add(fg);
        }
        object.addUIObject((UIObject)window);
        return object;
    }

    public DataObject proofDepreciate(DataObject object) throws Exception {
        Valuation valuation = this.panels.valuation[this.getActiveAccountingPrincipleTabIndex()];
        this.getProcess().setAttribute("valuation", (Object)valuation);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(ProofDepreciationAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    private int getActiveAccountingPrincipleTabIndex() {
        String tabName = this.apTabbedPanel.getActiveTabName();
        for (int i = 0; i <= this.panels.apTabCountMax; ++i) {
            if (!this.panels.apTabTexts[i].equals(tabName)) continue;
            return i;
        }
        return this.panels.apTabCount;
    }

    private class MyTabActivateAction
    extends TabActivateAction {
        private static final long serialVersionUID = 2298792855932187199L;

        private MyTabActivateAction(Tab tab, TabbedPanel tabbedPanel) {
            super(tab, tabbedPanel);
        }

        public boolean execute(DataObject object) throws Exception {
            super.execute(object);
            AssetTransactionAdapter.this.currentTabName = AssetTransactionAdapter.this.apTabbedPanel.getActiveTabName();
            return true;
        }
    }

    private class TransactionTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 8783248279555229442L;

        private TransactionTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            Transaction transaction = (Transaction)row.getObject();
            ContextMenu menu = new ContextMenu();
            for (int i = 0; i < rowActions.length; ++i) {
                if (i == 1 && transaction.getIncomingFinancialTransaction() == null || i == 2 && transaction.getTransactionType() != 150) continue;
                ContextAction rowAction = new ContextAction(rowActions[i].getName());
                rowAction.setAdapter(rowActions[i].getPageid());
                rowAction.setMethod(rowActions[i].getMethod());
                menu.addContextMenuItem(rowAction);
            }
            row.setContextMenu(menu);
        }
    }
}

