/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.Option;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabActivateAction;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.DepreciationMethodEnum;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.GenericUsageEnum;
import nl.ibs.fac.InterestCalculationMethodEnum;
import nl.ibs.fac.JournalingsTermEnum;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.StartPeriodHandlingEnum;
import nl.ibs.fac.adapters.AnalysisCodeReferenceField;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.adapters.InterestTableReferenceField;
import nl.ibs.fac.adapters.YearPercentageTableReferenceField;
import nl.ibs.fac.boadapters.AnalysisGroupBO;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetTypeAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.InterestTableBO;
import nl.ibs.fac.boadapters.MainAccountSchemeBO;
import nl.ibs.fac.boadapters.YearPercentageTableBO;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.AssetTypeAccountingPrincipleDefault;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.YearPercentageTable;
import nl.ibs.fac.gov.GovernmentEnumHelper;
import nl.ibs.fac.queries.AnalysisGroupQuery;
import nl.ibs.jsql.DBData;
import nl.ibs.util.NameValuePair;

public class AssetTypePanels
implements Serializable {
    private static final long serialVersionUID = -5155300709633643399L;
    private LoginHelper loginHelper;
    private DBData dbData = null;
    private Environment env = null;
    private Company company = null;
    private AssetType assetType;
    private String bookYearMin = null;
    private String bookYearMax = null;
    private int numberOfPeriods;
    private boolean governmentActivated;
    private AssetTypeAccountingPrincipleDefault[] accountingPrincipleDefault = new AssetTypeAccountingPrincipleDefault[4];
    private Tab commonTab;
    private Tab miscTab;
    protected MainTabActivateAction mainTabActivateAction;
    protected Panel mainPanel;
    protected Field id = new Field("Label.Id", "upper");
    protected Field description = new Field("Label.Description");
    protected CheckBox useAccountingPrinciple2 = new CheckBox("Label.InUse");
    private UseAccountingPrinciple2ChangeAction useAccountingPrinciple2ChangeAction = new UseAccountingPrinciple2ChangeAction();
    protected FieldGroup subPanel;
    protected FieldGroup subPanel2;
    private ComboBox category;
    private CategoryChangeAction categoryChangeAction;
    private CheckBox thirdPartyLoan = new CheckBox("Label.ThirdPartyLoan");
    private CheckBox notUsed = new CheckBox("Label.NotUsedAnymore");
    private CheckBox limitedDepreciation = new CheckBox("Label.LimitedDepreciation");
    private CheckBox depreciateBeyondEconomicLife = new CheckBox("Label.DepreciateBeyondEconomicLife");
    private DepreciateBeyondEconomicLifeChangeAction depreciateBeyondEconomicLifeChangeAction = new DepreciateBeyondEconomicLifeChangeAction();
    private CheckBox exclWriteOff = new CheckBox("Label.ExclWriteOff");
    private CheckBox differentAcquisitionValueForAP2 = new CheckBox("Label.DifferentAcquisitionValue");
    protected FieldGroup financialPanel;
    private String[] finTexts = new String[5];
    private ComboBox[] fins = new ComboBox[5];
    protected FieldGroup dimensionPanel;
    private ESPGridLayout gridLayout;
    private ComboBox[] dims = new ComboBox[10];
    private DimensionComboBoxChangeAction[] acts = new DimensionComboBoxChangeAction[10];
    private CheckBox[] mans = new CheckBox[10];
    private AnalysisCodeReferenceField[] dfts = new AnalysisCodeReferenceField[10];
    private Tab apTab;
    protected Panel[] apPanels = new Panel[3];
    private TabbedPanel apTabbedPanel;
    private Tab[] apTabs = new Tab[3];
    private int[] ap = new int[4];
    private FieldGroup[] depreciationGroups = new FieldGroup[3];
    private CheckBox[] calculateDepreciation = new CheckBox[3];
    private ComboBox[] depreciationMethod = new ComboBox[3];
    private ComboBox[] startPeriodHandlingMethod = new ComboBox[3];
    private FACDecimalField[] degressivePercentage = new FACDecimalField[3];
    private ODBQueryReferenceField[] yearPercentageTableId = new ODBQueryReferenceField[3];
    private ODBQueryReferenceField[] annuityInterestTableId = new ODBQueryReferenceField[3];
    private FACDecimalField[] annuityPercentage = new FACDecimalField[3];
    protected FieldGroup[] depreciationGroups2 = new FieldGroup[3];
    protected NumberField[] depreciatableLife = new NumberField[3];
    protected FACDecimalField[] residualValue = new FACDecimalField[3];
    protected FACDecimalField[] residualPercentage = new FACDecimalField[3];
    protected FACDecimalField[] beyondEconomicLifePercentage = new FACDecimalField[3];
    private FieldGroup[] interestGroups = new FieldGroup[3];
    private CheckBox[] calculateInterest = new CheckBox[3];
    private ComboBox[] interestCalculationMethod = new ComboBox[3];
    private FACDecimalField[] interestPercentage = new FACDecimalField[3];
    private ODBQueryReferenceField[] interestTableId = new ODBQueryReferenceField[3];
    private CalculateDepreciationChangeAction[] calculateDepreciationChangeAction = new CalculateDepreciationChangeAction[3];
    private CalculateInterestChangeAction[] calculateInterestChangeAction = new CalculateInterestChangeAction[3];
    private DepreciationMethodChangeAction[] depreciationMethodChangeAction = new DepreciationMethodChangeAction[3];
    private InterestCalculationMethodChangeAction[] interestCalculationMethodChangeAction = new InterestCalculationMethodChangeAction[3];
    protected Panel[] jtPanels = new Panel[4];
    private int[] jtAp = new int[4];
    private int jteLength = 0;
    private BookYearPeriodGrid[] validFrom = new BookYearPeriodGrid[4];
    private FinancialReferenceField[][] mainAccount = new FinancialReferenceField[4][11];
    protected TabbedPanel mainTabPanel;
    private String[] apTabTexts = new String[3];
    private String[] jtTabTexts = new String[4];
    private int mode = 0;
    private static final int NEW = 0;
    private static final int UPDATE = 1;
    protected int apTabCount = 0;
    protected int apTabCountMax = 0;
    protected int jtTabCount = 0;
    protected int jtTabCountMax = 0;
    private FloatBar[] fbMAS = new FloatBar[3];
    private int currentAccountingPrinciple = 1;

    public AssetTypePanels(LoginHelper loginHelper, DBData dbData, Environment env, Company company, String bookYearMin, String bookYearMax, int numberOfPeriods, boolean governmentActivated, AssetType assetType) throws Exception {
        this.loginHelper = loginHelper;
        this.dbData = dbData;
        this.env = env;
        this.bookYearMin = bookYearMin;
        this.bookYearMax = bookYearMax;
        this.numberOfPeriods = numberOfPeriods;
        this.governmentActivated = governmentActivated;
        this.company = company;
        this.assetType = assetType;
        this.mode = assetType == null ? 0 : 1;
        this.initialize();
    }

    private void initialize() throws Exception {
        this.apTabTexts[0] = this.env.getAPShortName1();
        this.apTabTexts[1] = this.env.getAPShortName2();
        this.apTabTexts[2] = this.env.getAPShortName3();
        this.jtTabTexts[0] = this.env.getAPShortName1();
        this.jtTabTexts[1] = this.env.getAPShortName2();
        this.jtTabTexts[2] = this.env.getAPShortName3();
        this.jtTabTexts[3] = this.env.getAPShortName4();
        this.finTexts[0] = this.env.getName1();
        this.finTexts[1] = this.env.getName2();
        this.finTexts[2] = this.env.getName3();
        this.finTexts[3] = this.env.getName4();
        this.finTexts[4] = this.env.getName5();
        this.initializeCommonForm();
        this.initializeAccountingPrincipleForms();
        if (this.mode == 0) {
            this.getAccountingPrincipleDefaultsFromCompany();
            this.initializeJournalingTermForms();
            this.getMainAccountDefaultsFromCompany();
            this.modifyFieldAttributes();
        } else {
            this.mainTabPanel = new TabbedPanel();
            this.commonTab = new Tab("Label.Common");
            this.commonTab.add(this.financialPanel);
            this.commonTab.add(this.subPanel2);
            this.commonTab.add(this.subPanel);
            this.mainTabActivateAction = new MainTabActivateAction(this.commonTab, this.mainTabPanel);
            this.mainTabPanel.add(this.commonTab, (TabActivateAction)this.mainTabActivateAction);
            this.miscTab = new Tab("Label.OtherDimensionsShort");
            this.miscTab.add(this.dimensionPanel);
            this.mainTabActivateAction = new MainTabActivateAction(this.miscTab, this.mainTabPanel);
            this.mainTabPanel.add(this.miscTab, (TabActivateAction)this.mainTabActivateAction);
            this.apTab = new Tab("Label.Valuation_Short");
            this.apTab.add(this.apTabbedPanel);
            this.mainTabPanel.add(this.apTab, (TabActivateAction)new MainTabActivateAction(this.apTab, this.mainTabPanel));
        }
    }

    protected void initializeCommonForm() throws Exception {
        int i;
        this.mainPanel = new HeaderPanel();
        this.mainPanel.setWidth(620);
        this.id.setLength(10);
        this.id.setMaxLength(10);
        this.id.setMandatory(true);
        this.id.setHelpId("AssetTypeId");
        this.mainPanel.addUIObject((UIObject)this.id);
        this.description.setLength(50);
        this.description.setMaxLength(50);
        this.mainPanel.addUIObject((UIObject)this.description);
        this.financialPanel = new FieldGroup("Label.FinancialDimensions");
        for (i = 0; i < 5; ++i) {
            if (this.finTexts[i].length() == 0) continue;
            this.fins[i] = EnumHelper.createComboBox(this.finTexts[i], GenericUsageEnum.getCollection(), false);
            this.fins[i].setWidth("120");
            this.financialPanel.add(this.fins[i]);
        }
        this.fins[0].setSelectedOptionValue("" + this.company.getFinancialDimension1Usage());
        this.fins[1].setSelectedOptionValue("" + this.company.getFinancialDimension2Usage());
        this.fins[2].setSelectedOptionValue("" + this.company.getFinancialDimension3Usage());
        this.fins[3].setSelectedOptionValue("" + this.company.getFinancialDimension4Usage());
        if (this.fins[4] != null) {
            this.fins[4].setSelectedOptionValue("" + this.company.getFinancialDimension5Usage());
        }
        for (i = 0; i < 5; ++i) {
            if (this.finTexts[i].length() == 0 || this.fins[i].getSelectedOptionValue().equals("1")) continue;
            this.fins[i].setReadonly(true);
        }
        this.subPanel2 = new FieldGroup("Label.AccountingPrinciple_2");
        this.subPanel2.add(this.useAccountingPrinciple2);
        this.subPanel2.add(this.differentAcquisitionValueForAP2);
        this.subPanel = new FieldGroup("Label.Miscellaneous");
        this.category = GovernmentEnumHelper.createComboBox("Label.Category", GovernmentEnumHelper.getCollection(0), false);
        this.categoryChangeAction = new CategoryChangeAction();
        this.category.add((Action)this.categoryChangeAction);
        this.subPanel.add(this.category);
        this.subPanel.add(this.thirdPartyLoan);
        this.subPanel.add(this.limitedDepreciation);
        if (this.company.getProcessParameters().getDepreciateBeyondEconomicLife()) {
            this.depreciateBeyondEconomicLife.setAction((Action)this.depreciateBeyondEconomicLifeChangeAction);
            this.subPanel.add(this.depreciateBeyondEconomicLife);
        }
        this.subPanel.add(this.exclWriteOff);
        if (this.mode != 0) {
            this.subPanel.add(this.notUsed);
        }
        switch (this.company.getAccountingPrinciple2Usage()) {
            case 1: {
                this.useAccountingPrinciple2.setValue(true);
                this.useAccountingPrinciple2.setAction((Action)this.useAccountingPrinciple2ChangeAction);
                this.differentAcquisitionValueForAP2.setValue(false);
                if (this.company.getProcessParameters().getUseDifferentAcquisitionValues()) break;
                this.differentAcquisitionValueForAP2.setHidden(true);
                break;
            }
            case 0: {
                this.useAccountingPrinciple2.setValue(false);
                this.differentAcquisitionValueForAP2.setValue(false);
                this.subPanel2.setHidden(true);
                break;
            }
            case 2: {
                this.useAccountingPrinciple2.setValue(true);
                this.useAccountingPrinciple2.setReadonly(true);
                this.differentAcquisitionValueForAP2.setValue(false);
                if (this.company.getProcessParameters().getUseDifferentAcquisitionValues()) break;
                this.differentAcquisitionValueForAP2.setHidden(true);
            }
        }
        Label[] labs = new Label[10];
        Label blank01 = new Label("&nbsp;");
        Label blank02 = new Label("&nbsp;&nbsp;");
        this.dimensionPanel = new FieldGroup();
        this.dimensionPanel.forceBorder(true);
        this.gridLayout = new ESPGridLayout();
        this.dimensionPanel.add(this.gridLayout);
        this.gridLayout.add((UIObject)new Label("Label.DimensionOrAttribute"), 0, 2);
        this.gridLayout.add((UIObject)new Label("Label.Mandatory.short"), 0, 3);
        this.gridLayout.add((UIObject)new Label("Label.Default"), 0, 5);
        ArrayList agCollection = (ArrayList)new AnalysisGroupQuery(this.dbData, this.company.getId()).fetchData(null, "name", null, 0);
        Iterator iter = agCollection.iterator();
        Option[] options = new Option[agCollection.size() + 1];
        options[0] = new Option("", "0");
        int j = 1;
        while (iter.hasNext()) {
            AnalysisGroup ag = (AnalysisGroup)iter.next();
            options[j] = new Option(ag.getName(), "" + ag.getSeqNr());
            ++j;
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            labs[i2] = new Label("" + (i2 + 1) + ".");
            labs[i2].setHelpId(null);
            this.dims[i2] = new ComboBox("", options);
            this.mans[i2] = new CheckBox("");
            this.acts[i2] = new DimensionComboBoxChangeAction(i2);
            this.dims[i2].add((Action)this.acts[i2]);
            if (i2 >= 6) continue;
            this.gridLayout.add((UIObject)labs[i2], i2 + 1, 0);
            this.gridLayout.add((UIObject)blank01, i2 + 1, 1);
            this.gridLayout.add((UIObject)this.dims[i2], i2 + 1, 2);
            this.gridLayout.add((UIObject)this.mans[i2], i2 + 1, 3);
            this.gridLayout.add((UIObject)blank02, i2 + 1, 4);
        }
    }

    protected void setMASAction(Action action) throws Exception {
        for (int i = 0; i <= this.apTabCountMax; ++i) {
            CompanyAccountingPrincipleDefault capd = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(this.dbData, this.company.getId(), this.ap[i])[0];
            if (capd == null || capd.getJournalingMethod() == 9) continue;
            this.fbMAS[i].addAction(action);
        }
    }

    private void getAccountingPrincipleDefaultsFromCompany() throws Exception {
        for (int i = 0; i <= this.apTabCountMax; ++i) {
            this.getAccountingPrincipleDefaultFromCompany(i);
        }
    }

    private void getAccountingPrincipleDefaultFromCompany(int i) throws Exception {
        CompanyAccountingPrincipleDefault companyAccountingPrincipleDefault = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(this.dbData, this.company.getId(), this.ap[i])[0];
        if (companyAccountingPrincipleDefault != null) {
            this.calculateDepreciation[i].setValue(companyAccountingPrincipleDefault.getCalculateDepreciation());
            this.depreciationMethod[i].setSelectedOptionValue("" + companyAccountingPrincipleDefault.getDepreciationMethod());
            this.yearPercentageTableId[i].setValue(companyAccountingPrincipleDefault.getYearPercentageTableId());
            YearPercentageTable yearPercentageTable = companyAccountingPrincipleDefault.getYearPercentageTable();
            if (yearPercentageTable != null) {
                this.yearPercentageTableId[i].setDescription(yearPercentageTable.getDescription());
            }
            this.degressivePercentage[i].setValue(companyAccountingPrincipleDefault.getDegressivePercentage());
            this.annuityPercentage[i].setValue(companyAccountingPrincipleDefault.getAnnuityPercentage());
            this.annuityInterestTableId[i].setValue(companyAccountingPrincipleDefault.getAnnuityInterestTableId());
            InterestTable interestTable = companyAccountingPrincipleDefault.getAnnuityInterestTable();
            if (interestTable != null) {
                this.annuityInterestTableId[i].setDescription(interestTable.getDescription());
            }
            this.startPeriodHandlingMethod[i].setSelectedOptionValue("" + companyAccountingPrincipleDefault.getStartPeriodHandlingMethod());
            this.calculateInterest[i].setValue(companyAccountingPrincipleDefault.getCalculateInterest());
            this.interestCalculationMethod[i].setSelectedOptionValue("" + companyAccountingPrincipleDefault.getInterestCalculationMethod());
            this.interestTableId[i].setValue(companyAccountingPrincipleDefault.getInterestTableId());
            interestTable = companyAccountingPrincipleDefault.getInterestTable();
            if (interestTable != null) {
                this.interestTableId[i].setDescription(interestTable.getDescription());
            }
            this.interestPercentage[i].setValue(companyAccountingPrincipleDefault.getInterestPercentage());
        }
    }

    private void getMainAccountDefaultsFromCompany() throws Exception {
        for (int i = 0; i <= this.jtTabCountMax; ++i) {
            this.getMainAccountDefaultFromCompany(i);
        }
    }

    private void getMainAccountDefaultFromCompany(int i) throws Exception {
        CompanyAccountingPrincipleDefault companyAccountingPrincipleDefault = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(this.dbData, this.company.getId(), this.jtAp[i])[0];
        if (companyAccountingPrincipleDefault != null) {
            this.mainAccount[i][0].setValue(companyAccountingPrincipleDefault.getMainAccountId1());
            this.mainAccount[i][1].setValue(companyAccountingPrincipleDefault.getMainAccountId2());
            this.mainAccount[i][2].setValue(companyAccountingPrincipleDefault.getMainAccountId3());
            this.mainAccount[i][3].setValue(companyAccountingPrincipleDefault.getMainAccountId4());
            this.mainAccount[i][4].setValue(companyAccountingPrincipleDefault.getMainAccountId5());
            this.mainAccount[i][5].setValue(companyAccountingPrincipleDefault.getMainAccountId6());
            this.mainAccount[i][6].setValue(companyAccountingPrincipleDefault.getMainAccountId7());
            this.mainAccount[i][7].setValue(companyAccountingPrincipleDefault.getMainAccountId8());
            this.mainAccount[i][8].setValue(companyAccountingPrincipleDefault.getMainAccountId9());
        }
    }

    private void initializeAccountingPrincipleForms() throws Exception {
        this.apTabCount = 0;
        this.apTabbedPanel = new TabbedPanel();
        this.initializeAccountingPrincipleForm(0, 1);
        this.apTabCountMax = 0;
        if (this.mode == 1 || this.useAccountingPrinciple2.isChecked()) {
            this.initializeAccountingPrincipleForm(++this.apTabCountMax, 2);
        }
        if (this.governmentActivated) {
            // empty if block
        }
    }

    private void initializeAccountingPrincipleForm(int tabNumber, int accountingPrinciple) throws Exception {
        if (this.mode == 0) {
            this.apPanels[tabNumber] = new Panel();
        } else {
            this.apTabs[tabNumber] = new Tab(this.apTabTexts[accountingPrinciple - 1]);
            this.apTabbedPanel.add(this.apTabs[tabNumber], (TabActivateAction)new APTabActivateAction(this.apTabs[tabNumber], this.apTabbedPanel));
        }
        this.depreciationGroups[tabNumber] = new FieldGroup("Label.Depreciations");
        this.ap[tabNumber] = accountingPrinciple;
        this.calculateDepreciation[tabNumber] = new CheckBox("Label.CalculateDepreciations", true);
        this.calculateDepreciationChangeAction[tabNumber] = new CalculateDepreciationChangeAction(tabNumber);
        this.calculateDepreciation[tabNumber].setAction((Action)this.calculateDepreciationChangeAction[tabNumber]);
        this.depreciationGroups[tabNumber].add(this.calculateDepreciation[tabNumber]);
        this.depreciationMethod[tabNumber] = EnumHelper.createComboBox("Label.DepreciationMethod", DepreciationMethodEnum.getCollection(), false);
        this.depreciationMethod[tabNumber].setWidth("225");
        this.depreciationMethodChangeAction[tabNumber] = new DepreciationMethodChangeAction(tabNumber);
        this.depreciationMethod[tabNumber].add((Action)this.depreciationMethodChangeAction[tabNumber]);
        this.depreciationGroups[tabNumber].add(this.depreciationMethod[tabNumber]);
        this.yearPercentageTableId[tabNumber] = new YearPercentageTableReferenceField(this.dbData);
        this.depreciationGroups[tabNumber].add((Field)this.yearPercentageTableId[tabNumber]);
        this.degressivePercentage[tabNumber] = new FACDecimalField("Label.Percentage", 5, 2);
        this.degressivePercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.degressivePercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.depreciationGroups[tabNumber].add((Field)this.degressivePercentage[tabNumber]);
        this.annuityInterestTableId[tabNumber] = new InterestTableReferenceField(this.dbData, this.numberOfPeriods);
        this.depreciationGroups[tabNumber].add((Field)this.annuityInterestTableId[tabNumber]);
        this.annuityPercentage[tabNumber] = new FACDecimalField("Label.Percentage", 6, 3);
        this.annuityPercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.annuityPercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.depreciationGroups[tabNumber].add((Field)this.annuityPercentage[tabNumber]);
        this.startPeriodHandlingMethod[tabNumber] = EnumHelper.createComboBox("Label.StartPeriodHandlingPolicy", StartPeriodHandlingEnum.getCollection(), false);
        this.startPeriodHandlingMethod[tabNumber].setWidth("225");
        this.depreciationGroups[tabNumber].add(this.startPeriodHandlingMethod[tabNumber]);
        this.addFieldGroupAP(this.depreciationGroups[tabNumber], tabNumber);
        this.depreciationGroups2[tabNumber] = new FieldGroup("Label.MiscDeprAttributes");
        this.depreciatableLife[tabNumber] = new NumberField("Label.DepreciationLife", 5, true);
        this.depreciatableLife[tabNumber].setMinValue(new BigInteger("0"), true);
        this.depreciationGroups2[tabNumber].add((Field)this.depreciatableLife[tabNumber]);
        this.residualPercentage[tabNumber] = new FACDecimalField("Label.ResidualValuePercentage", 5, 2);
        this.residualPercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.residualPercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.depreciationGroups2[tabNumber].add((Field)this.residualPercentage[tabNumber]);
        this.residualValue[tabNumber] = new FACDecimalField("Label.ResidualValueAmount", 15, 2);
        this.depreciationGroups2[tabNumber].add((Field)this.residualValue[tabNumber]);
        this.beyondEconomicLifePercentage[tabNumber] = new FACDecimalField("Label.BeyondEconomicLifePercentage", 5, 2);
        this.beyondEconomicLifePercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.beyondEconomicLifePercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.beyondEconomicLifePercentage[tabNumber].setValue(new BigDecimal("0.00"));
        this.beyondEconomicLifePercentage[tabNumber].setHidden(true);
        this.depreciationGroups2[tabNumber].add((Field)this.beyondEconomicLifePercentage[tabNumber]);
        this.addFieldGroupAP(this.depreciationGroups2[tabNumber], tabNumber);
        this.interestGroups[tabNumber] = new FieldGroup("Label.Interest");
        this.calculateInterest[tabNumber] = new CheckBox("Label.CalculateInterest", true);
        this.calculateInterestChangeAction[tabNumber] = new CalculateInterestChangeAction(tabNumber);
        this.calculateInterest[tabNumber].setAction((Action)this.calculateInterestChangeAction[tabNumber]);
        this.interestGroups[tabNumber].add(this.calculateInterest[tabNumber]);
        this.interestCalculationMethod[tabNumber] = EnumHelper.createComboBox("Label.InterestCalculationMethod", InterestCalculationMethodEnum.getCollection(), false);
        this.interestCalculationMethod[tabNumber].setWidth("225");
        this.interestCalculationMethodChangeAction[tabNumber] = new InterestCalculationMethodChangeAction(tabNumber);
        this.interestCalculationMethod[tabNumber].add((Action)this.interestCalculationMethodChangeAction[tabNumber]);
        this.interestGroups[tabNumber].add(this.interestCalculationMethod[tabNumber]);
        this.interestTableId[tabNumber] = new InterestTableReferenceField(this.dbData, this.numberOfPeriods);
        this.interestGroups[tabNumber].add((Field)this.interestTableId[tabNumber]);
        this.interestPercentage[tabNumber] = new FACDecimalField("Label.Percentage", 6, 3);
        this.interestPercentage[tabNumber].setLength(6);
        this.interestPercentage[tabNumber].setMaxLength(6);
        this.interestPercentage[tabNumber].setMaxFractionDigits(3);
        this.interestPercentage[tabNumber].setMaxIntegerDigits(3);
        this.interestPercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.interestPercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.interestGroups[tabNumber].add((Field)this.interestPercentage[tabNumber]);
        this.addFieldGroupAP(this.interestGroups[tabNumber], tabNumber);
        if (this.mode == 1) {
            this.fbMAS[tabNumber] = new FloatBar();
            this.fbMAS[tabNumber].alignment(1);
            this.apTabs[tabNumber].add(this.fbMAS[tabNumber]);
        }
    }

    private void addFieldGroupAP(FieldGroup fieldGroup, int tabNumber) throws Exception {
        if (this.mode == 0) {
            this.apPanels[tabNumber].addUIObject((UIObject)fieldGroup);
        } else {
            this.apTabs[tabNumber].add(fieldGroup);
        }
    }

    protected void initializeJournalingTermForms() throws Exception {
        this.jtTabCount = 0;
        this.jtTabCountMax = -1;
        this.initializeJournalingTermForm(1);
        if (this.mode == 1 || this.useAccountingPrinciple2.isChecked()) {
            this.initializeJournalingTermForm(2);
        }
        if (this.governmentActivated) {
            // empty if block
        }
    }

    private void initializeJournalingTermForm(int accountingPrinciple) throws Exception {
        CompanyAccountingPrincipleDefault capd = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(this.dbData, this.company.getId(), accountingPrinciple)[0];
        if (capd != null && capd.getJournalingMethod() == 9) {
            return;
        }
        ++this.jtTabCountMax;
        int tabNumber = this.jtTabCountMax;
        this.jtPanels[tabNumber] = new Panel();
        FieldGroup mainAccountScheme = new FieldGroup("Label.MainAccountScheme");
        this.validFrom[tabNumber] = new BookYearPeriodGrid("Label.ValidFrom", "" + this.company.getCurrentBookYear(), this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.validFrom[tabNumber].getPeriod().setValue(1L);
        mainAccountScheme.add((ESPGridLayout)this.validFrom[tabNumber]);
        FieldGroup fieldGroup = new FieldGroup("Label.MainAccounts");
        this.jtAp[tabNumber] = accountingPrinciple;
        Object[] jte = JournalingsTermEnum.getCollection().toArray();
        this.jteLength = jte.length;
        for (int i = 0; i < this.jteLength; ++i) {
            NameValuePair pair = (NameValuePair)jte[i];
            this.mainAccount[tabNumber][i] = this.env.getOperationArea().length() == 0 ? new FISReferenceField(this.loginHelper, pair.getValue(), 0, this.company.getId(), "" + this.company.getCurrentBookYear(), true) : new FMSReferenceField(this.loginHelper, pair.getValue(), 0, true);
            if (this.governmentActivated && i == 8) {
                this.mainAccount[tabNumber][i].setHidden(true);
            }
            if (!(i != 9 && i != 10 || this.company.getProcessParameters().getDepreciateBeyondEconomicLife())) {
                this.mainAccount[tabNumber][i].setHidden(true);
            }
            fieldGroup.add((Field)this.mainAccount[tabNumber][i]);
        }
        this.jtPanels[tabNumber].addUIObject((UIObject)mainAccountScheme);
        this.jtPanels[tabNumber].addUIObject((UIObject)fieldGroup);
    }

    protected void setValues() throws Exception {
        this.id.setValue(this.assetType.getId());
        this.id.setReadonly(true);
        this.description.setValue(this.assetType.getDescription().trim());
        this.category.setSelectedOptionValue("" + this.assetType.getCategory());
        this.thirdPartyLoan.setValue(this.assetType.getIs3rdPartyLoan());
        this.limitedDepreciation.setValue(this.assetType.getLimitedDepreciation());
        this.depreciateBeyondEconomicLife.setValue(false);
        this.depreciateBeyondEconomicLife.setValue(this.assetType.getDepreciateBeyondEconomicLife());
        this.exclWriteOff.setValue(this.assetType.getExclWriteOff());
        this.differentAcquisitionValueForAP2.setValue(this.assetType.getUseDifferentAcquisitionValues());
        this.notUsed.setValue(this.assetType.getNotUsed());
        this.useAccountingPrinciple2.setValue(this.assetType.getAccountingPrinciple2IsUsed());
        this.useAccountingPrinciple2.setReadonly(AssetBO.hasAssets(this.assetType));
        this.fins[0].setSelectedOptionValue("" + this.assetType.getFinancialDimension1Usage());
        this.fins[1].setSelectedOptionValue("" + this.assetType.getFinancialDimension2Usage());
        this.fins[2].setSelectedOptionValue("" + this.assetType.getFinancialDimension3Usage());
        this.fins[3].setSelectedOptionValue("" + this.assetType.getFinancialDimension4Usage());
        if (this.fins[4] != null) {
            this.fins[4].setSelectedOptionValue("" + this.assetType.getFinancialDimension5Usage());
        }
        this.dims[0].setSelectedOptionValue(this.assetType.getSeqNr1() == null ? "0" : "" + this.assetType.getSeqNr1());
        this.dims[1].setSelectedOptionValue(this.assetType.getSeqNr2() == null ? "0" : "" + this.assetType.getSeqNr2());
        this.dims[2].setSelectedOptionValue(this.assetType.getSeqNr3() == null ? "0" : "" + this.assetType.getSeqNr3());
        this.dims[3].setSelectedOptionValue(this.assetType.getSeqNr4() == null ? "0" : "" + this.assetType.getSeqNr4());
        this.dims[4].setSelectedOptionValue(this.assetType.getSeqNr5() == null ? "0" : "" + this.assetType.getSeqNr5());
        this.dims[5].setSelectedOptionValue(this.assetType.getSeqNr6() == null ? "0" : "" + this.assetType.getSeqNr6());
        this.dims[6].setSelectedOptionValue(this.assetType.getSeqNr7() == null ? "0" : "" + this.assetType.getSeqNr7());
        this.dims[7].setSelectedOptionValue(this.assetType.getSeqNr8() == null ? "0" : "" + this.assetType.getSeqNr8());
        this.dims[8].setSelectedOptionValue(this.assetType.getSeqNr9() == null ? "0" : "" + this.assetType.getSeqNr9());
        this.dims[9].setSelectedOptionValue(this.assetType.getSeqNr10() == null ? "0" : "" + this.assetType.getSeqNr10());
        this.mans[0].setValue(this.assetType.getSeqNr1Mandatory());
        this.mans[1].setValue(this.assetType.getSeqNr2Mandatory());
        this.mans[2].setValue(this.assetType.getSeqNr3Mandatory());
        this.mans[3].setValue(this.assetType.getSeqNr4Mandatory());
        this.mans[4].setValue(this.assetType.getSeqNr5Mandatory());
        this.mans[5].setValue(this.assetType.getSeqNr6Mandatory());
        this.mans[6].setValue(this.assetType.getSeqNr7Mandatory());
        this.mans[7].setValue(this.assetType.getSeqNr8Mandatory());
        this.mans[8].setValue(this.assetType.getSeqNr9Mandatory());
        this.mans[9].setValue(this.assetType.getSeqNr10Mandatory());
        for (int i = 0; i <= this.apTabCountMax; ++i) {
            this.accountingPrincipleDefault[i] = (AssetTypeAccountingPrincipleDefault)AssetTypeAccountingPrincipleDefaultBO.get(this.dbData, this.company.getId(), this.assetType.getId(), this.ap[i])[0];
            if (this.accountingPrincipleDefault[i] == null) {
                this.getAccountingPrincipleDefaultFromCompany(i);
                continue;
            }
            this.calculateDepreciation[i].setValue(this.accountingPrincipleDefault[i].getCalculateDepreciation());
            this.depreciationMethod[i].setSelectedOptionValue("" + this.accountingPrincipleDefault[i].getDepreciationMethod());
            this.yearPercentageTableId[i].setValue(this.accountingPrincipleDefault[i].getYearPercentageTableId());
            YearPercentageTable yearPercentageTable = this.accountingPrincipleDefault[i].getYearPercentageTable();
            if (yearPercentageTable != null) {
                this.yearPercentageTableId[i].setDescription(yearPercentageTable.getDescription());
            }
            this.degressivePercentage[i].setValue(this.accountingPrincipleDefault[i].getDegressivePercentage());
            this.annuityPercentage[i].setValue(this.accountingPrincipleDefault[i].getAnnuityPercentage());
            this.annuityInterestTableId[i].setValue(this.accountingPrincipleDefault[i].getAnnuityInterestTableId());
            InterestTable interestTable = this.accountingPrincipleDefault[i].getAnnuityInterestTable();
            if (interestTable != null) {
                this.annuityInterestTableId[i].setDescription(interestTable.getDescription());
            }
            this.startPeriodHandlingMethod[i].setSelectedOptionValue("" + this.accountingPrincipleDefault[i].getStartPeriodHandlingMethod());
            this.depreciatableLife[i].setValue((long)this.accountingPrincipleDefault[i].getDepreciatableLife());
            this.residualValue[i].setValue(this.accountingPrincipleDefault[i].getResidualValue());
            this.residualPercentage[i].setValue(this.accountingPrincipleDefault[i].getResidualPercentage());
            this.beyondEconomicLifePercentage[i].setValue(this.accountingPrincipleDefault[i].getBeyondEconomicLifePercentage());
            this.calculateInterest[i].setValue(this.accountingPrincipleDefault[i].getCalculateInterest());
            this.interestCalculationMethod[i].setSelectedOptionValue("" + this.accountingPrincipleDefault[i].getInterestCalculationMethod());
            this.interestTableId[i].setValue(this.accountingPrincipleDefault[i].getInterestTableId());
            interestTable = this.accountingPrincipleDefault[i].getInterestTable();
            if (interestTable != null) {
                this.interestTableId[i].setDescription(interestTable.getDescription());
            }
            this.interestPercentage[i].setValue(this.accountingPrincipleDefault[i].getInterestPercentage());
        }
        this.modifyFieldAttributes();
        if (this.dfts[0] != null) {
            this.dfts[0].setValue(!"0".equals(this.dims[0].getSelectedOptionValue()) ? this.assetType.getDefaultAnalysisCode1() : "");
            this.dfts[0].validate();
        }
        if (this.dfts[1] != null) {
            this.dfts[1].setValue(!"0".equals(this.dims[1].getSelectedOptionValue()) ? this.assetType.getDefaultAnalysisCode2() : "");
            this.dfts[1].validate();
        }
        if (this.dfts[2] != null) {
            this.dfts[2].setValue(!"0".equals(this.dims[2].getSelectedOptionValue()) ? this.assetType.getDefaultAnalysisCode3() : "");
            this.dfts[2].validate();
        }
        if (this.dfts[3] != null) {
            this.dfts[3].setValue(!"0".equals(this.dims[3].getSelectedOptionValue()) ? this.assetType.getDefaultAnalysisCode4() : "");
            this.dfts[3].validate();
        }
        if (this.dfts[4] != null) {
            this.dfts[4].setValue(!"0".equals(this.dims[4].getSelectedOptionValue()) ? this.assetType.getDefaultAnalysisCode5() : "");
            this.dfts[4].validate();
        }
        if (this.dfts[5] != null) {
            this.dfts[5].setValue(!"0".equals(this.dims[5].getSelectedOptionValue()) ? this.assetType.getDefaultAnalysisCode6() : "");
            this.dfts[5].validate();
        }
    }

    private void modifyFieldAttributes() throws Exception {
        int i;
        this.categoryChangeAction.execute(null);
        for (i = 0; i < 10; ++i) {
            this.acts[i].execute(null);
        }
        if (this.mode == 1) {
            this.depreciateBeyondEconomicLifeChangeAction.execute(null);
            this.useAccountingPrinciple2ChangeAction.execute(null);
        }
        for (i = 0; i <= this.apTabCountMax; ++i) {
            this.calculateDepreciationChangeAction[i].execute(null);
            this.calculateInterestChangeAction[i].execute(null);
            this.depreciationMethodChangeAction[i].execute(null);
            this.interestCalculationMethodChangeAction[i].execute(null);
        }
    }

    protected String validateAccountingPrincipleForm(int tabNumber) throws Exception {
        Object[] result;
        String message;
        Object[] result2;
        String message2;
        if (this.mode == 0) {
            this.apPanels[tabNumber].removeInvalidTags();
            this.apPanels[tabNumber].validateAll();
        } else {
            if (this.apTabs[tabNumber].isHidden()) {
                return null;
            }
            this.apTabs[tabNumber].removeInvalidTags();
            this.apTabs[tabNumber].validateAll();
        }
        String id = this.yearPercentageTableId[tabNumber].getValue().trim();
        if (id.length() > 0 && (message2 = (String)(result2 = YearPercentageTableBO.get(this.dbData, id))[1]) != null) {
            this.yearPercentageTableId[tabNumber].setInvalidTag();
            return message2;
        }
        if (!"0".equals(this.interestCalculationMethod[tabNumber].getValue())) {
            boolean precentageFilled;
            id = this.interestTableId[tabNumber].getValue().trim();
            boolean idFilled = id.length() > 0;
            boolean bl = precentageFilled = this.interestPercentage[tabNumber].getDoubleValue() > 0.0;
            if (idFilled && precentageFilled) {
                this.interestTableId[tabNumber].setInvalidTag();
                this.interestPercentage[tabNumber].setInvalidTag();
                return "provide_only_one_value";
            }
            if (idFilled && (message = (String)(result = InterestTableBO.get(this.dbData, id, this.numberOfPeriods))[1]) != null) {
                this.interestTableId[tabNumber].setInvalidTag();
                return message;
            }
        }
        if ("2".equals(this.depreciationMethod[tabNumber].getValue()) && this.degressivePercentage[tabNumber].getDoubleValue() == 0.0) {
            this.degressivePercentage[tabNumber].setInvalidTag();
            return "value_must_be_positive";
        }
        if ("11".equals(this.depreciationMethod[tabNumber].getValue())) {
            boolean precentageFilled;
            id = this.annuityInterestTableId[tabNumber].getValue().trim();
            boolean idFilled = id.length() > 0;
            boolean bl = precentageFilled = this.annuityPercentage[tabNumber].getDoubleValue() > 0.0;
            if (idFilled && precentageFilled) {
                this.annuityInterestTableId[tabNumber].setInvalidTag();
                this.annuityPercentage[tabNumber].setInvalidTag();
                return "provide_only_one_value";
            }
            if (idFilled && (message = (String)(result = InterestTableBO.get(this.dbData, id, this.numberOfPeriods))[1]) != null) {
                this.annuityInterestTableId[tabNumber].setInvalidTag();
                return message;
            }
        }
        if (this.residualValue[tabNumber].getDoubleValue() > 0.0 && this.residualPercentage[tabNumber].getDoubleValue() > 0.0) {
            this.residualValue[tabNumber].setInvalidTag();
            this.residualPercentage[tabNumber].setInvalidTag();
            return "provide_only_one_value";
        }
        return null;
    }

    private void validateJournalingTermForm(int tabNumber) throws Exception {
        int i;
        for (i = 0; i < this.jteLength; ++i) {
            this.mainAccount[tabNumber][i].removeInvalidTag();
        }
        for (i = 0; i < this.jteLength; ++i) {
            this.mainAccount[tabNumber][i].validate();
        }
    }

    private String validateAll() throws Exception {
        String message = this.validateFacDims();
        if (message != null) {
            this.mainTabPanel.setActiveTabByName("Label.Common");
            return message;
        }
        for (int i = 0; i <= this.apTabCountMax; ++i) {
            message = this.validateAccountingPrincipleForm(i);
            if (message == null) continue;
            this.mainTabPanel.setActiveTabByName("Label.Valuation_Short");
            this.apTabbedPanel.setActiveTab(this.apTabs[i]);
            return message;
        }
        return null;
    }

    protected String validateFacDims() throws Exception {
        HashSet<String> set = new HashSet<String>(10);
        for (int i = 0; i < 10; ++i) {
            if (this.dims[i].getSelectedOptionValue().equals("0")) continue;
            if (set.contains(this.dims[i].getSelectedOptionValue())) {
                this.dims[i].setInvalidTag();
                return "duplicate_key";
            }
            set.add(this.dims[i].getSelectedOptionValue());
        }
        return null;
    }

    protected Object[] create() throws Exception {
        String message;
        int i;
        int[] usageFinDims = new int[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            if (this.fins[i2] == null) continue;
            usageFinDims[i2] = Integer.parseInt(this.fins[i2].getValue());
        }
        int j = 0;
        int[] seqNr = new int[10];
        boolean[] seqNrMandatory = new boolean[10];
        String[] defaults = new String[10];
        for (int i3 = 0; i3 < 10; ++i3) {
            defaults[i3] = "";
            if (this.dims[i3].getSelectedOptionValue().equals("0")) continue;
            seqNr[j] = Integer.parseInt(this.dims[i3].getSelectedOptionValue());
            seqNrMandatory[j] = this.mans[i3].isChecked();
            if (this.dfts[i3] != null) {
                defaults[j] = this.dfts[i3].getValue();
            }
            ++j;
        }
        Object[] result = AssetTypeBO.create(this.dbData, this.company.getId(), this.id.getValue().trim(), this.description.getValue().trim(), Integer.parseInt(this.category.getSelectedOptionValue()), this.thirdPartyLoan.isChecked(), this.limitedDepreciation.isChecked(), this.exclWriteOff.isChecked(), this.differentAcquisitionValueForAP2.isChecked(), this.useAccountingPrinciple2.isChecked(), usageFinDims, seqNr, seqNrMandatory, defaults, this.depreciateBeyondEconomicLife.isChecked());
        if (result[1] != null) {
            return result;
        }
        this.assetType = (AssetType)result[0];
        for (i = 0; i <= this.apTabCountMax; ++i) {
            message = this.saveAccountingPrincipleDefault(i);
            if (message == null) continue;
            result[1] = message;
            return result;
        }
        for (i = 0; i <= this.jtTabCountMax; ++i) {
            message = this.saveMainAccounts(i);
            if (message == null) continue;
            result[1] = message;
            return result;
        }
        return result;
    }

    protected String update() throws Exception {
        int i;
        String message = this.validateAll();
        if (message != null) {
            return message;
        }
        int[] usageFinDim = new int[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            if (this.fins[i2] == null) continue;
            usageFinDim[i2] = Integer.parseInt(this.fins[i2].getValue());
        }
        int j = 0;
        int[] seqNr = new int[10];
        boolean[] seqNrMandatory = new boolean[10];
        String[] defaults = new String[10];
        for (i = 0; i < 10; ++i) {
            defaults[i] = "";
            if (this.dims[i].getSelectedOptionValue().equals("0")) continue;
            seqNr[j] = Integer.parseInt(this.dims[i].getSelectedOptionValue());
            seqNrMandatory[j] = this.mans[i].isChecked();
            if (this.dfts[i] != null) {
                defaults[j] = this.dfts[i].getValue();
            }
            ++j;
        }
        message = AssetTypeBO.update(this.assetType, this.description.getValue().trim(), Integer.parseInt(this.category.getSelectedOptionValue()), this.thirdPartyLoan.isChecked(), this.notUsed.isChecked(), this.limitedDepreciation.isChecked(), this.exclWriteOff.isChecked(), this.differentAcquisitionValueForAP2.isChecked(), this.useAccountingPrinciple2.isChecked(), usageFinDim, seqNr, seqNrMandatory, defaults, this.depreciateBeyondEconomicLife.isChecked());
        if (message != null) {
            return message;
        }
        for (i = 0; i <= this.apTabCountMax; ++i) {
            message = this.saveAccountingPrincipleDefault(i);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    private String saveAccountingPrincipleDefault(int i) throws Exception {
        String message = null;
        if (this.accountingPrincipleDefault[i] != null) {
            message = this.ap[i] != 2 || this.useAccountingPrinciple2.getValueAsBoolean() ? AssetTypeAccountingPrincipleDefaultBO.update(this.dbData, this.accountingPrincipleDefault[i], this.calculateDepreciation[i].getValueAsBoolean(), Integer.parseInt(this.depreciationMethod[i].getValue()), this.yearPercentageTableId[i].getValue(), this.degressivePercentage[i].getBigDecimal(), this.annuityInterestTableId[i].getValue(), this.annuityPercentage[i].getBigDecimal(), Integer.parseInt(this.startPeriodHandlingMethod[i].getValue()), this.depreciatableLife[i].getIntValue(), this.residualValue[i].getBigDecimal(), this.residualPercentage[i].getBigDecimal(), this.calculateInterest[i].getValueAsBoolean(), Integer.parseInt(this.interestCalculationMethod[i].getValue()), this.interestTableId[i].getValue(), this.numberOfPeriods, this.interestPercentage[i].getBigDecimal(), this.beyondEconomicLifePercentage[i].getBigDecimal()) : AssetTypeAccountingPrincipleDefaultBO.delete(this.accountingPrincipleDefault[i]);
        } else if (this.ap[i] != 2 || this.useAccountingPrinciple2.getValueAsBoolean()) {
            Object[] result = null;
            result = AssetTypeAccountingPrincipleDefaultBO.create(this.dbData, this.company.getId(), this.id.getValue(), this.ap[i], this.calculateDepreciation[i].getValueAsBoolean(), Integer.parseInt(this.depreciationMethod[i].getValue()), this.yearPercentageTableId[i].getValue(), this.degressivePercentage[i].getBigDecimal(), this.annuityInterestTableId[i].getValue(), this.annuityPercentage[i].getBigDecimal(), Integer.parseInt(this.startPeriodHandlingMethod[i].getValue()), this.depreciatableLife[i].getIntValue(), this.residualValue[i].getBigDecimal(), this.residualPercentage[i].getBigDecimal(), this.calculateInterest[i].getValueAsBoolean(), Integer.parseInt(this.interestCalculationMethod[i].getValue()), this.interestTableId[i].getValue(), this.interestPercentage[i].getBigDecimal(), this.beyondEconomicLifePercentage[i].getBigDecimal());
            this.accountingPrincipleDefault[i] = (AssetTypeAccountingPrincipleDefault)result[0];
            message = (String)result[1];
        }
        return message;
    }

    private String saveMainAccounts(int i) throws Exception {
        String message = null;
        Object[] result = MainAccountSchemeBO.create(this.dbData, this.company.getId(), this.assetType.getId(), this.jtAp[i], Integer.parseInt(this.validFrom[i].getBookYear().getValue()), Integer.parseInt(this.validFrom[i].getPeriod().getValue()), this.mainAccount[i][0].getFormattedId(), this.mainAccount[i][1].getFormattedId(), this.mainAccount[i][2].getFormattedId(), this.mainAccount[i][3].getFormattedId(), this.mainAccount[i][4].getFormattedId(), this.mainAccount[i][5].getFormattedId(), this.mainAccount[i][6].getFormattedId(), this.mainAccount[i][7].getFormattedId(), this.mainAccount[i][8].getFormattedId(), this.mainAccount[i][9].getFormattedId(), this.mainAccount[i][10].getFormattedId());
        message = (String)result[1];
        return message;
    }

    protected String getAccountingPrincipleTabText() {
        return this.apTabTexts[this.ap[this.apTabCount] - 1];
    }

    protected String getJournalingTermTabText() {
        return this.jtTabTexts[this.jtAp[this.jtTabCount] - 1];
    }

    protected int getCurrentAccountingPrinciple() {
        return this.currentAccountingPrinciple;
    }

    private class DepreciateBeyondEconomicLifeChangeAction
    extends Action {
        private static final long serialVersionUID = -7354964461687524935L;

        public boolean execute(DataObject dataObject) throws Exception {
            if (AssetTypePanels.this.depreciateBeyondEconomicLife.isChecked()) {
                AssetTypePanels.this.beyondEconomicLifePercentage[0].setHidden(false);
                if (AssetTypePanels.this.beyondEconomicLifePercentage[1] != null) {
                    AssetTypePanels.this.beyondEconomicLifePercentage[1].setHidden(false);
                }
            } else {
                AssetTypePanels.this.beyondEconomicLifePercentage[0].setValue(new BigDecimal("0.00"));
                AssetTypePanels.this.beyondEconomicLifePercentage[0].setHidden(true);
                if (AssetTypePanels.this.beyondEconomicLifePercentage[1] != null) {
                    AssetTypePanels.this.beyondEconomicLifePercentage[1].setValue(new BigDecimal("0.00"));
                    AssetTypePanels.this.beyondEconomicLifePercentage[1].setHidden(true);
                }
            }
            return true;
        }
    }

    private class CategoryChangeAction
    extends Action {
        private static final long serialVersionUID = 4520510526472107877L;

        public boolean execute(DataObject dataObject) throws Exception {
            if ("3".equals(AssetTypePanels.this.category.getValue())) {
                AssetTypePanels.this.thirdPartyLoan.setHidden(false);
            } else {
                AssetTypePanels.this.thirdPartyLoan.setValue(false);
                AssetTypePanels.this.thirdPartyLoan.setHidden(true);
            }
            return true;
        }
    }

    private class InterestCalculationMethodChangeAction
    extends Action {
        private static final long serialVersionUID = -4099934352056207581L;
        private int tabNumber;

        public InterestCalculationMethodChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if ("0".equals(AssetTypePanels.this.interestCalculationMethod[this.tabNumber].getValue())) {
                AssetTypePanels.this.interestTableId[this.tabNumber].setHidden(true);
                AssetTypePanels.this.interestTableId[this.tabNumber].setValue();
                AssetTypePanels.this.interestPercentage[this.tabNumber].setHidden(true);
                AssetTypePanels.this.interestPercentage[this.tabNumber].setValue();
                return true;
            }
            AssetTypePanels.this.interestTableId[this.tabNumber].setHidden(false);
            AssetTypePanels.this.interestPercentage[this.tabNumber].setHidden(false);
            return true;
        }
    }

    private class CalculateInterestChangeAction
    extends Action {
        private static final long serialVersionUID = 3562045469454924093L;
        private int tabNumber = 0;

        public CalculateInterestChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if (AssetTypePanels.this.calculateInterest[this.tabNumber].getValueAsBoolean()) {
                AssetTypePanels.this.interestCalculationMethod[this.tabNumber].setHidden(false);
                return true;
            }
            AssetTypePanels.this.interestCalculationMethod[this.tabNumber].setHidden(true);
            AssetTypePanels.this.interestCalculationMethod[this.tabNumber].setValueAsString("0");
            AssetTypePanels.this.interestTableId[this.tabNumber].setHidden(true);
            AssetTypePanels.this.interestTableId[this.tabNumber].setValue();
            AssetTypePanels.this.interestPercentage[this.tabNumber].setHidden(true);
            AssetTypePanels.this.interestPercentage[this.tabNumber].setValue();
            return true;
        }
    }

    private class DepreciationMethodChangeAction
    extends Action {
        private static final long serialVersionUID = -7988927228620312875L;
        private int tabNumber;

        public DepreciationMethodChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            AssetTypePanels.this.startPeriodHandlingMethod[this.tabNumber].setReadonly(false);
            AssetTypePanels.this.interestCalculationMethod[this.tabNumber].setReadonly(false);
            if ("3".equals(AssetTypePanels.this.depreciationMethod[this.tabNumber].getValue())) {
                AssetTypePanels.this.yearPercentageTableId[this.tabNumber].setMandatory(true);
                AssetTypePanels.this.yearPercentageTableId[this.tabNumber].setHidden(false);
                AssetTypePanels.this.degressivePercentage[this.tabNumber].setMandatory(false);
                AssetTypePanels.this.degressivePercentage[this.tabNumber].setHidden(true);
                AssetTypePanels.this.degressivePercentage[this.tabNumber].setValue();
                AssetTypePanels.this.annuityPercentage[this.tabNumber].setMandatory(false);
                AssetTypePanels.this.annuityPercentage[this.tabNumber].setHidden(true);
                AssetTypePanels.this.annuityPercentage[this.tabNumber].setValue();
                AssetTypePanels.this.annuityInterestTableId[this.tabNumber].setMandatory(false);
                AssetTypePanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
                AssetTypePanels.this.annuityInterestTableId[this.tabNumber].setValue();
                return true;
            }
            if ("11".equals(AssetTypePanels.this.depreciationMethod[this.tabNumber].getValue())) {
                AssetTypePanels.this.yearPercentageTableId[this.tabNumber].setMandatory(false);
                AssetTypePanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
                AssetTypePanels.this.yearPercentageTableId[this.tabNumber].setValue();
                AssetTypePanels.this.degressivePercentage[this.tabNumber].setMandatory(false);
                AssetTypePanels.this.degressivePercentage[this.tabNumber].setHidden(true);
                AssetTypePanels.this.degressivePercentage[this.tabNumber].setValue();
                AssetTypePanels.this.annuityInterestTableId[this.tabNumber].setHidden(false);
                AssetTypePanels.this.annuityPercentage[this.tabNumber].setHidden(false);
                AssetTypePanels.this.startPeriodHandlingMethod[this.tabNumber].setSelectedOptionValue("1");
                AssetTypePanels.this.startPeriodHandlingMethod[this.tabNumber].setReadonly(true);
                AssetTypePanels.this.interestCalculationMethod[this.tabNumber].setSelectedOptionValue("0");
                AssetTypePanels.this.interestCalculationMethod[this.tabNumber].setReadonly(true);
                AssetTypePanels.this.interestCalculationMethodChangeAction[this.tabNumber].execute(null);
                return true;
            }
            if ("2".equals(AssetTypePanels.this.depreciationMethod[this.tabNumber].getValue())) {
                AssetTypePanels.this.yearPercentageTableId[this.tabNumber].setMandatory(false);
                AssetTypePanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
                AssetTypePanels.this.yearPercentageTableId[this.tabNumber].setValue();
                AssetTypePanels.this.degressivePercentage[this.tabNumber].setMandatory(true);
                AssetTypePanels.this.degressivePercentage[this.tabNumber].setHidden(false);
                AssetTypePanels.this.annuityPercentage[this.tabNumber].setMandatory(false);
                AssetTypePanels.this.annuityPercentage[this.tabNumber].setHidden(true);
                AssetTypePanels.this.annuityPercentage[this.tabNumber].setValue();
                AssetTypePanels.this.annuityInterestTableId[this.tabNumber].setMandatory(false);
                AssetTypePanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
                AssetTypePanels.this.annuityInterestTableId[this.tabNumber].setValue();
                return true;
            }
            AssetTypePanels.this.yearPercentageTableId[this.tabNumber].setMandatory(false);
            AssetTypePanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
            AssetTypePanels.this.yearPercentageTableId[this.tabNumber].setValue();
            AssetTypePanels.this.degressivePercentage[this.tabNumber].setMandatory(false);
            AssetTypePanels.this.degressivePercentage[this.tabNumber].setHidden(true);
            AssetTypePanels.this.degressivePercentage[this.tabNumber].setValue();
            AssetTypePanels.this.annuityPercentage[this.tabNumber].setMandatory(false);
            AssetTypePanels.this.annuityPercentage[this.tabNumber].setHidden(true);
            AssetTypePanels.this.annuityPercentage[this.tabNumber].setValue();
            AssetTypePanels.this.annuityInterestTableId[this.tabNumber].setMandatory(false);
            AssetTypePanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
            AssetTypePanels.this.annuityInterestTableId[this.tabNumber].setValue();
            return true;
        }
    }

    private class CalculateDepreciationChangeAction
    extends Action {
        private static final long serialVersionUID = 7466661560217263804L;
        private int tabNumber = 0;

        public CalculateDepreciationChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if (AssetTypePanels.this.calculateDepreciation[this.tabNumber].getValueAsBoolean()) {
                AssetTypePanels.this.depreciationMethod[this.tabNumber].setHidden(false);
                AssetTypePanels.this.startPeriodHandlingMethod[this.tabNumber].setHidden(false);
                AssetTypePanels.this.depreciationGroups2[this.tabNumber].setHidden(false);
                return true;
            }
            AssetTypePanels.this.depreciationMethod[this.tabNumber].setValueAsString("99");
            AssetTypePanels.this.depreciationMethod[this.tabNumber].setHidden(true);
            AssetTypePanels.this.yearPercentageTableId[this.tabNumber].setMandatory(false);
            AssetTypePanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
            AssetTypePanels.this.yearPercentageTableId[this.tabNumber].setValue();
            AssetTypePanels.this.degressivePercentage[this.tabNumber].setMandatory(false);
            AssetTypePanels.this.degressivePercentage[this.tabNumber].setHidden(true);
            AssetTypePanels.this.degressivePercentage[this.tabNumber].setValue();
            AssetTypePanels.this.annuityPercentage[this.tabNumber].setMandatory(false);
            AssetTypePanels.this.annuityPercentage[this.tabNumber].setHidden(true);
            AssetTypePanels.this.annuityPercentage[this.tabNumber].setValue();
            AssetTypePanels.this.annuityInterestTableId[this.tabNumber].setMandatory(false);
            AssetTypePanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
            AssetTypePanels.this.annuityInterestTableId[this.tabNumber].setValue();
            AssetTypePanels.this.startPeriodHandlingMethod[this.tabNumber].setHidden(true);
            AssetTypePanels.this.depreciationGroups2[this.tabNumber].setHidden(true);
            return true;
        }
    }

    private class APTabActivateAction
    extends TabActivateAction {
        private static final long serialVersionUID = 4698365794179208227L;

        public APTabActivateAction(Tab tab, TabbedPanel tabbedPanel) {
            super(tab, tabbedPanel);
        }

        public boolean execute(DataObject object) throws Exception {
            object.removeMessages();
            int tabNumber = this.getActiveAccountingPrincipleTabIndex();
            String message = AssetTypePanels.this.validateAccountingPrincipleForm(tabNumber);
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return true;
            }
            super.execute(object);
            AssetTypePanels.this.currentAccountingPrinciple = AssetTypePanels.this.ap[this.getActiveAccountingPrincipleTabIndex()];
            return true;
        }

        private int getActiveAccountingPrincipleTabIndex() {
            String tabName = AssetTypePanels.this.apTabbedPanel.getActiveTabName();
            for (int i = 0; i <= AssetTypePanels.this.apTabCountMax; ++i) {
                if (!AssetTypePanels.this.apTabTexts[i].equals(tabName)) continue;
                return i;
            }
            return AssetTypePanels.this.apTabCount;
        }
    }

    protected class MainTabActivateAction
    extends TabActivateAction {
        private static final long serialVersionUID = 2298792855932187199L;

        public MainTabActivateAction(Tab tab, TabbedPanel tabbedPanel) {
            super(tab, tabbedPanel);
        }

        public boolean execute(DataObject object) throws Exception {
            int i;
            object.removeMessages();
            if ("Label.Valuation_Short".equals(AssetTypePanels.this.mainTabPanel.getActiveTabName())) {
                for (i = 0; i <= AssetTypePanels.this.apTabCountMax; ++i) {
                    String message = AssetTypePanels.this.validateAccountingPrincipleForm(i);
                    if (message == null) continue;
                    object.addUIObject((UIObject)new Message(message, "error"));
                    AssetTypePanels.this.mainTabPanel.setActiveTabByName("Label.Valuation_Short");
                    AssetTypePanels.this.apTabbedPanel.setActiveTab(AssetTypePanels.this.apTabs[i]);
                    return true;
                }
            }
            if ("Label.MainAccountScheme".equals(AssetTypePanels.this.mainTabPanel.getActiveTabName())) {
                for (i = 0; i <= AssetTypePanels.this.jtTabCountMax; ++i) {
                    AssetTypePanels.this.validateJournalingTermForm(i);
                }
            }
            super.execute(object);
            AssetTypePanels.this.description.setReadonly(true);
            if ("Label.Common".equals(AssetTypePanels.this.mainTabPanel.getActiveTabName())) {
                AssetTypePanels.this.description.setReadonly(false);
            }
            return true;
        }
    }

    private class DimensionComboBoxChangeAction
    extends Action {
        private static final long serialVersionUID = -4416047143155386675L;
        int seqNr = 0;

        public DimensionComboBoxChangeAction(int seqNr) {
            this.seqNr = seqNr;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if ("0".equals(AssetTypePanels.this.dims[this.seqNr].getValue())) {
                AssetTypePanels.this.mans[this.seqNr].setValue(false);
                AssetTypePanels.this.mans[this.seqNr].setReadonly(true);
                if (this.seqNr < 6) {
                    AssetTypePanels.this.gridLayout.removeUIObject((UIObject)AssetTypePanels.this.dfts[this.seqNr], false);
                    ((AssetTypePanels)AssetTypePanels.this).dfts[this.seqNr] = null;
                }
            } else {
                AssetTypePanels.this.mans[this.seqNr].setReadonly(false);
                AnalysisGroup group = (AnalysisGroup)AnalysisGroupBO.get(AssetTypePanels.this.dbData, AssetTypePanels.this.company.getId(), Integer.parseInt(AssetTypePanels.this.dims[this.seqNr].getValue()))[0];
                if (group != null && group.getUsage() == 1) {
                    AnalysisCodeReferenceField refField = new AnalysisCodeReferenceField(AssetTypePanels.this.dbData, group);
                    refField.setDiscardLabel(true);
                    refField.setDescriptionLength(33);
                    AssetTypePanels.this.gridLayout.add((UIObject)refField, this.seqNr + 1, 5);
                    ((AssetTypePanels)AssetTypePanels.this).dfts[this.seqNr] = refField;
                } else {
                    ((AssetTypePanels)AssetTypePanels.this).dfts[this.seqNr] = null;
                }
            }
            return true;
        }
    }

    private class UseAccountingPrinciple2ChangeAction
    extends Action {
        private static final long serialVersionUID = 6404088286134116694L;

        public boolean execute(DataObject dataObject) throws Exception {
            if (AssetTypePanels.this.mode == 0) {
                AssetTypePanels.this.initializeAccountingPrincipleForms();
                AssetTypePanels.this.getAccountingPrincipleDefaultsFromCompany();
                AssetTypePanels.this.modifyFieldAttributes();
                AssetTypePanels.this.initializeJournalingTermForms();
                AssetTypePanels.this.getMainAccountDefaultsFromCompany();
                return true;
            }
            if (AssetTypePanels.this.useAccountingPrinciple2.isChecked()) {
                AssetTypePanels.this.apTabs[1].setHidden(false);
                if (AssetTypePanels.this.company.getProcessParameters().getUseDifferentAcquisitionValues()) {
                    AssetTypePanels.this.differentAcquisitionValueForAP2.setHidden(false);
                }
                return true;
            }
            AssetTypePanels.this.apTabs[1].setHidden(true);
            AssetTypePanels.this.differentAcquisitionValueForAP2.setHidden(true);
            AssetTypePanels.this.apTabbedPanel.setActiveTab(AssetTypePanels.this.apTabs[0]);
            return true;
        }
    }
}

