/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.AssetWOZValueDetailAdapter;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.queries.AssetQuery;

public class AssetWOZValueAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 5764706852633568880L;
    public static final String PAGE = AssetWOZValueAdapter.class.getName();
    private String cId;
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES = new String[]{"id", "description", "typeId", "CurrentWOZValue"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description", "Label.Type", "Label.WozAmount"};
    private static final short[] SIZES = new short[]{80, 300, 80, 150};
    private static final ZeroBigDecimalToBlankTransformer DECIMALTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
    private static final Transformer[] TRANSFORMERS = new Transformer[]{null, null, null, DECIMALTRANSFORMER};
    private static final String[] TYPES = new String[]{null, null, null, null};
    private static final boolean[] SORTABLE = new boolean[]{true, true, true, false};
    private Map<String, AssetTypeReferenceField> inputComponents = new HashMap<String, AssetTypeReferenceField>();
    public static final String REFRESH = "refresh";
    private static final String EDIT = "edit";
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbEdit = new FloatBar();
    private Action[] rowActions;
    private Action[] headerActions;
    private Asset asset;

    public AssetWOZValueAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.cId = this.companyId;
        if (this.dataSetId != null) {
            this.cId = this.dataSetId;
        }
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(this.finish);
        this.inputComponents.put("typeId", new AssetTypeReferenceField(this.dbData, this.cId));
        this.fbEdit.addAction(this.back);
        this.fbEdit.addAction(this.finish);
        this.rowActions = new Action[]{edit};
        this.headerActions = new Action[]{refresh};
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.AssetWozValues", "screen_name"));
        if (this.table == null) {
            this.createTable();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        AssetQuery assetQuery = new AssetQuery(this.dbData, this.companyId);
        assetQuery.setQueryForLimitedDepreciation();
        this.table = new ODBTable(Asset.class, (ODBQuery)assetQuery, new String[]{"id"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)assetQuery);
        this.table.setTextCodeSingleObject("Label.Asset");
        this.table.setTextCodeMultipleObjects("Label.Assets");
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setColumnTypes(TYPES);
        this.table.setSortable(true);
        this.table.setColumnSortable(SORTABLE);
        this.table.orderByColumn("id");
        this.searchPanel = this.table.createSearch(NAMES, LABELS);
        this.searchPanel.setCSSClass("headerPanel");
        Action filterAction = this.table.createFilterAction(NAMES, LABELS, 3);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject edit(DataObject object) throws Exception {
        this.asset = (Asset)TableHelper.getSelectedItem((DataObject)object);
        this.getProcess().setAttribute("asset", (Object)this.asset);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(AssetWOZValueDetailAdapter.PAGE), REFRESH, this.getProcess().getProcessId()));
        return object;
    }
}

