/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.CalculatorParameter;
import nl.ibs.fac.DepreciationMethodEnum;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.InterestCalculationMethodEnum;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ProofDepreciationCalculator;
import nl.ibs.fac.ReasonCodeEnum;
import nl.ibs.fac.StartPeriodHandlingEnum;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.InterestTableReferenceField;
import nl.ibs.fac.adapters.ReasonCodeImageTransformer;
import nl.ibs.fac.adapters.YearPercentageTableReferenceField;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.adapters.ZeroIntegerToBlankTransformer;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.InterestTableBO;
import nl.ibs.fac.boadapters.ProcessParametersBO;
import nl.ibs.fac.boadapters.YearPercentageTableBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.ProcessParameters;

public class CalculatorAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 4880441330398542158L;
    public static final String PAGE = CalculatorAdapter.class.getName();
    private Company company;
    private Company dataSet;
    private ProcessParameters processParameters;
    private Panel apPanel;
    private ComboBox depreciationMethod;
    private FieldGroup fg1A;
    private FACDecimalField acquTotal;
    private NumberField depreciatableLife;
    private BookYearPeriodGrid startUseYearPeriod;
    private NumberField startUseYear;
    private BookYearPeriodGrid yearPeriodTo;
    private FieldGroup fg2;
    private FACDecimalField degressivePercentage;
    private ODBQueryReferenceField yearPercentageTableId;
    private ODBQueryReferenceField annuityInterestTableId;
    private FACDecimalField annuityPercentage;
    private ComboBox startPeriodHandlingMethod;
    private CheckBox depreciationPaused;
    private FieldGroup fg3;
    private FACDecimalField deprTotal;
    private NumberField nbrOfDeprPers;
    private FACDecimalField residualValue;
    private FACDecimalField residualPercentage;
    private FieldGroup fg4;
    private ComboBox interestCalculationMethod;
    private FACDecimalField interestPercentage;
    private ODBQueryReferenceField interestTableId;
    private DepreciationMethodChangeAction depreciationMethodChangeAction;
    private InterestCalculationMethodChangeAction interestCalculationMethodChangeAction;
    private StartPeriodHandlingMethodChangeAction startPeriodHandlingMethodChangeAction;
    private FloatBar fbShow = new FloatBar();
    private CommonTable.SearchPanel searchPanel;
    private static final String[] SEARCHNAMES = new String[]{"year"};
    private static final String[] SEARCHLABELS = new String[]{"Label.Year"};
    private static final String[] NAMES = new String[]{"year", "period", "bookValue", "depreciationAmount", "bookValueAfterDepreciation", "totalDepreciationAmount", "interestAmount", "reasonCode"};
    private static final String[] LABELS = new String[]{"Label.Year", "Label.Period.short", "Label.BookValueBeforeDepreciation.short", "Label.DepreciationAmount.short", "Label.BookValueAfterDepreciation.short", "Label.TotalDepreciationAmount.short", "Label.InterestAmount", "Label.ReasonCode"};
    private static final String[] TOOLTIPS = new String[]{"Label.ReasonCode"};
    private static final short[] SIZES = new short[]{50, 30, 120, 120, 120, 120, 120, 20};
    private static final ZeroIntegerToBlankTransformer INTEGERTRANSFORMER = new ZeroIntegerToBlankTransformer();
    private static final ZeroBigDecimalToBlankTransformer DECIMALTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
    private Transformer[] transformers = new Transformer[]{INTEGERTRANSFORMER, INTEGERTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, new ReasonCodeImageTransformer()};
    private static final boolean[] COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true};
    private int numberOfTableRows;
    private CalculatorParameter parameter = new CalculatorParameter();
    private ProofDepreciationCalculator calculator;
    private CollectionTable table = null;

    public CalculatorAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.dataSet = this.company.getDataSet();
        if (this.dataSet == null) {
            this.dataSet = this.company;
        }
        this.processParameters = (ProcessParameters)ProcessParametersBO.get(this.company.getDBData(), this.dataSet.getId())[0];
        this.calculator = new ProofDepreciationCalculator(this.processParameters.getFullInterestIn1stPeriod());
        this.initializeForm();
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("calculate");
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        this.fbShow.addAction(ok);
        this.fbShow.addAction(this.finish);
        ComboBox code = EnumHelper.createComboBox("Label.Type", ReasonCodeEnum.getCollection(), true);
        code.setWidth("370");
    }

    private void initializeForm() throws Exception {
        this.apPanel = new Panel();
        FieldGroup fg = new FieldGroup("Label.Depreciation");
        fg.forceBorder(true);
        this.depreciationMethod = EnumHelper.createComboBox("Label.DepreciationMethod", DepreciationMethodEnum.getCollection(), false);
        this.depreciationMethod.setWidth("225");
        this.depreciationMethodChangeAction = new DepreciationMethodChangeAction();
        this.depreciationMethod.add((Action)this.depreciationMethodChangeAction);
        fg.add(this.depreciationMethod);
        this.apPanel.addUIObject((UIObject)fg);
        this.fg1A = new FieldGroup("Label.Common");
        this.fg1A.forceBorder(true);
        this.acquTotal = new FACDecimalField("Label.AcquisitionValue", 15, 2);
        this.acquTotal.setMandatory(true);
        this.fg1A.add((Field)this.acquTotal);
        this.depreciatableLife = new NumberField("Label.DepreciationLife", 4, true);
        this.depreciatableLife.setMinValue(new BigInteger("0"), true);
        this.depreciatableLife.setMandatory(true);
        this.fg1A.add((Field)this.depreciatableLife);
        this.startUseYear = new NumberField("Label.InvestmentYear", 4, true);
        this.startUseYear.setValue("" + this.company.getCurrentBookYear());
        this.startUseYear.setMandatory(true);
        this.fg1A.add((Field)this.startUseYear);
        this.startUseYearPeriod = new BookYearPeriodGrid("Label.InvestmentPeriod", "" + this.company.getCurrentBookYear(), this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.startUseYearPeriod.getPeriod().setValue(1L);
        this.fg1A.add((ESPGridLayout)this.startUseYearPeriod);
        this.yearPeriodTo = new BookYearPeriodGrid("Label.CalculateUntilIncluding", this.bookYearMax, this.bookYearMin, null, this.numberOfPeriods);
        this.yearPeriodTo.getPeriod().setValue((long)this.numberOfPeriods);
        this.fg1A.add((ESPGridLayout)this.yearPeriodTo);
        this.apPanel.addUIObject((UIObject)this.fg1A);
        this.fg2 = new FieldGroup("Label.Miscellaneous");
        this.yearPercentageTableId = new YearPercentageTableReferenceField(this.dbData);
        this.fg2.add((Field)this.yearPercentageTableId);
        this.degressivePercentage = new FACDecimalField("Label.Percentage", 6, 2);
        this.degressivePercentage.setMinValue(new BigDecimal(0), true);
        this.degressivePercentage.setMaxValue(new BigDecimal(100), true);
        this.fg2.add((Field)this.degressivePercentage);
        this.annuityInterestTableId = new InterestTableReferenceField(this.dbData, this.numberOfPeriods);
        this.fg2.add((Field)this.annuityInterestTableId);
        this.annuityPercentage = new FACDecimalField("Label.Percentage", 6, 3);
        this.annuityPercentage.setMinValue(new BigDecimal(0), true);
        this.annuityPercentage.setMaxValue(new BigDecimal(100), true);
        this.fg2.add((Field)this.annuityPercentage);
        this.startPeriodHandlingMethod = EnumHelper.createComboBox("Label.StartPeriodHandlingPolicy", StartPeriodHandlingEnum.getCollection(), false);
        this.startPeriodHandlingMethodChangeAction = new StartPeriodHandlingMethodChangeAction();
        this.startPeriodHandlingMethod.add((Action)this.startPeriodHandlingMethodChangeAction);
        if (this.numberOfPeriods == 13) {
            this.startPeriodHandlingMethod.removeOption(this.startPeriodHandlingMethod.getOptionByValue("4"));
            this.startPeriodHandlingMethod.removeOption(this.startPeriodHandlingMethod.getOptionByValue("6"));
        }
        this.startPeriodHandlingMethod.setWidth("225");
        this.fg2.add(this.startPeriodHandlingMethod);
        this.depreciationPaused = new CheckBox("Label.DepreciationPaused");
        this.fg2.add(this.depreciationPaused);
        this.apPanel.addUIObject((UIObject)this.fg2);
        this.fg3 = new FieldGroup("Label.Other");
        this.deprTotal = new FACDecimalField("Label.Depreciations", 15, 2);
        this.fg3.add((Field)this.deprTotal);
        this.nbrOfDeprPers = new NumberField("Label.DepreciatedPeriods", 5, true);
        this.nbrOfDeprPers.setMinValue(new BigInteger("0"), true);
        this.fg3.add((Field)this.nbrOfDeprPers);
        this.residualValue = new FACDecimalField("Label.ResidualValueAmount", 15, 2);
        this.fg3.add((Field)this.residualValue);
        this.residualPercentage = new FACDecimalField("Label.ResidualValuePercentage", 5, 2);
        this.residualPercentage.setMinValue(new BigDecimal(0), true);
        this.residualPercentage.setMaxValue(new BigDecimal(100), true);
        this.fg3.add((Field)this.residualPercentage);
        this.apPanel.addUIObject((UIObject)this.fg3);
        this.fg4 = new FieldGroup("Label.Interest");
        this.interestCalculationMethod = EnumHelper.createComboBox("Label.InterestCalculationMethod", InterestCalculationMethodEnum.getCollection(), false);
        this.interestCalculationMethod.setWidth("225");
        this.interestCalculationMethodChangeAction = new InterestCalculationMethodChangeAction();
        this.interestCalculationMethod.add((Action)this.interestCalculationMethodChangeAction);
        this.fg4.add(this.interestCalculationMethod);
        this.interestTableId = new InterestTableReferenceField(this.dbData, this.numberOfPeriods);
        this.fg4.add((Field)this.interestTableId);
        this.interestPercentage = new FACDecimalField("Label.Percentage", 6, 3);
        this.interestPercentage.setMinValue(new BigDecimal(0), true);
        this.interestPercentage.setMaxValue(new BigDecimal(100), true);
        this.fg4.add((Field)this.interestPercentage);
        this.apPanel.addUIObject((UIObject)this.fg4);
        this.depreciationMethodChangeAction.execute(null);
        this.interestCalculationMethodChangeAction.execute(null);
        this.startPeriodHandlingMethodChangeAction.execute(null);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.Calculate", "screen_name"));
        object.addUIObject((UIObject)this.apPanel);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject calculate(DataObject object) throws Exception {
        String message = this.validate(object);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.setParameter();
        this.createTable();
        Window window = new Window();
        window.setTop("20%");
        window.setRight("13%");
        window.setLabel("Title.CalculationResult");
        object.addUIObject((UIObject)window);
        window.add((Panel)this.searchPanel);
        window.add((Table)this.table);
        return object;
    }

    private String validate(DataObject object) throws Exception {
        Object[] result;
        String message;
        Object[] result2;
        String message2;
        this.apPanel.removeInvalidTags();
        String id = this.yearPercentageTableId.getValue().trim();
        if (id.length() > 0 && (message2 = (String)(result2 = YearPercentageTableBO.get(this.dbData, id))[1]) != null) {
            this.yearPercentageTableId.setInvalidTag();
            return message2;
        }
        if (!"0".equals(this.interestCalculationMethod.getValue())) {
            boolean precentageFilled;
            id = this.interestTableId.getValue().trim();
            boolean idFilled = id.length() > 0;
            boolean bl = precentageFilled = this.interestPercentage.getDoubleValue() > 0.0;
            if (idFilled && precentageFilled) {
                this.interestTableId.setInvalidTag();
                this.interestPercentage.setInvalidTag();
                return "provide_only_one_value";
            }
            if (!idFilled && !precentageFilled) {
                this.interestTableId.setInvalidTag();
                this.interestPercentage.setInvalidTag();
                return "provide_one_value";
            }
            if (idFilled && (message = (String)(result = InterestTableBO.get(this.dbData, id, this.numberOfPeriods))[1]) != null) {
                this.interestTableId.setInvalidTag();
                return message;
            }
        }
        if ("2".equals(this.depreciationMethod.getValue()) && this.degressivePercentage.getDoubleValue() == 0.0) {
            this.degressivePercentage.setInvalidTag();
            return "value_must_be_positive";
        }
        if ("12".equals(this.depreciationMethod.getValue()) || "11".equals(this.depreciationMethod.getValue())) {
            boolean precentageFilled;
            id = this.annuityInterestTableId.getValue().trim();
            boolean idFilled = id.length() > 0;
            boolean bl = precentageFilled = this.annuityPercentage.getDoubleValue() > 0.0;
            if (idFilled && precentageFilled) {
                this.annuityInterestTableId.setInvalidTag();
                this.annuityPercentage.setInvalidTag();
                return "provide_only_one_value";
            }
            if (!idFilled && !precentageFilled) {
                this.annuityInterestTableId.setInvalidTag();
                this.annuityPercentage.setInvalidTag();
                return "provide_one_value";
            }
            if (idFilled && (message = (String)(result = InterestTableBO.get(this.dbData, id, this.numberOfPeriods))[1]) != null) {
                this.annuityInterestTableId.setInvalidTag();
                return message;
            }
        }
        if (this.residualValue.getDoubleValue() > 0.0 && this.residualPercentage.getDoubleValue() > 0.0) {
            this.residualValue.setInvalidTag();
            this.residualPercentage.setInvalidTag();
            return "provide_only_one_value";
        }
        if (PeriodHelper.isBefore(this.yearPeriodTo.getBookYear().getIntValue(), this.yearPeriodTo.getPeriod().getIntValue(), this.startUseYearPeriod.getBookYear().getIntValue(), this.startUseYearPeriod.getPeriod().getIntValue())) {
            this.yearPeriodTo.getBookYear().setInvalidTag();
            this.yearPeriodTo.getPeriod().setInvalidTag();
            return object.translate("Period_is_not_after", object.getLocale()) + " " + PeriodHelper.toString(this.startUseYearPeriod.getBookYear().getIntValue(), this.startUseYearPeriod.getPeriod().getIntValue());
        }
        return null;
    }

    private void setParameter() throws Exception {
        this.parameter.setCorrectionAmount445A(new BigDecimal("0.00"));
        this.parameter.setCorrectionAmount445B(new BigDecimal("0.00"));
        this.parameter.setPostedAcquisitionBalance(this.acquTotal.getBigDecimal());
        this.parameter.setPostedDepreciationBalance(this.deprTotal.getBigDecimal());
        this.parameter.setPreviousBookvalueBalance(this.calculatePreviousBookValueBalance());
        this.parameter.setDegressivePercentage(this.degressivePercentage.getBigDecimal());
        this.parameter.setAnnuityPercentage(this.annuityPercentage.getBigDecimal());
        this.parameter.setAnnuityInterestTableId(this.annuityInterestTableId.getValue());
        this.parameter.setYearPercentageTableId(this.yearPercentageTableId.getValue());
        this.parameter.setInterestCalculationMethod(Integer.parseInt(this.interestCalculationMethod.getValue()));
        this.parameter.setInterestPercentage(this.interestPercentage.getBigDecimal());
        this.parameter.setInterestTableId(this.interestTableId.getValue());
        this.parameter.setDepreciationPaused(this.depreciationPaused.getValueAsBoolean());
        this.parameter.setNumberOfDepreciatedPeriods(this.nbrOfDeprPers.getIntValue());
        this.parameter.setResidualPercentage(this.residualPercentage.getBigDecimal());
        this.parameter.setResidualValue(this.residualValue.getBigDecimal());
        this.parameter.setStartPeriodHandlingMethod(Integer.parseInt(this.startPeriodHandlingMethod.getValue()));
        this.parameter.setDepreciationMethod(Integer.parseInt(this.depreciationMethod.getValue()));
        if (this.parameter.getDepreciationMethod() != 11) {
            this.parameter.setDepreciatableLife(this.depreciatableLife.getIntValue());
            this.parameter.setStartUseYear(this.startUseYearPeriod.getBookYear().getIntValue());
            this.parameter.setStartUsePeriod(this.startUseYearPeriod.getPeriod().getIntValue());
        } else {
            this.parameter.setDepreciatableLife(this.depreciatableLife.getIntValue() * this.numberOfPeriods);
            this.parameter.setStartUseYear(this.startUseYear.getIntValue());
            this.parameter.setStartUsePeriod(1);
        }
        this.parameter.setStartDepreciationBookYear(this.parameter.getStartUseYear());
        this.parameter.setStartDepreciationPeriod(this.parameter.getStartUsePeriod());
        if (Integer.parseInt(this.startPeriodHandlingMethod.getValue()) == 6) {
            if (this.startUseYearPeriod.getPeriod().getIntValue() > 6) {
                this.parameter.setStartDepreciationBookYear(this.startUseYearPeriod.getBookYear().getIntValue() + 1);
                this.parameter.setStartDepreciationPeriod(1);
            } else {
                this.parameter.setStartDepreciationBookYear(this.startUseYearPeriod.getBookYear().getIntValue());
                this.parameter.setStartDepreciationPeriod(7);
            }
        }
        if (Integer.parseInt(this.startPeriodHandlingMethod.getValue()) == 5) {
            this.parameter.setStartDepreciationBookYear(this.startUseYearPeriod.getBookYear().getIntValue() + 1);
            this.parameter.setStartDepreciationPeriod(1);
        }
    }

    private BigDecimal calculatePreviousBookValueBalance() throws Exception {
        BigDecimal previousBookValueBalance = new BigDecimal(0);
        if (this.nbrOfDeprPers.getIntValue() > 0 || this.deprTotal.getBigDecimal().doubleValue() != 0.0) {
            previousBookValueBalance = previousBookValueBalance.add(this.acquTotal.getBigDecimal().subtract(this.deprTotal.getBigDecimal()));
        }
        return previousBookValueBalance;
    }

    private void createTable() throws Exception {
        int periodTo;
        int yearTo;
        if (this.parameter.getDepreciationMethod() != 11) {
            yearTo = this.yearPeriodTo.getBookYear().getIntValue();
            periodTo = this.yearPeriodTo.getPeriod().getIntValue();
        } else {
            yearTo = this.parameter.getStartUseYear() + this.depreciatableLife.getIntValue() - 1;
            periodTo = this.numberOfPeriods;
        }
        ArrayList collection = (ArrayList)this.calculator.calculate(this.dbData, this.company, this.numberOfPeriods, false, yearTo, periodTo, this.parameter);
        this.numberOfTableRows = this.numberOfPeriods;
        collection = this.insertOpeningBalanceRowIfApplicable(collection);
        this.table = new CollectionTable(CalculationValue.class, (Collection)collection, this.numberOfPeriods);
        this.table.setName(PAGE);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setDisplayTransformers(this.transformers);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setSortable(false);
        this.table.setSelectable(false);
        this.searchPanel = this.table.createSearch(SEARCHNAMES, SEARCHLABELS, true, false, true);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    private ArrayList insertOpeningBalanceRowIfApplicable(ArrayList collection) throws Exception {
        BigDecimal bookAmount;
        CalculationValue value2;
        BigDecimal acquAmount;
        BigDecimal diffAmount;
        if (collection != null && !collection.isEmpty() && (diffAmount = (acquAmount = (value2 = (CalculationValue)collection.get(0)).getAcquisitionValue()).subtract(bookAmount = value2.getBookValue())).doubleValue() != 0.0) {
            for (CalculationValue value2 : collection) {
                value2.addToTotalDepreciationAmount(diffAmount);
            }
            CalculationValue firstBlood = new CalculationValue(99, 0, 0, new BigDecimal("0"), new BigDecimal("0"), null, null, bookAmount, acquAmount, diffAmount, new BigDecimal("0"), new BigDecimal("0"), null, null, false, new BigDecimal("0"));
            collection.add(0, firstBlood);
            ++this.numberOfTableRows;
        }
        return collection;
    }

    private class StartPeriodHandlingMethodChangeAction
    extends Action {
        private static final long serialVersionUID = -1954436578272498089L;

        public boolean execute(DataObject dataObject) throws Exception {
            if ("1".equals(CalculatorAdapter.this.startPeriodHandlingMethod.getValue())) {
                CalculatorAdapter.this.depreciationPaused.setReadonly(false);
                return true;
            }
            CalculatorAdapter.this.depreciationPaused.setValue(false);
            CalculatorAdapter.this.depreciationPaused.setReadonly(true);
            return true;
        }
    }

    private class InterestCalculationMethodChangeAction
    extends Action {
        private static final long serialVersionUID = -1954436578272498089L;

        public boolean execute(DataObject dataObject) throws Exception {
            if ("0".equals(CalculatorAdapter.this.interestCalculationMethod.getValue())) {
                CalculatorAdapter.this.interestTableId.setHidden(true);
                CalculatorAdapter.this.interestTableId.setValue();
                CalculatorAdapter.this.interestPercentage.setHidden(true);
                CalculatorAdapter.this.interestPercentage.setValue();
                return true;
            }
            CalculatorAdapter.this.interestTableId.setHidden(false);
            CalculatorAdapter.this.interestPercentage.setHidden(false);
            return true;
        }
    }

    private class DepreciationMethodChangeAction
    extends Action {
        private static final long serialVersionUID = -8897592052559181246L;

        public boolean execute(DataObject dataObject) throws Exception {
            CalculatorAdapter.this.yearPeriodTo.setHidden(false);
            CalculatorAdapter.this.startPeriodHandlingMethod.setReadonly(false);
            CalculatorAdapter.this.interestCalculationMethod.setReadonly(false);
            CalculatorAdapter.this.deprTotal.setHidden(false);
            CalculatorAdapter.this.nbrOfDeprPers.setHidden(false);
            CalculatorAdapter.this.depreciatableLife.setLabel("Label.DepreciationLife");
            CalculatorAdapter.this.startUseYearPeriod.setHidden(false);
            CalculatorAdapter.this.startUseYearPeriod.setMandatory(true);
            CalculatorAdapter.this.startUseYear.setHidden(true);
            CalculatorAdapter.this.startUseYear.setMandatory(false);
            if ("99".equals(CalculatorAdapter.this.depreciationMethod.getValue())) {
                CalculatorAdapter.this.startUseYearPeriod.getPeriod().setMinValue(new BigInteger("0"), true);
                CalculatorAdapter.this.startUseYearPeriod.getPeriod().setMandatory(false);
                CalculatorAdapter.this.startUseYearPeriod.getBookYear().setMandatory(false);
                CalculatorAdapter.this.depreciatableLife.setMinValue(new BigInteger("0"), true);
                CalculatorAdapter.this.depreciatableLife.setMandatory(false);
            } else {
                CalculatorAdapter.this.startUseYearPeriod.getPeriod().setMinValue(new BigInteger("1"), true);
                CalculatorAdapter.this.startUseYearPeriod.getPeriod().setMandatory(true);
                CalculatorAdapter.this.startUseYearPeriod.getBookYear().setMandatory(true);
                CalculatorAdapter.this.depreciatableLife.setMinValue(new BigInteger("1"), true);
                CalculatorAdapter.this.depreciatableLife.setMandatory(true);
            }
            if ("3".equals(CalculatorAdapter.this.depreciationMethod.getValue())) {
                CalculatorAdapter.this.yearPercentageTableId.setMandatory(true);
                CalculatorAdapter.this.yearPercentageTableId.setHidden(false);
                CalculatorAdapter.this.degressivePercentage.setMandatory(false);
                CalculatorAdapter.this.degressivePercentage.setHidden(true);
                CalculatorAdapter.this.degressivePercentage.setValue();
                CalculatorAdapter.this.annuityPercentage.setMandatory(false);
                CalculatorAdapter.this.annuityPercentage.setHidden(true);
                CalculatorAdapter.this.annuityPercentage.setValue();
                CalculatorAdapter.this.annuityInterestTableId.setHidden(true);
                CalculatorAdapter.this.annuityInterestTableId.setValue();
                return true;
            }
            if ("12".equals(CalculatorAdapter.this.depreciationMethod.getValue()) || "11".equals(CalculatorAdapter.this.depreciationMethod.getValue())) {
                CalculatorAdapter.this.yearPeriodTo.setHidden(true);
                CalculatorAdapter.this.startPeriodHandlingMethod.setSelectedOptionValue("1");
                CalculatorAdapter.this.startPeriodHandlingMethod.setReadonly(true);
                CalculatorAdapter.this.interestCalculationMethod.setSelectedOptionValue("0");
                CalculatorAdapter.this.interestCalculationMethod.setReadonly(true);
                CalculatorAdapter.this.deprTotal.setValue();
                CalculatorAdapter.this.deprTotal.setHidden(true);
                CalculatorAdapter.this.nbrOfDeprPers.setValue();
                CalculatorAdapter.this.nbrOfDeprPers.setHidden(true);
                CalculatorAdapter.this.depreciatableLife.setLabel("Label.DepreciationLifeInYears");
                CalculatorAdapter.this.startUseYearPeriod.setHidden(true);
                CalculatorAdapter.this.startUseYearPeriod.setMandatory(false);
                CalculatorAdapter.this.startUseYear.setHidden(false);
                CalculatorAdapter.this.startUseYear.setMandatory(true);
                CalculatorAdapter.this.yearPercentageTableId.setMandatory(false);
                CalculatorAdapter.this.yearPercentageTableId.setHidden(true);
                CalculatorAdapter.this.yearPercentageTableId.setValue();
                CalculatorAdapter.this.degressivePercentage.setMandatory(false);
                CalculatorAdapter.this.degressivePercentage.setHidden(true);
                CalculatorAdapter.this.degressivePercentage.setValue();
                CalculatorAdapter.this.annuityPercentage.setHidden(false);
                CalculatorAdapter.this.annuityInterestTableId.setHidden(false);
                return true;
            }
            if ("2".equals(CalculatorAdapter.this.depreciationMethod.getValue())) {
                CalculatorAdapter.this.yearPercentageTableId.setMandatory(false);
                CalculatorAdapter.this.yearPercentageTableId.setHidden(true);
                CalculatorAdapter.this.yearPercentageTableId.setValue();
                CalculatorAdapter.this.degressivePercentage.setMandatory(true);
                CalculatorAdapter.this.degressivePercentage.setHidden(false);
                CalculatorAdapter.this.annuityPercentage.setMandatory(false);
                CalculatorAdapter.this.annuityPercentage.setHidden(true);
                CalculatorAdapter.this.annuityPercentage.setValue();
                CalculatorAdapter.this.annuityInterestTableId.setHidden(true);
                CalculatorAdapter.this.annuityInterestTableId.setValue();
                return true;
            }
            CalculatorAdapter.this.yearPercentageTableId.setMandatory(false);
            CalculatorAdapter.this.yearPercentageTableId.setHidden(true);
            CalculatorAdapter.this.yearPercentageTableId.setValue();
            CalculatorAdapter.this.degressivePercentage.setMandatory(false);
            CalculatorAdapter.this.degressivePercentage.setHidden(true);
            CalculatorAdapter.this.degressivePercentage.setValue();
            CalculatorAdapter.this.annuityPercentage.setMandatory(false);
            CalculatorAdapter.this.annuityPercentage.setHidden(true);
            CalculatorAdapter.this.annuityPercentage.setValue();
            CalculatorAdapter.this.annuityInterestTableId.setHidden(true);
            CalculatorAdapter.this.annuityInterestTableId.setValue();
            return true;
        }
    }
}

