/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.DialogWindow;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.FACAdapter;
import nl.ibs.fac.adapters.LoginAdapter;
import nl.ibs.fac.adapters.LogoutAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.UserBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.User;
import nl.ibs.jsql.DBData;

public class CheckCurrentBatchAdapter
extends FACAdapter {
    private static final long serialVersionUID = -1066251741032148929L;
    public static final String PAGE = CheckCurrentBatchAdapter.class.getName();
    private DialogWindow confirm;

    public CheckCurrentBatchAdapter(DataObject object) throws Exception {
        super(object);
        this.showTaskBar(false);
    }

    public DataObject show(DataObject object) throws Exception {
        TransactionBatch transactionBatch;
        String companyId;
        Company company;
        DBData dbData;
        User user;
        LoginHelper loginHelper = (LoginHelper)object.getSessionAttribute(LoginHelper.LOGINHELPER);
        if (loginHelper != null && (user = (User)UserBO.get(loginHelper.getUser())[0]) != null && user.getCheckCurrentTransactionBatchHasTransactions() && (dbData = (DBData)object.getSessionAttribute("ActiveDBData")) != null && (company = (Company)CompanyBO.get(dbData, companyId = (String)object.getSessionAttribute("ActiveCompany"))[0]) != null && TransactionBO.getFirstTransaction(transactionBatch = company.getCurrentTransactionBatch()) != null) {
            object.addUIObject((UIObject)this.createWindow(true));
            return object;
        }
        object.addUIObject((UIObject)this.createWindow(true));
        return object;
    }

    public DataObject execute(DataObject object) throws Exception {
        if (object.getSessionAttribute("SingleSigOn") != null) {
            object.addUIObject((UIObject)new RedirectAction(LogoutAdapter.class.getName(), "logout"));
        } else {
            object.addUIObject((UIObject)new RedirectAction(LoginAdapter.class.getName(), "newLogin"));
        }
        return object;
    }

    public DataObject closeWindow(DataObject object) throws Exception {
        this.confirm.closeWindow(object);
        this.destroyAdapter(object);
        return object;
    }

    public String getDescription() {
        return this.translate("MenuItem.Signoff");
    }

    public String getShortDescription() {
        return "MenuItem.Signoff";
    }

    public Window createWindow(boolean transaction) {
        Action yes = new Action("logoff").setAdapter(PAGE).setMethod("execute").setDefault(true);
        Action no = new Action("no").setAdapter(PAGE).setMethod("closeWindow");
        String message = transaction ? this.translate("Label.CurrentBatchHasTransactions") + "\n" + this.translate("Label.ContinueSignoff") : "Label.ContinueSignoff";
        this.confirm = new DialogWindow("confirmation", "question-mark.png", message, false, "no", false, new Action[]{yes, no}, 300);
        return this.confirm;
    }
}

