/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.Collection;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.language.TranslationHelperImpl;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Separator;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.fac.adapters.CompanyPanels;
import nl.ibs.fac.adapters.CompanyReportAdapter;
import nl.ibs.fac.adapters.DisinvestmentReasonMainAccountAdapter;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.ProcessParametersAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.ProcessParametersBO;
import nl.ibs.fac.boadapters.UserBO;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.AssetTypeManagerFactory;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.ProcessParameters;
import nl.ibs.fac.db.User;
import nl.ibs.fac.queries.CompanyQuery;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.util.Scrambler;

public class CompanyAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 3003128743735264669L;
    public static final String PAGE = CompanyAdapter.class.getName();
    private User user;
    private CompanyPanels panels;
    private String processParametersActionName = TranslationHelperImpl.getInstance().translate("Button.ProcessProperties");
    private FloatBar fbShow;
    private FloatBar fbCreate;
    private FloatBar fbEdit;
    private FloatBar fbDelete;
    private FloatBar fbDeleteAssets;
    private Action[] rowActions;
    private Action[] headerActions;
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES = new String[]{"id", "description", "currentBookYear"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description", "Label.BookYear"};
    private static final short[] SIZES = new short[]{70, 500, 70};
    private Company company;
    private Object[] companies;

    public CompanyAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.env == null) {
            return;
        }
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.user = (User)UserBO.get(this.loginHelper.getUser())[0];
        this.fbShow = new FloatBar();
        this.fbCreate = new FloatBar();
        this.fbEdit = new FloatBar();
        this.fbDelete = new FloatBar();
        this.fbDeleteAssets = new FloatBar();
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("refresh");
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initCreateForm");
        Action report = new Action("Button.Report").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("report");
        Action confirmDeleteAllAssets = new Action("Button.DeleteAllAssets").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDeleteAllAssets");
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDelete");
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        this.fbShow.addAction(report);
        this.fbShow.addAction(this.finish);
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initEditForm");
        this.rowActions = new Action[]{edit, report, confirmDeleteAllAssets, confirmDelete};
        Action reportAll = new Action("Button.Report").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("reportAll");
        this.headerActions = new Action[]{refresh, create, reportAll};
        this.fbCreate.addAction(this.back);
        Action createOK = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createForm2");
        createOK.setDefault(true);
        createOK.setValidationEnabled(true);
        this.fbCreate.addAction(createOK);
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("edit");
        editOK.setDefault(true);
        editOK.setValidationEnabled(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.cancel);
        this.fbEdit.addAction(this.finish);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("delete");
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.fbDelete.addAction(this.finish);
        deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("deleteAllAssets");
        this.fbDeleteAssets.addAction(deleteOK);
        this.fbDeleteAssets.addAction(this.back);
        this.fbDeleteAssets.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.env == null) {
            object.addUIObject((UIObject)new Message("NoActiveEnvironment", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.Companies", "screen_name"));
        this.company = null;
        if (this.table == null) {
            this.createTable();
        } else if (this.table.isSelectable()) {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        CompanyQuery query = new CompanyQuery(this.dbData);
        this.table = new ODBTable(Company.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        TableHelper.createMenu((CommonTable)this.table, (Action[])this.headerActions, (Action[])this.rowActions, (TableRowMethod)new MyTableRowMethod());
        this.searchPanel = this.table.createSearch(NAMES, LABELS);
        this.searchPanel.setCSSClass("headerpanel");
        Action filterAction = this.table.createFilterAction(NAMES, LABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject initCreateForm(DataObject object) throws Exception {
        this.activateCompany(object, null, this.user);
        this.panels = new CompanyPanels(this.loginHelper, this.dbData, this.env, this.numberOfPeriods, this.governmentActivated, null);
        this.panels.setCompanyAdapter(this);
        return this.createCommonForm(object);
    }

    public DataObject createCommonForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateCompany", "screen_name"));
        object.addUIObject((UIObject)this.panels.fgCreate);
        object.addUIObject((UIObject)this.fbCreate);
        return object;
    }

    public DataObject createForm2(DataObject object) throws Exception {
        Action action;
        String message = this.panels.validateCreateForm();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.panels.initializeBookYears();
        this.clearScreen(true, false, true);
        Header header = new Header("Title.CreateCompany", "screen_name");
        header.setHelpId("Title.CreateCompanyLabel.Common");
        object.addUIObject((UIObject)header);
        header = new Header("Label.Common", "sub_screen_name");
        object.addUIObject((UIObject)header);
        if (!this.panels.useOwnBasicData.getValueAsBoolean()) {
            object.addUIObject((UIObject)this.panels.mainPanel);
            object.addUIObject((UIObject)this.panels.fgDataSet);
            object.addUIObject((UIObject)this.panels.fgMiscellaneous);
            action = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("create");
        } else {
            object.addUIObject((UIObject)this.panels.mainPanel);
            object.addUIObject((UIObject)this.panels.fgMiscellaneous);
            action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createForm3");
        }
        object.addUIObject((UIObject)this.panels.fgAssetId);
        if (this.governmentActivated) {
            object.addUIObject((UIObject)this.panels.fgCreditId);
        }
        FloatBar fb = new FloatBar();
        fb.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createCommonForm"));
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(this.cancel);
        object.addUIObject((UIObject)fb);
        return object;
    }

    public DataObject createForm3(DataObject object) throws Exception {
        String message = this.panels.validateCreateForm2();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.loginHelper.logout(this.env, this.companyId, this.bookYear);
        message = this.loginHelper.login(this.env, this.panels.idDesc.getValue(), this.panels.currentBookYear.getValue());
        if (message != null && message.trim().length() > 0) {
            this.loginHelper.login(this.env, this.companyId, this.bookYear);
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.companyId = this.panels.idDesc.getValue();
        this.bookYear = this.panels.currentBookYear.getValue();
        object.setSessionAttribute("ActiveCompany", (Object)this.companyId);
        object.setSessionAttribute("ActiveBookYear", (Object)this.bookYear);
        this.panels.initializeDimensionPanels();
        this.panels.useAccountingPrinciple2ChangeAction.execute(object);
        this.clearScreen(true, false, true);
        Header header = new Header("Title.CreateCompany", "screen_name");
        header.setHelpId("Title.CreateCompanyLabel.Dimensions");
        object.addUIObject((UIObject)header);
        header = new Header("Label.Dimensions", "sub_screen_name");
        object.addUIObject((UIObject)header);
        object.addUIObject((UIObject)this.panels.mainPanel);
        object.addUIObject((UIObject)this.panels.financialPanel);
        FloatBar fb = new FloatBar();
        fb.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createForm2"));
        Action action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleForm");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(this.cancel);
        object.addUIObject((UIObject)fb);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        String message = this.panels.validateCreateForm2();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        Object[] result = this.panels.create();
        message = (String)result[1];
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.company = (Company)result[0];
        this.activateCompany(object, this.company, this.user);
        this.table.setPointer("id", (Object)this.companyId, true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject createAccountingPrincipleFormNext(DataObject object) throws Exception {
        String message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        ++this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleFormPrevious(DataObject object) throws Exception {
        --this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        Header header = new Header(object.translate("Title.CreateCompany", object.getLocale()) + " - " + object.translate("Label.Valuation", object.getLocale()), "screen_name");
        header.setHelpId("Title.CreateCompanyLabel.Valuation");
        object.addUIObject((UIObject)header);
        header = new Header(this.panels.getAccountingPrincipleTabText(), "sub_screen_name");
        object.addUIObject((UIObject)header);
        object.addUIObject((UIObject)this.panels.mainPanel);
        object.addUIObject((UIObject)this.panels.apPanels[this.panels.apTabCount]);
        this.createAccountingPrincipleFloatBar(object);
        return object;
    }

    public void createAccountingPrincipleFloatBar(DataObject object) throws Exception {
        object.getScreen().removeUIObjects(FloatBar.class, false);
        FloatBar fbCreateAP = new FloatBar();
        Action action = this.panels.apTabCount == 0 ? new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createForm3") : new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormPrevious");
        fbCreateAP.addAction(action);
        if (this.panels.apTabCount == this.panels.apTabCountMax) {
            this.panels.jtTabCount = -1;
            action = this.getJournalingTabIndexNext(this.panels.jtTabCount) == -1 ? new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("create") : new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createJournalingTermFormNext");
        } else {
            action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormNext");
        }
        action.setDefault(true);
        action.setValidationEnabled(true);
        fbCreateAP.addAction(action);
        fbCreateAP.addAction(this.cancel);
        object.addUIObject((UIObject)fbCreateAP);
    }

    public DataObject createJournalingTermFormNext(DataObject object) throws Exception {
        ++this.panels.jtTabCount;
        if ("9".equals(this.panels.journalingMethod[this.panels.jtTabCount].getValue())) {
            this.createJournalingTermFormNext(object);
        }
        return this.createJournalingTermForm(object);
    }

    public DataObject createJournalingTermFormPrevious(DataObject object) throws Exception {
        --this.panels.jtTabCount;
        if ("9".equals(this.panels.journalingMethod[this.panels.jtTabCount].getValue())) {
            this.createJournalingTermFormPrevious(object);
        }
        return this.createJournalingTermForm(object);
    }

    private int getJournalingTabIndexNext(int index) throws Exception {
        int result = -1;
        ++index;
        while (index <= this.panels.jtTabCountMax) {
            if (!"9".equals(this.panels.journalingMethod[index].getValue())) {
                result = index;
            }
            ++index;
        }
        return result;
    }

    private int getJournalingTabIndexPrevious(int index) throws Exception {
        int result = -1;
        --index;
        while (index >= 0) {
            if (!"9".equals(this.panels.journalingMethod[index].getValue())) {
                result = index;
            }
            --index;
        }
        return result;
    }

    public DataObject createJournalingTermForm(DataObject object) throws Exception {
        String message;
        if (this.panels.jtTabCount == 0 && (message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount)) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.clearScreen(true, false, true);
        Header header = new Header(object.translate("Title.CreateCompany", object.getLocale()) + " - " + object.translate("Label.MainAccountScheme", object.getLocale()), "screen_name");
        header.setHelpId("Title.CreateCompanyLabel.MainAccountScheme");
        object.addUIObject((UIObject)header);
        header = new Header(this.panels.getJournalingTermTabText(), "sub_screen_name");
        object.addUIObject((UIObject)header);
        object.addUIObject((UIObject)this.panels.mainPanel);
        object.addUIObject((UIObject)this.panels.jtPanels[this.panels.jtTabCount]);
        FloatBar fbCreateJP = new FloatBar();
        Action action = this.getJournalingTabIndexPrevious(this.panels.jtTabCount) == -1 ? new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleForm") : new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createJournalingTermFormPrevious");
        fbCreateJP.addAction(action);
        action = this.getJournalingTabIndexNext(this.panels.jtTabCount) == -1 ? new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("create") : new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createJournalingTermFormNext");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fbCreateJP.addAction(action);
        fbCreateJP.addAction(this.cancel);
        object.addUIObject((UIObject)fbCreateJP);
        return object;
    }

    public DataObject initEditForm(DataObject object) throws Exception {
        this.company = (Company)TableHelper.getSelectedItem((DataObject)object);
        this.activateCompany(object, this.company, null);
        this.panels = new CompanyPanels(this.loginHelper, this.dbData, this.env, this.company.retrieveNumberOfPeriods(), this.governmentActivated, this.company);
        this.panels.setCompanyAdapter(this);
        if (!("".equals(this.env.getDIRCName1()) && "".equals(this.env.getDIRCName2()) && "".equals(this.env.getDIRCName3()) && "".equals(this.env.getDIRCName4()) && "".equals(this.env.getDIRCName5()))) {
            this.getProcess().setAttribute("DisinvestmentReasonMainAccountAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
            this.getProcess().setAttribute("DisinvestmentReasonMainAccountAdapterReturnMethod", (Object)"refreshCompanyAPDefaults");
            this.panels.setDisinvestmentReasonMainAccountAction(new Action("Label.DisinvestmentReasonCodes").setAdapter(this.getProcessAdapterPageName(DisinvestmentReasonMainAccountAdapter.PAGE)).setMethod("show"));
        }
        this.panels.setValues();
        this.getProcess().setAttribute("ProcessParametersAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("ProcessParametersAdapterReturnMethod", (Object)"editForm");
        if (this.dataSetId == null) {
            this.panels.addProcessParametersAction(new Action(this.processParametersActionName).setAdapter(this.getProcessAdapterPageName(ProcessParametersAdapter.PAGE)).setMethod("show"));
        }
        return this.editForm(object);
    }

    public DataObject refreshCompanyAPDefaults(DataObject object) throws Exception {
        this.panels.refreshCompanyAPDefaults();
        return object;
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.EditCompany", "screen_name"));
        object.addUIObject((UIObject)this.panels.mainPanel);
        object.addUIObject((UIObject)this.panels.mainTabPanel);
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        this.panels.mainTabActivateAction.execute(object);
        if (!object.getScreen().getUIObjects(Message.class, false).isEmpty()) {
            return object;
        }
        String message = this.panels.update();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.companyId = this.company.getId();
        this.table.setPointer("id", (Object)this.companyId, true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject report(DataObject object) throws Exception {
        this.companies = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (this.companies.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        for (int i = 0; i < this.companies.length; ++i) {
            this.company = (Company)this.companies[i];
            String[][] selections = new String[][]{{"User", this.loginHelper.getUser()}, {"System", this.loginHelper.getSystem()}, {"Password", Scrambler.scramble((String)this.loginHelper.getPassword())}, {"facLib", this.dbData.getSchema()}, {"governmentActivated", "" + this.governmentActivated}, {"Environment", this.env.getId()}, {"orderBy", "id"}, {"FromCompany", this.company.getId()}, {"ToCompany", this.company.getId()}};
            this.getProcess().setAttribute("selections", (Object)selections);
            this.getProcess().setAttribute("classNamePDF", (Object)CompanyReportAdapter.CLASSNAMEPDF);
            this.getProcess().setAttribute("jobName", (Object)"Job.Company");
            this.getProcess().setAttribute("returnPage", (Object)PAGE);
            object = ((SubmitAdapter)this.getProcess().getAdapterByName(SubmitAdapter.PAGE)).submit(object);
        }
        return object;
    }

    public DataObject reportAll(DataObject object) throws Exception {
        this.getProcess().setAttribute("returnPage", (Object)PAGE);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(CompanyReportAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.companies = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteCompanies", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.companies.length);
        for (int i = 0; i < this.companies.length; ++i) {
            list.add(this.companies[i]);
        }
        CollectionTable table = new CollectionTable(Company.class, list, 12);
        table.setName(PAGE);
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        this.activateCompany(object, null, this.user);
        String message = null;
        for (int i = 0; i < this.companies.length; ++i) {
            Company company = (Company)this.companies[i];
            if (company == null) continue;
            if (AssetTypeBO.hasAssetTypes(company)) {
                ExecutableQuery query = QueryFactory.create(AssetType.class);
                Collection assetTypes = AssetTypeManagerFactory.getInstance(this.dbData).getCollection(query);
                for (AssetType assetType : assetTypes) {
                    assetType.setAnalysisGroup1(null);
                    assetType.setAnalysisGroup2(null);
                    assetType.setAnalysisGroup3(null);
                    assetType.setAnalysisGroup4(null);
                    assetType.setAnalysisGroup5(null);
                    assetType.setAnalysisGroup6(null);
                    assetType.setAnalysisGroup7(null);
                    assetType.setAnalysisGroup8(null);
                    assetType.setAnalysisGroup9(null);
                    assetType.setAnalysisGroup10(null);
                }
            }
            if ((message = CompanyBO.delete(company)) == null) continue;
            object.addUIObject((UIObject)new Message(message, "error"));
        }
        if (message != null) {
            return object;
        }
        this.table = null;
        return this.show(object);
    }

    public DataObject confirmDeleteAllAssets(DataObject object) throws Exception {
        this.companies = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteAssets", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)this.fbDeleteAssets);
        return object;
    }

    public DataObject deleteAllAssets(DataObject object) throws Exception {
        for (int i = 0; i < this.companies.length; ++i) {
            Company company = (Company)this.companies[i];
            if (company == null) continue;
            AssetBO.deleteAllAssets(company);
        }
        return this.show(object);
    }

    public String getDescription() {
        return this.translate("Process.Companies");
    }

    public String getShortDescription() {
        return "Process.Companies.short";
    }

    private class MyTableRowMethod
    implements TableRowMethod {
        private MyTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            Company company = (Company)row.getObject();
            ProcessParameters parameters = (ProcessParameters)ProcessParametersBO.get(company.getDBData(), company.getId())[0];
            ContextMenu menu = new ContextMenu();
            for (int i = 0; i < rowActions.length; ++i) {
                ContextAction rowAction = new ContextAction(rowActions[i].getName());
                rowAction.setAdapter(rowActions[i].getPageid());
                rowAction.setMethod(rowActions[i].getMethod());
                rowAction.setLabel(rowActions[i].getLanguageCode());
                if (rowAction.getLanguageCode().equals("Button.DeleteAllAssets")) {
                    if (!parameters.getIsTestCompany()) continue;
                    menu.addContextMenuItem(new Separator());
                }
                if (rowAction.getLanguageCode().equals("Button.Delete") && !parameters.getIsTestCompany()) continue;
                menu.addContextMenuItem(rowAction);
            }
            row.setContextMenu(menu);
        }
    }
}

