/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.ObjectDataReader;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.AnalysisGroupHelper;
import nl.ibs.fac.adapters.AssetDimensionPanels;
import nl.ibs.fac.adapters.AssetField;
import nl.ibs.fac.adapters.AssetPanels;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.adapters.MemoAdapter;
import nl.ibs.fac.adapters.MemoImageTransformer;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.ParentAssetAdapter;
import nl.ibs.fac.adapters.ParentAssetImageTransformer;
import nl.ibs.fac.adapters.ParentReferenceField;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetDataReader;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.AssetBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.gov.adapters.ValuationMainAccountAdapter;
import nl.ibs.fac.gov.bp.GenericGovernmentBP;
import nl.ibs.fac.queries.AssetQuery;

public class CurrentCapitalizationAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -5404822667543452301L;
    public static final String PAGE = CurrentCapitalizationAdapter.class.getName();
    private Company company;
    private String cId;
    private AssetPanels panels;
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private String[] names2;
    private String[] labels2;
    private String[] searchNames;
    private String[] searchLabels2;
    private String[] shortLabels2;
    private short[] sizes2;
    private String[] types2;
    private Transformer[] transformers2;
    private static final String[] NAMES = new String[]{"id", "description", "typeId", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "parentId", "hasMemo"};
    private static final String[] TOOLTIPS = new String[]{"Label.ParentAsset", "Label.Memo"};
    private String[] labels;
    private String[] shortLabels;
    private static final int LEADING_LABELS = 3;
    private static final int FIN_DIM_LABELS = 5;
    private static final short[] SIZES = new short[]{100, 200, 100, 80, 80, 80, 80, 80, 20, 20};
    private String[] types = new String[]{null, null, null, null, null, null, null, null, null, null};
    private static final NumericIdTransformer NUMERIC_ID_TRANSFORMER = new NumericIdTransformer();
    private Transformer[] transformers;
    private static final boolean[] COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true};
    private Map inputComponents = new HashMap();
    private static final String CREATE = "create";
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbCreate = new FloatBar();
    private FloatBar fbEdit = new FloatBar();
    private FloatBar fbDelete = new FloatBar();
    private Action[] rowActions;
    private Action[] headerActions;
    private Asset asset;
    private ArrayList<Object> deleteList;
    private GenericGovernmentBP genericGovernmentBP;
    private FieldGroup maFieldGroup = null;

    public CurrentCapitalizationAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.labels = new String[]{"Label.Id", "Label.Description", "Label.Type", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5(), "Label.ParentAsset", "Label.Memo"};
        this.shortLabels = new String[]{"Label.Id", "Label.Description", "Label.Type", this.env.getShortName1(), this.env.getShortName2(), this.env.getShortName3(), this.env.getShortName4(), this.env.getShortName5(), "Label.ParentAsset", "Label.Memo"};
        this.transformers = new Transformer[]{null, null, null, null, null, null, null, null, new ParentAssetImageTransformer(this.company), new MemoImageTransformer()};
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        if (this.company.getUseValuationMainAccount()) {
            this.genericGovernmentBP = new GenericGovernmentBP(this.company);
        }
        this.cId = this.companyId;
        if (this.dataSetId != null) {
            this.cId = this.dataSetId;
        }
        if (this.env.getOperationArea().trim().length() == 0) {
            this.transformers[3] = NUMERIC_ID_TRANSFORMER;
            this.transformers[4] = NUMERIC_ID_TRANSFORMER;
            this.transformers[5] = NUMERIC_ID_TRANSFORMER;
            this.transformers[6] = NUMERIC_ID_TRANSFORMER;
            this.transformers[7] = NUMERIC_ID_TRANSFORMER;
            this.types[3] = "number";
            this.types[4] = "number";
            this.types[5] = "number";
            this.types[6] = "number";
            this.types[7] = "number";
        }
        this.modifyTableArrays();
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("refresh");
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initCreateForm");
        Action selectAll = new Action("Button.SelectAll").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("selectAll");
        Action activate = new Action("Button.Activate").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("activate");
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDelete");
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        this.fbShow.addAction(selectAll);
        this.fbShow.addAction(activate);
        this.fbShow.addAction(confirmDelete);
        this.fbShow.addAction(this.finish);
        this.headerActions = new Action[]{refresh, create, selectAll};
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initEditForm");
        Action memo = new Action("Label.Memo").setAdapter(this.getProcessAdapterPageName(MemoAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{edit, memo, confirmDelete};
        this.getProcess().setAttribute("MemoAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        Action createOK = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createDimensionsForm");
        createOK.setDefault(true);
        createOK.setValidationEnabled(true);
        this.fbCreate.addAction(this.back);
        this.fbCreate.addAction(createOK);
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("edit");
        editOK.setValidationEnabled(true);
        editOK.setDefault(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.cancel);
        this.fbEdit.addAction(this.finish);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("delete");
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.fbDelete.addAction(this.finish);
        this.inputComponents.put("id", new AssetField(this.company, false));
        this.inputComponents.put("typeId", new AssetTypeReferenceField(this.dbData, this.cId));
        this.inputComponents.put("parentId", new ParentReferenceField(this.company, false));
        Company dataSet = this.company;
        if (this.dataSetId != null) {
            dataSet = this.company.getDataSet();
        }
        AssetDimensionPanels dimensionPanels = new AssetDimensionPanels(this.loginHelper, this.dbData, this.env, this.company, false);
        FinancialReferenceField[] financialDimension = dimensionPanels.getFINDimensions();
        for (int i = 0; i < 5; ++i) {
            if (financialDimension[i] == null) continue;
            this.inputComponents.put(NAMES[i + 3], financialDimension[i]);
        }
        this.searchNames = NAMES;
        this.searchLabels2 = this.labels;
        Object[] result = AnalysisGroupHelper.addAnalysisGroups(this.loginHelper, this.env, dataSet, this.inputComponents, this.searchNames, this.searchLabels2);
        this.searchNames = (String[])result[0];
        this.searchLabels2 = (String[])result[1];
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CurrentCapitalizations", "screen_name"));
        this.asset = null;
        if (this.table == null) {
            this.createTable();
        } else {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        AssetQuery query = new AssetQuery(this.dbData, this.companyId, null, new Boolean(true), false, new Boolean(true), false, false);
        this.table = new ODBTable((ObjectDataReader)new AssetDataReader(), (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setTextCodeSingleObject("Label.Asset");
        this.table.setTextCodeMultipleObjects("Label.Assets");
        this.table.setColumnNames(this.names2);
        this.table.setColumnLabels(this.shortLabels2);
        this.table.setColumnSizes(this.sizes2);
        this.table.setColumnTypes(this.types2);
        this.table.setDisplayTransformers(this.transformers2);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setInputComponents(this.inputComponents);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        this.table.orderByColumn("id");
        this.searchPanel = this.table.createSearch(this.searchNames, this.searchLabels2);
        this.searchPanel.setCSSClass("headerPanel");
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        Action filterAction = this.table.createFilterAction(this.searchNames, this.searchLabels2, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
        this.getProcess().setAttribute("Table", (Object)this.table);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject initCreateForm(DataObject object) throws Exception {
        this.panels = new AssetPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.governmentActivated, null, false, false, true, null, false, null, null);
        this.maFieldGroup = null;
        this.getProcess().setAttribute("ParentAssetAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("ParentAssetAdapterReturnMethod", (Object)"createCommonForm");
        this.panels.fbParent.addAction(this.panels.getCreateParentAssetAction().setAdapter(this.getProcessAdapterPageName(ParentAssetAdapter.PAGE)).setMethod("initCreateForm"));
        return this.createCommonForm(object);
    }

    public DataObject createCommonForm(DataObject object) throws Exception {
        this.handleNewParent();
        this.panels.id.setReadonly(this.panels.idReadOnly);
        this.panels.id.setLabel("");
        this.panels.description.setReadonly(false);
        this.panels.description.setLabel("");
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateCurrentCapitalization", "screen_name"));
        object.addUIObject((UIObject)new Header("Label.Common", "sub_screen_name"));
        object.addUIObject((UIObject)this.panels.firstPanel);
        object.addUIObject((UIObject)this.panels.secondPanel);
        object.addUIObject((UIObject)this.fbCreate);
        return object;
    }

    public DataObject createDimensionsForm(DataObject object) throws Exception {
        String message;
        if (!this.panels.id.isHidden()) {
            Object[] result;
            if ("number".equals(this.panels.id.getType())) {
                try {
                    if (Integer.parseInt(this.panels.id.getValue()) <= 0) {
                        this.panels.id.setInvalidTag();
                        object.addUIObject((UIObject)new Message("value_must_be_positive", "error"));
                        return object;
                    }
                }
                catch (NumberFormatException nfe) {
                    this.panels.id.setInvalidTag();
                    object.addUIObject((UIObject)new Message("not_a_number", "error"));
                    return object;
                }
            }
            if ((result = AssetBO.get(this.company, this.panels.id.getValue().trim(), false))[0] != null) {
                this.panels.id.setInvalidTag();
                object.addUIObject((UIObject)new Message("duplicate_key", "error"));
                return object;
            }
        }
        if ((message = this.panels.validateCommonForm()) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.panels.id.setReadonly(true);
        this.panels.id.setLabel("Label.Id");
        this.panels.id.setHelpId("Label.AssetId");
        this.panels.description.setReadonly(true);
        this.panels.description.setLabel("Label.Description");
        this.panels.initializeType();
        this.panels.copyStartUsePeriod();
        return this.createDimensionsFormContinued(object);
    }

    public DataObject createDimensionsFormContinued(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateCurrentCapitalization", "screen_name"));
        object.addUIObject((UIObject)new Header("Label.Dimensions", "sub_screen_name"));
        object.addUIObject((UIObject)this.panels.headerPanel);
        object.addUIObject((UIObject)this.panels.finDimensionPanel);
        object.addUIObject((UIObject)this.panels.facDimensionPanel);
        FloatBar fb = new FloatBar();
        Action action = new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createCommonForm");
        fb.addAction(action);
        action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleForm");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(this.cancel);
        object.addUIObject((UIObject)fb);
        return object;
    }

    public DataObject createAccountingPrincipleFormNext(DataObject object) throws Exception {
        String message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        ++this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleFormPrevious(DataObject object) throws Exception {
        --this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleForm(DataObject object) throws Exception {
        this.panels.id.setReadonly(true);
        this.panels.description.setReadonly(true);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateCurrentCapitalization", "screen_name"));
        if (!this.env.getGovernmentActivated()) {
            object.addUIObject((UIObject)new Header(this.panels.getAccountingPrincipleTabText(), "sub_screen_name"));
        } else {
            object.addUIObject((UIObject)new Header("Label.Valuation_Short", "sub_screen_name"));
        }
        object.addUIObject((UIObject)this.panels.headerPanel);
        object.addUIObject((UIObject)this.panels.apPanels[this.panels.apTabCount]);
        this.panels.copyValues();
        FloatBar fbCreateAP = new FloatBar();
        Action action = this.panels.apTabCount == 0 ? new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createDimensionsFormContinued") : new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormPrevious");
        fbCreateAP.addAction(action);
        if (this.panels.apTabCount == this.panels.apTabCountMax) {
            if (!this.company.getUseValuationMainAccount()) {
                action = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATE);
                action.setDefault(true);
                action.setValidationEnabled(true);
                fbCreateAP.addAction(action);
            } else {
                action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createMainAccountForm");
                action.setDefault(true);
                action.setValidationEnabled(true);
                fbCreateAP.addAction(action);
            }
        } else {
            action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormNext");
            action.setDefault(true);
            action.setValidationEnabled(true);
            fbCreateAP.addAction(action);
        }
        fbCreateAP.addAction(this.cancel);
        object.addUIObject((UIObject)fbCreateAP);
        return object;
    }

    public DataObject createMainAccountForm(DataObject object) throws Exception {
        String message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        ++this.panels.apTabCount;
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateCurrentCapitalization", "screen_name"));
        object.addUIObject((UIObject)new Header("Label.MainAccounts", "sub_screen_name"));
        object.addUIObject((UIObject)this.panels.headerPanel);
        if (this.maFieldGroup == null) {
            this.maFieldGroup = this.genericGovernmentBP.getInitialMainAccountFieldGroup(this.loginHelper, this.panels.assetType, 1, this.panels.investmentYP.getBookYear().getIntValue(), this.panels.investmentYP.getPeriod().getIntValue());
        }
        object.addUIObject((UIObject)this.maFieldGroup);
        FloatBar fb = new FloatBar();
        fb.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormPrevious"));
        Action action = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATE);
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(this.cancel);
        object.addUIObject((UIObject)fb);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        String message;
        if (!this.company.getUseValuationMainAccount()) {
            message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return object;
            }
        } else {
            this.panels.mainAccountIds = this.genericGovernmentBP.getFormattedMainAccountIds();
        }
        this.asset = null;
        Object[] result = new AssetBP(this.panels).create(null, null, false);
        message = (String)result[1];
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.asset = (Asset)result[0];
        this.table.setPointer("id", (Object)((Asset)result[0]).getId(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject activate(DataObject object) throws Exception {
        Object[] assets = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        for (int i = 0; i < assets.length; ++i) {
            String message;
            this.asset = (Asset)assets[i];
            if (this.asset == null || (message = AssetBP.activate(this.asset)) == null) continue;
            object.addUIObject((UIObject)new Message(message, "error"));
        }
        this.table = null;
        return this.show(object);
    }

    public DataObject selectAll(DataObject object) throws Exception {
        TableHelper.selectAllRows((AbstractTable)this.table, (DataObject)object);
        return object;
    }

    public DataObject initEditForm(DataObject object) throws Exception {
        this.asset = (Asset)TableHelper.getSelectedItem((DataObject)object);
        this.panels = new AssetPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.governmentActivated, this.asset, false, false, true, null, false, null, null);
        this.panels.setValues();
        if (this.governmentActivated && this.asset.getLoan()) {
            this.panels.updateSecondPanelLabels();
            this.panels.updateAccountingPrincipleForms(true);
        }
        this.getProcess().setAttribute("ParentAssetAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("ParentAssetAdapterReturnMethod", (Object)"editForm");
        this.panels.fbParent.removeAction("+");
        this.panels.fbParent.addAction(new Action("+").setAdapter(this.getProcessAdapterPageName(ParentAssetAdapter.PAGE)).setMethod("initCreateForm"));
        if (this.company.getUseValuationMainAccount()) {
            this.getProcess().setAttribute("asset", (Object)this.asset);
            this.panels.addMainAccountAction(new Action("Label.MainAccountScheme").setAdapter(this.getProcessAdapterPageName(ValuationMainAccountAdapter.PAGE)).setMethod("show"));
        }
        return this.editForm(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.handleNewParent();
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.EditCurrentCapitalization", "screen_name"));
        object.addUIObject((UIObject)this.panels.headerPanel);
        object.addUIObject((UIObject)this.panels.mainTabPanel);
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = this.panels.update();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("id", (Object)this.asset.getId(), true);
        this.table.reload();
        return this.show(object);
    }

    private void handleNewParent() throws Exception {
        Object newParentId = this.getProcess().getAttribute("NewParentId");
        if (newParentId != null) {
            this.panels.setNewParent(newParentId.toString(), this.getProcess().getAttribute("NewParentDescription").toString());
            this.getProcess().removeAttribute("NewParentId");
            this.getProcess().removeAttribute("NewParentDescription");
        }
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteCurrentCapitalizations", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable(object));
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable(DataObject object) throws Exception {
        Object[] assets = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        this.deleteList = new ArrayList(assets.length);
        for (int i = 0; i < assets.length; ++i) {
            this.deleteList.add(assets[i]);
        }
        CollectionTable table = new CollectionTable(Asset.class, this.deleteList, 12);
        table.setName(PAGE);
        table.setColumnNames(this.names2);
        table.setColumnLabels(this.shortLabels2);
        table.orderByColumn(this.names2[0]);
        table.setColumnSizes(this.sizes2);
        table.setColumnTypes(this.types2);
        table.setDisplayTransformers(this.transformers2);
        table.setSortable(true);
        table.reload();
        TableHelper.setHeaderTooltips((CommonTable)table, (String[])TOOLTIPS);
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        Object[] assets = this.deleteList.toArray();
        for (int i = 0; i < assets.length; ++i) {
            Asset asset = (Asset)assets[i];
            if (asset == null || (message = AssetBO.delete(asset)) == null) continue;
            object.addUIObject((UIObject)new Message(message, "error"));
        }
        if (message != null) {
            return object;
        }
        this.table = null;
        return this.show(object);
    }

    private void modifyTableArrays() throws Exception {
        if (AssetBO.isIdNumeric(this.company, false)) {
            this.types[0] = "number";
            this.types[8] = "number";
            this.transformers[0] = NUMERIC_ID_TRANSFORMER;
            this.transformers[8] = NUMERIC_ID_TRANSFORMER;
        }
        int[] finDimUsage = new int[]{this.company.retrieveFinancialDimension1Usage(), this.company.retrieveFinancialDimension2Usage(), this.company.retrieveFinancialDimension3Usage(), this.company.retrieveFinancialDimension4Usage(), this.company.retrieveFinancialDimension5Usage()};
        int oldArrayLength = NAMES.length;
        int newArrayLength = NAMES.length;
        for (int i = 0; i < 5; ++i) {
            if (finDimUsage[i] != 0) continue;
            --newArrayLength;
        }
        if (newArrayLength == oldArrayLength) {
            this.names2 = NAMES;
            this.labels2 = this.labels;
            this.shortLabels2 = this.shortLabels;
            this.sizes2 = SIZES;
            this.types2 = this.types;
            this.transformers2 = this.transformers;
            return;
        }
        this.names2 = new String[newArrayLength];
        this.labels2 = new String[newArrayLength];
        this.shortLabels2 = new String[newArrayLength];
        this.sizes2 = new short[newArrayLength];
        this.types2 = new String[newArrayLength];
        this.transformers2 = new Transformer[newArrayLength];
        int j = 0;
        for (int i = 0; i < oldArrayLength; ++i) {
            if (i >= 3 && i < 8 && finDimUsage[i - 3] == 0) continue;
            this.names2[j] = NAMES[i];
            this.labels2[j] = this.labels[i];
            this.shortLabels2[j] = this.shortLabels[i];
            this.sizes2[j] = SIZES[i];
            this.types2[j] = this.types[i];
            this.transformers2[j] = this.transformers[i];
            ++j;
        }
    }
}

