/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.Calendar;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.DateSelectionField;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.adapters.TransactionBatchTransactionAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.ProcessParametersBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.commands.CompanyCurrentBatchCreateCommand;
import nl.ibs.fac.commands.TransactionBatchBookCommand;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.ProcessParameters;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.session.StartStopServlet;
import nl.ibs.util.Scrambler;

public class CurrentTransactionBatchPostAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 4567100255054802958L;
    public static final String PAGE = CurrentTransactionBatchPostAdapter.class.getName();
    private Company company;
    private static final String TITLE = "Title.PostCurrentTransactionBatch";
    private static final String PREPROCESSOR = CompanyCurrentBatchCreateCommand.CLASSNAME;
    private static final String JOBNAME = "Job.BookTransactionBatch";
    private static final String CLASSNAME = TransactionBatchBookCommand.CLASSNAME;
    private Panel headerPanel;
    private TransactionBatch transactionBatch;
    private BookYearPeriodGrid periodGrid;
    private boolean belgianWayOfLiving = false;
    private Field voucherNumber;
    private DateSelectionField voucherDate;

    public CurrentTransactionBatchPostAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        Integer batchId = this.company.getCurrentBatchId();
        if (batchId == null) {
            object.addUIObject((UIObject)new Message(LanguageHelper.getString("nl.ibs.fac.language", "batch_not_found"), "error"));
            return this.finish(object);
        }
        this.transactionBatch = (TransactionBatch)TransactionBatchBO.get(this.dbData, this.companyId, batchId)[0];
        if (TransactionBO.getFirstTransaction(this.transactionBatch) == null) {
            object.addUIObject((UIObject)new Message(LanguageHelper.getString("nl.ibs.fac.language", "batch_is_empty"), "error"));
            return this.finish(object);
        }
        this.headerPanel = TransactionBatchTransactionAdapter.getHeaderPanel(this.transactionBatch);
        ProcessParameters pp = (ProcessParameters)ProcessParametersBO.get(this.dbData, this.companyId)[0];
        if (pp.getStandardVoucherDate() == 5) {
            this.belgianWayOfLiving = true;
            this.voucherNumber = new Field("Label.VoucherId", "number");
            this.voucherNumber.setLength(6);
            this.voucherNumber.setMaxLength(6);
            this.voucherNumber.setMandatory(true);
            this.voucherDate = new DateSelectionField("Label.VoucherDate");
            this.voucherDate.setValue(Calendar.getInstance().getTime());
            this.voucherDate.setMandatory(true);
            this.headerPanel.addUIObject((UIObject)this.voucherDate);
            this.headerPanel.addUIObject((UIObject)this.voucherNumber);
        }
        this.periodGrid = new BookYearPeriodGrid("Label.DaybookPeriod", this.bookYearMax, this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        int year = this.company.getLastDepreciationRunYear();
        int period = 0;
        if (year > 0) {
            period = this.company.getLastDepreciationRunPeriod();
        } else {
            year = this.company.getCurrentBookYear();
            period = 1;
        }
        this.periodGrid.setValues("" + year, "" + period);
        this.headerPanel.addUIObject((UIObject)this.periodGrid);
        FloatBar floatBar = new FloatBar();
        Action submit = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("submit");
        submit.setValidationEnabled(true);
        submit.setDefault(true);
        floatBar.addAction(submit);
        floatBar.addAction(this.finish);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        object.addUIObject((UIObject)this.headerPanel);
        object.addUIObject((UIObject)floatBar);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        BookYearBO.synchronizeWithFinancials(this.loginHelper, this.env, this.company);
        this.transactionBatch.setEndYear(this.periodGrid.getBookYear().getIntValue());
        this.transactionBatch.setEndPeriod(this.periodGrid.getPeriod().getIntValue());
        this.periodGrid.setMandatory(false);
        this.periodGrid.setReadonly(true);
        if (this.belgianWayOfLiving) {
            this.transactionBatch.setVoucherId(this.voucherNumber.getValue());
            this.transactionBatch.setVoucherDate(this.voucherDate.getValueAsDate());
            this.voucherNumber.setMandatory(false);
            this.voucherNumber.setReadonly(true);
            this.voucherDate.setMandatory(false);
            this.voucherDate.setReadonly(true);
        }
        this.transactionBatch.setState(1);
        this.getProcess().setAttribute("preprocessor", (Object)PREPROCESSOR);
        String[][] selections = new String[][]{{"facLib", this.dbData.getSchema()}, {"System", this.loginHelper.getSystem()}, {"User", this.loginHelper.getUser()}, {"Password", Scrambler.scramble((String)this.loginHelper.getPassword())}, {"operationArea", this.env.getOperationArea().trim()}, {"dataLib", this.env.getDataLib().trim()}, {"programLib", this.env.getProgramLib().trim()}, {"object_lib", StartStopServlet.getObjectLibrary()}, {"Environment", this.env.getId()}, {"Company", this.companyId}, {"batchId", "" + this.transactionBatch.getBatchId()}};
        this.getProcess().setAttribute("title", (Object)TITLE);
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("className", (Object)CLASSNAME);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("header", (Object)this.headerPanel);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }
}

