/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.Calendar;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.DateSelectionField;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.adapters.TransactionBatchTransactionAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.ProcessParametersBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.commands.DepreciationProposalPostCommand;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.ProcessParameters;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.session.StartStopServlet;
import nl.ibs.util.Scrambler;

public class DepreciationProposalPostAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 2339683653360786171L;
    public static final String PAGE = DepreciationProposalPostAdapter.class.getName();
    private static final String TITLE = "Title.PostDepreciationProposal";
    private static final String CLASSNAME = DepreciationProposalPostCommand.CLASSNAME;
    private static final String JOBNAME = "Job.PostDepreciationProposal";
    private Company company;
    private Panel headerPanel;
    private TransactionBatch transactionBatch;
    private boolean belgianWayOfLiving = false;
    private FieldGroup fieldGroup;
    private Field voucherNumber;
    private DateSelectionField voucherDate;

    public DepreciationProposalPostAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.transactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(this.dbData, this.companyId);
        if (this.transactionBatch == null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "batch_not_found");
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.finish(object);
        }
        if (TransactionBO.getFirstTransaction(this.transactionBatch) == null) {
            object.addUIObject((UIObject)new Message(LanguageHelper.getString("nl.ibs.fac.language", "batch_is_empty"), "error"));
            return this.finish(object);
        }
        this.headerPanel = TransactionBatchTransactionAdapter.getHeaderPanel(this.transactionBatch);
        ProcessParameters pp = (ProcessParameters)ProcessParametersBO.get(this.dbData, this.companyId)[0];
        if (pp.getStandardVoucherDate() == 5) {
            this.belgianWayOfLiving = true;
            return this.showWithAdditionalAttributes(object);
        }
        return this.submit(object);
    }

    public DataObject showWithAdditionalAttributes(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        this.fieldGroup = new FieldGroup("", 200, 0);
        this.fieldGroup.forceBorder(true);
        this.voucherNumber = new Field("Label.VoucherId", "number");
        this.voucherNumber.setLength(6);
        this.voucherNumber.setMaxLength(6);
        this.voucherNumber.setMandatory(true);
        this.voucherDate = new DateSelectionField("Label.VoucherDate");
        this.voucherDate.setValue(Calendar.getInstance().getTime());
        this.voucherDate.setMandatory(true);
        this.fieldGroup.add((Field)this.voucherDate);
        this.fieldGroup.add(this.voucherNumber);
        FloatBar floatBar = new FloatBar();
        Action submit = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("submit");
        submit.setValidationEnabled(true);
        submit.setDefault(true);
        floatBar.addAction(submit);
        floatBar.addAction(this.finish);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        object.addUIObject((UIObject)this.headerPanel);
        object.addUIObject((UIObject)this.fieldGroup);
        object.addUIObject((UIObject)floatBar);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        BookYearBO.synchronizeWithFinancials(this.loginHelper, this.env, this.company);
        if (this.belgianWayOfLiving) {
            this.transactionBatch.setVoucherId(this.voucherNumber.getValue());
            this.transactionBatch.setVoucherDate(this.voucherDate.getValueAsDate());
            this.voucherNumber.setMandatory(false);
            this.voucherNumber.setReadonly(true);
            this.voucherDate.setMandatory(false);
            this.voucherDate.setReadonly(true);
            this.headerPanel.addUIObject((UIObject)this.voucherDate);
            this.headerPanel.addUIObject((UIObject)this.voucherNumber);
        }
        StringBuffer msg = new StringBuffer();
        for (int ap = 1; ap <= 2; ++ap) {
            int err = ap == 1 ? TransactionBatchBO.numberOfSevereErrors(this.companyId, ap, this.transactionBatch, false) : TransactionBatchBO.numberOfSevereErrors(this.companyId, ap, this.transactionBatch, this.governmentActivated);
            if (err <= 0) continue;
            String apDescription = ap == 1 ? this.env.getAPName1() : (this.governmentActivated ? this.env.getAPName3() : this.env.getAPName2());
            msg.append(object.translate("Label.DepreciationProposal", object.getLocale()) + " " + apDescription + " " + object.translate("Label.IsInError", object.getLocale()) + ". ");
        }
        if (msg.length() > 0) {
            msg.append(object.translate("Label.GoOn", object.getLocale()));
            this.getProcess().setAttribute("confirmationMessage", (Object)msg.toString());
        }
        String[][] selections = new String[][]{{"facLib", this.dbData.getSchema()}, {"System", this.loginHelper.getSystem()}, {"User", this.loginHelper.getUser()}, {"Password", Scrambler.scramble((String)this.loginHelper.getPassword())}, {"operationArea", this.env.getOperationArea().trim()}, {"dataLib", this.env.getDataLib().trim()}, {"programLib", this.env.getProgramLib().trim()}, {"object_lib", StartStopServlet.getObjectLibrary()}, {"Environment", this.env.getId()}, {"Company", this.companyId}, {"governmentActivated", "" + this.governmentActivated}};
        this.getProcess().setAttribute("title", (Object)TITLE);
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("className", (Object)CLASSNAME);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("header", (Object)this.headerPanel);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }
}

