/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.fac.adapters.EnvironmentPanels;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.queries.EnvironmentQuery;

public class EnvironmentAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 5351420532423933482L;
    public static final String PAGE = EnvironmentAdapter.class.getName();
    private EnvironmentPanels panels;
    private FloatBar fbShow;
    private FloatBar fbCreate;
    private FloatBar fbEdit;
    private FloatBar fbDelete;
    private Action[] rowActions;
    private Action[] headerActions;
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES = new String[]{"facLib", "description", "operationArea", "dataLib", "programLib"};
    private static final String[] LABELS = new String[]{"Label.Environment", "Label.Description", "Label.OperationArea.short", "Label.DataLib.short", "Label.ProgramLib.short"};
    private static final short[] SIZES = new short[]{90, 290, 70, 90, 90};
    private Object[] environments;
    private boolean isFACSYSBEH;

    public EnvironmentAdapter(ESPProcess process, DataObject object, boolean isFACSYSBEH) throws Exception {
        super(process, object);
        this.isFACSYSBEH = isFACSYSBEH;
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.activateEnvironment(object, null);
        this.fbShow = new FloatBar();
        this.fbCreate = new FloatBar();
        this.fbDelete = new FloatBar();
        this.fbEdit = new FloatBar();
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("refresh");
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initCreateForm");
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDelete");
        this.fbShow.addAction(refresh);
        if (this.isFACSYSBEH) {
            this.fbShow.addAction(create);
            this.fbShow.addAction(confirmDelete);
        }
        this.fbShow.addAction(this.finish);
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initEditForm");
        if (!this.isFACSYSBEH) {
            this.rowActions = new Action[]{edit};
            this.headerActions = new Action[]{refresh};
        } else {
            this.rowActions = new Action[]{confirmDelete};
            this.headerActions = new Action[]{refresh, create};
        }
        Action createOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("create");
        createOK.setDefault(true);
        createOK.setValidationEnabled(true);
        this.fbCreate.addAction(createOK);
        this.fbCreate.addAction(this.cancel);
        this.fbCreate.addAction(this.finish);
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("edit");
        editOK.setDefault(true);
        editOK.setValidationEnabled(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.cancel);
        this.fbEdit.addAction(this.finish);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("delete");
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.fbDelete.addAction(this.finish);
    }

    public DataObject initCreateForm(DataObject object) throws Exception {
        this.panels = new EnvironmentPanels(this.loginHelper, this.dbData, null);
        return this.createForm(object);
    }

    public DataObject createForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateEnvironment", "screen_name"));
        object.addUIObject((UIObject)this.panels.header);
        object.addUIObject((UIObject)this.panels.fms);
        object.addUIObject((UIObject)this.panels.fis);
        object.addUIObject((UIObject)this.fbCreate);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        Object[] result = this.panels.create();
        String message = (String)result[1];
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        Environment env = (Environment)result[0];
        this.table.setPointer("facLib", (Object)env.getFacLib(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject initEditForm(DataObject object) throws Exception {
        this.env = (Environment)TableHelper.getSelectedItem((DataObject)object);
        this.dbData = EnvironmentBO.getDBData(this.env.getFacLib());
        this.panels = new EnvironmentPanels(this.loginHelper, this.dbData, this.env);
        this.panels.setValues();
        this.panels.modifyFieldAttributes(object);
        return this.editForm(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.EditEnvironment", "screen_name"));
        object.addUIObject((UIObject)this.panels.header);
        object.addUIObject((UIObject)this.panels.mainTabPanel);
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = this.panels.update();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("facLib", (Object)this.env.getFacLib(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.Environments", "screen_name"));
        if (this.table == null) {
            this.createTable();
        } else if (this.table.isSelectable()) {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        EnvironmentQuery query = new EnvironmentQuery();
        this.table = new ODBTable(Environment.class, (ODBQuery)query, new String[]{"facLib"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        this.table.orderByColumn(NAMES[0]);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        if (this.isFACSYSBEH) {
            this.table.setRowAction(null);
        }
        this.searchPanel = this.table.createSearch(NAMES, LABELS);
        this.searchPanel.setCSSClass("headerpanel");
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.environments = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteEnvironments", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.environments.length);
        for (int i = 0; i < this.environments.length; ++i) {
            list.add(this.environments[i]);
        }
        CollectionTable table = new CollectionTable(Environment.class, list, 12);
        table.setName(PAGE);
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        for (int i = 0; i < this.environments.length; ++i) {
            Environment env = (Environment)this.environments[i];
            if (env == null || (message = EnvironmentBO.delete(env)) == null) continue;
            object.addUIObject((UIObject)new Message(message, "error"));
        }
        if (message != null) {
            return object;
        }
        this.table = null;
        return this.show(object);
    }
}

