/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandCall;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.language.TranslationHelperImpl;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.CollectionReferenceField;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabActivateAction;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.DepreciationMethodEnum;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.InterestCalculationMethodEnum;
import nl.ibs.fac.JournalingMethodEnum;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.StartPeriodHandlingEnum;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.InterestTableReferenceField;
import nl.ibs.fac.adapters.YearPercentageTableReferenceField;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.InterestTableBO;
import nl.ibs.fac.boadapters.YearPercentageTableBO;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.EnvironmentAccountingPrincipleDefault;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.YearPercentageTable;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.NameValuePair;

public class EnvironmentPanels
implements Serializable {
    private static final long serialVersionUID = -4640592472533039362L;
    private LoginHelper loginHelper;
    private DBData dbData = null;
    private Environment env = null;
    private boolean governmentActivated = false;
    private String message = null;
    protected Panel header;
    private Field facLib;
    private Field envDescription;
    protected FieldGroup fms = null;
    private CollectionReferenceField operationArea;
    private CheckBox isGovernment;
    protected FieldGroup fis = null;
    private Field dataLib;
    private Field programLib;
    protected TabbedPanel mainTabPanel;
    private Tab commonTab;
    private FieldGroup fgDims;
    private Field[] names = new Field[17];
    private Field[] shortNames = new Field[17];
    private FieldGroup fgAps;
    private Field[] apNames = new Field[4];
    private Field[] apShortNames = new Field[4];
    private CheckBox useAccountingPrinciple2;
    private Tab miscTab;
    private FieldGroup fgMiscDC;
    private FieldGroup fgMiscCMS;
    private FieldGroup fgOther;
    private FieldGroup fgDirc;
    private Field bespokeWorkLib;
    private TabbedPanel apTabbedPanel;
    private Tab[] apTabs = new Tab[3];
    private FieldGroup[] depreciationGroups = new FieldGroup[3];
    private CheckBox[] calculateDepreciation = new CheckBox[3];
    private ComboBox[] depreciationMethod = new ComboBox[3];
    private ComboBox[] startPeriodHandlingMethod = new ComboBox[3];
    private FACDecimalField[] degressivePercentage = new FACDecimalField[3];
    private ODBQueryReferenceField[] yearPercentageTableId = new ODBQueryReferenceField[3];
    private ODBQueryReferenceField[] annuityInterestTableId = new ODBQueryReferenceField[3];
    private FACDecimalField[] annuityPercentage = new FACDecimalField[3];
    private FieldGroup[] interestGroups = new FieldGroup[3];
    private CheckBox[] calculateInterest = new CheckBox[3];
    private ComboBox[] interestCalculationMethod = new ComboBox[3];
    private FACDecimalField[] interestPercentage = new FACDecimalField[3];
    private ODBQueryReferenceField[] interestTableId = new ODBQueryReferenceField[3];
    private FieldGroup[] journalingGroups = new FieldGroup[3];
    private ComboBox[] journalingMethod = new ComboBox[3];
    private CalculateDepreciationChangeAction[] calculateDepreciationChangeAction = new CalculateDepreciationChangeAction[3];
    private CalculateInterestChangeAction[] calculateInterestChangeAction = new CalculateInterestChangeAction[3];
    private DepreciationMethodChangeAction[] depreciationMethodChangeAction = new DepreciationMethodChangeAction[3];
    private InterestCalculationMethodChangeAction[] interestCalculationMethodChangeAction = new InterestCalculationMethodChangeAction[3];
    private Tab apTab;
    private String[] apTabTexts = new String[3];
    private int mode = 0;
    private static final int NEW = 0;
    private static final int UPDATE = 1;
    private EnvironmentAccountingPrincipleDefault[] accountingPrincipleDefault = new EnvironmentAccountingPrincipleDefault[4];
    private static final String[] NAMES = new String[]{"name", "value"};
    private static final String[] LABELS = new String[]{"Label.OperationArea", "Label.Description"};
    private static final short[] SIZES = new short[]{150, 300};
    private int apTabCountMax = 0;

    public EnvironmentPanels(LoginHelper loginHelper, DBData dbData, Environment env) throws Exception {
        this.loginHelper = loginHelper;
        this.dbData = dbData;
        this.env = env;
        this.mode = env == null ? 0 : 1;
        this.initialize();
    }

    private void initialize() throws Exception {
        if (this.mode == 0) {
            this.initializeCreateForm();
        } else {
            this.apTabTexts[0] = this.env.getAPShortName1();
            this.apTabTexts[1] = this.env.getAPShortName2();
            this.apTabTexts[2] = this.env.getAPShortName3();
            this.mainTabPanel = new TabbedPanel();
            this.commonTab = new Tab("Label.Common");
            this.miscTab = new Tab("Label.Miscellaneous");
            this.initializeEditForm();
            this.commonTab.add(this.fgDims);
            this.commonTab.add(this.fgAps);
            this.mainTabPanel.add(this.commonTab, (TabActivateAction)new CommonTabActivateAction(this.commonTab, this.mainTabPanel));
            this.miscTab.add(this.fgMiscDC);
            this.miscTab.add(this.fgDirc);
            this.mainTabPanel.add(this.miscTab, (TabActivateAction)new MiscTabActivateAction(this.miscTab, this.mainTabPanel));
            this.apTab = new Tab("Label.Valuation");
            this.apTab.add(this.apTabbedPanel);
            this.mainTabPanel.add(this.apTab);
            this.mainTabPanel.setWidth(600);
            this.initializeAccountingPrincipleForms();
        }
    }

    private void initializeCreateForm() throws Exception {
        this.header = new HeaderPanel();
        this.facLib = new Field("Label.FACDataLib", "upper");
        this.facLib.setLength(10);
        this.facLib.setMaxLength(10);
        this.facLib.setMandatory(true);
        this.header.addUIObject((UIObject)this.facLib);
        this.envDescription = new Field("Label.Description");
        this.envDescription.setLength(50);
        this.header.addUIObject((UIObject)this.envDescription);
        this.createFMSGroup();
        this.createFISGroup();
    }

    private void createFMSGroup() throws Exception {
        FMSHelper helper = new FMSHelper(this.loginHelper);
        helper.login(null, null, null);
        this.message = helper.getMessage();
        if (this.message != null && !"".equals(this.message.trim())) {
            Log.warn((String)this.message);
        } else {
            List list = helper.getOperationAreas();
            helper.logout(null, null, null);
            this.operationArea = new CollectionReferenceField(LABELS[0], "upper", (Collection)list, NameValuePair.class);
            this.operationArea.setLength(3);
            this.operationArea.setMaxLength(3);
            this.operationArea.setValueField(NAMES[0]);
            this.operationArea.setDescriptionField(NAMES[1]);
            this.operationArea.setDescriptionLength(40);
            this.operationArea.setTableFields(NAMES);
            this.operationArea.setTableHeaderLabels(LABELS);
            this.operationArea.setTableHeaderSizes(SIZES);
            this.fms = new FieldGroup("FMS");
            this.fms.add((Field)this.operationArea);
            this.isGovernment = new CheckBox("Label.GOVImplementation");
            this.fms.add(this.isGovernment);
        }
    }

    private void createFISGroup() throws Exception {
        this.dataLib = new Field("Label.DataLib", "upper");
        this.dataLib.setLength(10);
        this.dataLib.setMaxLength(10);
        this.programLib = new Field("Label.ProgramLib", "upper");
        this.programLib.setLength(10);
        this.programLib.setMaxLength(10);
        this.fis = new FieldGroup("FIS2000");
        this.fis.add(this.dataLib);
        this.fis.add(this.programLib);
    }

    protected Object[] create() throws Exception {
        Object[] result = null;
        if (this.fis != null && this.fms == null) {
            new CommandCall((AS400)this.loginHelper.getAs400()).run("ADDLIBLE " + this.programLib.getValue().trim());
            result = EnvironmentBO.checkActivated(this.loginHelper, "", false);
        }
        if (this.fis == null && this.fms != null) {
            result = EnvironmentBO.checkActivated(this.loginHelper, this.operationArea.getValue(), this.isGovernment.getValueAsBoolean());
        }
        if (this.fis != null && this.fms != null) {
            if (this.operationArea.getValue().trim().length() == 0) {
                new CommandCall((AS400)this.loginHelper.getAs400()).run("ADDLIBLE " + this.programLib.getValue().trim());
                result = EnvironmentBO.checkActivated(this.loginHelper, "", false);
            } else {
                result = EnvironmentBO.checkActivated(this.loginHelper, this.operationArea.getValue(), this.isGovernment.getValueAsBoolean());
            }
        }
        if (result[0] != null && result[1] == null) {
            String message = (String)result[0];
            result = new Object[2];
            result[1] = message;
            return result;
        }
        if (this.fis != null && this.fms == null) {
            result = EnvironmentBO.create(this.loginHelper, this.facLib.getValue().trim(), "", this.dataLib.getValue().trim(), this.programLib.getValue().trim(), this.envDescription.getValue().trim(), false);
        }
        if (this.fis == null && this.fms != null) {
            result = EnvironmentBO.create(this.loginHelper, this.facLib.getValue().trim(), this.operationArea.getValue().trim(), "", "", this.envDescription.getValue().trim(), this.isGovernment.getValueAsBoolean());
        }
        if (this.fis != null && this.fms != null) {
            result = EnvironmentBO.create(this.loginHelper, this.facLib.getValue().trim(), this.operationArea.getValue().trim(), this.dataLib.getValue().trim(), this.programLib.getValue().trim(), this.envDescription.getValue().trim(), this.isGovernment.getValueAsBoolean());
        }
        return result;
    }

    private void initializeEditForm() throws Exception {
        Object[] result;
        int i;
        this.header = new HeaderPanel();
        this.facLib = new Field("Label.FACDataLib");
        this.facLib.setLength(10);
        this.facLib.setReadonly(true);
        this.header.addUIObject((UIObject)this.facLib);
        this.envDescription = new Field("Label.Description");
        this.envDescription.setLength(50);
        this.header.addUIObject((UIObject)this.envDescription);
        this.programLib = new Field("Label.ProgramLib", "upper");
        this.programLib.setLength(10);
        this.programLib.setMaxLength(10);
        if (this.env.getOperationArea().trim().length() == 0) {
            this.header.addUIObject((UIObject)this.programLib);
        }
        this.fgDims = new FieldGroup("Label.Dimensions");
        ESPGridLayout gridLayout = new ESPGridLayout();
        this.fgDims.add(gridLayout);
        gridLayout.add((UIObject)new Label("Label.Name"), 0, 0);
        gridLayout.add((UIObject)new Label("Label.ShortName"), 0, 1);
        for (i = 0; i < 5; ++i) {
            this.names[i] = new Field();
            this.shortNames[i] = new Field();
            if (i == 4 && this.env.getOperationArea().trim().length() > 0) continue;
            this.names[i].setMandatory(true);
            this.names[i].setLength(35);
            this.names[i].setMaxLength(35);
            gridLayout.add((UIObject)this.names[i], i + 1, 0);
            this.shortNames[i].setMandatory(true);
            this.shortNames[i].setLength(15);
            this.shortNames[i].setMaxLength(15);
            gridLayout.add((UIObject)this.shortNames[i], i + 1, 1);
        }
        this.fgMiscDC = new FieldGroup("");
        gridLayout = new ESPGridLayout();
        this.fgMiscDC.add(gridLayout);
        gridLayout.add((UIObject)new Label("Label.Name"), 0, 0);
        gridLayout.add((UIObject)new Label("Label.ShortName"), 0, 1);
        for (i = 5; i < 8; ++i) {
            this.names[i] = new Field();
            this.shortNames[i] = new Field();
            if (i == 7) {
                if (this.env.getOperationArea().trim().length() > 0) {
                    this.fgMiscDC.setLabel("FMS");
                } else {
                    this.fgMiscDC.setLabel("FIS2000");
                    continue;
                }
            }
            this.names[i].setMandatory(true);
            this.names[i].setLength(35);
            this.names[i].setMaxLength(35);
            this.shortNames[i].setMandatory(true);
            this.shortNames[i].setLength(15);
            this.shortNames[i].setMaxLength(15);
            gridLayout.add((UIObject)this.names[i], i - 4, 0);
            gridLayout.add((UIObject)this.shortNames[i], i - 4, 1);
        }
        this.fgMiscCMS = new FieldGroup("CMS / PRS");
        gridLayout = new ESPGridLayout();
        this.fgMiscCMS.add(gridLayout);
        gridLayout.add((UIObject)new Label("Label.Name"), 0, 0);
        gridLayout.add((UIObject)new Label("Label.ShortName"), 0, 1);
        for (i = 8; i < 11; ++i) {
            this.names[i] = new Field();
            this.names[i].setReadonly(true);
            this.names[i].setLength(35);
            this.names[i].setMaxLength(35);
            this.shortNames[i] = new Field();
            this.shortNames[i].setReadonly(true);
            this.shortNames[i].setLength(15);
            this.shortNames[i].setMaxLength(15);
            gridLayout.add((UIObject)this.names[i], i - 7, 0);
            gridLayout.add((UIObject)this.shortNames[i], i - 7, 1);
        }
        this.fgDirc = new FieldGroup("Label.DisinvestmentReasonCodes");
        gridLayout = new ESPGridLayout();
        this.fgDirc.add(gridLayout);
        gridLayout.add((UIObject)new Label("Label.Name"), 0, 0);
        gridLayout.add((UIObject)new Label("Label.ShortName"), 0, 1);
        for (i = 11; i < 17; ++i) {
            this.names[i] = new Field();
            this.names[i].setLength(35);
            this.names[i].setMaxLength(35);
            this.shortNames[i] = new Field();
            this.shortNames[i].setLength(15);
            this.shortNames[i].setMaxLength(15);
            if (i == 11) {
                this.names[i].setMandatory(true);
                this.shortNames[i].setMandatory(true);
            }
            gridLayout.add((UIObject)this.names[i], i - 10, 0);
            gridLayout.add((UIObject)this.shortNames[i], i - 10, 1);
        }
        this.fgOther = new FieldGroup("Label.Miscellaneous");
        gridLayout = new ESPGridLayout();
        this.fgOther.add(gridLayout);
        Field label = new Field();
        label.setValue(TranslationHelperImpl.getInstance().translate("Label.BespokeWorkLib"));
        label.setLength(35);
        label.setReadonly(true);
        this.bespokeWorkLib = new Field();
        this.bespokeWorkLib.setType("upper");
        this.bespokeWorkLib.setLength(15);
        this.bespokeWorkLib.setMaxLength(10);
        gridLayout.add((UIObject)label, 0, 0);
        gridLayout.add((UIObject)this.bespokeWorkLib, 0, 1);
        this.governmentActivated = false;
        if (this.env.getGovernmentActivated() && ((result = EnvironmentBO.checkActivated(this.loginHelper, this.env.getOperationArea(), true))[0] == null || result[1] != null)) {
            this.governmentActivated = true;
        }
        this.fgAps = new FieldGroup("Label.AccountingPrinciples");
        gridLayout = new ESPGridLayout();
        this.fgAps.add(gridLayout);
        gridLayout.add((UIObject)new Label("Label.Name"), 0, 0);
        gridLayout.add((UIObject)new Label("Label.ShortName"), 0, 1);
        for (int i2 = 0; i2 < 4; ++i2) {
            this.apNames[i2] = new Field();
            this.apShortNames[i2] = new Field();
            if (i2 > 1 && !this.governmentActivated || i2 == 3) continue;
            this.apNames[i2].setMandatory(true);
            this.apNames[i2].setLength(35);
            this.apNames[i2].setMaxLength(25);
            this.apShortNames[i2].setMandatory(true);
            this.apShortNames[i2].setLength(15);
            this.apShortNames[i2].setMaxLength(10);
            if (i2 == 1) {
                this.useAccountingPrinciple2 = new CheckBox("", false);
                if (this.governmentActivated) continue;
                gridLayout.add((UIObject)new Label("Label.InUse"), 0, 2);
                this.useAccountingPrinciple2.setAction((Action)new Ap2InUseChangeAction());
                gridLayout.add((UIObject)this.useAccountingPrinciple2, i2 + 1, 2);
            }
            gridLayout.add((UIObject)this.apNames[i2], i2 + 1, 0);
            gridLayout.add((UIObject)this.apShortNames[i2], i2 + 1, 1);
        }
    }

    private void initializeAccountingPrincipleForms() throws Exception {
        this.apTabbedPanel = new TabbedPanel();
        this.apTab.add(this.apTabbedPanel);
        this.initializeAccountingPrincipleForm(0);
        this.initializeAccountingPrincipleForm(1);
        this.apTabCountMax = 2;
        if (this.governmentActivated) {
            this.initializeAccountingPrincipleForm(2);
            this.apTabCountMax = 3;
            this.depreciationGroups[2].setHidden(true);
            this.calculateDepreciation[2].setValue(false);
            this.interestCalculationMethod[2].removeOption(this.interestCalculationMethod[2].getOptionByValue("2"));
            this.interestCalculationMethod[2].setSelectedOptionValue("1");
        }
    }

    private void initializeAccountingPrincipleForm(int tabNumber) throws Exception {
        this.apTabs[tabNumber] = new Tab(this.apTabTexts[tabNumber]);
        this.apTabbedPanel.add(this.apTabs[tabNumber]);
        this.depreciationGroups[tabNumber] = new FieldGroup("Label.Depreciations");
        this.calculateDepreciation[tabNumber] = new CheckBox("Label.CalculateDepreciations", true);
        this.calculateDepreciationChangeAction[tabNumber] = new CalculateDepreciationChangeAction(tabNumber);
        this.calculateDepreciation[tabNumber].setAction((Action)this.calculateDepreciationChangeAction[tabNumber]);
        this.depreciationGroups[tabNumber].add(this.calculateDepreciation[tabNumber]);
        this.depreciationMethod[tabNumber] = EnumHelper.createComboBox("Label.DepreciationMethod", DepreciationMethodEnum.getCollection(), false);
        this.depreciationMethod[tabNumber].setWidth("225");
        this.depreciationMethodChangeAction[tabNumber] = new DepreciationMethodChangeAction(tabNumber);
        this.depreciationMethod[tabNumber].add((Action)this.depreciationMethodChangeAction[tabNumber]);
        this.depreciationGroups[tabNumber].add(this.depreciationMethod[tabNumber]);
        this.yearPercentageTableId[tabNumber] = new YearPercentageTableReferenceField(this.dbData);
        this.depreciationGroups[tabNumber].add((Field)this.yearPercentageTableId[tabNumber]);
        this.degressivePercentage[tabNumber] = new FACDecimalField("Label.Percentage", 5, 2);
        this.degressivePercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.degressivePercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.depreciationGroups[tabNumber].add((Field)this.degressivePercentage[tabNumber]);
        this.annuityInterestTableId[tabNumber] = new InterestTableReferenceField(this.dbData, 0);
        this.depreciationGroups[tabNumber].add((Field)this.annuityInterestTableId[tabNumber]);
        this.annuityPercentage[tabNumber] = new FACDecimalField("Label.Percentage", 6, 3);
        this.annuityPercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.annuityPercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.depreciationGroups[tabNumber].add((Field)this.annuityPercentage[tabNumber]);
        this.startPeriodHandlingMethod[tabNumber] = EnumHelper.createComboBox("Label.StartPeriodHandlingPolicy", StartPeriodHandlingEnum.getCollection(), false);
        this.startPeriodHandlingMethod[tabNumber].setWidth("225");
        this.depreciationGroups[tabNumber].add(this.startPeriodHandlingMethod[tabNumber]);
        this.apTabs[tabNumber].add(this.depreciationGroups[tabNumber]);
        this.interestGroups[tabNumber] = new FieldGroup("Label.Interest");
        this.calculateInterest[tabNumber] = new CheckBox("Label.CalculateInterest", true);
        this.calculateInterestChangeAction[tabNumber] = new CalculateInterestChangeAction(tabNumber);
        this.calculateInterest[tabNumber].setAction((Action)this.calculateInterestChangeAction[tabNumber]);
        this.interestGroups[tabNumber].add(this.calculateInterest[tabNumber]);
        this.interestCalculationMethod[tabNumber] = EnumHelper.createComboBox("Label.InterestCalculationMethod", InterestCalculationMethodEnum.getCollection(), false);
        this.interestCalculationMethod[tabNumber].setWidth("225");
        this.interestCalculationMethodChangeAction[tabNumber] = new InterestCalculationMethodChangeAction(tabNumber);
        this.interestCalculationMethod[tabNumber].add((Action)this.interestCalculationMethodChangeAction[tabNumber]);
        this.interestGroups[tabNumber].add(this.interestCalculationMethod[tabNumber]);
        this.interestTableId[tabNumber] = new InterestTableReferenceField(this.dbData, 0);
        this.interestGroups[tabNumber].add((Field)this.interestTableId[tabNumber]);
        this.interestPercentage[tabNumber] = new FACDecimalField("Label.Percentage", 6, 3);
        this.interestPercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.interestPercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.interestGroups[tabNumber].add((Field)this.interestPercentage[tabNumber]);
        this.apTabs[tabNumber].add(this.interestGroups[tabNumber]);
        this.journalingGroups[tabNumber] = new FieldGroup("Label.MainAccountScheme");
        this.journalingMethod[tabNumber] = EnumHelper.createComboBox("Label.JournalingMethod", JournalingMethodEnum.getCollection(), false);
        this.journalingMethod[tabNumber].setWidth("225");
        this.journalingGroups[tabNumber].add(this.journalingMethod[tabNumber]);
        this.apTabs[tabNumber].add(this.journalingGroups[tabNumber]);
    }

    protected void setValues() throws Exception {
        this.facLib.setValue(this.env.getFacLib());
        this.envDescription.setValue(this.env.getDescription());
        this.programLib.setValue(this.env.getProgramLib());
        this.names[0].setValue(this.env.getName1());
        this.names[1].setValue(this.env.getName2());
        this.names[2].setValue(this.env.getName3());
        this.names[3].setValue(this.env.getName4());
        this.names[4].setValue(this.env.getName5());
        this.names[5].setValue(this.env.getNameDebtor());
        this.names[6].setValue(this.env.getNameCreditor());
        this.names[7].setValue(this.env.getNameRelation());
        this.names[11].setValue(this.env.getDIRCName0());
        this.names[12].setValue(this.env.getDIRCName1());
        this.names[13].setValue(this.env.getDIRCName2());
        this.names[14].setValue(this.env.getDIRCName3());
        this.names[15].setValue(this.env.getDIRCName4());
        this.names[16].setValue(this.env.getDIRCName5());
        this.shortNames[0].setValue(this.env.getShortName1());
        this.shortNames[1].setValue(this.env.getShortName2());
        this.shortNames[2].setValue(this.env.getShortName3());
        this.shortNames[3].setValue(this.env.getShortName4());
        this.shortNames[4].setValue(this.env.getShortName5());
        this.shortNames[5].setValue(this.env.getShortNameDebtor());
        this.shortNames[6].setValue(this.env.getShortNameCreditor());
        this.shortNames[7].setValue(this.env.getShortNameRelation());
        this.shortNames[11].setValue(this.env.getDIRCShort0());
        this.shortNames[12].setValue(this.env.getDIRCShort1());
        this.shortNames[13].setValue(this.env.getDIRCShort2());
        this.shortNames[14].setValue(this.env.getDIRCShort3());
        this.shortNames[15].setValue(this.env.getDIRCShort4());
        this.shortNames[16].setValue(this.env.getDIRCShort5());
        this.apNames[0].setValue(this.env.getAPName1());
        this.apNames[1].setValue(this.env.getAPName2());
        this.apNames[2].setValue(this.env.getAPName3());
        this.apNames[3].setValue(this.env.getAPName4());
        this.apShortNames[0].setValue(this.env.getAPShortName1());
        this.apShortNames[1].setValue(this.env.getAPShortName2());
        this.apShortNames[2].setValue(this.env.getAPShortName3());
        this.apShortNames[3].setValue(this.env.getAPShortName4());
        this.useAccountingPrinciple2.setValue(this.env.getAccountingPrinciple2IsUsed());
        this.useAccountingPrinciple2.setReadonly(CompanyBO.hasCompanies(this.dbData));
        if (!this.useAccountingPrinciple2.getValueAsBoolean()) {
            this.apTabs[1].setHidden(true);
        }
        if (this.governmentActivated) {
            this.fgAps.setHidden(true);
        }
        for (int i = 0; i < 3 && (i <= 1 || this.governmentActivated); ++i) {
            this.accountingPrincipleDefault[i] = (EnvironmentAccountingPrincipleDefault)EnvironmentAccountingPrincipleDefaultBO.get(this.env, i + 1)[0];
            this.calculateDepreciation[i].setValue(this.accountingPrincipleDefault[i].getCalculateDepreciation());
            this.depreciationMethod[i].setSelectedOptionValue("" + this.accountingPrincipleDefault[i].getDepreciationMethod());
            this.yearPercentageTableId[i].setValue(this.accountingPrincipleDefault[i].getYearPercentageTableId());
            YearPercentageTable yearPercentageTable = this.accountingPrincipleDefault[i].getYearPercentageTable();
            if (yearPercentageTable != null) {
                this.yearPercentageTableId[i].setDescription(yearPercentageTable.getDescription());
            }
            this.degressivePercentage[i].setValue(this.accountingPrincipleDefault[i].getDegressivePercentage());
            this.annuityPercentage[i].setValue(this.accountingPrincipleDefault[i].getAnnuityPercentage());
            this.annuityInterestTableId[i].setValue(this.accountingPrincipleDefault[i].getAnnuityInterestTableId());
            InterestTable interestTable = this.accountingPrincipleDefault[i].getAnnuityInterestTable();
            if (interestTable != null) {
                this.annuityInterestTableId[i].setDescription(interestTable.getDescription());
            }
            this.calculateInterest[i].setValue(this.accountingPrincipleDefault[i].getCalculateInterest());
            this.interestCalculationMethod[i].setSelectedOptionValue("" + this.accountingPrincipleDefault[i].getInterestCalculationMethod());
            this.interestTableId[i].setValue(this.accountingPrincipleDefault[i].getInterestTableId());
            interestTable = this.accountingPrincipleDefault[i].getInterestTable();
            if (interestTable != null) {
                this.interestTableId[i].setDescription(interestTable.getDescription());
            }
            this.interestPercentage[i].setValue(this.accountingPrincipleDefault[i].getInterestPercentage());
            this.journalingMethod[i].setSelectedOptionValue("" + this.accountingPrincipleDefault[i].getJournalingMethod());
        }
    }

    protected void modifyFieldAttributes(DataObject object) throws Exception {
        for (int i = 0; i < 3 && (i <= 1 || this.governmentActivated); ++i) {
            this.calculateDepreciationChangeAction[i].execute(object);
            this.calculateInterestChangeAction[i].execute(object);
            this.depreciationMethodChangeAction[i].execute(object);
            this.interestCalculationMethodChangeAction[i].execute(object);
        }
    }

    protected String update() throws Exception {
        String message = null;
        if (this.env.getOperationArea().trim().length() == 0 && !this.env.getProgramLib().trim().equals(this.programLib.getValue().trim())) {
            if (this.programLib.getValue().trim().length() == 0) {
                TokenList tl = new TokenList();
                tl.addTranslatable("nl.ibs.fac.language", "ProgramLib");
                return LanguageHelper.getString("nl.ibs.fac.language", "empty-mandatory-field", tl);
            }
            FISHelper helper = new FISHelper(this.loginHelper);
            helper.login(this.env.getDataLib(), this.programLib.getValue());
            message = helper.getMessage();
            if (message.trim().length() == 0) {
                helper.logout(this.env.getDataLib(), this.programLib.getValue());
            } else {
                return message;
            }
        }
        for (int i = 0; i < this.apTabCountMax; ++i) {
            message = this.validateAccountingPrincipleForm(i);
            if (message == null) continue;
            this.mainTabPanel.setActiveTabByName("Label.Valuation");
            this.apTabbedPanel.setActiveTab(this.apTabs[i]);
            return message;
        }
        message = this.updateEnvironment();
        if (message != null && message.trim().length() > 0) {
            return message;
        }
        message = this.updateAccountingPrinciples();
        if (message != null && message.trim().length() > 0) {
            return message;
        }
        return null;
    }

    protected String validateAccountingPrincipleForm(int tabNumber) throws Exception {
        Object[] result;
        String message;
        Object[] result2;
        String message2;
        if (this.apTabs[tabNumber].isHidden()) {
            return null;
        }
        this.apTabs[tabNumber].removeInvalidTags();
        this.apTabs[tabNumber].validateAll();
        String id = this.yearPercentageTableId[tabNumber].getValue().trim();
        if (id.length() > 0 && (message2 = (String)(result2 = YearPercentageTableBO.get(this.dbData, id))[1]) != null) {
            this.yearPercentageTableId[tabNumber].setInvalidTag();
            return message2;
        }
        if (!"0".equals(this.interestCalculationMethod[tabNumber].getValue())) {
            boolean precentageFilled;
            id = this.interestTableId[tabNumber].getValue().trim();
            boolean idFilled = id.length() > 0;
            boolean bl = precentageFilled = this.interestPercentage[tabNumber].getDoubleValue() > 0.0;
            if (idFilled && precentageFilled) {
                this.interestTableId[tabNumber].setInvalidTag();
                this.interestPercentage[tabNumber].setInvalidTag();
                return "provide_only_one_value";
            }
            if (idFilled && (message = (String)(result = InterestTableBO.get(this.dbData, id, 0))[1]) != null) {
                this.interestTableId[tabNumber].setInvalidTag();
                return message;
            }
        }
        if ("2".equals(this.depreciationMethod[tabNumber].getValue()) && this.degressivePercentage[tabNumber].getDoubleValue() == 0.0) {
            this.degressivePercentage[tabNumber].setInvalidTag();
            return "value_must_be_positive";
        }
        if ("12".equals(this.depreciationMethod[tabNumber].getValue()) || "11".equals(this.depreciationMethod[tabNumber].getValue())) {
            boolean precentageFilled;
            id = this.annuityInterestTableId[tabNumber].getValue().trim();
            boolean idFilled = id.length() > 0;
            boolean bl = precentageFilled = this.annuityPercentage[tabNumber].getDoubleValue() > 0.0;
            if (idFilled && precentageFilled) {
                this.annuityInterestTableId[tabNumber].setInvalidTag();
                this.annuityPercentage[tabNumber].setInvalidTag();
                return "provide_only_one_value";
            }
            if (idFilled && (message = (String)(result = InterestTableBO.get(this.dbData, id, 0))[1]) != null) {
                this.annuityInterestTableId[tabNumber].setInvalidTag();
                return message;
            }
        }
        return null;
    }

    private String updateEnvironment() throws Exception {
        String[] array1 = new String[11];
        String[] array2 = new String[11];
        for (int i = 0; i < 11; ++i) {
            if (i == 4 && this.env.getOperationArea().trim().length() > 0 || i == 7 && this.env.getOperationArea().trim().length() == 0) {
                array1[i] = "";
                array2[i] = "";
                continue;
            }
            array1[i] = this.names[i].getValue();
            array2[i] = this.shortNames[i].getValue();
        }
        String[] array3 = new String[4];
        String[] array4 = new String[4];
        for (int i = 0; i < 4; ++i) {
            if (i > 1 && !this.governmentActivated) {
                array3[i] = "";
                array4[i] = "";
                continue;
            }
            array3[i] = this.apNames[i].getValue();
            array4[i] = this.apShortNames[i].getValue();
        }
        String[] array5 = new String[6];
        String[] array6 = new String[6];
        for (int i = 11; i < 17; ++i) {
            array5[i - 11] = this.names[i].getValue();
            array6[i - 11] = this.shortNames[i].getValue();
        }
        return EnvironmentBO.update(this.env, array1, array2, this.useAccountingPrinciple2.getValueAsBoolean(), array3, array4, this.envDescription.getValue().trim(), this.programLib.getValue().trim(), this.bespokeWorkLib.getValue(), array5, array6);
    }

    private String updateAccountingPrinciples() throws Exception {
        String message = null;
        message = this.updateAccountingPrinciple(0);
        if (message != null && message.trim().length() > 0) {
            return message;
        }
        message = this.updateAccountingPrinciple(1);
        if (message != null && message.trim().length() > 0) {
            return message;
        }
        if (this.governmentActivated && (message = this.updateAccountingPrinciple(2)) != null && message.trim().length() > 0) {
            return message;
        }
        return message;
    }

    private String updateAccountingPrinciple(int i) throws Exception {
        String message = null;
        message = EnvironmentAccountingPrincipleDefaultBO.update(this.env, this.accountingPrincipleDefault[i], this.calculateDepreciation[i].getValueAsBoolean(), Integer.parseInt(this.depreciationMethod[i].getValue()), this.yearPercentageTableId[i].getValue(), this.degressivePercentage[i].getBigDecimal(), this.annuityInterestTableId[i].getValue(), this.annuityPercentage[i].getBigDecimal(), Integer.parseInt(this.startPeriodHandlingMethod[i].getValue()), this.calculateInterest[i].getValueAsBoolean(), Integer.parseInt(this.interestCalculationMethod[i].getValue()), this.interestTableId[i].getValue(), this.interestPercentage[i].getBigDecimal(), Integer.parseInt(this.journalingMethod[i].getValue()));
        return message;
    }

    private class InterestCalculationMethodChangeAction
    extends Action {
        private static final long serialVersionUID = -4099934352056207581L;
        private int tabNumber;

        public InterestCalculationMethodChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if ("0".equals(EnvironmentPanels.this.interestCalculationMethod[this.tabNumber].getValue())) {
                EnvironmentPanels.this.interestTableId[this.tabNumber].setHidden(true);
                EnvironmentPanels.this.interestTableId[this.tabNumber].setValue();
                EnvironmentPanels.this.interestPercentage[this.tabNumber].setHidden(true);
                EnvironmentPanels.this.interestPercentage[this.tabNumber].setValue();
                return true;
            }
            EnvironmentPanels.this.interestTableId[this.tabNumber].setHidden(false);
            EnvironmentPanels.this.interestPercentage[this.tabNumber].setHidden(false);
            return true;
        }
    }

    private class CalculateInterestChangeAction
    extends Action {
        private static final long serialVersionUID = 3562045469454924093L;
        private int tabNumber = 0;

        public CalculateInterestChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if (EnvironmentPanels.this.calculateInterest[this.tabNumber].getValueAsBoolean()) {
                EnvironmentPanels.this.interestCalculationMethod[this.tabNumber].setHidden(false);
                return true;
            }
            EnvironmentPanels.this.interestCalculationMethod[this.tabNumber].setHidden(true);
            EnvironmentPanels.this.interestCalculationMethod[this.tabNumber].setValueAsString("0");
            EnvironmentPanels.this.interestTableId[this.tabNumber].setHidden(true);
            EnvironmentPanels.this.interestTableId[this.tabNumber].setValue();
            EnvironmentPanels.this.interestPercentage[this.tabNumber].setHidden(true);
            EnvironmentPanels.this.interestPercentage[this.tabNumber].setValue();
            return true;
        }
    }

    private class DepreciationMethodChangeAction
    extends Action {
        private static final long serialVersionUID = -7988927228620312875L;
        private int tabNumber;

        public DepreciationMethodChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if ("3".equals(EnvironmentPanels.this.depreciationMethod[this.tabNumber].getValue())) {
                EnvironmentPanels.this.yearPercentageTableId[this.tabNumber].setHidden(false);
                EnvironmentPanels.this.degressivePercentage[this.tabNumber].setHidden(true);
                EnvironmentPanels.this.degressivePercentage[this.tabNumber].setValue();
                EnvironmentPanels.this.annuityPercentage[this.tabNumber].setHidden(true);
                EnvironmentPanels.this.annuityPercentage[this.tabNumber].setValue();
                EnvironmentPanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
                EnvironmentPanels.this.annuityInterestTableId[this.tabNumber].setValue();
                EnvironmentPanels.this.interestGroups[this.tabNumber].setHidden(false);
                return true;
            }
            if ("12".equals(EnvironmentPanels.this.depreciationMethod[this.tabNumber].getValue()) || "11".equals(EnvironmentPanels.this.depreciationMethod[this.tabNumber].getValue())) {
                EnvironmentPanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
                EnvironmentPanels.this.yearPercentageTableId[this.tabNumber].setValue();
                EnvironmentPanels.this.degressivePercentage[this.tabNumber].setHidden(true);
                EnvironmentPanels.this.degressivePercentage[this.tabNumber].setValue();
                EnvironmentPanels.this.annuityPercentage[this.tabNumber].setHidden(false);
                EnvironmentPanels.this.annuityInterestTableId[this.tabNumber].setHidden(false);
                EnvironmentPanels.this.calculateInterest[this.tabNumber].setValue(false);
                EnvironmentPanels.this.interestCalculationMethod[this.tabNumber].setHidden(true);
                EnvironmentPanels.this.interestCalculationMethod[this.tabNumber].setValueAsString("0");
                EnvironmentPanels.this.interestTableId[this.tabNumber].setHidden(true);
                EnvironmentPanels.this.interestTableId[this.tabNumber].setValue();
                EnvironmentPanels.this.interestPercentage[this.tabNumber].setHidden(true);
                EnvironmentPanels.this.interestPercentage[this.tabNumber].setValue();
                EnvironmentPanels.this.interestGroups[this.tabNumber].setHidden(true);
                return true;
            }
            if ("2".equals(EnvironmentPanels.this.depreciationMethod[this.tabNumber].getValue())) {
                EnvironmentPanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
                EnvironmentPanels.this.yearPercentageTableId[this.tabNumber].setValue();
                EnvironmentPanels.this.degressivePercentage[this.tabNumber].setHidden(false);
                EnvironmentPanels.this.annuityPercentage[this.tabNumber].setHidden(true);
                EnvironmentPanels.this.annuityPercentage[this.tabNumber].setValue();
                EnvironmentPanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
                EnvironmentPanels.this.annuityInterestTableId[this.tabNumber].setValue();
                EnvironmentPanels.this.interestGroups[this.tabNumber].setHidden(false);
                return true;
            }
            EnvironmentPanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
            EnvironmentPanels.this.yearPercentageTableId[this.tabNumber].setValue();
            EnvironmentPanels.this.degressivePercentage[this.tabNumber].setHidden(true);
            EnvironmentPanels.this.degressivePercentage[this.tabNumber].setValue();
            EnvironmentPanels.this.annuityPercentage[this.tabNumber].setHidden(true);
            EnvironmentPanels.this.annuityPercentage[this.tabNumber].setValue();
            EnvironmentPanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
            EnvironmentPanels.this.annuityInterestTableId[this.tabNumber].setValue();
            EnvironmentPanels.this.interestGroups[this.tabNumber].setHidden(false);
            return true;
        }
    }

    private class CalculateDepreciationChangeAction
    extends Action {
        private static final long serialVersionUID = 7466661560217263804L;
        private int tabNumber = 0;

        public CalculateDepreciationChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if (EnvironmentPanels.this.calculateDepreciation[this.tabNumber].getValueAsBoolean()) {
                EnvironmentPanels.this.depreciationMethod[this.tabNumber].setHidden(false);
                EnvironmentPanels.this.startPeriodHandlingMethod[this.tabNumber].setHidden(false);
                return true;
            }
            EnvironmentPanels.this.depreciationMethod[this.tabNumber].setValueAsString("99");
            EnvironmentPanels.this.depreciationMethod[this.tabNumber].setHidden(true);
            EnvironmentPanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
            EnvironmentPanels.this.yearPercentageTableId[this.tabNumber].setValue();
            EnvironmentPanels.this.degressivePercentage[this.tabNumber].setHidden(true);
            EnvironmentPanels.this.degressivePercentage[this.tabNumber].setValue();
            EnvironmentPanels.this.annuityPercentage[this.tabNumber].setHidden(true);
            EnvironmentPanels.this.annuityPercentage[this.tabNumber].setValue();
            EnvironmentPanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
            EnvironmentPanels.this.annuityInterestTableId[this.tabNumber].setValue();
            EnvironmentPanels.this.startPeriodHandlingMethod[this.tabNumber].setHidden(true);
            return true;
        }
    }

    private class Ap2InUseChangeAction
    extends Action {
        private static final long serialVersionUID = -8381706445069891312L;

        private Ap2InUseChangeAction() {
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if (EnvironmentPanels.this.useAccountingPrinciple2.getValueAsBoolean()) {
                EnvironmentPanels.this.apTabs[1].setHidden(false);
            } else {
                EnvironmentPanels.this.apTabs[1].setHidden(true);
                if (EnvironmentPanels.this.apTabs[1].isActive()) {
                    EnvironmentPanels.this.apTabbedPanel.setActiveTab(EnvironmentPanels.this.apTabs[0]);
                }
            }
            return true;
        }
    }

    private class MiscTabActivateAction
    extends TabActivateAction {
        private static final long serialVersionUID = -1262047450143117561L;

        public MiscTabActivateAction(Tab tab, TabbedPanel tabbedPanel) {
            super(tab, tabbedPanel);
        }

        public boolean execute(DataObject object) throws Exception {
            object.removeMessages();
            EnvironmentPanels.this.miscTab.removeInvalidTags();
            EnvironmentPanels.this.miscTab.validateAll();
            super.execute(object);
            return true;
        }
    }

    private class CommonTabActivateAction
    extends TabActivateAction {
        private static final long serialVersionUID = 2209304162525377272L;

        public CommonTabActivateAction(Tab tab, TabbedPanel tabbedPanel) {
            super(tab, tabbedPanel);
        }

        public boolean execute(DataObject object) throws Exception {
            object.removeMessages();
            EnvironmentPanels.this.commonTab.removeInvalidTags();
            EnvironmentPanels.this.commonTab.validateAll();
            super.execute(object);
            return true;
        }
    }
}

