/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import java.util.Collection;
import nl.ibs.esp.event.EventListener;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.OutputField;
import nl.ibs.esp.uiobjects.TableHeader;
import nl.ibs.esp.uiobjects.TableHeaderField;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.UserErrorMessage;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.util.NameValuePair;

public class FISReferenceField
extends FinancialReferenceField {
    private static final long serialVersionUID = -4857650391998501416L;
    private String companyId;
    private String bookYear;
    private FISHelper fisHelper;
    private boolean checkEvent = true;

    public FISReferenceField(LoginHelper loginHelper, String label, int index, Company company) throws Exception {
        this(loginHelper, label, index, company.getId(), "" + company.getCurrentBookYear(), true);
        this.company = company;
    }

    public FISReferenceField(LoginHelper loginHelper, String label, int index, String companyId, String bookYear, boolean validate) throws Exception {
        super(loginHelper, label, index, validate);
        this.companyId = companyId;
        this.bookYear = bookYear;
        this.index = index;
        this.fisHelper = new FISHelper(loginHelper);
        if (index == -3) {
            this.setType("text");
        } else {
            this.setType("number");
        }
        this.setLength(10);
        this.setPositionFields(new String[]{NAMES[0]});
        this.setSearchFields(new String[]{NAMES[1]});
        if (index == -3) {
            this.setFilterFields(new String[]{NAMES[0]});
            this.setPositionFields(new String[]{NAMES[0]});
            this.setSearchFields(null);
            this.setMaxLength(7);
            this.setLength(7);
        } else if (index == -1) {
            this.setMaxLength(3);
        } else if (index == 1) {
            this.setMaxLength(5);
        } else {
            this.setMaxLength(9);
        }
        this.setDescriptionLength(40);
        this.determineHelpId();
        this.addOnChangeListener(new MyListener());
    }

    private void determineHelpId() throws Exception {
        switch (this.index) {
            case -1: {
                this.setHelpId("GLDayBook");
                break;
            }
            case 0: {
                this.setHelpId("GLMainAccount");
                break;
            }
            case 11: {
                this.setHelpId("EXTDimension");
                break;
            }
            case 10: {
                this.setHelpId("EXTDimension");
                break;
            }
            default: {
                this.setHelpId("FINDimension");
            }
        }
    }

    protected TableHeader createTableHeader() throws Exception {
        TableHeader header = new TableHeader();
        header.add(new TableHeaderField(LABELS[0], 80));
        header.add(new TableHeaderField(LABELS[1], 280));
        return header;
    }

    protected TableRow createTableRow(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        NameValuePair pair = (NameValuePair)object;
        TableRow row = new TableRow();
        row.add(new OutputField(pair.getName()));
        row.add(new OutputField(pair.getValue()));
        return row;
    }

    protected Collection getNextCollection(Object previousObject, String filter, String filterField, boolean position, int max) throws Exception {
        if (!this.moreRecs && previousObject != null) {
            return null;
        }
        Collection result = this.index == 10 || this.index == 11 ? this.fisHelper.getNextDCCollection(previousObject, max, filter, filterField, position, this.companyId, this.index) : this.fisHelper.getNextCollection(previousObject, max, filter, filterField, position, this.companyId, this.bookYear, this.index);
        if (result == null) {
            this.moreRecs = false;
            return null;
        }
        this.moreRecs = result.size() >= max;
        return result;
    }

    public void validate() throws Exception {
        super.validate();
        if (!this.validate || this.getReadonly()) {
            this.formattedId = FISHelper.formatId(this.getValue().trim(), this.index);
            return;
        }
        if (this.getValue().trim().length() == 0) {
            this.formattedId = "";
            this.setDescription("");
            return;
        }
        String desc = this.getDescription(this.getValue().trim());
        if (desc == null) {
            this.setInvalidTag();
            throw new UserErrorMessage("key_not_found");
        }
        if (this.index != -3) {
            this.formattedId = FISHelper.formatId(this.getValue().trim(), this.index);
        }
        if (this.company == null) {
            return;
        }
        Company dataSet = this.company.getDataSet();
        if (dataSet == null) {
            dataSet = this.company;
        }
        String fromId = "";
        String toId = "";
        switch (this.index) {
            case 1: {
                fromId = dataSet.getFD1From();
                toId = dataSet.getFD1To();
                break;
            }
            case 2: {
                fromId = dataSet.getFD2From();
                toId = dataSet.getFD2To();
                break;
            }
            case 3: {
                fromId = dataSet.getFD3From();
                toId = dataSet.getFD3To();
                break;
            }
            case 4: {
                fromId = dataSet.getFD4From();
                toId = dataSet.getFD4To();
                break;
            }
            case 5: {
                fromId = dataSet.getFD5From();
                toId = dataSet.getFD5To();
            }
        }
        if (fromId.trim().length() > 0 && new BigDecimal(this.getValue()).compareTo(new BigDecimal(fromId)) < 0) {
            this.setInvalidTag();
            throw new UserErrorMessage("not_in_range");
        }
        if (toId.trim().length() > 0 && new BigDecimal(this.getValue()).compareTo(new BigDecimal(toId)) > 0) {
            this.setInvalidTag();
            throw new UserErrorMessage("not_in_range");
        }
    }

    private String getDescription(String id) throws Exception {
        if (this.index == 10 || this.index == 11) {
            return this.fisHelper.getDCDescription(id, this.companyId, this.index);
        }
        return this.fisHelper.getDescription(id, this.companyId, this.bookYear, this.index);
    }

    protected void setSelectedObject(Object object) throws Exception {
        NameValuePair pair = (NameValuePair)object;
        this.checkEvent = false;
        this.setValue(pair.getName());
        this.checkEvent = true;
        this.setDescription(pair.getValue());
    }

    public Field setValue(String value) {
        try {
            return super.setValue(FISHelper.unFormatId(value));
        }
        catch (Exception e) {
            return super.setValue(value);
        }
    }

    private class MyListener
    implements EventListener {
        private static final long serialVersionUID = 2680984705342842641L;

        private MyListener() {
        }

        public void event(UIObject object, String eventType) throws Exception {
            if (!FISReferenceField.this.checkEvent) {
                return;
            }
            if (FISReferenceField.this.getValue().trim().length() == 0) {
                FISReferenceField.this.setDescription("");
                return;
            }
            String description = FISReferenceField.this.getDescription(FISReferenceField.this.getValue().trim());
            if (description != null) {
                FISReferenceField.this.setDescription(description);
                return;
            }
            FISReferenceField.this.setDescription("");
        }
    }
}

