/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFileOutputStream;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FileSelectionField;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Option;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.UserMessageException;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.inport.AnalysisCodeCSV;
import nl.ibs.fac.inport.AnalysisGroupCSV;
import nl.ibs.fac.inport.AssetCSV;
import nl.ibs.fac.inport.AssetTypeCSV;
import nl.ibs.fac.inport.CompanyCSV;
import nl.ibs.fac.inport.ImportCSVHelper;
import nl.ibs.fac.inport.IncomingFinancialTransactionCSV;
import nl.ibs.fac.inport.TransactionCSV;
import nl.ibs.fac.inport.ValuationCSV;
import nl.ibs.util.Scrambler;

public class ImportAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 4166286943093921891L;
    public static final String PAGE = ImportAdapter.class.getName();
    private FieldGroup group = new FieldGroup();
    private ComboBox index;
    private static final String[] TITLES = new String[]{"Title.ImportCompanyCSV", "Title.ImportAnalysisGroupCSV", "Title.ImportAnalysisCodeCSV", "Title.ImportAssetTypeCSV", "Title.ImportIncomingFinancialTransactionCSV", "Title.ImportAssetCSV", "Title.ImportValuationCSV", "Title.ImportTransactionCSV"};
    private static final String[] JOBNAMES = new String[]{"Job.ImportCompanyCSV", "Job.ImportAnalysisGroupCSV", "Job.ImportAnalysisCodeCSV", "Job.ImportAssetTypeCSV", "Job.ImportIncomingFinancialTransactionCSV", "Job.ImportAssetCSV", "Job.ImportValuationCSV", "Job.ImportTransactionCSV"};
    private static final String[] CLASSNAMES = new String[]{CompanyCSV.CLASSNAME, AnalysisGroupCSV.CLASSNAME, AnalysisCodeCSV.CLASSNAME, AssetTypeCSV.CLASSNAME, IncomingFinancialTransactionCSV.CLASSNAME, AssetCSV.CLASSNAME, ValuationCSV.CLASSNAME, TransactionCSV.CLASSNAME};
    private FileSelectionField file = new FileSelectionField("Label.File", 40);
    private FloatBar fbShow = new FloatBar();
    private static final String SUBMIT = "submit";
    private static final int CCSID = 819;

    public ImportAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        Option[] options = new Option[TITLES.length];
        for (int i = 0; i < TITLES.length; ++i) {
            options[i] = new Option(TITLES[i], "" + i);
        }
        this.index = new ComboBox("", options);
        this.index.setWidth("350");
        this.group.add(this.index);
        this.file.setMandatory(true);
        this.group.add((Field)this.file);
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        this.fbShow.addAction(ok);
        this.fbShow.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.Import", "screen_name"));
        object.addUIObject((UIObject)this.group);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        this.file.validateSize(object);
        byte[] bytes = this.file.getFileContent(object);
        if (bytes.length == 0) {
            this.file.setInvalidTag();
            throw new UserMessageException("importfile_not_found");
        }
        LoginHelper loginHelper = (LoginHelper)object.getSessionAttribute(LoginHelper.LOGINHELPER);
        String pathToFile = ImportCSVHelper.getDefaultPath() + '/' + this.file.getValue();
        IFSFileOutputStream fos = new IFSFileOutputStream((AS400)loginHelper.getAs400(), pathToFile, 819);
        fos.write(bytes);
        fos.close();
        int i = Integer.parseInt(this.index.getValue());
        String[][] selections = new String[][]{{"pathToFile", pathToFile}, {"System", loginHelper.getSystem()}, {"User", loginHelper.getUser()}, {"Password", Scrambler.scramble((String)loginHelper.getPassword())}};
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("className", (Object)CLASSNAMES[i]);
        this.getProcess().setAttribute("title", (Object)object.translate(TITLES[i], object.getLocale()));
        this.getProcess().setAttribute("jobName", (Object)JOBNAMES[i]);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }
}

