/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.DateSelectionField;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.DocumentViewerProperties;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.gov.GovernmentConstants;
import nl.ibs.fac.gov.adapters.CreditReferenceField;
import nl.ibs.fac.gov.boadapters.CreditBO;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;

public class IncomingFinancialTransactionDetailAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 7610750280301371181L;
    public static final String PAGE = IncomingFinancialTransactionDetailAdapter.class.getName();
    public static final String INCOMINGFINANCIALTRANSACTION = "IncomingFinancialTransaction";
    public static final String START_ACTION = "showDetails";
    private Company company;
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private FinancialReferenceField daybook;
    private FinancialReferenceField[] financialDimension = new FinancialReferenceField[9];
    private FieldGroup fgW1;
    private FieldGroup fgW2;
    private FieldGroup fgW3;
    private FieldGroup fgW4;
    private String[] finTexts = new String[5];
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();

    public IncomingFinancialTransactionDetailAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.finTexts[0] = this.env.getName1();
        this.finTexts[1] = this.env.getName2();
        this.finTexts[2] = this.env.getName3();
        this.finTexts[3] = this.env.getName4();
        this.finTexts[4] = this.env.getName5();
    }

    public DataObject showDetails(DataObject object) throws Exception {
        Transaction transaction;
        IncomingFinancialTransaction theTransaction = (IncomingFinancialTransaction)this.getProcess().getAttribute(INCOMINGFINANCIALTRANSACTION);
        Object selectedItem = null;
        if (theTransaction == null) {
            selectedItem = TableHelper.getSelectedItem((DataObject)object);
        }
        if (selectedItem instanceof IncomingFinancialTransaction) {
            theTransaction = (IncomingFinancialTransaction)selectedItem;
        } else if (selectedItem instanceof Transaction && (theTransaction = (transaction = (Transaction)selectedItem).getIncomingFinancialTransaction()) == null) {
            object.addUIObject((UIObject)new Message("key_not_found", "error"));
            return object;
        }
        Window window = new Window();
        window.setTop("10%");
        window.setRight("15%");
        window.setLabel("Title.InquiryIFTDetails");
        this.createFieldGroups(theTransaction, object);
        window.add(this.fgW1);
        window.add(this.fgW2);
        window.add(this.fgW3);
        if (this.governmentActivated) {
            window.add(this.fgW4);
        }
        if (theTransaction.getDocumentId().trim().length() != 0) {
            window.add(DocumentViewerProperties.getAction(theTransaction.getDocumentId()));
        }
        object.addUIObject((UIObject)window);
        return object;
    }

    private void createFieldGroups(IncomingFinancialTransaction incomingFinancialTransaction, DataObject object) throws Exception {
        this.fgW1 = new FieldGroup("Label.Common");
        this.fgW2 = new FieldGroup("Label.Miscellaneous");
        this.fgW3 = new FieldGroup("Label.Dimensions");
        Field field = new Field("Label.SystemItemNbr");
        field.setLength(15);
        field.setReadonly(true);
        this.fgW1.add(field);
        String sSystemItemNumber = incomingFinancialTransaction.getSystemItemSequencenumber() != 0 ? "" + incomingFinancialTransaction.getSystemItemNumber() + "/" + incomingFinancialTransaction.getSystemItemSequencenumber() : "" + incomingFinancialTransaction.getSystemItemNumber();
        field.setValue(sSystemItemNumber);
        field = new Field("Label.VoucherId", "text", null, "", 15);
        field.setReadonly(true);
        this.fgW1.add(field);
        if (incomingFinancialTransaction.getVoucherId().trim().length() != 0) {
            if (this.env.getOperationArea().trim().length() == 0) {
                field.setValue((String)this.numericIdTransformer.transform(incomingFinancialTransaction.getVoucherId()));
            } else {
                field.setValue(incomingFinancialTransaction.getVoucherId());
            }
        }
        field = new Field("Label.InvoiceNbr", "text", null, "", 15);
        field.setReadonly(true);
        this.fgW1.add(field);
        if (incomingFinancialTransaction.getInternalInvoiceId() != 0L) {
            field.setValue("" + incomingFinancialTransaction.getInternalInvoiceId());
        }
        String label = object.translate("Label.Description", object.getLocale());
        field = new Field(label, "text", null, "", 50);
        field.setReadonly(true);
        this.fgW1.add(field);
        field.setValue(incomingFinancialTransaction.getDescription());
        if (incomingFinancialTransaction.getDescription2().trim().length() > 0) {
            field = new Field(label + "-2", "text", null, "", 50);
            field.setReadonly(true);
            this.fgW1.add(field);
            field.setValue(incomingFinancialTransaction.getDescription2().trim());
        }
        if (incomingFinancialTransaction.getDocumentId().trim().length() > 0) {
            field = new Field("Label.DocumentId", "text", null, "", 50);
            field.setReadonly(true);
            this.fgW1.add(field);
            field.setValue(incomingFinancialTransaction.getDocumentId().trim());
        }
        BookYearPeriodGrid iftYearPeriod = new BookYearPeriodGrid("Label.GLPeriod", true);
        this.fgW2.add((ESPGridLayout)iftYearPeriod);
        iftYearPeriod.setValues("" + incomingFinancialTransaction.getBookYear(), "" + incomingFinancialTransaction.getPeriod());
        field = new Field("Label.TransactionValue", "decimal", null, "", 15);
        field.setReadonly(true);
        this.fgW2.add(field);
        field.setValue((String)DECIMALTRANSFORMER.transform(incomingFinancialTransaction.getTransactionValue()));
        DateSelectionField dsField = new DateSelectionField("Label.BookDate");
        dsField.setReadonly(true);
        this.fgW2.add((Field)dsField);
        dsField.setValue(incomingFinancialTransaction.getBookDate());
        if (!this.companyId.equals(incomingFinancialTransaction.getCompanyId())) {
            this.company = (Company)CompanyBO.get(this.dbData, incomingFinancialTransaction.getCompanyId())[0];
        }
        if (this.env.getOperationArea().length() == 0) {
            this.daybook = new FISReferenceField(this.loginHelper, "Label.Daybook", -1, this.company.getId(), "" + this.company.getCurrentBookYear(), true);
            this.financialDimension[0] = new FISReferenceField(this.loginHelper, "Label.MainAccount", 0, this.company.getId(), "" + this.company.getCurrentBookYear(), true);
            this.financialDimension[6] = new FISReferenceField(this.loginHelper, this.env.getNameDebtor(), 10, this.company.getId(), "" + this.company.getCurrentBookYear(), true);
            this.financialDimension[7] = new FISReferenceField(this.loginHelper, this.env.getNameCreditor(), 11, this.company.getId(), "" + this.company.getCurrentBookYear(), true);
        } else {
            this.daybook = new FMSReferenceField(this.loginHelper, "Label.Daybook", -1, true);
            this.financialDimension[0] = new FMSReferenceField(this.loginHelper, "Label.MainAccount", 0, true);
            this.financialDimension[6] = new FMSReferenceField(this.loginHelper, this.env.getNameDebtor(), 10, true);
            this.financialDimension[7] = new FMSReferenceField(this.loginHelper, this.env.getNameCreditor(), 11, true);
            this.financialDimension[8] = new FMSReferenceField(this.loginHelper, this.env.getNameRelation(), 12, true);
        }
        for (int i = 0; i < this.finTexts.length; ++i) {
            if (this.finTexts[i].length() == 0) continue;
            this.financialDimension[i + 1] = this.env.getOperationArea().length() == 0 ? new FISReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.company) : new FMSReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.company);
        }
        this.financialDimension[0].setReadonly(true);
        this.fgW2.add((Field)this.financialDimension[0]);
        this.financialDimension[0].setValue(incomingFinancialTransaction.getMainAccount());
        this.daybook.setReadonly(true);
        this.fgW2.add((Field)this.daybook);
        this.daybook.setValue(incomingFinancialTransaction.getDaybookId().trim());
        String value = null;
        for (int i = 1; i < this.financialDimension.length; ++i) {
            if (this.financialDimension[i] == null) continue;
            switch (i) {
                case 1: {
                    value = incomingFinancialTransaction.getFinDimId1();
                    break;
                }
                case 2: {
                    value = incomingFinancialTransaction.getFinDimId2();
                    break;
                }
                case 3: {
                    value = incomingFinancialTransaction.getFinDimId3();
                    break;
                }
                case 4: {
                    value = incomingFinancialTransaction.getFinDimId4();
                    break;
                }
                case 5: {
                    value = incomingFinancialTransaction.getFinDimId5();
                    break;
                }
                case 6: {
                    if (!incomingFinancialTransaction.getSuspenseType().equals("D") && incomingFinancialTransaction.getSuspenseType().trim().length() != 0) break;
                    value = incomingFinancialTransaction.getSuspenseAccount();
                    break;
                }
                case 7: {
                    if (!incomingFinancialTransaction.getSuspenseType().equals("C") && incomingFinancialTransaction.getSuspenseType().trim().length() != 0) break;
                    value = incomingFinancialTransaction.getSuspenseAccount();
                    break;
                }
                case 8: {
                    if (!incomingFinancialTransaction.getSuspenseType().equals("R") && incomingFinancialTransaction.getSuspenseType().trim().length() != 0) break;
                    value = incomingFinancialTransaction.getSuspenseAccount();
                }
            }
            this.financialDimension[i].setValue(value);
            this.financialDimension[i].setReadonly(true);
            if (i < 6) {
                this.fgW3.add((Field)this.financialDimension[i]);
                continue;
            }
            if (this.financialDimension[i].getDescription() == null || this.financialDimension[i].getDescription().trim().length() <= 0) continue;
            this.fgW1.add((Field)this.financialDimension[i]);
        }
        if (!this.governmentActivated) {
            return;
        }
        this.fgW4 = new FieldGroup("Label.Government");
        field = new Field("Label.IFTType", "text", null, "", 30);
        field.setReadonly(true);
        this.fgW4.add(field);
        field.setValue(GovernmentConstants.retrieveIFTTypeDescription(incomingFinancialTransaction.getIFTType()));
        if (incomingFinancialTransaction.getIFTType() == 3) {
            if (incomingFinancialTransaction.getBBVCategory() > 0) {
                field = new Field("Label.BBVCategory", "text", null, "", 30);
                field.setReadonly(true);
                this.fgW4.add(field);
                field.setValue(GovernmentConstants.retrieveBBVCategoryDescription(incomingFinancialTransaction.getBBVCategory()));
            }
            return;
        }
        if (incomingFinancialTransaction.getIFTType() < 2) {
            field = new Field("Label.BBVCategory", "text", null, "", 30);
            field.setReadonly(true);
            this.fgW4.add(field);
            field.setValue(GovernmentConstants.retrieveBBVCategoryDescription(incomingFinancialTransaction.getBBVCategory()));
        }
        if (incomingFinancialTransaction.getIFTType() == 0) {
            if (incomingFinancialTransaction.getGovernmentCode() == 1) {
                field = new Field("Label.Remark", "text", null, "", 30);
                field.setReadonly(true);
                this.fgW4.add(field);
                field.setValue(GovernmentConstants.retrieveIFTGovernmentCodeDescription(incomingFinancialTransaction.getGovernmentCode()));
            }
            return;
        }
        Credit credit = null;
        CreditBalance creditBalance = (CreditBalance)CreditBalanceBO.get(this.company, incomingFinancialTransaction.getMainAccount())[0];
        if (creditBalance == null) {
            return;
        }
        credit = (Credit)CreditBO.get(this.company, creditBalance.getCreditId())[0];
        if (credit == null) {
            return;
        }
        CreditReferenceField crf = new CreditReferenceField(this.company, true);
        crf.setReadonly(true);
        crf.setLabel("Label.Credit");
        crf.setValue(credit.getId());
        crf.setDescription(credit.getDescription());
        this.fgW4.add((Field)crf);
    }
}

