/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionDetailAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionIdImageTransformer;
import nl.ibs.fac.adapters.IncomingFinancialTransactionTransactionAdapter;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.ZeroLongToBlankTransformer;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.IncomingFinancialTransactionBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.gov.GovernmentEnumHelper;
import nl.ibs.fac.gov.adapters.BBVCategoryImageTransformer;
import nl.ibs.fac.gov.adapters.IFTGovernmentCodeImageTransformer;
import nl.ibs.fac.queries.IncomingFinancialTransactionQuery;

public class IncomingFinancialTransactionInfoAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -2730819539905894823L;
    public static final String PAGE = IncomingFinancialTransactionInfoAdapter.class.getName();
    public static final String TABLENAME1 = "IFTInfo1";
    public static final String TABLENAME2 = "IFTInfo2";
    public static final String INCOMINGFINANCIALTRANSACTION = "IncomingFinancialTransaction";
    public static final String UPDATE_TABLE = "updateTable";
    private static final String REFRESH = "refresh";
    private static final String EDIT = "editBBVCategoryWindow";
    private Company company;
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private static final ZeroLongToBlankTransformer ZLTBTRANSFORMER = new ZeroLongToBlankTransformer();
    private static final BBVCategoryImageTransformer BBVTRANSFORMER = new BBVCategoryImageTransformer();
    private static final IFTGovernmentCodeImageTransformer GOVCDETRANSFORMER = new IFTGovernmentCodeImageTransformer();
    private static final String[] TOOLTIPS = new String[]{"Label.AssetsRemoved", "Label.BBVCategory", "Label.Remark"};
    private static final String[] NAMES1 = new String[]{"bookYear", "period", "transactionValue", "id", "bBVCategory", "governmentCode", "description", "systemItemNumber", "voucherId", "internalInvoiceId"};
    private static final String[] SHORTLABELS1 = new String[]{"Label.Year", "Label.Period.short", "Label.Amount", "Label.AssetsRemoved", "Label.BBVCategory", "Label.Remark", "Label.Description", "Label.SystemItemNbr.Xshort", "Label.VoucherId.short", "Label.InvoiceNbr.Xshort"};
    private static final short[] SIZES1 = new short[]{50, 30, 125, 20, 20, 20, 210, 100, 80, 122};
    private Transformer[] transformers1;
    private static final String[] SEARCHNAMES1 = new String[]{"bookYear", "period", "transactionValue", "description", "systemItemNumber", "voucherId", "internalInvoiceId"};
    private static final String[] SEARCHLABELS1 = new String[]{"Label.Year", "Label.Period", "Label.Amount", "Label.Description", "Label.SystemItemNbr.short", "Label.VoucherId", "Label.InvoiceNbr.short"};
    private static final String[] NAMES2 = new String[]{"bookYear", "period", "transactionValue", "id", "bBVCategory", "governmentCode", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
    private final String[] shortLabels2 = new String[]{"Label.Year", "Label.Period.short", "Label.Amount", "Label.AssetsRemoved", "Label.BBVCategory", "Label.Remark", "Label.MainAccount", this.env.getShortName1(), this.env.getShortName2(), this.env.getShortName3(), this.env.getShortName4(), this.env.getShortName5()};
    private static final short[] SIZES2 = new short[]{50, 30, 125, 20, 20, 20, 85, 85, 85, 85, 85, 84};
    private Transformer[] transformers2;
    private static final String[] SEARCHNAMES2 = new String[]{"bookYear", "period", "transactionValue", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
    private String[] searchLabels2 = new String[]{"Label.Year", "Label.Period", "Label.Amount", "Label.MainAccount", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5()};
    private static final NumericIdTransformer NUMERICIDTRANSFORMER = new NumericIdTransformer();
    private Action[] rowActions;
    private Action[] headerActions;
    private FloatBar fbShow = new FloatBar();
    private IncomingFinancialTransaction incomingFinancialTransaction;
    private boolean table2Active = false;
    private Action changeView;
    private Window editWindow;
    private ComboBox oldBBVCategory;
    private ComboBox newBBVCategory;
    private static final String GRID_FILL_NONE = ESPGridLayoutConstraints.GRID_FILL_NONE;
    private static final String GRID_ANCHOR_WEST = ESPGridLayoutConstraints.GRID_ANCHOR_WEST;

    public IncomingFinancialTransactionInfoAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        IncomingFinancialTransactionIdImageTransformer idTransformer = new IncomingFinancialTransactionIdImageTransformer(this.company);
        this.transformers1 = new Transformer[]{null, null, DECIMALTRANSFORMER, idTransformer, BBVTRANSFORMER, GOVCDETRANSFORMER, null, null, null, ZLTBTRANSFORMER};
        this.transformers2 = new Transformer[]{null, null, DECIMALTRANSFORMER, idTransformer, BBVTRANSFORMER, GOVCDETRANSFORMER, null, null, null, null, null, null};
        if (this.env.getOperationArea().trim().length() == 0) {
            this.transformers1[8] = NUMERICIDTRANSFORMER;
            this.transformers2[6] = NUMERICIDTRANSFORMER;
            this.transformers2[7] = NUMERICIDTRANSFORMER;
            this.transformers2[8] = NUMERICIDTRANSFORMER;
            this.transformers2[9] = NUMERICIDTRANSFORMER;
            this.transformers2[10] = NUMERICIDTRANSFORMER;
            this.transformers2[11] = NUMERICIDTRANSFORMER;
        }
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        this.fbShow.addAction(refresh);
        this.changeView = new Action("Button.ToView_2").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("changeView");
        this.fbShow.addAction(this.changeView);
        this.fbShow.addAction(this.finish);
        Action transactions = new Action("Button.Transactions").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionTransactionAdapter.PAGE)).setMethod("show");
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionDetailAdapter.PAGE)).setMethod("showDetails");
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT);
        this.headerActions = new Action[]{refresh, this.changeView};
        this.rowActions = this.governmentActivated ? new Action[]{details, edit, transactions} : new Action[]{details, transactions};
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.getProcess().removeAttribute(INCOMINGFINANCIALTRANSACTION);
        this.incomingFinancialTransaction = null;
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.IncomingFinancialTransactionsInfo", "screen_name"));
        if (this.table == null) {
            this.createTable();
        } else if (this.table.isSelectable()) {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject changeView(DataObject object) throws Exception {
        if (this.table2Active) {
            this.table2Active = false;
            this.changeView.setLabel("Button.ToView_2");
        } else {
            this.table2Active = true;
            this.changeView.setLabel("Button.ToView_1");
        }
        this.table = null;
        return this.show(object);
    }

    private void createTable() throws Exception {
        if (this.table2Active) {
            this.createTable2();
        } else {
            this.createTable1();
        }
    }

    private void createTable1() throws Exception {
        IncomingFinancialTransactionQuery query = new IncomingFinancialTransactionQuery(this.dbData, this.companyId, true, false);
        this.table = new ODBTable(IncomingFinancialTransaction.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(TABLENAME1);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES1);
        this.table.setColumnLabels(SHORTLABELS1);
        this.table.setColumnSizes(SIZES1);
        this.table.setDisplayTransformers(this.transformers1);
        this.table.setSortable(true);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(SEARCHNAMES1, SEARCHLABELS1);
        this.searchPanel.setCSSClass("headerPanel");
        this.searchPanel.setWidth(795);
        Action filterAction = this.table.createFilterAction(SEARCHNAMES1, SEARCHLABELS1, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    private void createTable2() throws Exception {
        IncomingFinancialTransactionQuery query = new IncomingFinancialTransactionQuery(this.dbData, this.companyId, true, false);
        this.table = new ODBTable(IncomingFinancialTransaction.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(TABLENAME2);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES2);
        this.table.setColumnLabels(this.shortLabels2);
        this.table.setColumnSizes(SIZES2);
        this.table.setDisplayTransformers(this.transformers2);
        this.table.setSortable(true);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(SEARCHNAMES2, this.searchLabels2);
        this.searchPanel.setCSSClass("headerPanel");
        this.searchPanel.setWidth(795);
        Action filterAction = this.table.createFilterAction(SEARCHNAMES2, this.searchLabels2, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    public DataObject updateTable(DataObject object) throws Exception {
        this.incomingFinancialTransaction = (IncomingFinancialTransaction)this.getProcess().getAttribute(INCOMINGFINANCIALTRANSACTION);
        if (this.incomingFinancialTransaction != null) {
            this.table.setPointer("id", (Object)this.incomingFinancialTransaction.getId(), true);
            this.table.reload();
        }
        return this.show(object);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject editBBVCategoryWindow(DataObject object) throws Exception {
        this.incomingFinancialTransaction = (IncomingFinancialTransaction)TableHelper.getSelectedItem((DataObject)object);
        this.editWindow = new Window();
        this.editWindow.setTop("10%");
        this.editWindow.setRight("15%");
        this.editWindow.setLabel("Title.ChangeBBVCategory");
        this.editWindow.add(this.getHeader());
        FieldGroup fg = new FieldGroup("Label.BBVCategory");
        this.oldBBVCategory = EnumHelper.createComboBox("Label.Current", GovernmentEnumHelper.getCollection(5), false);
        this.oldBBVCategory.setSelectedOptionValue("" + this.incomingFinancialTransaction.getBBVCategory());
        this.oldBBVCategory.setReadonly(true);
        fg.add(this.oldBBVCategory);
        this.newBBVCategory = EnumHelper.createComboBox("Label.New", GovernmentEnumHelper.getCollection(5), false);
        fg.add(this.newBBVCategory);
        this.editWindow.add(fg);
        FloatBar fb = new FloatBar();
        fb.addAction(new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("editBBVCategory"));
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("cancelEdit"));
        this.editWindow.add(fb);
        object.addUIObject((UIObject)this.editWindow);
        return object;
    }

    private HeaderPanel getHeader() throws Exception {
        HeaderPanel header = new HeaderPanel();
        ESPGridLayout grid = new ESPGridLayout();
        grid.setColumnWidths(new short[]{200, 0});
        Field systemItemNumber = new Field();
        systemItemNumber.setDiscardLabel(true);
        systemItemNumber.setLength(15);
        systemItemNumber.setReadonly(true);
        grid.add((UIObject)new Label("Label.SystemItemNbr"), 0, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)systemItemNumber, 0, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        BookYearPeriodGrid iftYearPeriod = new BookYearPeriodGrid(null, true);
        grid.add((UIObject)new Label("Label.GLPeriod"), 1, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)iftYearPeriod, 1, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        Field iftTransactionValue = new Field("", "decimal", null, "", 15);
        iftTransactionValue.setDiscardLabel(true);
        iftTransactionValue.setReadonly(true);
        grid.add((UIObject)new Label("Label.TransactionValue"), 2, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)iftTransactionValue, 2, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        header.addUIObject((UIObject)grid);
        String sSystemItemNumber = this.incomingFinancialTransaction.getSystemItemSequencenumber() != 0 ? "" + this.incomingFinancialTransaction.getSystemItemNumber() + "/" + this.incomingFinancialTransaction.getSystemItemSequencenumber() : "" + this.incomingFinancialTransaction.getSystemItemNumber();
        systemItemNumber.setValue(sSystemItemNumber);
        iftYearPeriod.setValues("" + this.incomingFinancialTransaction.getBookYear(), "" + this.incomingFinancialTransaction.getPeriod());
        iftTransactionValue.setValue((String)DECIMALTRANSFORMER.transform(this.incomingFinancialTransaction.getTransactionValue()));
        return header;
    }

    public DataObject editBBVCategory(DataObject object) throws Exception {
        if (this.oldBBVCategory.getSelectedOptionValue().equals(this.newBBVCategory.getSelectedOptionValue())) {
            return this.cancelEdit(object);
        }
        String message = IncomingFinancialTransactionBP.changeBBVCategory(this.incomingFinancialTransaction, Integer.parseInt(this.newBBVCategory.getSelectedOptionValue()));
        if (message != null) {
            this.editWindow.add(new Message(message, "error"));
        } else {
            this.table.reloadPage();
            this.editWindow.closeWindow(object);
        }
        return object;
    }

    public DataObject cancelEdit(DataObject object) throws Exception {
        this.editWindow.closeWindow(object);
        return object;
    }
}

