/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.OutputField;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.MainTransactionTypeEnum;
import nl.ibs.fac.adapters.AssetOriginatedImageTransformer;
import nl.ibs.fac.adapters.AssetReferenceField;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.ExtendedTransactionAdapter;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionIdImageTransformer;
import nl.ibs.fac.adapters.IncomingFinancialTransactionInfoAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionInfoProcess;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.TransactionTypeTransformer;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.adapters.ZeroIntegerToBlankTransformer;
import nl.ibs.fac.adapters.ZeroLongToBlankTransformer;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.gov.adapters.BBVCategoryImageTransformer;
import nl.ibs.fac.gov.adapters.IFTGovernmentCodeImageTransformer;
import nl.ibs.fac.queries.TransactionQuery;

public class IncomingFinancialTransactionMultipleTransactionsAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 1314187117307114300L;
    public static final String PAGE = IncomingFinancialTransactionMultipleTransactionsAdapter.class.getName();
    public static final String TABLENAME = "IFTTAdapterMT";
    public static final String SHOWINTERNAL = "showInternal";
    private Company company;
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();
    private IncomingFinancialTransaction incomingFinancialTransaction;
    private Object[] incomingFinancialTransactions;
    private static final NumericIdTransformer NUMERICIDTRANSFORMER = new NumericIdTransformer();
    private static final ZeroLongToBlankTransformer ZLTBTRANSFORMER = new ZeroLongToBlankTransformer();
    private static final BBVCategoryImageTransformer BBVTRANSFORMER = new BBVCategoryImageTransformer();
    private static final IFTGovernmentCodeImageTransformer GOVCDETRANSFORMER = new IFTGovernmentCodeImageTransformer();
    private Panel header;
    private Field systemItemNumber;
    private Field internalInvoiceId;
    private Field voucherId;
    private BookYearPeriodGrid iftYearPeriod;
    private Field iftDescription;
    private Field iftTransactionValue;
    private Field unAllocatedValue;
    private CollectionTable table = null;
    private CollectionTable cfTable = null;
    private static final String[] NAMES = new String[]{"transactionType", "originalIFTAmount", "bookYear", "period", "assetId", "transactionOrAssetDescription", "assetOriginatedByFinancialTransaction", "bookingIndicator", "valueForAmount1", "amount2"};
    private String[] LABELS = new String[]{"Label.TransactionType.short", "Label.Amount", "Label.Year", "Label.Period.short", "Label.Asset", "Label.Description", "Label.NewAsset", "Label.BookingIndicator", "Label.Acquisition", "Label.Depreciation"};
    private static final String[] TOOLTIPS = new String[]{"Label.NewAsset", "Label.BookingIndicator"};
    private static final short[] SIZES = new short[]{120, 100, 50, 30, 80, 175, 20, 20, 100, 100};
    private static final String[] TYPES = new String[]{"text", null, null, null, null, null, null, null, null, null};
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private static final ZeroIntegerToBlankTransformer BLANKTRANSFORMER = new ZeroIntegerToBlankTransformer();
    private static final ZeroBigDecimalToBlankTransformer BD_BLANKTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
    private static final Transformer[] TRANSFORMERS = new Transformer[]{new TransactionTypeTransformer(), DECIMALTRANSFORMER, BLANKTRANSFORMER, BLANKTRANSFORMER, null, null, new AssetOriginatedImageTransformer(), new BBVCategoryImageTransformer(), BD_BLANKTRANSFORMER, BD_BLANKTRANSFORMER};
    private static final boolean[] COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true};
    private Map<String, ComboBox> inputComponents = new HashMap<String, ComboBox>();
    private TransactionTableRowMethod transactionTableRowMethod = new TransactionTableRowMethod();
    private static final String REFRESH = "refresh";
    private FloatBar fbShow1 = new FloatBar();
    private FloatBar fbShow2 = new FloatBar();
    private Action allocate;
    private Action confirm;
    private Action[] rowActions;
    private Action[] headerActions;
    private FloatBar fbDelete = new FloatBar();
    private ArrayList<Object> deleteList;
    private boolean info;
    private String[] NAMES0;
    private String[] shortLabels0;
    private short[] SIZES0;
    private String[] SEARCHNAMES0;
    private String[] searchLabels0;
    private Transformer[] transformers0;
    private String[] NAMES2;
    private AssetReferenceField assetField;

    public IncomingFinancialTransactionMultipleTransactionsAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        if (this.env.getShortName5().trim().length() > 0) {
            this.NAMES0 = new String[]{"systemItemNumber", "transactionValue", "bookYear", "period", "description", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "description2", "bBVCategory", "governmentCode", "voucherId", "internalInvoiceId"};
            this.SIZES0 = new short[]{60, 85, 40, 30, 125, 85, 85, 85, 85, 85, 85, 125, 50, 50, 50, 50, 50};
            this.SEARCHNAMES0 = new String[]{"systemItemNumber", "transactionValue", "bookYear", "period", "description", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "description2", "id", "bBVCategory", "governmentCode", "voucherId", "internalInvoiceId"};
            this.NAMES2 = new String[]{"systemItemNumber", "transactionValue", "bookYear", "period", "description", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
            this.shortLabels0 = new String[]{"Label.SystemItemNbr.Xshort", "Label.Amount", "Label.Year", "Label.Period.short", "Label.Description", "Label.MainAccount", this.env.getShortName1(), this.env.getShortName2(), this.env.getShortName3(), this.env.getShortName4(), this.env.getShortName5(), "Label.Description2", "Label.BBVCategory", "Label.Remark", "Label.VoucherId.short", "Label.InvoiceNbr.Xshort"};
        } else {
            this.NAMES0 = new String[]{"systemItemNumber", "transactionValue", "bookYear", "period", "description", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "bBVCategory", "governmentCode", "voucherId", "internalInvoiceId"};
            this.SIZES0 = new short[]{60, 85, 40, 30, 125, 85, 85, 85, 85, 85, 86, 85, 86, 85, 85, 85};
            this.SEARCHNAMES0 = new String[]{"systemItemNumber", "transactionValue", "bookYear", "period", "description", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "bBVCategory", "governmentCode", "voucherId", "internalInvoiceId"};
            this.NAMES2 = new String[]{"systemItemNumber", "transactionValue", "bookYear", "period", "description", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4"};
            this.shortLabels0 = new String[]{"Label.SystemItemNbr.Xshort", "Label.Amount", "Label.Year", "Label.Period.short", "Label.Description", "Label.MainAccount", this.env.getShortName1(), this.env.getShortName2(), this.env.getShortName3(), this.env.getShortName4(), "Label.BBVCategory", "Label.Government", "Label.VoucherId.short", "Label.InvoiceNbr.Xshort"};
        }
        this.searchLabels0 = new String[]{"Label.SystemItemNbr.short", "Label.Amount", "Label.Year", "Label.Period", "Label.Description", "Label.MainAccount", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5(), "Label.Description2", "Label.VoucherId", "Label.InvoiceNbr.short"};
        this.info = this.getProcess() instanceof IncomingFinancialTransactionInfoProcess;
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        IncomingFinancialTransactionIdImageTransformer idTransformer = new IncomingFinancialTransactionIdImageTransformer(this.company);
        this.transformers0 = new Transformer[]{null, DECIMALTRANSFORMER, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        if (this.env.getOperationArea().trim().length() == 0) {
            this.transformers0[8] = NUMERICIDTRANSFORMER;
            this.transformers0[10] = NUMERICIDTRANSFORMER;
            this.transformers0[11] = NUMERICIDTRANSFORMER;
            this.transformers0[12] = NUMERICIDTRANSFORMER;
            this.transformers0[13] = NUMERICIDTRANSFORMER;
            this.transformers0[14] = NUMERICIDTRANSFORMER;
            this.transformers0[15] = NUMERICIDTRANSFORMER;
        }
        Action back = !this.info ? new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionAdapter.PAGE)).setMethod("updateTableMultipleTransactions") : new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionInfoAdapter.PAGE)).setMethod("updateTable");
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        this.fbShow2.addAction(back);
        this.fbShow2.addAction(refresh);
        Action confirmDelete = null;
        if (!this.info) {
            this.allocate = new Action("Button.Allocate").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionAdapter.PAGE)).setMethod("allocateEntry");
            this.confirm = new Action("Button.Confirm").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionAdapter.PAGE)).setMethod("confirmEntryMultipleTransactions");
            confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDelete");
            this.fbShow1.addAction(this.allocate);
            this.fbShow1.addAction(this.confirm);
            this.fbShow2.addAction(confirmDelete);
        }
        this.fbShow2.addAction(this.finish);
        this.headerActions = new Action[]{refresh, this.allocate, this.confirm};
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(ExtendedTransactionAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{details, confirmDelete};
        ComboBox mtt = EnumHelper.createComboBox("Label.MainTransactionType", MainTransactionTypeEnum.getCollection(), true);
        mtt.setWidth("150");
        this.inputComponents.put("mainTransactionType", mtt);
        this.fbDelete.addAction(new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("delete"));
        this.fbDelete.addAction(new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SHOWINTERNAL));
        this.fbDelete.addAction(this.finish);
        this.header = new HeaderPanel();
        this.assetField = new AssetReferenceField(this.company, null, new Boolean(true), true, false, new Boolean(false));
        this.assetField.setLabel("Label.Asset");
        this.assetField.setDescriptionLength(35);
        this.assetField.setReadonly(true);
        this.header.addUIObject((UIObject)this.assetField);
        this.systemItemNumber = new Field("Label.SystemItemNbr");
        this.systemItemNumber.setLength(15);
        this.systemItemNumber.setReadonly(true);
        this.header.addUIObject((UIObject)this.systemItemNumber);
        this.internalInvoiceId = new Field("Label.InvoiceNbr", "text", null, "", 15);
        this.internalInvoiceId.setReadonly(true);
        this.header.addUIObject((UIObject)this.internalInvoiceId);
        this.voucherId = new Field("Label.VoucherId", "text", null, "", 15);
        this.voucherId.setReadonly(true);
        this.header.addUIObject((UIObject)this.voucherId);
        this.iftDescription = new Field("Label.Description", "text", null, "", 50);
        this.iftDescription.setReadonly(true);
        this.header.addUIObject((UIObject)this.iftDescription);
        this.iftYearPeriod = new BookYearPeriodGrid("Label.GLPeriod", true);
        this.header.addUIObject((UIObject)this.iftYearPeriod);
        this.iftTransactionValue = new Field("Label.TransactionValue", "decimal", null, "", 15);
        this.iftTransactionValue.setReadonly(true);
        this.header.addUIObject((UIObject)this.iftTransactionValue);
        this.unAllocatedValue = new Field("Label.StillAllocatable.short", "decimal", null, "", 15);
        this.unAllocatedValue.setReadonly(true);
        if (!this.info) {
            this.header.addUIObject((UIObject)this.unAllocatedValue);
        }
    }

    public DataObject show(DataObject object) throws Exception {
        this.incomingFinancialTransactions = (Object[])this.getProcess().getAttribute("IncomingFinancialTransactions");
        this.assetField.setValue((String)this.getProcess().getAttribute("Asset"));
        this.assetField.validate();
        return this.refresh(object);
    }

    public DataObject showInternal(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        if (this.info) {
            object.addUIObject((UIObject)new Header("Title.InquiryIFT_Transactions", "screen_name"));
        } else {
            object.addUIObject((UIObject)new Header("Title.AllocateIFT_Transactions", "screen_name"));
        }
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.fbShow1);
        if (this.table == null) {
            this.createTable();
        } else if (this.table.isSelectable()) {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow2);
        return object;
    }

    private void createTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.incomingFinancialTransactions.length);
        for (int i = 0; i < this.incomingFinancialTransactions.length; ++i) {
            list.add(this.incomingFinancialTransactions[i]);
        }
        this.table = new CollectionTable(IncomingFinancialTransaction.class, list, 12);
        this.table.setName(TABLENAME);
        this.table.setColumnNames(this.NAMES0);
        this.table.setColumnsToDisplay(this.NAMES2);
        this.table.setColumnLabels(this.shortLabels0);
        this.table.setColumnSizes(this.SIZES0);
        this.table.setDisplayTransformers(this.transformers0);
        if (!this.info) {
            this.table.setMultipleSelectable();
        }
        this.table.setSortable(true);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.systemItemNumber.setHidden(true);
        this.internalInvoiceId.setHidden(true);
        this.voucherId.setHidden(true);
        IncomingFinancialTransaction ift = (IncomingFinancialTransaction)this.incomingFinancialTransactions[0];
        this.iftYearPeriod.setValues("" + ift.getBookYear(), "" + ift.getPeriod());
        this.iftDescription.setHidden(true);
        BigDecimal transactionValue = new BigDecimal(0);
        BigDecimal unallocatedValueBD = new BigDecimal(0);
        IncomingFinancialTransaction incomingFinancialTransactionLaatste = null;
        for (int i = 0; i < this.incomingFinancialTransactions.length; ++i) {
            incomingFinancialTransactionLaatste = (IncomingFinancialTransaction)this.incomingFinancialTransactions[i];
            unallocatedValueBD = unallocatedValueBD.add(incomingFinancialTransactionLaatste.getUnAllocatedValue());
            transactionValue = transactionValue.add(incomingFinancialTransactionLaatste.getTransactionValue());
        }
        this.iftTransactionValue.setValue((String)DECIMALTRANSFORMER.transform(transactionValue));
        this.unAllocatedValue.setValue((String)DECIMALTRANSFORMER.transform(unallocatedValueBD));
        if (!this.info) {
            if (unallocatedValueBD.doubleValue() != 0.0) {
                this.allocate.setDefault(true);
                this.allocate.setEnabled(true);
                this.confirm.setDefault(false);
                this.confirm.setEnabled(false);
            } else {
                this.allocate.setDefault(false);
                this.allocate.setEnabled(false);
                this.confirm.setDefault(true);
                this.confirm.setEnabled(true);
            }
        }
        this.table = null;
        return this.showInternal(object);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteTransactions", "screen_name"));
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.createConfirmationTable(object));
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable(DataObject object) throws Exception {
        Object[] incomingFinTransactions = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        TransactionQuery query = new TransactionQuery(this.dbData, this.incomingFinancialTransaction);
        this.deleteList = new ArrayList(incomingFinTransactions.length);
        for (int i = 0; i < incomingFinTransactions.length; ++i) {
            IncomingFinancialTransaction incfintrns = (IncomingFinancialTransaction)incomingFinTransactions[i];
            TransactionQuery queryIfntrns = new TransactionQuery(this.dbData, incfintrns);
            for (Transaction transaction : queryIfntrns.fetchData(null, null, null, 0)) {
                this.deleteList.add(transaction);
            }
        }
        this.cfTable = new CollectionTable(Transaction.class, this.deleteList, 12);
        this.cfTable.setName(PAGE);
        this.cfTable.setColumnNames(NAMES);
        this.cfTable.setColumnLabels(this.LABELS);
        this.cfTable.orderByColumn(NAMES[0]);
        this.cfTable.setColumnSizes(SIZES);
        this.cfTable.setColumnTypes(TYPES);
        this.cfTable.setDisplayTransformers(TRANSFORMERS);
        this.cfTable.setSortable(true);
        this.cfTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.cfTable, (String[])TOOLTIPS);
        return this.cfTable;
    }

    public DataObject delete(DataObject object) throws Exception {
        Transaction transaction = null;
        String message = null;
        Object[] transactions = this.deleteList.toArray();
        for (int i = 0; i < transactions.length; ++i) {
            transaction = (Transaction)transactions[i];
            message = TransactionBO.delete(transaction, transaction.getIncomingFinancialTransaction(), null);
            if (message == null) continue;
            object.addUIObject((UIObject)new Message(message, "error"));
        }
        if (transaction != null) {
            ArrayList<IncomingFinancialTransaction> incomingFinancialTransactionsTemp = new ArrayList<IncomingFinancialTransaction>();
            for (int i = 0; i < this.incomingFinancialTransactions.length; ++i) {
                IncomingFinancialTransaction incFinTransTemp = (IncomingFinancialTransaction)this.incomingFinancialTransactions[i];
                if (transaction.getIncomingFinancialTransaction().getSystemItemNumber() == incFinTransTemp.getSystemItemNumber()) continue;
                incomingFinancialTransactionsTemp.add(incFinTransTemp);
            }
            this.incomingFinancialTransactions = incomingFinancialTransactionsTemp.toArray();
        }
        if (message != null) {
            return object;
        }
        return this.refresh(object);
    }

    private class TransactionTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 8351780433747830979L;

        private TransactionTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            Transaction transaction = (Transaction)row.getObject();
            if (AssetBO.isIdNumeric(IncomingFinancialTransactionMultipleTransactionsAdapter.this.company, "C".equals(transaction.getCora()))) {
                OutputField field = (OutputField)row.getUIOBjectByName(OutputField.class, "assetId");
                field.setValue((String)IncomingFinancialTransactionMultipleTransactionsAdapter.this.numericIdTransformer.transform(transaction.getAssetId()));
                field.setType("number");
            }
            ContextMenu menu = new ContextMenu();
            for (int i = 0; i < rowActions.length; ++i) {
                if (rowActions[i] == null) continue;
                ContextAction rowAction = new ContextAction(rowActions[i].getName());
                rowAction.setAdapter(rowActions[i].getPageid());
                rowAction.setMethod(rowActions[i].getMethod());
                menu.addContextMenuItem(rowAction);
            }
            row.setContextMenu(menu);
        }
    }
}

