/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.ReportAdapterHelper;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.IncomingFinancialTransactionToCSV;
import nl.ibs.fac.reports.IncomingFinancialTransactionToPDF;
import nl.ibs.fac.ui.IncomingFinancialTransactionSelection;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.Scrambler;

public class IncomingFinancialTransactionReportAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 3708988390053786317L;
    public static final String PAGE = IncomingFinancialTransactionReportAdapter.class.getName();
    private static final String SUBMIT = "submit";
    private String title = "Title.IncomingFinancialTransactionReport";
    private String classNameCSV = IncomingFinancialTransactionToCSV.CLASSNAME;
    private String classNamePDF = IncomingFinancialTransactionToPDF.CLASSNAME;
    private String jobName = "Job.IncomingFinancialTransactionReport";
    private Panel selectionPanel = null;
    private IncomingFinancialTransactionSelection selection = null;
    private Panel panel = new HeaderPanel("");
    private CheckBox justTotals;
    private CheckBox generalTotal;
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbShowSelectionPanel = new FloatBar();
    private ComboBox reportType;
    private ReportTypeChangeAction reportTypeChangeAction;
    private BookYearPeriodGrid periodFrom;
    private BookYearPeriodGrid periodTo;
    private static final String GRID_FILL_NONE = ESPGridLayoutConstraints.GRID_FILL_NONE;
    private static final String GRID_ANCHOR_WEST = ESPGridLayoutConstraints.GRID_ANCHOR_WEST;
    private FieldGroup subPanel = new FieldGroup("Label.Common");

    public IncomingFinancialTransactionReportAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        ESPGridLayout grid = new ESPGridLayout();
        grid.setColumnWidths(new short[]{200, 0});
        this.periodFrom = new BookYearPeriodGrid(null, "", this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.periodFrom.setMandatory(false);
        this.periodTo = new BookYearPeriodGrid(null, "", this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.periodTo.setMandatory(false);
        grid.add((UIObject)new Label("Label.Period"), 0, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)this.periodFrom, 0, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)new Label("up-to-and-including"), 1, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)this.periodTo, 1, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        this.panel.addUIObject((UIObject)grid);
        this.reportType = ReportAdapterHelper.retrieveReportTypeComboBox(false);
        this.reportTypeChangeAction = new ReportTypeChangeAction();
        this.reportType.add((Action)this.reportTypeChangeAction);
        this.subPanel.add(this.reportType);
        this.justTotals = new CheckBox(LanguageHelper.getString("nl.ibs.fac.language", "JustTotals"));
        this.subPanel.add(this.justTotals);
        this.generalTotal = new CheckBox("Label.PrintGeneralTotal", false);
        this.subPanel.add(this.generalTotal);
        Action next = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showSelectionPanel");
        next.setValidationEnabled(true);
        next.setDefault(true);
        this.fbShow.addAction(next);
        this.fbShow.addAction(this.finish);
        this.fbShowSelectionPanel.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("show"));
        Action ok = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        this.fbShowSelectionPanel.addAction(ok);
        this.fbShowSelectionPanel.addAction(this.finish);
        this.selection = new IncomingFinancialTransactionSelection(object);
        this.selection.hideFieldGroup = true;
        this.reportTypeChangeAction.execute(object);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(this.title, "screen_name"));
        this.panel.setReadonly(false);
        object.addUIObject((UIObject)this.panel);
        this.subPanel.setReadonly(false);
        object.addUIObject((UIObject)this.subPanel);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject showSelectionPanel(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(this.title, "screen_name"));
        this.panel.setReadonly(true);
        object.addUIObject((UIObject)this.panel);
        this.selectionPanel = this.selection.getSelectionPanel(this.loginHelper);
        object.addUIObject((UIObject)this.selectionPanel);
        object.addUIObject((UIObject)this.fbShowSelectionPanel);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair("User", this.loginHelper.getUser()));
        list.add(new NameValuePair("System", this.loginHelper.getSystem()));
        list.add(new NameValuePair("Password", Scrambler.scramble((String)this.loginHelper.getPassword())));
        list.add(new NameValuePair("facLib", this.dbData.getSchema()));
        list.add(new NameValuePair("Environment", this.env.getId()));
        list.add(new NameValuePair("Company", this.companyId));
        list.add(new NameValuePair("BookYear", this.bookYear));
        list.add(new NameValuePair("governmentActivated", "" + this.governmentActivated));
        list.add(new NameValuePair("BookYearFrom", "" + this.periodFrom.getBookYear().getIntValue()));
        list.add(new NameValuePair("PeriodFrom", "" + this.periodFrom.getPeriod().getIntValue()));
        list.add(new NameValuePair("BookYearTo", "" + this.periodTo.getBookYear().getIntValue()));
        list.add(new NameValuePair("PeriodTo", "" + this.periodTo.getPeriod().getIntValue()));
        this.selection.fldJustTotals.setValue(this.justTotals.getValueAsBoolean());
        this.selection.fldGrandTotal.setValue(this.generalTotal.getValueAsBoolean());
        this.selection.setBookYearFrom(this.periodFrom.getBookYear().getValue());
        this.selection.setPeriodFrom(this.periodFrom.getPeriod().getValue());
        this.selection.setBookYearTo(this.periodTo.getBookYear().getValue());
        this.selection.setPeriodTo(this.periodTo.getPeriod().getValue());
        list.add(new NameValuePair(IncomingFinancialTransactionSelection.IFTSELECTION, this.selection.getStringRepresentation()));
        this.selection.save();
        this.getProcess().setAttribute("selections", (Object)NameValuePair.getStringArray(list));
        this.getProcess().setAttribute("title", (Object)this.title);
        this.getProcess().removeAttribute("classNameCSV");
        this.getProcess().removeAttribute("classNamePDF");
        if ("CSV".equals(this.reportType.getValue())) {
            this.getProcess().setAttribute("classNameCSV", (Object)this.classNameCSV);
        } else {
            this.getProcess().setAttribute("classNamePDF", (Object)this.classNamePDF);
        }
        this.getProcess().setAttribute("jobName", (Object)this.jobName);
        this.getProcess().setAttribute("backPage", (Object)PAGE);
        this.getProcess().setAttribute("backMethod", (Object)"show");
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "showInWindow", this.getProcess().getProcessId()));
        return object;
    }

    private class ReportTypeChangeAction
    extends Action {
        private static final long serialVersionUID = 1L;

        public boolean execute(DataObject dataObject) throws Exception {
            if ("CSV".equals(IncomingFinancialTransactionReportAdapter.this.reportType.getValue())) {
                IncomingFinancialTransactionReportAdapter.this.justTotals.setValue(false);
                IncomingFinancialTransactionReportAdapter.this.justTotals.setHidden(true);
                IncomingFinancialTransactionReportAdapter.this.generalTotal.setValue(false);
                IncomingFinancialTransactionReportAdapter.this.generalTotal.setHidden(true);
                IncomingFinancialTransactionReportAdapter.this.selection.setDisplayAttributes(true, false, false, false, false);
            } else {
                IncomingFinancialTransactionReportAdapter.this.justTotals.setHidden(false);
                IncomingFinancialTransactionReportAdapter.this.generalTotal.setHidden(false);
                IncomingFinancialTransactionReportAdapter.this.selection.setDisplayAttributes(true, false, false, true, true);
            }
            IncomingFinancialTransactionReportAdapter.this.panel.setModified();
            return true;
        }
    }
}

