/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.adapters.AssetPanels;
import nl.ibs.fac.adapters.AssetReferenceField;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FinancialCompanyReferenceField;
import nl.ibs.fac.adapters.ParentAssetAdapter;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.bp.InterCompanyMovementBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.db.AssetValue;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Valuation;

public class InterCompanyMovementAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 146384013799728790L;
    public static final String PAGE = InterCompanyMovementAdapter.class.getName();
    public static final String RETURNPAGE = "InterCompanyMovementAdapterReturnPage";
    public static final String RETURNMETHOD = "InterCompanyMovementAdapterReturnMethod";
    public static final String ASSET = "InterCompanyMovementAsset";
    private Company company;
    private Asset asset;
    private InterCompanyMovementBP interCompanyMovementBP;
    private BigDecimal[] interCompanyMovementValues;
    private Panel headerPanel;
    private AssetReferenceField assetReferenceField;
    private Window window;
    private Action closeContinued;
    private BookYearPeriodGrid facYearPeriod;
    private BookYearPeriodGrid finYearPeriod;
    private FinancialCompanyReferenceField companyReferenceFieldTo;
    private Company toCompany;
    private AssetPanels panels;
    private FloatBar fbCreate = new FloatBar();
    private Valuation[] valuation = new Valuation[2];

    public InterCompanyMovementAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.interCompanyMovementBP = new InterCompanyMovementBP(this.company, this.numberOfPeriods, this.company.getProcessParameters().getUseRCTableForMOVIC());
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "close");
        this.window.setLabel("Title.InterCompanyMovement");
        this.window.setTop("10%");
        this.window.setRight("15%");
        this.headerPanel = new HeaderPanel();
        this.assetReferenceField = new AssetReferenceField(this.company, null, null, false, false);
        this.assetReferenceField.setLabel("Label.Asset");
        this.assetReferenceField.setReadonly(true);
        this.assetReferenceField.setDescriptionLength(40);
        this.headerPanel.addUIObject((UIObject)this.assetReferenceField);
        ReferenceField rf = new ReferenceField("Label.FromCompany");
        rf.setLength(10);
        rf.setDescriptionLength(40);
        rf.setValue(this.companyId);
        rf.setDescription(this.company.getDescription());
        rf.setReadonly(true);
        this.headerPanel.addUIObject((UIObject)rf);
        this.window.add(this.headerPanel);
        FieldGroup fg = new FieldGroup();
        this.companyReferenceFieldTo = new FinancialCompanyReferenceField(this.loginHelper, this.env);
        this.companyReferenceFieldTo.setLabel("Label.ToCompany");
        this.companyReferenceFieldTo.setLength(10);
        this.companyReferenceFieldTo.setMandatory(true);
        this.companyReferenceFieldTo.setDescriptionLength(40);
        this.companyReferenceFieldTo.setValue();
        this.companyReferenceFieldTo.setDescription("");
        fg.add((Field)this.companyReferenceFieldTo);
        this.window.add(fg);
        this.facYearPeriod = new BookYearPeriodGrid("Label.FACStartPeriod", "" + this.company.getCurrentBookYear(), this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.finYearPeriod = new BookYearPeriodGrid("Label.BookPeriod", false);
        fg.add((ESPGridLayout)this.facYearPeriod);
        fg.add((ESPGridLayout)this.finYearPeriod);
        FloatBar fb = new FloatBar();
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initCreateForm");
        ok.setDefault(true);
        ok.setValidationEnabled(true);
        fb.addAction(ok);
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("close"));
        fg.add(fb);
        Action createOK = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createDimensionsForm");
        createOK.setDefault(true);
        createOK.setValidationEnabled(true);
        this.fbCreate.addAction(createOK);
        this.closeContinued = new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("closeContinued");
        this.fbCreate.addAction(this.closeContinued);
    }

    public DataObject show(DataObject object) throws Exception {
        this.asset = (Asset)this.getProcess().getAttribute(ASSET);
        this.valuation[0] = (Valuation)ValuationBO.get(this.dbData, this.company.getId(), this.asset.getCora(), this.asset.getId(), 1)[0];
        this.valuation[1] = null;
        String message = this.interCompanyMovementBP.hasNotPostedTransactions(this.asset);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        if (this.asset.getState() != 2) {
            object.addUIObject((UIObject)new Message("invalid_state", "error"));
            return object;
        }
        this.assetReferenceField.setValue(this.asset.getId());
        this.assetReferenceField.setDescription(this.asset.getDescription());
        this.companyReferenceFieldTo.setValue();
        this.companyReferenceFieldTo.setDescription("");
        String[] yps = this.interCompanyMovementBP.retrieveYearsAndPeriods(this.asset, null);
        this.facYearPeriod.setValues(yps[0], yps[1]);
        this.finYearPeriod.setValues(yps[2], yps[3]);
        return this.showContinued(object);
    }

    public DataObject showContinued(DataObject object) throws Exception {
        this.headerPanel.removeUIObject((UIObject)this.companyReferenceFieldTo, false);
        this.companyReferenceFieldTo.setReadonly(false);
        object.addUIObject((UIObject)this.window);
        this.window.removeUIObjects(Message.class, false);
        return object;
    }

    public DataObject close(DataObject object) throws Exception {
        this.window.closeWindow(object);
        return this.closeContinued(object);
    }

    public DataObject closeContinued(DataObject object) throws Exception {
        object.addUIObject((UIObject)new RedirectAction(this.getProcess().getAttribute(RETURNPAGE).toString(), this.getProcess().getAttribute(RETURNMETHOD).toString(), this.getProcess().getProcessId()));
        return object;
    }

    public DataObject initCreateForm(DataObject object) throws Exception {
        String[] messages;
        boolean error = false;
        String toCompanyId = this.companyReferenceFieldTo.getValue();
        if (this.companyId.equals(toCompanyId)) {
            error = true;
            object.addUIObject((UIObject)new Message("value_not_valid", "error"));
            this.companyReferenceFieldTo.setInvalidTag();
        }
        if ((messages = this.interCompanyMovementBP.validateFACYearAndPeriod(this.asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), false)) != null) {
            error = true;
            this.addErrors(object, messages);
            this.facYearPeriod.getBookYear().setInvalidTag();
            this.facYearPeriod.getPeriod().setInvalidTag();
        }
        if ((messages = this.interCompanyMovementBP.validateFINYearAndPeriod(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax))) != null) {
            error = true;
            this.addErrors(object, messages);
            this.finYearPeriod.getBookYear().setInvalidTag();
            this.finYearPeriod.getPeriod().setInvalidTag();
        }
        if (error) {
            return object;
        }
        this.companyReferenceFieldTo.setReadonly(true);
        this.headerPanel.addUIObject((UIObject)this.companyReferenceFieldTo);
        this.toCompany = (Company)CompanyBO.get(this.dbData, toCompanyId)[0];
        int numberOfPeriods = this.toCompany.retrieveNumberOfPeriods();
        this.panels = new AssetPanels(this.loginHelper, this.dbData, this.env, this.toCompany, this.bookYearMin, this.bookYearMax, numberOfPeriods, this.governmentActivated, null, false, false, true, null, false, null, null);
        this.getProcess().setAttribute("ParentAssetAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("ParentAssetAdapterReturnMethod", (Object)"createCommonForm");
        this.panels.fbParent.addAction(this.panels.getCreateParentAssetAction().setAdapter(this.getProcessAdapterPageName(ParentAssetAdapter.PAGE)).setMethod("initCreateForm"));
        return this.createCommonForm(object);
    }

    private void addErrors(DataObject object, String[] errors) throws Exception {
        for (int i = 0; i < errors.length; ++i) {
            if (errors[i] == null || errors[i].trim().length() <= 0) continue;
            object.addUIObject((UIObject)new Message(errors[i], "error"));
        }
    }

    public DataObject createCommonForm(DataObject object) throws Exception {
        this.handleNewParent();
        this.panels.id.setReadonly(this.panels.idReadOnly);
        this.panels.id.setLabel("");
        this.panels.description.setReadonly(false);
        this.panels.description.setLabel("");
        this.panels.description.setValue(this.asset.getDescription());
        this.panels.parent.setValue(this.asset.getParent());
        this.panels.type.setValue();
        String companyOrDataSetId = this.toCompany.getId();
        if (this.toCompany.getDataSetId() != null) {
            companyOrDataSetId = this.toCompany.getDataSetId();
        }
        if (AssetTypeBO.get(this.company.getDBData(), companyOrDataSetId, this.asset.getTypeId())[0] != null) {
            this.panels.type.setValue(this.asset.getTypeId());
        }
        if (this.asset.getHistoricalYear() != 0) {
            this.panels.historicalYP.setValues("" + this.asset.getHistoricalYear(), "" + this.asset.getHistoricalPeriod());
        } else {
            this.panels.historicalYP.setValues("" + this.asset.getStartUseYear(), "" + this.asset.getStartUsePeriod());
        }
        this.panels.historicalYP.setReadonly(true);
        this.panels.investmentYP.setValues("" + this.facYearPeriod.getBookYear().getIntValue(), "" + this.facYearPeriod.getPeriod().getIntValue());
        this.panels.investmentYP.setReadonly(true);
        this.panels.bookYP.setValues("" + this.finYearPeriod.getBookYear().getIntValue(), "" + this.finYearPeriod.getPeriod().getIntValue());
        this.panels.bookYP.setReadonly(true);
        this.interCompanyMovementBP.calculateInterCompanyMovementValues(this.asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue());
        this.interCompanyMovementValues = this.interCompanyMovementBP.getInterCompanyMovementValues();
        this.panels.acquisitionValue.setValue(this.interCompanyMovementValues[1].multiply(new BigDecimal("-1")));
        this.panels.acquisitionValue.setReadonly(true);
        this.panels.negativeInvestment.setValue(this.asset.getNegativeInvestment());
        this.panels.negativeInvestment.setReadonly(true);
        this.panels.acquisitionDate.setValue(this.asset.getAcquisitionDate());
        this.panels.acquisitionDate.setReadonly(true);
        return this.createCommonFormContinued(object);
    }

    public DataObject createCommonFormContinued(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.InterCompanyMovementAddAsset", "screen_name"));
        object.addUIObject((UIObject)this.headerPanel);
        object.addUIObject((UIObject)this.panels.firstPanel);
        object.addUIObject((UIObject)this.panels.secondPanel);
        object.addUIObject((UIObject)this.fbCreate);
        return object;
    }

    public DataObject createDimensionsForm(DataObject object) throws Exception {
        String name;
        Object[] result;
        if (!this.panels.id.isHidden() && (result = AssetBO.get(this.toCompany, this.panels.id.getValue().trim(), false))[0] != null) {
            this.panels.id.setInvalidTag();
            object.addUIObject((UIObject)new Message("duplicate_key", "error"));
            return object;
        }
        String message = this.panels.validateCommonForm();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.valuation[1] = (Valuation)ValuationBO.get(this.dbData, this.company.getId(), this.asset.getCora(), this.asset.getId(), 2)[0];
        boolean ap2 = this.panels.assetType.getAccountingPrinciple2IsUsed();
        if (ap2 && this.valuation[1] == null) {
            object.addUIObject((UIObject)new Message("asset_has_noaccountingprinciple2", "error"));
            this.panels.type.setInvalidTag();
            return object;
        }
        if (!ap2 && this.valuation[1] != null) {
            object.addUIObject((UIObject)new Message("type_has_noaccountingprinciple2", "error"));
            this.panels.type.setInvalidTag();
            return object;
        }
        this.panels.id.setReadonly(true);
        this.panels.id.setLabel("Label.Id");
        this.panels.id.setHelpId("Label.AssetId");
        this.panels.description.setReadonly(true);
        this.panels.description.setLabel("Label.Description");
        this.panels.initializeType();
        this.panels.copyStartUsePeriod();
        if (this.panels.dimensionPanels.financialDimension[0] != null) {
            this.panels.dimensionPanels.financialDimension[0].setValue(this.asset.getFinDimId1());
        }
        if (this.panels.dimensionPanels.financialDimension[1] != null) {
            this.panels.dimensionPanels.financialDimension[1].setValue(this.asset.getFinDimId2());
        }
        if (this.panels.dimensionPanels.financialDimension[2] != null) {
            this.panels.dimensionPanels.financialDimension[2].setValue(this.asset.getFinDimId3());
        }
        if (this.panels.dimensionPanels.financialDimension[3] != null) {
            this.panels.dimensionPanels.financialDimension[3].setValue(this.asset.getFinDimId4());
        }
        if (this.panels.dimensionPanels.financialDimension[4] != null) {
            this.panels.dimensionPanels.financialDimension[4].setValue(this.asset.getFinDimId5());
        }
        block0: for (AssetAnalysisCode assetAnalysisCode : this.asset.getAssetAnalysisCodeCollection(null)) {
            name = assetAnalysisCode.getAnalysisCode().getOwnedByAnalysisGroupAsCodes().getName();
            for (int i = 0; i < 10; ++i) {
                if (this.panels.dimensionPanels.dimension[i] == null || !name.equals(this.panels.dimensionPanels.dimension[i].getLanguageCode())) continue;
                this.panels.dimensionPanels.dimension[i].setValue(assetAnalysisCode);
                continue block0;
            }
        }
        block2: for (AssetValue assetValue : this.asset.getAssetValueCollection(null)) {
            name = assetValue.getAnalysisGroup().getName();
            for (int i = 0; i < 10; ++i) {
                if (this.panels.dimensionPanels.freeDimension[i] == null || !name.equals(this.panels.dimensionPanels.freeDimension[i].getLanguageCode())) continue;
                this.panels.dimensionPanels.freeDimension[i].setValue(assetValue.getValue());
                continue block2;
            }
        }
        return this.createDimensionsFormContinued(object);
    }

    public DataObject createDimensionsFormContinued(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.InterCompanyMovementDimensions", "screen_name"));
        object.addUIObject((UIObject)this.headerPanel);
        object.addUIObject((UIObject)this.panels.headerPanel);
        object.addUIObject((UIObject)this.panels.finDimensionPanel);
        object.addUIObject((UIObject)this.panels.facDimensionPanel);
        FloatBar fb = new FloatBar();
        Action action = new Action("Vorige").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createCommonForm");
        fb.addAction(action);
        action = new Action("Volgende").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleForm");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(this.closeContinued);
        object.addUIObject((UIObject)fb);
        return object;
    }

    public DataObject createAccountingPrincipleFormNext(DataObject object) throws Exception {
        String message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        ++this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleFormPrevious(DataObject object) throws Exception {
        --this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleForm(DataObject object) throws Exception {
        int[] correctionPeriods;
        this.panels.id.setReadonly(true);
        this.panels.description.setReadonly(true);
        this.panels.setAPValues(this.valuation, this.panels.apTabCount);
        int i = this.panels.apTabCount;
        int index = 1;
        if (this.valuation[i].getAccountingPrinciple() == 2) {
            index = 3;
        }
        BigDecimal acquisitionBalance = this.interCompanyMovementValues[index].multiply(new BigDecimal("-1"));
        this.panels.acquTotal[i].setValue(acquisitionBalance);
        BigDecimal depreciationBalance = this.interCompanyMovementValues[index + 1].multiply(new BigDecimal("-1"));
        this.panels.deprTotal[i].setValue(depreciationBalance);
        this.panels.bookTotal[i].setValue(acquisitionBalance.subtract(depreciationBalance));
        if (PeriodHelper.isAfter(this.valuation[i].getStartDepreciationBookYear(), this.valuation[i].getStartDepreciationPeriod(), this.panels.investmentYP.getBookYear().getIntValue(), this.panels.investmentYP.getPeriod().getIntValue())) {
            this.panels.startDepreciation[i].setValues("" + this.valuation[i].getStartDepreciationBookYear(), "" + this.valuation[i].getStartDepreciationPeriod());
        } else {
            this.panels.startDepreciation[i].setValues("" + this.panels.investmentYP.getBookYear().getIntValue(), "" + this.panels.investmentYP.getPeriod().getIntValue());
        }
        if (this.valuation[i].getInterestBookYear() != 0) {
            if (!PeriodHelper.isBefore(this.valuation[i].getInterestBookYear(), this.valuation[i].getInterestPeriod(), this.panels.investmentYP.getBookYear().getIntValue(), this.panels.investmentYP.getPeriod().getIntValue())) {
                this.panels.startInterest[i].setValues("" + this.valuation[i].getInterestBookYear(), "" + this.valuation[i].getInterestPeriod());
            } else {
                this.panels.startInterest[i].getBookYear().setValue();
                this.panels.startInterest[i].getPeriod().setValue();
            }
        }
        if ((correctionPeriods = this.interCompanyMovementBP.getCorrectionPeriods())[this.valuation[i].getAccountingPrinciple()] != 0) {
            int nodp = this.panels.nbrOfDeprPers[i].getIntValue();
            int reml = this.panels.remainingLife[i].getIntValue();
            this.panels.nbrOfDeprPers[i].setValue("" + (nodp + correctionPeriods[this.valuation[i].getAccountingPrinciple()]));
            this.panels.remainingLife[i].setValue("" + (reml - correctionPeriods[this.valuation[i].getAccountingPrinciple()]));
        }
        this.panels.modifyFieldAttributes();
        this.panels.apPanels[this.panels.apTabCount].setReadonly();
        this.panels.remainingLife[this.panels.apTabCount].setMandatory(false);
        this.panels.deprTotal[this.panels.apTabCount].setMandatory(false);
        this.clearScreen(true, false, true);
        Header header = new Header(object.translate("Title.InterCompanyMovementDepreciationInterest", object.getLocale()) + " " + this.panels.getAccountingPrincipleTabText(), "screen_name");
        header.setHelpId("Title.InterCompanyMovementDepreciationInterest");
        object.addUIObject((UIObject)header);
        object.addUIObject((UIObject)this.headerPanel);
        object.addUIObject((UIObject)this.panels.headerPanel);
        object.addUIObject((UIObject)this.panels.apPanels[this.panels.apTabCount]);
        this.panels.copyValues();
        FloatBar fbCreateAP = new FloatBar();
        Action action = this.panels.apTabCount == 0 ? new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createDimensionsFormContinued") : new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormPrevious");
        fbCreateAP.addAction(action);
        if (this.panels.apTabCount == this.panels.apTabCountMax) {
            action = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("create");
            action.setDefault(true);
            action.setValidationEnabled(true);
            fbCreateAP.addAction(action);
        } else {
            action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormNext");
            action.setDefault(true);
            action.setValidationEnabled(true);
            fbCreateAP.addAction(action);
        }
        fbCreateAP.addAction(this.closeContinued);
        object.addUIObject((UIObject)fbCreateAP);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        String message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        message = this.interCompanyMovementBP.move(this.asset, this.panels, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.loginHelper.getUser());
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        return this.close(object);
    }

    private void handleNewParent() throws Exception {
        Object newParentId = this.getProcess().getAttribute("NewParentId");
        if (newParentId != null) {
            this.panels.setNewParent(newParentId.toString(), this.getProcess().getAttribute("NewParentDescription").toString());
            this.getProcess().removeAttribute("NewParentId");
            this.getProcess().removeAttribute("NewParentDescription");
        }
    }
}

