/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import nl.ibs.esp.adapter.Adapter;
import nl.ibs.esp.dataobject.BinaryObject;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.LogFileHelper;
import nl.ibs.fac.ReportFile;
import nl.ibs.fac.adapters.FACAdapter;

public class LogFileAdapter
extends FACAdapter {
    private static final long serialVersionUID = 4766087389518213044L;
    public static final String PAGE = LogFileAdapter.class.getName();
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbDelete = new FloatBar();
    protected TableRowMethod tableRowMethod = new FileRowMethod();
    private Action[] rowActions;
    private Action[] headerActions;
    private CollectionTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES = new String[]{"name", "date", "time", "size", "directory"};
    private static final String[] LABELS = new String[]{"Label.Name", "Label.Date", "Label.Time", "Label.Size", "Label.Directory"};
    private static final short[] SIZES = new short[]{250, 80, 70, 70, 70};
    private Object[] files;
    private String root;
    private ReportFile home;

    public LogFileAdapter(DataObject object) throws Exception {
        super(object);
        this.showTaskBar(false);
        this.back = new Action("Button.Back", (Adapter)this, "back");
        Action refresh = new Action("Button.Refresh", (Adapter)this, "refresh");
        Action confirmDelete = new Action("Button.Delete", (Adapter)this, "confirmDelete");
        this.fbShow.addAction(this.back);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(confirmDelete);
        Action download = new Action("Button.Download", (Adapter)this, "download");
        download.setIsDownloadAction(true);
        Action open = new Action("Button.Open", (Adapter)this, "download");
        this.rowActions = new Action[]{download, open, confirmDelete};
        this.headerActions = new Action[]{refresh};
        Action deleteOK = new Action("Button.OK", (Adapter)this, "delete");
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(new Action("Button.Back", (Adapter)this, "show"));
    }

    public DataObject show(DataObject object) throws Exception {
        Header header;
        this.clearScreen(true, false, true);
        if (this.home != null) {
            header = new Header(object.translate("Title.LogFiles", object.getLocale()) + " - " + this.home.getName(), "screen_name");
            header.setHelpId("Title.LogFiles");
        } else {
            header = new Header("Title.LogFiles", "screen_name");
        }
        object.addUIObject((UIObject)header);
        if (this.table == null) {
            this.createTable();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        this.back.setHidden(this.home == null);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        File file = null;
        if (this.home != null) {
            file = this.home.getFile();
        }
        this.table = new CollectionTable(ReportFile.class, (Collection)LogFileHelper.getFiles(file), 12);
        this.table.setName(PAGE);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.orderByColumn(NAMES[0]);
        this.table.setColumnSizes(SIZES);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        TableHelper.createMenu((CommonTable)this.table, (Action[])this.headerActions, (Action[])this.rowActions, (TableRowMethod)this.tableRowMethod);
        this.searchPanel = this.table.createSearch(NAMES, LABELS);
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject back(DataObject object) throws Exception {
        String parent = this.home.getFile().getParent();
        this.home = parent.equals(this.root) ? null : new ReportFile(new File(parent));
        this.table = null;
        return this.show(object);
    }

    public DataObject download(DataObject object) throws Exception {
        ReportFile reportFile = (ReportFile)TableHelper.getSelectedItem((DataObject)object);
        Action action = object.getExecutedActionObject();
        if (reportFile.getFile().isDirectory()) {
            this.home = reportFile;
            if (this.root == null) {
                this.root = this.home.getFile().getParent();
            }
            action.setIsDownloadAction(false);
            this.table = null;
            return this.show(object);
        }
        action.setIsDownloadAction(true);
        BinaryObject bobj = new BinaryObject(LogFileHelper.getBytes(reportFile.getFile()), "text/plain", object);
        bobj.openSaveAsDialog(reportFile.getName());
        return bobj;
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.files = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteLogFiles", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.files.length);
        for (int i = 0; i < this.files.length; ++i) {
            list.add(this.files[i]);
        }
        CollectionTable table = new CollectionTable(ReportFile.class, list, 12);
        table.setName(PAGE);
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        for (int i = 0; i < this.files.length; ++i) {
            ReportFile reportFile = (ReportFile)this.files[i];
            if (LogFileHelper.delete(reportFile.getFile())) continue;
            object.addUIObject((UIObject)new Message(reportFile.getName() + " " + object.translate("deletion_failed", object.getLocale()), "error"));
        }
        this.table = null;
        return this.show(object);
    }

    public String getDescription() {
        return this.translate("Process.LogFiles");
    }

    public String getShortDescription() {
        return "Process.LogFiles.short";
    }

    private class FileRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 5587843220765380751L;

        private FileRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            ReportFile reportFile = (ReportFile)row.getObject();
            int i = 0;
            if (reportFile.getFile().isDirectory()) {
                i = 1;
            }
            ContextMenu menu = new ContextMenu();
            ContextAction rowAction = new ContextAction(rowActions[i].getName());
            rowAction.setAdapter(rowActions[i].getPageid());
            rowAction.setMethod(rowActions[i].getMethod());
            if (i == 0) {
                rowAction.setIsDownloadAction(true);
            }
            menu.addContextMenuItem(rowAction);
            row.setContextMenu(menu);
        }
    }
}

