/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.Collection;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Option;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.JournalingsTermEnum;
import nl.ibs.fac.adapters.AssetTypeAdapter;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.MainAccountSchemeBO;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.MainAccountScheme;
import nl.ibs.fac.gov.adapters.ExtendedAdditionalJournalingDataAdapter;
import nl.ibs.fac.queries.MainAccountSchemeQuery;
import nl.ibs.util.NameValuePair;

public class MainAccountSchemeAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 7773334108239665281L;
    public static final String PAGE = MainAccountSchemeAdapter.class.getName();
    public static final String RETURNPAGE = "MainAccountSchemeAdapterReturnPage";
    public static final String RETURNMETHOD = "MainAccountSchemeAdapterReturnMethod";
    private Company company;
    private AssetType assetType;
    private FieldGroup mainPanel;
    private Field description = new Field();
    private FloatBar fbMain = new FloatBar();
    private Action backAction;
    private Action addAction;
    private Action editAction;
    private Action deleteAction;
    private Action additionalJournalingDataAction;
    private Action backToMainAction;
    private Action addOKAction;
    private Action editOKAction;
    private Action deleteOKAction;
    private FieldGroup fgMainAccounts;
    private ComboBox schemes;
    private Label schemesLabel;
    private BookYearPeriodGrid validFrom;
    private FinancialReferenceField[] mainAccounts = new FinancialReferenceField[11];
    private int jteLength = 0;
    private MainAccountScheme mass;
    private Window window;
    private int accountingPrinciple = 1;

    public MainAccountSchemeAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.mainPanel = new FieldGroup("Label.Common");
        ESPGridLayout grid = new ESPGridLayout();
        grid.setColumnWidths(new short[]{198, 0});
        grid.setPaddingBottom(0);
        grid.setPaddingTop(0);
        Label label = new Label("Label.AccountingPrinciple");
        grid.add((UIObject)label, 0, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.description.setDiscardLabel(true);
        this.description.setLength(50);
        this.description.setReadonly(true);
        grid.add((UIObject)this.description, 0, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.schemesLabel = new Label("Label.ValidFrom");
        grid.add((UIObject)this.schemesLabel, 1, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.description.setDiscardLabel(true);
        this.description.setLength(50);
        this.description.setReadonly(true);
        grid.add((UIObject)this.description, 0, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.schemes = new ComboBox();
        this.schemes.add((Action)new ComboBoxChangeAction());
        this.schemes.setWidth("100");
        grid.add((UIObject)this.schemes, 1, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.mainPanel.add(grid);
        this.validFrom = new BookYearPeriodGrid("Label.ValidFrom", "" + this.company.getCurrentBookYear(), this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.mainPanel.add((ESPGridLayout)this.validFrom);
        this.initializeJournalingTermForm();
        this.backAction = new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(AssetTypeAdapter.PAGE)).setMethod("editForm");
        this.backAction.setDefault(true);
        this.addAction = new Action("Button.Add").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createForm");
        this.editAction = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("editForm");
        this.deleteAction = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("deleteForm");
        this.additionalJournalingDataAction = new Action("Button.AdditionalData_short").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("handleAdditionalJournalingData");
        this.addOKAction = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("create");
        this.editOKAction = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("edit");
        this.deleteOKAction = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("delete");
        this.backToMainAction = new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showForm");
    }

    private void initializeJournalingTermForm() throws Exception {
        this.fgMainAccounts = new FieldGroup("Label.MainAccounts");
        Object[] jte = JournalingsTermEnum.getCollection().toArray();
        this.jteLength = jte.length;
        for (int j = 0; j < this.jteLength; ++j) {
            NameValuePair pair = (NameValuePair)jte[j];
            this.mainAccounts[j] = this.env.getOperationArea().length() == 0 ? new FISReferenceField(this.loginHelper, pair.getValue(), 0, this.company.getId(), "" + this.company.getCurrentBookYear(), true) : new FMSReferenceField(this.loginHelper, pair.getValue(), 0, true);
            if (this.governmentActivated && j == 8) {
                this.mainAccounts[j].setHidden(true);
            }
            if (!(j != 9 && j != 10 || this.company.getProcessParameters().getDepreciateBeyondEconomicLife())) {
                this.mainAccounts[j].setHidden(true);
            }
            this.fgMainAccounts.add((Field)this.mainAccounts[j]);
        }
    }

    public DataObject show(DataObject object) throws Exception {
        this.assetType = (AssetType)this.getProcess().getAttribute("assetType");
        this.accountingPrinciple = Integer.parseInt((String)this.getProcess().getAttribute("accountingPrinciple"));
        if (this.accountingPrinciple != 0) {
            switch (this.accountingPrinciple) {
                case 1: {
                    this.description.setValue(this.env.getAPName1());
                    break;
                }
                case 2: {
                    this.description.setValue(this.env.getAPName2());
                    break;
                }
                case 3: {
                    this.description.setValue(this.env.getAPName3());
                    break;
                }
                case 4: {
                    this.description.setValue(this.env.getAPName4());
                }
            }
        }
        return this.showPanel(object);
    }

    public DataObject showPanel(DataObject object) throws Exception {
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "close");
        this.window.setWidth(600);
        this.window.setTop("10%");
        this.window.setRight("15%");
        this.window.setLabel("Label.MainAccountSchemeData");
        this.window.add(this.mainPanel);
        this.window.add(this.fgMainAccounts);
        FieldGroup floatBar = new FieldGroup("", this.window.getWidth(), 0);
        floatBar.forceBorder(false);
        floatBar.add(this.fbMain);
        this.window.add(floatBar);
        object.addUIObject((UIObject)this.window);
        return this.showForm(object);
    }

    public DataObject showForm(DataObject object) throws Exception {
        this.schemesLabel.setHidden(false);
        this.schemes.setHidden(false);
        this.schemes.setReadonly(false);
        this.validFrom.setMandatory(false);
        this.validFrom.setHidden(true);
        this.fillComboBox();
        this.setValues();
        this.removeActions();
        this.fbMain.addAction(this.backAction);
        this.fbMain.addAction(this.addAction);
        this.fbMain.addAction(this.editAction);
        this.fbMain.addAction(this.deleteAction);
        if (this.governmentActivated) {
            this.fbMain.addAction(this.additionalJournalingDataAction);
        }
        if (this.schemes.getUIObjects(Option.class, false).size() == 0) {
            this.editAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
            this.additionalJournalingDataAction.setEnabled(false);
        } else {
            this.editAction.setEnabled(true);
            this.deleteAction.setEnabled(true);
            this.additionalJournalingDataAction.setEnabled(true);
        }
        for (int i = 0; i < this.jteLength; ++i) {
            this.mainAccounts[i].setReadonly(true);
        }
        return object;
    }

    public DataObject createForm(DataObject object) throws Exception {
        this.schemesLabel.setHidden(true);
        this.schemes.setHidden(true);
        this.validFrom.setMandatory(true);
        this.validFrom.setHidden(false);
        this.validFrom.getPeriod().requestFocus(true);
        this.removeActions();
        this.fbMain.addAction(this.addOKAction);
        this.fbMain.addAction(this.backToMainAction);
        this.addOKAction.setDefault(true);
        this.addOKAction.setValidationEnabled(true);
        for (int i = 0; i < this.jteLength; ++i) {
            this.mainAccounts[i].setReadonly(false);
        }
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        int year = this.validFrom.getBookYear().getIntValue();
        int period = this.validFrom.getPeriod().getIntValue();
        Object[] result = null;
        result = MainAccountSchemeBO.create(this.dbData, this.companyId, this.assetType.getId(), this.accountingPrinciple, year, period, this.mainAccounts[0].getFormattedId(), this.mainAccounts[1].getFormattedId(), this.mainAccounts[2].getFormattedId(), this.mainAccounts[3].getFormattedId(), this.mainAccounts[4].getFormattedId(), this.mainAccounts[5].getFormattedId(), this.mainAccounts[6].getFormattedId(), this.mainAccounts[7].getFormattedId(), this.mainAccounts[8].getFormattedId(), this.mainAccounts[9].getFormattedId(), this.mainAccounts[10].getFormattedId());
        if (result[1] != null) {
            String messageText = (String)result[1];
            object.addUIObject((UIObject)new Message(messageText, "error"));
            return object;
        }
        this.mass = (MainAccountScheme)result[0];
        this.fillComboBox();
        return this.showForm(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.schemesLabel.setHidden(false);
        this.schemes.setHidden(false);
        this.schemes.setReadonly(true);
        this.validFrom.setMandatory(false);
        this.validFrom.setHidden(true);
        this.removeActions();
        this.fbMain.addAction(this.editOKAction);
        this.fbMain.addAction(this.backToMainAction);
        this.editOKAction.setDefault(true);
        this.editOKAction.setValidationEnabled(true);
        for (int i = 0; i < this.jteLength; ++i) {
            this.mainAccounts[i].setReadonly(false);
        }
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String messageText = MainAccountSchemeBO.update(this.mass, this.mainAccounts[0].getFormattedId(), this.mainAccounts[1].getFormattedId(), this.mainAccounts[2].getFormattedId(), this.mainAccounts[3].getFormattedId(), this.mainAccounts[4].getFormattedId(), this.mainAccounts[5].getFormattedId(), this.mainAccounts[6].getFormattedId(), this.mainAccounts[7].getFormattedId(), this.mainAccounts[8].getFormattedId(), this.mainAccounts[9].getFormattedId(), this.mainAccounts[10].getFormattedId());
        if (messageText != null) {
            object.addUIObject((UIObject)new Message(messageText, "error"));
            return object;
        }
        return this.showForm(object);
    }

    public DataObject deleteForm(DataObject object) throws Exception {
        this.schemesLabel.setHidden(false);
        this.schemes.setHidden(false);
        this.schemes.setReadonly(true);
        this.validFrom.setMandatory(false);
        this.validFrom.setHidden(true);
        this.removeActions();
        this.fbMain.addAction(this.deleteOKAction);
        this.fbMain.addAction(this.backToMainAction);
        this.deleteOKAction.setDefault(true);
        this.deleteOKAction.setValidationEnabled(true);
        for (int i = 0; i < this.jteLength; ++i) {
            this.mainAccounts[i].setReadonly(true);
        }
        return object;
    }

    public DataObject delete(DataObject object) throws Exception {
        String messageText = MainAccountSchemeBO.delete(this.mass);
        if (messageText != null) {
            object.addUIObject((UIObject)new Message(messageText, "error"));
            return object;
        }
        this.fillComboBox();
        new ComboBoxChangeAction().execute(this.dataObject);
        return this.showForm(object);
    }

    public DataObject handleAdditionalJournalingData(DataObject object) throws Exception {
        FinancialReferenceField[] newMainAccounts = new FinancialReferenceField[11];
        System.arraycopy(this.mainAccounts, 0, newMainAccounts, 0, this.mainAccounts.length);
        this.getProcess().setAttribute("mainAccounts", (Object)newMainAccounts);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(ExtendedAdditionalJournalingDataAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    public void removeActions() throws Exception {
        this.fbMain.removeAction("Button.OK");
        this.fbMain.removeAction("Button.Back");
        this.fbMain.removeAction("Button.Add");
        this.fbMain.removeAction("Button.Edit");
        this.fbMain.removeAction("Button.Delete");
        if (this.governmentActivated) {
            this.fbMain.removeAction("Button.AdditionalData_short");
        }
    }

    protected void setValues() throws Exception {
        String value = this.schemes.getSelectedOptionValue();
        if (value == null) {
            return;
        }
        int year = Integer.parseInt(value.substring(0, 4));
        int period = Integer.parseInt(value.substring(5));
        Object[] objects = MainAccountSchemeBO.get(this.dbData, this.companyId, this.assetType.getId(), this.accountingPrinciple, year, period);
        this.mass = (MainAccountScheme)objects[0];
        if (this.mass != null) {
            this.mainAccounts[0].setValue(this.mass.getMainAccountId1());
            this.mainAccounts[1].setValue(this.mass.getMainAccountId2());
            this.mainAccounts[2].setValue(this.mass.getMainAccountId3());
            this.mainAccounts[3].setValue(this.mass.getMainAccountId4());
            this.mainAccounts[4].setValue(this.mass.getMainAccountId5());
            this.mainAccounts[5].setValue(this.mass.getMainAccountId6());
            this.mainAccounts[6].setValue(this.mass.getMainAccountId7());
            this.mainAccounts[7].setValue(this.mass.getMainAccountId8());
            this.mainAccounts[8].setValue(this.mass.getMainAccountId9());
            this.mainAccounts[9].setValue(this.mass.getMainAccountId10());
            this.mainAccounts[10].setValue(this.mass.getMainAccountId11());
        } else {
            this.mainAccounts[0].setValue();
            this.mainAccounts[1].setValue();
            this.mainAccounts[2].setValue();
            this.mainAccounts[3].setValue();
            this.mainAccounts[4].setValue();
            this.mainAccounts[5].setValue();
            this.mainAccounts[6].setValue();
            this.mainAccounts[7].setValue();
            this.mainAccounts[8].setValue();
            this.mainAccounts[9].setValue();
            this.mainAccounts[10].setValue();
        }
    }

    private void fillComboBox() throws Exception {
        this.schemes.removeUIObjects(Option.class, false);
        MainAccountSchemeQuery query = new MainAccountSchemeQuery(this.dbData, this.companyId, this.assetType.getId(), "" + this.accountingPrinciple);
        Collection maSchemes = query.fetchData(null, null, null, 0);
        Object[] maSchemesArray = maSchemes.toArray();
        boolean selected = true;
        for (int i = maSchemesArray.length - 1; i >= 0; --i) {
            MainAccountScheme maScheme = (MainAccountScheme)maSchemesArray[i];
            String labval = "" + maScheme.getBookYearFrom() + "-" + maScheme.getPeriodFrom();
            this.schemes.addOption(labval, labval, selected);
            selected = false;
        }
    }

    public DataObject close(DataObject object) throws Exception {
        this.window.closeWindow(object);
        object.addUIObject((UIObject)new RedirectAction(this.getProcess().getAttribute(RETURNPAGE).toString(), this.getProcess().getAttribute(RETURNMETHOD).toString(), this.getProcess().getProcessId()));
        return object;
    }

    private class ComboBoxChangeAction
    extends Action {
        private static final long serialVersionUID = 3064534779286620621L;

        public boolean execute(DataObject dataObject) throws Exception {
            MainAccountSchemeAdapter.this.setValues();
            return true;
        }
    }
}

