/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Image;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.ActiveCompanyAdapter;
import nl.ibs.fac.adapters.DBConfigAdapter;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.session.StartStopServlet;

public class MainAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -7076524608961497810L;
    public static final String PAGE = MainAdapter.class.getName();
    private Image logo = new Image("Fixed Assets logo");
    public static final String MESSAGE = "MESSAGE";
    public static final String ALERT = "ALERT";

    public MainAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (StartStopServlet.settingsValid(false)) {
            this.setMenuBar(object);
        }
    }

    public DataObject show(DataObject object) throws Exception {
        if (!StartStopServlet.settingsValid(false)) {
            object.addUIObject((UIObject)new RedirectAction(DBConfigAdapter.PAGE, "show"));
            return object;
        }
        this.clearScreen(true, false, true);
        String message = (String)object.getSessionAttribute(MESSAGE);
        if (message != null) {
            String type = (String)object.getSessionAttribute(ALERT);
            if (type != null) {
                object.addUIObject((UIObject)new Message(message, type));
                object.setSessionAttribute(ALERT, null);
            } else {
                object.addUIObject((UIObject)new Message(message, "error"));
            }
            object.setSessionAttribute(MESSAGE, null);
        }
        object.addUIObject((UIObject)new Header("", "screen_name", null));
        this.logo.setSource("fixed_assets_logo.jpg");
        this.logo.setAlignment("center");
        this.logo.setWidth("640");
        this.logo.setHeight("360");
        object.addUIObject((UIObject)this.logo);
        if (Boolean.toString(true).equals(object.getSessionAttribute("selectCompany"))) {
            object.removeSessionAttribute("selectCompany");
            object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(ActiveCompanyAdapter.PAGE), "show", this.getProcess().getProcessId()));
        }
        return object;
    }

    public void post(String action, DataObject object) throws Exception {
        object.removeMessages();
    }
}

