/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import java.util.List;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.MassTransactionPanel;
import nl.ibs.fac.bp.MassCorrectionBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.util.NameValuePair;

public class MassCorrectionPanel
extends MassTransactionPanel {
    private static final long serialVersionUID = 7159388389135817518L;
    private AssetTypeReferenceField type = null;
    private ComboBox accountingPrinciple;
    private NumberField depreciatableLife;
    private FACDecimalField residualValue;
    private FACDecimalField residualPercentage;
    private BookYearPeriodGrid periodFAC;
    private BookYearPeriodGrid periodFIN;
    private int facYear;
    private int facPeriod;
    private int finYear;
    private int finPeriod;
    private MassCorrectionBP businessProcess;
    private Environment env;

    public MassCorrectionPanel(Company company, Environment environment, String bookYearMin, String bookYearMax) throws Exception {
        super(company, null, bookYearMin, bookYearMax);
        this.env = environment;
        this.initialize();
    }

    private void initialize() throws Exception {
        this.businessProcess = new MassCorrectionBP(this.company, this.company.getNumberOfPeriods());
        this.accountingPrinciple = new ComboBox("Label.AccountingPrinciple");
        this.accountingPrinciple.addOption(this.env.getAPShortName1(), "1");
        this.accountingPrinciple.setSelectedOptionValue("1");
        if (this.dataSet.getAccountingPrinciple2Usage() != 0) {
            this.accountingPrinciple.addOption(this.env.getAPShortName2(), "2");
            this.addUIObject((UIObject)this.accountingPrinciple);
        }
        this.type = new AssetTypeReferenceField(this.company.getDBData(), this.company.getId());
        this.type.setLabel("Label.Type");
        this.type.setMandatory(true);
        this.addUIObject((UIObject)this.type);
        this.depreciatableLife = new NumberField("Label.DepreciationLife", 4, false);
        this.depreciatableLife.setLength(5);
        this.addUIObject((UIObject)this.depreciatableLife);
        this.residualPercentage = new FACDecimalField("Label.ResidualValuePercentage", 5, 2);
        this.residualPercentage.setMinValue(new BigDecimal(0), true);
        this.residualPercentage.setMaxValue(new BigDecimal(100), true);
        this.addUIObject((UIObject)this.residualPercentage);
        this.residualValue = new FACDecimalField("Label.ResidualValueAmount", 15, 2);
        this.addUIObject((UIObject)this.residualValue);
        this.residualValue.setHidden(true);
        String[] yps = this.businessProcess.retrieveYearsAndPeriods();
        this.periodFAC = new BookYearPeriodGrid("Label.FACStartPeriod", yps[0], yps[1], false);
        this.periodFAC.setMandatory(true);
        this.addUIObject((UIObject)this.periodFAC);
        this.periodFIN = new BookYearPeriodGrid("Label.FinancialPeriod", yps[2], yps[3], false);
        this.addUIObject((UIObject)this.periodFIN);
    }

    public void setHidden(boolean isHidden) {
        try {
            this.type.setMandatory(!isHidden);
            this.periodFAC.setMandatory(!isHidden);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setHidden(isHidden);
    }

    @Override
    public boolean validate(DataObject object) throws Exception {
        boolean error = false;
        String[] errors = null;
        if (this.depreciatableLife.getValue().trim().length() == 0 && this.residualPercentage.getValue().trim().length() == 0 && this.residualValue.getValue().trim().length() == 0) {
            error = true;
            this.addErrors(object, new String[]{"NothingSelected"});
            this.depreciatableLife.setInvalidTag();
            this.residualPercentage.setInvalidTag();
            this.residualValue.setInvalidTag();
        }
        if (this.residualPercentage.getValue().trim().length() > 0 && this.residualValue.getValue().trim().length() > 0) {
            error = true;
            this.addErrors(object, new String[]{"provide_only_one_value"});
            this.residualPercentage.setInvalidTag();
            this.residualValue.setInvalidTag();
        }
        this.facYear = this.periodFAC.getBookYear().getIntValue();
        this.facPeriod = this.periodFAC.getPeriod().getIntValue();
        errors = this.businessProcess.validateFACYearAndPeriod(this.facYear, this.facPeriod);
        if (errors != null) {
            error = true;
            this.addErrors(object, errors);
            this.periodFAC.setInvalidTag();
        }
        this.finYear = this.periodFIN.getBookYear().getIntValue();
        this.finPeriod = this.periodFIN.getPeriod().getIntValue();
        errors = this.businessProcess.validateFINYearAndPeriod(this.finYear, this.finPeriod, Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax));
        if (errors != null) {
            error = true;
            this.addErrors(object, errors);
            this.periodFIN.setInvalidTag();
        }
        return error;
    }

    @Override
    public List addSubmitParms(List list) throws Exception {
        list.add(new NameValuePair("TYPE", this.type.getValue()));
        if ("1".equals(this.accountingPrinciple.getSelectedOptionValue())) {
            list.add(new NameValuePair("APDESCR", this.env.getAPShortName1()));
        } else {
            list.add(new NameValuePair("APDESCR", this.env.getAPShortName1()));
        }
        list.add(new NameValuePair("ACCPRINC", this.accountingPrinciple.getSelectedOptionValue()));
        list.add(new NameValuePair("DEPRLIFE", this.depreciatableLife.getValue().trim()));
        list.add(new NameValuePair("RESPERC", this.residualPercentage.getValue().trim().length() == 0 ? "" : "" + this.residualPercentage.getBigDecimal().doubleValue()));
        list.add(new NameValuePair("RESAMOUNT", this.residualValue.getValue().trim().length() == 0 ? "" : "" + this.residualValue.getBigDecimal().doubleValue()));
        list.add(new NameValuePair("FACPERYEAR", "" + this.facYear));
        list.add(new NameValuePair("FACPERPER", "" + this.facPeriod));
        list.add(new NameValuePair("FINPERYEAR", "" + this.finYear));
        list.add(new NameValuePair("FINPERPER", "" + this.finPeriod));
        return list;
    }
}

