/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.List;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.event.EventListener;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.adapters.MassTransactionPanel;
import nl.ibs.fac.bp.MassMovementBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.util.NameValuePair;

public class MassMovementPanel
extends MassTransactionPanel {
    private static final long serialVersionUID = 4710640029195097062L;
    private Environment env;
    private ComboBox cbDim;
    private FinancialReferenceField[] rfOld = new FinancialReferenceField[5];
    private FinancialReferenceField[] rfNew = new FinancialReferenceField[5];
    private FinancialReferenceField rfOldValue = null;
    private FinancialReferenceField rfNewValue = null;
    private BookYearPeriodGrid periodFAC;
    private BookYearPeriodGrid periodFIN;
    private int facYear;
    private int facPeriod;
    private int finYear;
    private int finPeriod;
    private String[] dimText = new String[]{"", "", "", "", ""};
    private MassMovementBP businessProcess;

    public MassMovementPanel(Company company, LoginHelper loginHelper, Environment env, String bookYearMin, String bookYearMax) throws Exception {
        super(company, loginHelper, bookYearMin, bookYearMax);
        this.env = env;
        this.initialize();
    }

    private void initialize() throws Exception {
        this.businessProcess = new MassMovementBP(this.company, this.company.getNumberOfPeriods());
        this.dimText[0] = this.env.getName1();
        this.dimText[1] = this.env.getName2();
        this.dimText[2] = this.env.getName3();
        this.dimText[3] = this.env.getName4();
        this.dimText[4] = this.env.getName5();
        for (int index = 0; index < this.dimText.length; ++index) {
            if (this.dimText[index].length() == 0) continue;
            if (this.env.getOperationArea().length() == 0) {
                this.rfOld[index] = new FISReferenceField(this.loginHelper, this.dimText[index], index + 1, this.dataSet);
                this.rfNew[index] = new FISReferenceField(this.loginHelper, this.dimText[index], index + 1, this.dataSet);
            } else {
                this.rfOld[index] = new FMSReferenceField(this.loginHelper, this.dimText[index], index + 1, this.dataSet);
                this.rfNew[index] = new FMSReferenceField(this.loginHelper, this.dimText[index], index + 1, this.dataSet);
            }
            this.rfOld[index].setLabel("Label.OldValue");
            this.rfOld[index].setMandatory(true);
            this.rfNew[index].setLabel("Label.NewValue");
            this.rfNew[index].setMandatory(true);
        }
        this.rfOldValue = this.rfOld[0];
        this.rfOldValue.setMandatory(false);
        this.rfNewValue = this.rfNew[0];
        this.rfNewValue.setMandatory(false);
        this.cbDim = new ComboBox("Label.AnalysisGroup");
        if (this.company.getFinancialDimension1Usage() != 0) {
            this.cbDim.addOption(this.dimText[0], "0");
        }
        if (this.company.getFinancialDimension2Usage() != 0) {
            this.cbDim.addOption(this.dimText[1], "1");
        }
        if (this.company.getFinancialDimension3Usage() != 0) {
            this.cbDim.addOption(this.dimText[2], "2");
        }
        if (this.company.getFinancialDimension4Usage() != 0) {
            this.cbDim.addOption(this.dimText[3], "3");
        }
        if (this.company.getFinancialDimension5Usage() != 0) {
            this.cbDim.addOption(this.dimText[4], "4");
        }
        cbDimListener listener = new cbDimListener();
        listener.event(null, null);
        this.cbDim.addOnChangeListener((EventListener)listener);
        String[] yps = this.businessProcess.retrieveYearsAndPeriods();
        this.periodFAC = new BookYearPeriodGrid("Label.FACStartPeriod", yps[0], yps[1], false);
        this.periodFAC.setMandatory(true);
        this.periodFIN = new BookYearPeriodGrid("Label.FinancialPeriod", yps[2], yps[3], false);
        this.addUIObject((UIObject)this.cbDim);
        this.addUIObject((UIObject)this.rfOldValue);
        this.addUIObject((UIObject)this.rfNewValue);
        this.addUIObject((UIObject)this.periodFAC);
        this.addUIObject((UIObject)this.periodFIN);
    }

    public void setHidden(boolean isHidden) {
        this.rfOldValue.setMandatory(!isHidden);
        this.rfNewValue.setMandatory(!isHidden);
        try {
            this.periodFAC.setMandatory(!isHidden);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setHidden(isHidden);
    }

    @Override
    public boolean validate(DataObject object) throws Exception {
        boolean error = false;
        String[] errors = null;
        if (this.rfOldValue.getValue().trim().equals(this.rfNewValue.getValue().trim())) {
            error = true;
            this.addErrors(object, new String[]{"values_should_not_be_equal"});
            this.rfOldValue.setInvalidTag();
            this.rfNewValue.setInvalidTag();
        }
        this.facYear = this.periodFAC.getBookYear().getIntValue();
        this.facPeriod = this.periodFAC.getPeriod().getIntValue();
        errors = this.businessProcess.validateFACYearAndPeriod(this.facYear, this.facPeriod);
        if (errors != null) {
            error = true;
            this.addErrors(object, errors);
            this.periodFAC.setInvalidTag();
        }
        this.finYear = this.periodFIN.getBookYear().getIntValue();
        this.finPeriod = this.periodFIN.getPeriod().getIntValue();
        errors = this.businessProcess.validateFINYearAndPeriod(this.finYear, this.finPeriod, Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax));
        if (errors != null) {
            error = true;
            this.addErrors(object, errors);
            this.periodFIN.setInvalidTag();
        }
        return error;
    }

    @Override
    public List addSubmitParms(List list) throws Exception {
        list.add(new NameValuePair("DIM", this.cbDim.getValue()));
        list.add(new NameValuePair("OLDVALUE", this.rfOldValue.getFormattedId()));
        list.add(new NameValuePair("NEWVALUE", this.rfNewValue.getFormattedId()));
        list.add(new NameValuePair("OLDVALUE_F", this.rfOldValue.getValue()));
        list.add(new NameValuePair("NEWVALUE_F", this.rfNewValue.getValue()));
        list.add(new NameValuePair("FACPERYEAR", "" + this.facYear));
        list.add(new NameValuePair("FACPERPER", "" + this.facPeriod));
        list.add(new NameValuePair("FINPERYEAR", "" + this.finYear));
        list.add(new NameValuePair("FINPERPER", "" + this.finPeriod));
        list.add(new NameValuePair("DIMTEXT1", this.dimText[0]));
        list.add(new NameValuePair("DIMTEXT2", this.dimText[1]));
        list.add(new NameValuePair("DIMTEXT3", this.dimText[2]));
        list.add(new NameValuePair("DIMTEXT4", this.dimText[3]));
        list.add(new NameValuePair("DIMTEXT5", this.dimText[4]));
        return list;
    }

    private class cbDimListener
    implements EventListener {
        private static final long serialVersionUID = -2688804800149938678L;

        private cbDimListener() {
        }

        public void event(UIObject object, String type) throws Exception {
            int i = Integer.parseInt(MassMovementPanel.this.cbDim.getSelectedOptionValue());
            MassMovementPanel.this.replaceUIObject((UIObject)MassMovementPanel.this.rfOldValue, (UIObject)MassMovementPanel.this.rfOld[i]);
            MassMovementPanel.this.replaceUIObject((UIObject)MassMovementPanel.this.rfNewValue, (UIObject)MassMovementPanel.this.rfNew[i]);
            MassMovementPanel.this.rfOldValue = MassMovementPanel.this.rfOld[i];
            MassMovementPanel.this.rfNewValue = MassMovementPanel.this.rfNew[i];
        }
    }
}

