/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.List;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.MassTransactionPanel;
import nl.ibs.fac.bp.MassRemoveBP;
import nl.ibs.fac.db.Company;
import nl.ibs.util.NameValuePair;

public class MassRemovePanel
extends MassTransactionPanel {
    private static final long serialVersionUID = -8982380183549585635L;
    private AssetTypeReferenceField rfTypeFrom = null;
    private AssetTypeReferenceField rfTypeTo = null;
    private BookYearPeriodGrid periodREM;
    private CheckBox includeMovementsIC;
    private int remYear;
    private int remPeriod;
    private MassRemoveBP businessProcess;

    public MassRemovePanel(Company company, String bookYearMin, String bookYearMax) throws Exception {
        super(company, null, bookYearMin, bookYearMax);
        this.initialize();
    }

    private void initialize() throws Exception {
        this.businessProcess = new MassRemoveBP(this.company, this.company.getNumberOfPeriods());
        this.rfTypeFrom = new AssetTypeReferenceField(this.company.getDBData(), this.company.getId());
        this.rfTypeFrom.setLabel("Label.AssetTypeFrom");
        this.rfTypeTo = new AssetTypeReferenceField(this.company.getDBData(), this.company.getId());
        this.rfTypeTo.setLabel("Label.AssetTypeTo");
        String[] pyp = this.businessProcess.retrieveRemoveYearAndPeriod();
        this.periodREM = new BookYearPeriodGrid("Label.WriteOffPeriod", pyp[0], pyp[1], false);
        this.periodREM.setMandatory(true);
        this.includeMovementsIC = new CheckBox("Label.IncludeMovementsIC", false);
        this.addUIObject((UIObject)this.rfTypeFrom);
        this.addUIObject((UIObject)this.rfTypeTo);
        this.addUIObject((UIObject)this.periodREM);
        this.addUIObject((UIObject)this.includeMovementsIC);
    }

    public void setHidden(boolean isHidden) {
        try {
            this.periodREM.setMandatory(!isHidden);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setHidden(isHidden);
    }

    @Override
    public boolean validate(DataObject object) throws Exception {
        boolean error = false;
        String[] errors = null;
        String val1 = this.rfTypeFrom.getValue().trim();
        String val2 = this.rfTypeTo.getValue().trim();
        if (val1.length() > 0 && val2.length() > 0 && val1.compareTo(val2) > 0) {
            error = true;
            this.addErrors(object, new String[]{"from_is_greater_than_to"});
            this.rfTypeFrom.setInvalidTag();
            this.rfTypeTo.setInvalidTag();
        }
        this.remYear = this.periodREM.getBookYear().getIntValue();
        this.remPeriod = this.periodREM.getPeriod().getIntValue();
        errors = this.businessProcess.validateRemoveYearAndPeriod(this.remYear, this.remPeriod);
        if (errors != null) {
            error = true;
            this.addErrors(object, errors);
            this.periodREM.setInvalidTag();
        }
        return error;
    }

    @Override
    public List addSubmitParms(List list) throws Exception {
        list.add(new NameValuePair("TYPEFROM", this.rfTypeFrom.getValue()));
        list.add(new NameValuePair("TYPETO", this.rfTypeTo.getValue()));
        list.add(new NameValuePair("REMPERYEAR", "" + this.remYear));
        list.add(new NameValuePair("REMPERPER", "" + this.remPeriod));
        list.add(new NameValuePair("INCLMOVIC", this.includeMovementsIC.getValue()));
        return list;
    }
}

