/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.MassTransactionPanel;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.commands.MassTransactionDeleteCommand;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;

public class MassTransactionDeleteAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 8835404494004215389L;
    public static final String PAGE = MassTransactionDeleteAdapter.class.getName();
    private static final String TITLE = "Title.MassTransactionsDelete";
    private static final String CLASSNAME = MassTransactionDeleteCommand.CLASSNAME;
    private static final String JOBNAME = "Job.DeleteMassTransactionProposal";

    public MassTransactionDeleteAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        TransactionBatch transactionBatch = MassTransactionBP.getCurrentMassTransactionBatch(this.dbData, this.companyId);
        if (transactionBatch == null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "batch_not_found");
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.finish(object);
        }
        String[][] selections = new String[][]{{"User", this.loginHelper.getUser()}, {"facLib", this.dbData.getSchema()}, {"Environment", this.env.getId()}, {"Company", this.companyId}};
        this.getProcess().setAttribute("title", (Object)TITLE);
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("className", (Object)CLASSNAME);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("header", (Object)MassTransactionPanel.getHeaderPanel(transactionBatch));
        Action action = new Action("Button.Info").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showInfo");
        int procType = transactionBatch.getMassTransactionProcessType();
        if (procType == 4 || procType == 5 || procType == 6) {
            action.setEnabled(false);
        }
        MassTransactionPanel.addExtraInfoAction(action);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    public DataObject showInfo(DataObject object) throws Exception {
        TransactionBatch transactionBatch = MassTransactionBP.getCurrentMassTransactionBatch(this.dbData, this.companyId);
        Window window = new Window();
        window.setTop("10%");
        window.setRight("15%");
        window.setLabel("Title.Info");
        FieldGroup fg = MassTransactionPanel.getExtraBatchDetails(transactionBatch, false);
        if (transactionBatch.getMassTransactionProcessType() != 3) {
            fg.add((ESPGridLayout)new BookYearPeriodGrid("Label.FACStartPeriod", "" + transactionBatch.getEndYear(), "" + transactionBatch.getEndPeriod(), true));
            fg.add((ESPGridLayout)new BookYearPeriodGrid("Label.FinancialPeriod", "" + transactionBatch.getFinYear(), "" + transactionBatch.getFinPeriod(), true));
        }
        window.add(fg);
        object.addUIObject((UIObject)window);
        return object;
    }
}

