/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.List;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.MassTransactionProcessTypeEnum;
import nl.ibs.fac.TransactionBatchCodeEnum;
import nl.ibs.fac.TransactionBatchStateEnum;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.TransactionBatch;

public abstract class MassTransactionPanel
extends Panel {
    private static final long serialVersionUID = -1202959732434429516L;
    protected Company company;
    protected Company dataSet;
    protected LoginHelper loginHelper;
    protected String bookYearMin;
    protected String bookYearMax;
    private static FloatBar fb;
    private static ESPGridLayout grid;

    public MassTransactionPanel(Company company, LoginHelper loginHelper, String bookYearMin, String bookYearMax) throws Exception {
        this.company = company;
        this.loginHelper = loginHelper;
        this.bookYearMin = bookYearMin;
        this.bookYearMax = bookYearMax;
        this.dataSet = company.getDataSet();
        if (this.dataSet == null) {
            this.dataSet = company;
        }
        this.setForceBorder(true);
    }

    public static Panel getHeaderPanel(TransactionBatch transactionBatch) throws Exception {
        HeaderPanel panel = new HeaderPanel();
        FieldGroup fg = new FieldGroup();
        fg.forceBorder(false);
        grid = new ESPGridLayout();
        grid.setColumnWidths(new short[]{146, 50, 0});
        fg.add(grid);
        grid.add((UIObject)new Label(TransactionBatchCodeEnum.getValue(transactionBatch.getBatchCode())), 0, 0, 1, 1, "0", "17");
        fb = new FloatBar();
        grid.add((UIObject)fb, 0, 1, 1, 1, "0", "17");
        ReferenceField reffld = new ReferenceField("", "text", "", "" + transactionBatch.getBatchId(), 10);
        reffld.setDescriptionLength("40");
        reffld.setDescription(MassTransactionProcessTypeEnum.getValue(transactionBatch.getMassTransactionProcessType()));
        reffld.setReadonly(true);
        grid.add((UIObject)reffld, 0, 2, 1, 1, "0", "17");
        grid.add((UIObject)new Label("Label.State"), 2, 0, 1, 1, "0", "17");
        Field field = new Field("", "text", null, TransactionBatchStateEnum.getValue(transactionBatch.getState()), 20);
        field.setReadonly(true);
        grid.add((UIObject)field, 2, 2, 1, 1, "0", "17");
        panel.addUIObject((UIObject)fg);
        return panel;
    }

    public static void addExtraInfoAction(Action action) {
        fb.removeAction(action.getName());
        fb.addAction(action);
    }

    public static FieldGroup getExtraBatchDetails(TransactionBatch transactionBatch, boolean includeProcessType) throws Exception {
        Field field;
        FieldGroup fg = new FieldGroup("Label.ExtraInfo");
        if (includeProcessType) {
            String procType = MassTransactionProcessTypeEnum.getValue(transactionBatch.getMassTransactionProcessType());
            field = new Field("Label.ProcType", "text", null, procType);
            field.setReadonly(true);
            fg.add(field);
        }
        String[][] details = MassTransactionBP.getInstanceFor(transactionBatch).getExtraBatchDetails(transactionBatch);
        for (int i = 0; i < details.length; ++i) {
            field = new Field(details[i][0], "text", null, details[i][1]);
            field.setReadonly(true);
            fg.add(field);
        }
        return fg;
    }

    public static void addGridComponent(UIObject o, int r, int c) {
        grid.add(o, r, c, 1, 1, "0", "17");
    }

    protected void addErrors(DataObject object, String[] errors) throws Exception {
        for (int i = 0; i < errors.length; ++i) {
            if (errors[i] == null || errors[i].trim().length() <= 0) continue;
            object.addUIObject((UIObject)new Message(errors[i], "error"));
        }
    }

    public abstract boolean validate(DataObject var1) throws Exception;

    public abstract List addSubmitParms(List var1) throws Exception;
}

