/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.Calendar;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.DateSelectionField;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.MassTransactionPanel;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.ProcessParametersBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.commands.MassTransactionPostCommand;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.ProcessParameters;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.session.StartStopServlet;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.Scrambler;

public class MassTransactionPostAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 8716164528351399691L;
    public static final String PAGE = MassTransactionPostAdapter.class.getName();
    private static final String TITLE = "Title.MassTransactionsPost";
    private static final String CLASSNAME = MassTransactionPostCommand.CLASSNAME;
    private static final String JOBNAME = "Job.PostMassTransactionProposal";
    private Company company;
    private Panel headerPanel;
    private TransactionBatch transactionBatch;
    private boolean belgianWayOfLiving = false;
    private Field voucherNumber;
    private DateSelectionField voucherDate;

    public MassTransactionPostAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
    }

    public DataObject show(DataObject object) throws Exception {
        ProcessParameters pp;
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.transactionBatch = MassTransactionBP.getCurrentMassTransactionBatch(this.dbData, this.companyId);
        if (this.transactionBatch == null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "batch_not_found");
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.finish(object);
        }
        if (TransactionBO.getFirstTransaction(this.transactionBatch) == null) {
            object.addUIObject((UIObject)new Message(LanguageHelper.getString("nl.ibs.fac.language", "batch_is_empty"), "error"));
            return this.finish(object);
        }
        this.headerPanel = MassTransactionPanel.getHeaderPanel(this.transactionBatch);
        Action action = new Action("Button.Info").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showInfo");
        int procType = this.transactionBatch.getMassTransactionProcessType();
        if (procType == 4 || procType == 5 || procType == 6) {
            action.setEnabled(false);
        }
        MassTransactionPanel.addExtraInfoAction(action);
        if (this.transactionBatch.getMassTransactionProcessType() != 3 && (pp = (ProcessParameters)ProcessParametersBO.get(this.dbData, this.companyId)[0]).getStandardVoucherDate() == 5) {
            this.belgianWayOfLiving = true;
            return this.showWithAdditionalAttributes(object);
        }
        return this.submit(object);
    }

    public DataObject showWithAdditionalAttributes(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        MassTransactionPanel.addGridComponent((UIObject)new Label("Label.VoucherDate"), 2, 0);
        this.voucherDate = new DateSelectionField("");
        this.voucherDate.setValue(Calendar.getInstance().getTime());
        this.voucherDate.setMandatory(true);
        MassTransactionPanel.addGridComponent((UIObject)new Label("Label.VoucherId"), 3, 0);
        this.voucherNumber = new Field("", "number");
        this.voucherNumber.setLength(6);
        this.voucherNumber.setMaxLength(6);
        this.voucherNumber.setMandatory(true);
        MassTransactionPanel.addGridComponent((UIObject)this.voucherDate, 2, 2);
        MassTransactionPanel.addGridComponent((UIObject)this.voucherNumber, 3, 2);
        FloatBar floatBar = new FloatBar();
        Action submit = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("submit");
        submit.setValidationEnabled(true);
        submit.setDefault(true);
        floatBar.addAction(submit);
        floatBar.addAction(this.finish);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        object.addUIObject((UIObject)this.headerPanel);
        object.addUIObject((UIObject)floatBar);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        BookYearBO.synchronizeWithFinancials(this.loginHelper, this.env, this.company);
        if (this.belgianWayOfLiving) {
            this.transactionBatch.setVoucherId(this.voucherNumber.getValue());
            this.transactionBatch.setVoucherDate(this.voucherDate.getValueAsDate());
            this.voucherNumber.setMandatory(false);
            this.voucherNumber.setReadonly(true);
            this.voucherDate.setMandatory(false);
            this.voucherDate.setReadonly(true);
        }
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair("User", this.loginHelper.getUser()));
        list.add(new NameValuePair("System", this.loginHelper.getSystem()));
        list.add(new NameValuePair("Password", Scrambler.scramble((String)this.loginHelper.getPassword())));
        list.add(new NameValuePair("facLib", this.dbData.getSchema()));
        list.add(new NameValuePair("operationArea", this.env.getOperationArea().trim()));
        list.add(new NameValuePair("dataLib", this.env.getDataLib().trim()));
        list.add(new NameValuePair("programLib", this.env.getProgramLib().trim()));
        list.add(new NameValuePair("object_lib", StartStopServlet.getObjectLibrary().trim()));
        list.add(new NameValuePair("Environment", this.env.getId()));
        list.add(new NameValuePair("Company", this.companyId));
        list.add(new NameValuePair("BookYear", this.bookYear));
        list.add(new NameValuePair("governmentActivated", "" + this.governmentActivated));
        String[][] selections = NameValuePair.getStringArray(list);
        this.getProcess().setAttribute("title", (Object)TITLE);
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("className", (Object)CLASSNAME);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("header", (Object)this.headerPanel);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    public DataObject showInfo(DataObject object) throws Exception {
        TransactionBatch transactionBatch = MassTransactionBP.getCurrentMassTransactionBatch(this.dbData, this.companyId);
        Window window = new Window();
        window.setTop("10%");
        window.setRight("15%");
        window.setLabel("Title.Info");
        FieldGroup fg = MassTransactionPanel.getExtraBatchDetails(transactionBatch, false);
        if (transactionBatch.getMassTransactionProcessType() != 3) {
            fg.add((ESPGridLayout)new BookYearPeriodGrid("Label.FACStartPeriod", "" + transactionBatch.getEndYear(), "" + transactionBatch.getEndPeriod(), true));
            fg.add((ESPGridLayout)new BookYearPeriodGrid("Label.FinancialPeriod", "" + transactionBatch.getFinYear(), "" + transactionBatch.getFinPeriod(), true));
        }
        window.add(fg);
        object.addUIObject((UIObject)window);
        return object;
    }
}

