/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.InputComponent;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.OutputField;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.ReasonCodeEnum;
import nl.ibs.fac.adapters.AssetReferenceField;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.MassTransactionPanel;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.ReasonCodeImageTransformer;
import nl.ibs.fac.adapters.TransactionAdapter;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.queries.TransactionQuery;

public class MassTransactionUpdateAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 8324317237491232467L;
    public static final String PAGE = MassTransactionUpdateAdapter.class.getName();
    private String tableName = "";
    public static final String SHOWINTERNAL = "showInternal";
    private TransactionBatch transactionBatch;
    private Panel headerPanel;
    private TabbedPanel tabbedPanel;
    private Tab[] tabs = new Tab[4];
    private String[] tabTexts = new String[4];
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private int tableSize;
    private String[] names;
    private String[] namesDisplay;
    private String[] labels;
    private short[] sizes;
    private String[] types;
    private Transformer[] transformers;
    private boolean[] columnnowraps;
    private boolean[] sortable;
    private String[] searchNames;
    private String[] searchLabels;
    private Map<String, InputComponent> inputComponents = new HashMap<String, InputComponent>();
    private TransactionTableRowMethod transactionTableRowMethod = new TransactionTableRowMethod();
    private static final String DELETE_FORM = "confirmDelete";
    private static final String DELETE = "delete";
    private static final String REFRESH = "refresh";
    private FloatBar fbShow = new FloatBar();
    private Action refresh;
    private Action delete;
    private Action[] rowActions;
    private Action[] headerActions;
    private Company company;
    private Object[] transactions;
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();
    private static final String[] TOOLTIPS = new String[]{"Label.ReasonCode"};
    private static final ZeroBigDecimalToBlankTransformer DECIMALTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
    private static final String[] MOV_NAMES_DISPLAY = new String[]{"documentAndSequenceNumber", "assetId", "AssetDescription", "amount1", "amount2", "FACYearAndPeriod", "reasonCode"};
    private static final String[] COR_NAMES_DISPLAY = new String[]{"documentAndSequenceNumber", "assetId", "AssetDescription", "amount1", "amount2", "FACYearAndPeriod", "reasonCode"};
    private static final String[] REM_NAMES_DISPLAY = new String[]{"assetId", "AssetDescription", "amount1", "amount2", "FINYearAndPeriod", "FACYearAndPeriod", "reasonCode"};
    private static final String[] IMP_NAMES_DISPLAY = new String[]{"assetId", "AssetDescription", "amount1", "amount2", "amount3", "FACYearAndPeriod", "reasonCode"};
    private static final String[] WRT_NAMES_DISPLAY = new String[]{"documentAndSequenceNumber", "assetId", "AssetDescription", "amount1", "amount2", "FACYearAndPeriod", "reasonCode"};
    private String[] WRT_NAMES;
    private String[] WRT_LABELS;
    private short[] WRT_SIZES;
    private String[] WRT_TYPES;
    private Transformer[] WRT_TRANSFORMERS;
    private boolean[] WRT_COLUMNNOWRAPS;
    private boolean[] WRT_SORTABLE;
    private String[] WRT_SEARCH_NAMES;
    private String[] WRT_SEARCH_LABELS;
    private String[] MOV_NAMES;
    private String[] MOV_LABELS;
    private short[] MOV_SIZES;
    private String[] MOV_TYPES;
    private Transformer[] MOV_TRANSFORMERS;
    private boolean[] MOV_COLUMNNOWRAPS;
    private boolean[] MOV_SORTABLE;
    private String[] MOV_SEARCH_NAMES;
    private String[] MOV_SEARCH_LABELS;
    private String[] COR_NAMES;
    private String[] COR_LABELS;
    private short[] COR_SIZES;
    private String[] COR_TYPES;
    private Transformer[] COR_TRANSFORMERS;
    private boolean[] COR_COLUMNNOWRAPS;
    private boolean[] COR_SORTABLE;
    private String[] COR_SEARCH_NAMES;
    private String[] COR_SEARCH_LABELS;
    private String[] REM_NAMES;
    private String[] REM_LABELS;
    private short[] REM_SIZES;
    private String[] REM_TYPES;
    private Transformer[] REM_TRANSFORMERS;
    private boolean[] REM_COLUMNNOWRAPS;
    private boolean[] REM_SORTABLE;
    private String[] REM_SEARCH_NAMES;
    private String[] REM_SEARCH_LABELS;
    private String[] IMP_NAMES;
    private String[] IMP_LABELS;
    private short[] IMP_SIZES;
    private String[] IMP_TYPES;
    private Transformer[] IMP_TRANSFORMERS;
    private boolean[] IMP_COLUMNNOWRAPS;
    private boolean[] IMP_SORTABLE;
    private String[] IMP_SEARCH_NAMES;
    private String[] IMP_SEARCH_LABELS;

    public MassTransactionUpdateAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.tabTexts[0] = this.env.getAPShortName1();
        this.tabTexts[1] = this.env.getAPShortName2();
        this.tabTexts[2] = this.env.getAPShortName3();
        this.tabTexts[3] = this.env.getAPShortName4();
        this.initializeMOVTableSettings();
        this.initializeCORTableSettings();
        this.initializeREMTableSettings();
        this.initializeIMPTableSettings();
        this.initializeWRTTableSettings();
        this.refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        this.fbShow.addAction(this.refresh);
        this.delete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE_FORM);
        this.fbShow.addAction(this.delete);
        this.fbShow.addAction(this.finish);
        this.headerActions = new Action[]{this.refresh};
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(TransactionAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{details, this.delete};
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.transactionBatch = MassTransactionBP.getCurrentMassTransactionBatch(this.dbData, this.companyId);
        if (this.transactionBatch == null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "batch_not_found");
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.finish(object);
        }
        this.tableSize = 12;
        ComboBox comboBox = EnumHelper.createComboBox("Label.ReasonCode", ReasonCodeEnum.getCollection(), true);
        comboBox.removeOption(comboBox.getOptionByValue("52"));
        comboBox.setWidth("170");
        this.inputComponents.put("reasonCode", (InputComponent)comboBox);
        this.inputComponents.put("assetId", (InputComponent)new AssetReferenceField(this.company, null, null, true, false));
        if (this.transactionBatch.getMassTransactionProcessType() == 0) {
            this.tableName = "WRT_Table";
            this.names = this.WRT_NAMES;
            this.namesDisplay = WRT_NAMES_DISPLAY;
            this.labels = this.WRT_LABELS;
            this.sizes = this.WRT_SIZES;
            this.types = this.WRT_TYPES;
            this.transformers = this.WRT_TRANSFORMERS;
            this.columnnowraps = this.WRT_COLUMNNOWRAPS;
            this.sortable = this.WRT_SORTABLE;
            this.searchNames = this.WRT_SEARCH_NAMES;
            this.searchLabels = this.WRT_SEARCH_LABELS;
        } else if (this.transactionBatch.getMassTransactionProcessType() == 1) {
            this.tableName = "MOV_Table";
            this.names = this.MOV_NAMES;
            this.namesDisplay = MOV_NAMES_DISPLAY;
            this.labels = this.MOV_LABELS;
            this.sizes = this.MOV_SIZES;
            this.types = this.MOV_TYPES;
            this.transformers = this.MOV_TRANSFORMERS;
            this.columnnowraps = this.MOV_COLUMNNOWRAPS;
            this.sortable = this.MOV_SORTABLE;
            this.searchNames = this.MOV_SEARCH_NAMES;
            this.searchLabels = this.MOV_SEARCH_LABELS;
        } else if (this.transactionBatch.getMassTransactionProcessType() == 2) {
            this.tableName = "COR_Table";
            this.names = this.COR_NAMES;
            this.namesDisplay = COR_NAMES_DISPLAY;
            this.labels = this.COR_LABELS;
            this.sizes = this.COR_SIZES;
            this.types = this.COR_TYPES;
            this.transformers = this.COR_TRANSFORMERS;
            this.columnnowraps = this.COR_COLUMNNOWRAPS;
            this.sortable = this.COR_SORTABLE;
            this.searchNames = this.COR_SEARCH_NAMES;
            this.searchLabels = this.COR_SEARCH_LABELS;
        } else if (this.transactionBatch.getMassTransactionProcessType() == 3) {
            this.tableName = "REM_Table";
            this.names = this.REM_NAMES;
            this.namesDisplay = REM_NAMES_DISPLAY;
            this.labels = this.REM_LABELS;
            this.sizes = this.REM_SIZES;
            this.types = this.REM_TYPES;
            this.transformers = this.REM_TRANSFORMERS;
            this.columnnowraps = this.REM_COLUMNNOWRAPS;
            this.sortable = this.REM_SORTABLE;
            this.searchNames = this.REM_SEARCH_NAMES;
            this.searchLabels = this.REM_SEARCH_LABELS;
        } else {
            this.tableName = "IMP_Table";
            this.names = this.IMP_NAMES;
            this.namesDisplay = IMP_NAMES_DISPLAY;
            this.labels = this.IMP_LABELS;
            this.sizes = this.IMP_SIZES;
            this.types = this.IMP_TYPES;
            this.transformers = this.IMP_TRANSFORMERS;
            this.columnnowraps = this.IMP_COLUMNNOWRAPS;
            this.sortable = this.IMP_SORTABLE;
            this.searchNames = this.IMP_SEARCH_NAMES;
            this.searchLabels = this.IMP_SEARCH_LABELS;
        }
        this.headerPanel = MassTransactionPanel.getHeaderPanel(this.transactionBatch);
        Action action = new Action("Button.Info").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showInfo");
        int procType = this.transactionBatch.getMassTransactionProcessType();
        if (procType == 4 || procType == 5 || procType == 6) {
            action.setEnabled(false);
        }
        MassTransactionPanel.addExtraInfoAction(action);
        return this.refresh(object);
    }

    public DataObject showInternal(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.MassTransactionsUpdate", "screen_name"));
        object.addUIObject((UIObject)this.headerPanel);
        if (this.table == null) {
            this.tabbedPanel = new TabbedPanel();
            boolean setActiveTab = false;
            boolean activeTabSet = false;
            Tab activeTab = null;
            for (int i = 0; i < 4; ++i) {
                this.tabs[i] = new Tab(this.tabTexts[i]);
                TransactionQuery query = new TransactionQuery(this.dbData, this.transactionBatch, i + 1);
                Collection fetchedData = query.fetchData(null, null, null, 1);
                if (fetchedData != null && !fetchedData.isEmpty()) {
                    this.createTable(i + 1);
                    if (this.transactionBatch.getBatchCode() == 3) {
                        this.tabs[i].setLabel(this.translate("Label.Transactions"));
                    }
                    this.tabs[i].add((Panel)this.searchPanel);
                    this.tabs[i].add((Table)this.table);
                    setActiveTab = true;
                } else {
                    this.tabs[i].setHidden(true);
                }
                this.tabbedPanel.add(this.tabs[i]);
                if (activeTabSet || !setActiveTab) continue;
                activeTab = this.tabs[i];
                activeTabSet = true;
            }
            if (activeTab != null) {
                this.tabbedPanel.setActiveTab(activeTab);
            }
        }
        this.refresh.setHidden(this.table == null);
        this.delete.setHidden(this.table == null);
        object.addUIObject((UIObject)this.tabbedPanel);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject showInfo(DataObject object) throws Exception {
        TransactionBatch transactionBatch = MassTransactionBP.getCurrentMassTransactionBatch(this.dbData, this.companyId);
        Window window = new Window();
        window.setTop("10%");
        window.setRight("15%");
        window.setLabel("Title.Info");
        FieldGroup fg = MassTransactionPanel.getExtraBatchDetails(transactionBatch, false);
        if (transactionBatch.getMassTransactionProcessType() != 3) {
            fg.add((ESPGridLayout)new BookYearPeriodGrid("Label.FACStartPeriod", "" + transactionBatch.getEndYear(), "" + transactionBatch.getEndPeriod(), true));
            fg.add((ESPGridLayout)new BookYearPeriodGrid("Label.FinancialPeriod", "" + transactionBatch.getFinYear(), "" + transactionBatch.getFinPeriod(), true));
        }
        window.add(fg);
        object.addUIObject((UIObject)window);
        return object;
    }

    private void createTable(int accountingPrinciple) throws Exception {
        TransactionQuery query = new TransactionQuery(this.dbData, this.transactionBatch, accountingPrinciple);
        this.table = new ODBTable(Transaction.class, (ODBQuery)query, new String[]{"documentNr", "seqNr"}, this.tableSize);
        this.table.setName(this.tableName);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(this.names);
        if (this.namesDisplay != null) {
            this.table.setColumnsToDisplay(this.namesDisplay);
        }
        this.table.setColumnLabels(this.labels);
        this.table.setColumnSizes(this.sizes);
        this.table.setColumnTypes(this.types);
        this.table.setDisplayTransformers(this.transformers);
        this.table.setColumnNoWraps(this.columnnowraps);
        this.table.setColumnSortable(this.sortable);
        this.table.setInputComponents(this.inputComponents);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        TableHelper.createMenu((CommonTable)this.table, (Action[])this.headerActions, (Action[])this.rowActions, (TableRowMethod)this.transactionTableRowMethod);
        this.searchPanel = this.table.createSearch(this.searchNames, this.searchLabels);
        Action filterAction = this.table.createFilterAction(this.searchNames, this.searchLabels, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.transactions = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (this.transactions.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        FloatBar fbDelete = new FloatBar();
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE);
        fbDelete.addAction(deleteOK);
        fbDelete.addAction(this.back);
        fbDelete.addAction(this.finish);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteTransactions", "screen_name"));
        object.addUIObject((UIObject)this.headerPanel);
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.transactions.length);
        for (int i = 0; i < this.transactions.length; ++i) {
            list.add(this.transactions[i]);
        }
        CollectionTable table = new CollectionTable(Transaction.class, list, 12);
        table.setName(this.tableName);
        table.setColumnNames(this.names);
        table.setColumnLabels(this.labels);
        table.setColumnSizes(this.sizes);
        table.setColumnTypes(this.types);
        table.setDisplayTransformers(this.transformers);
        table.setColumnNoWraps(this.columnnowraps);
        table.setColumnSortable(this.sortable);
        table.setInputComponents(this.inputComponents);
        table.orderByColumn(this.names[0]);
        table.setSortable(true);
        table.reload();
        TableHelper.setHeaderTooltips((CommonTable)table, (String[])TOOLTIPS);
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        for (int i = 0; i < this.transactions.length; ++i) {
            Transaction transaction = (Transaction)this.transactions[i];
            if (transaction == null || (message = TransactionBO.delete(transaction, null, null)) == null) continue;
            object.addUIObject((UIObject)new Message(message, "error"));
        }
        if (message != null) {
            return object;
        }
        return this.refresh(object);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.showInternal(object);
    }

    private void initializeMOVTableSettings() throws Exception {
        if (this.env.getShortName5().trim().length() > 0) {
            this.MOV_NAMES = new String[]{"documentAndSequenceNumber", "assetId", "AssetDescription", "amount1", "amount2", "FACYearAndPeriod", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
            this.MOV_LABELS = new String[]{"Label.TransNbrShort", "Label.Asset", "Label.Description", "Label.Acquisition", "Label.Depreciation", "Label.Period", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5()};
            this.MOV_SIZES = new short[]{100, 120, 200, 120, 120, 80, 20, 200, 85, 85, 85, 85, 85};
            this.MOV_TYPES = new String[]{null, null, null, null, null, null, "text", null, null, null, null, null, null};
            this.MOV_TRANSFORMERS = new Transformer[]{null, null, null, DECIMALTRANSFORMER, DECIMALTRANSFORMER, null, new ReasonCodeImageTransformer(), null, null, null, null, null, null};
            if (this.env.getOperationArea().trim().length() == 0) {
                this.MOV_TRANSFORMERS[8] = this.numericIdTransformer;
                this.MOV_TRANSFORMERS[9] = this.numericIdTransformer;
                this.MOV_TRANSFORMERS[10] = this.numericIdTransformer;
                this.MOV_TRANSFORMERS[11] = this.numericIdTransformer;
                this.MOV_TRANSFORMERS[12] = this.numericIdTransformer;
            }
            this.MOV_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true};
            this.MOV_SORTABLE = new boolean[]{false, true, false, true, true, true, true, true, true, true, true, true, true};
            this.MOV_SEARCH_NAMES = new String[]{"documentNr", "assetId", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
            this.MOV_SEARCH_LABELS = new String[]{"Label.Transaction", "Label.Asset", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5()};
        } else {
            this.MOV_NAMES = new String[]{"documentAndSequenceNumber", "assetId", "AssetDescription", "amount1", "amount2", "FACYearAndPeriod", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4"};
            this.MOV_LABELS = new String[]{"Label.TransNbrShort", "Label.Asset", "Label.Description", "Label.Acquisition", "Label.Depreciation", "Label.Period", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4()};
            this.MOV_SIZES = new short[]{100, 120, 200, 120, 120, 80, 20, 200, 85, 85, 85, 85};
            this.MOV_TYPES = new String[]{null, null, null, null, null, null, "text", null, null, null, null, null};
            this.MOV_TRANSFORMERS = new Transformer[]{null, null, null, DECIMALTRANSFORMER, DECIMALTRANSFORMER, null, new ReasonCodeImageTransformer(), null, null, null, null, null};
            if (this.env.getOperationArea().trim().length() == 0) {
                this.MOV_TRANSFORMERS[8] = this.numericIdTransformer;
                this.MOV_TRANSFORMERS[9] = this.numericIdTransformer;
                this.MOV_TRANSFORMERS[10] = this.numericIdTransformer;
                this.MOV_TRANSFORMERS[11] = this.numericIdTransformer;
            }
            this.MOV_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true};
            this.MOV_SORTABLE = new boolean[]{false, true, false, true, true, true, true, true, true, true, true, true};
            this.MOV_SEARCH_NAMES = new String[]{"documentNr", "assetId", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4"};
            this.MOV_SEARCH_LABELS = new String[]{"Label.Transaction", "Label.Asset", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4()};
        }
    }

    private void initializeCORTableSettings() throws Exception {
        if (this.env.getShortName5().trim().length() > 0) {
            this.COR_NAMES = new String[]{"documentAndSequenceNumber", "assetId", "AssetDescription", "amount1", "amount2", "FACYearAndPeriod", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
            this.COR_LABELS = new String[]{"Label.TransNbrShort", "Label.Asset", "Label.Description", "Label.Acquisition", "Label.Depreciation", "Label.Period", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5()};
            this.COR_SIZES = new short[]{100, 120, 200, 120, 120, 80, 20, 200, 85, 85, 85, 85, 85};
            this.COR_TYPES = new String[]{null, null, null, null, null, null, "text", null, null, null, null, null, null};
            this.COR_TRANSFORMERS = new Transformer[]{null, null, null, DECIMALTRANSFORMER, DECIMALTRANSFORMER, null, new ReasonCodeImageTransformer(), null, null, null, null, null, null};
            if (this.env.getOperationArea().trim().length() == 0) {
                this.COR_TRANSFORMERS[8] = this.numericIdTransformer;
                this.COR_TRANSFORMERS[9] = this.numericIdTransformer;
                this.COR_TRANSFORMERS[10] = this.numericIdTransformer;
                this.COR_TRANSFORMERS[11] = this.numericIdTransformer;
                this.COR_TRANSFORMERS[12] = this.numericIdTransformer;
            }
            this.COR_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true};
            this.COR_SORTABLE = new boolean[]{false, true, false, true, true, true, true, true, true, true, true, true, true};
            this.COR_SEARCH_NAMES = new String[]{"documentNr", "assetId", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
            this.COR_SEARCH_LABELS = new String[]{"Label.Transaction", "Label.Asset", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5()};
        } else {
            this.COR_NAMES = new String[]{"documentAndSequenceNumber", "assetId", "AssetDescription", "amount1", "amount2", "FACYearAndPeriod", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4"};
            this.COR_LABELS = new String[]{"Label.TransNbrShort", "Label.Asset", "Label.Description", "Label.Acquisition", "Label.Depreciation", "Label.Period", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4()};
            this.COR_SIZES = new short[]{100, 120, 200, 120, 120, 80, 20, 200, 85, 85, 85, 85};
            this.COR_TYPES = new String[]{null, null, null, null, null, null, "text", null, null, null, null, null};
            this.COR_TRANSFORMERS = new Transformer[]{null, null, null, DECIMALTRANSFORMER, DECIMALTRANSFORMER, null, new ReasonCodeImageTransformer(), null, null, null, null, null};
            if (this.env.getOperationArea().trim().length() == 0) {
                this.COR_TRANSFORMERS[8] = this.numericIdTransformer;
                this.COR_TRANSFORMERS[9] = this.numericIdTransformer;
                this.COR_TRANSFORMERS[10] = this.numericIdTransformer;
                this.COR_TRANSFORMERS[11] = this.numericIdTransformer;
            }
            this.COR_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true};
            this.COR_SORTABLE = new boolean[]{false, true, false, true, true, true, true, true, true, true, true, true};
            this.COR_SEARCH_NAMES = new String[]{"documentNr", "assetId", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4"};
            this.COR_SEARCH_LABELS = new String[]{"Label.Transaction", "Label.Asset", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4()};
        }
    }

    private void initializeREMTableSettings() throws Exception {
        if (this.env.getShortName5().trim().length() > 0) {
            this.REM_NAMES = new String[]{"assetId", "AssetDescription", "amount1", "amount2", "FINYearAndPeriod", "FACYearAndPeriod", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
            this.REM_LABELS = new String[]{"Label.Asset", "Label.Description", "Label.Acquisition", "Label.Depreciation", "Label.PeriodFrom", "Label.PeriodTo", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5()};
            this.REM_SIZES = new short[]{100, 200, 120, 120, 100, 100, 20, 200, 85, 85, 85, 85, 85};
            this.REM_TYPES = new String[]{null, null, null, null, null, null, "text", null, null, null, null, null, null};
            this.REM_TRANSFORMERS = new Transformer[]{null, null, DECIMALTRANSFORMER, DECIMALTRANSFORMER, null, null, new ReasonCodeImageTransformer(), null, null, null, null, null, null};
            if (this.env.getOperationArea().trim().length() == 0) {
                this.REM_TRANSFORMERS[8] = this.numericIdTransformer;
                this.REM_TRANSFORMERS[9] = this.numericIdTransformer;
                this.REM_TRANSFORMERS[10] = this.numericIdTransformer;
                this.REM_TRANSFORMERS[11] = this.numericIdTransformer;
                this.REM_TRANSFORMERS[12] = this.numericIdTransformer;
            }
            this.REM_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true};
            this.REM_SORTABLE = new boolean[]{true, false, true, true, false, false, true, true, true, true, true, true, true};
            this.REM_SEARCH_NAMES = new String[]{"assetId", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
            this.REM_SEARCH_LABELS = new String[]{"Label.Asset", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5()};
        } else {
            this.REM_NAMES = new String[]{"assetId", "AssetDescription", "amount1", "amount2", "FINYearAndPeriod", "FACYearAndPeriod", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4"};
            this.REM_LABELS = new String[]{"Label.Asset", "Label.Description", "Label.Acquisition", "Label.Depreciation", "Label.PeriodFrom", "Label.PeriodTo", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4()};
            this.REM_SIZES = new short[]{100, 200, 120, 120, 100, 100, 20, 200, 85, 85, 85, 85};
            this.REM_TYPES = new String[]{null, null, null, null, null, null, "text", null, null, null, null, null};
            this.REM_TRANSFORMERS = new Transformer[]{null, null, DECIMALTRANSFORMER, DECIMALTRANSFORMER, null, null, new ReasonCodeImageTransformer(), null, null, null, null, null};
            if (this.env.getOperationArea().trim().length() == 0) {
                this.REM_TRANSFORMERS[8] = this.numericIdTransformer;
                this.REM_TRANSFORMERS[9] = this.numericIdTransformer;
                this.REM_TRANSFORMERS[10] = this.numericIdTransformer;
                this.REM_TRANSFORMERS[11] = this.numericIdTransformer;
            }
            this.REM_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true};
            this.REM_SORTABLE = new boolean[]{true, false, true, true, false, false, true, true, true, true, true, true};
            this.REM_SEARCH_NAMES = new String[]{"assetId", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4"};
            this.REM_SEARCH_LABELS = new String[]{"Label.Asset", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4()};
        }
    }

    private void initializeIMPTableSettings() throws Exception {
        if (this.env.getShortName5().trim().length() > 0) {
            this.IMP_NAMES = new String[]{"assetId", "AssetDescription", "amount1", "amount2", "amount3", "FACYearAndPeriod", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
            this.IMP_LABELS = new String[]{"Label.Asset", "Label.Description", "Label.Acquisition", "Label.Depreciation", "Label.Interest", "Label.Period", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5()};
            this.IMP_SIZES = new short[]{100, 200, 120, 120, 120, 100, 200, 85, 85, 85, 85, 85};
            this.IMP_TYPES = new String[]{null, null, null, null, null, null, null, null, null, null, null, null};
            this.IMP_TRANSFORMERS = new Transformer[]{null, null, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, null, null, null, null, null, null, null};
            if (this.env.getOperationArea().trim().length() == 0) {
                this.REM_TRANSFORMERS[7] = this.numericIdTransformer;
                this.REM_TRANSFORMERS[8] = this.numericIdTransformer;
                this.REM_TRANSFORMERS[9] = this.numericIdTransformer;
                this.REM_TRANSFORMERS[10] = this.numericIdTransformer;
                this.REM_TRANSFORMERS[11] = this.numericIdTransformer;
            }
            this.IMP_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true};
            this.IMP_SORTABLE = new boolean[]{true, false, true, true, false, false, true, true, true, true, true, true};
            this.IMP_SEARCH_NAMES = new String[]{"assetId", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
            this.IMP_SEARCH_LABELS = new String[]{"Label.Asset", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5()};
        } else {
            this.IMP_NAMES = new String[]{"assetId", "AssetDescription", "amount1", "amount2", "amount3", "FACYearAndPeriod", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4"};
            this.IMP_LABELS = new String[]{"Label.Asset", "Label.Description", "Label.Acquisition", "Label.Depreciation", "Label.Interest", "Label.Period", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4()};
            this.IMP_SIZES = new short[]{100, 200, 120, 120, 120, 100, 200, 85, 85, 85, 85};
            this.IMP_TYPES = new String[]{null, null, null, null, null, null, null, null, null, null, null};
            this.IMP_TRANSFORMERS = new Transformer[]{null, null, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, null, null, null, null, null, null};
            if (this.env.getOperationArea().trim().length() == 0) {
                this.REM_TRANSFORMERS[7] = this.numericIdTransformer;
                this.REM_TRANSFORMERS[8] = this.numericIdTransformer;
                this.REM_TRANSFORMERS[9] = this.numericIdTransformer;
                this.REM_TRANSFORMERS[10] = this.numericIdTransformer;
            }
            this.IMP_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true};
            this.IMP_SORTABLE = new boolean[]{true, false, true, true, false, false, true, true, true, true, true};
            this.IMP_SEARCH_NAMES = new String[]{"assetId", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4"};
            this.IMP_SEARCH_LABELS = new String[]{"Label.Asset", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4()};
        }
    }

    private void initializeWRTTableSettings() throws Exception {
        if (this.env.getShortName5().trim().length() > 0) {
            this.WRT_NAMES = new String[]{"documentAndSequenceNumber", "assetId", "AssetDescription", "amount1", "amount2", "FACYearAndPeriod", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
            this.WRT_LABELS = new String[]{"Label.TransNbrShort", "Label.Asset", "Label.Description", "Label.Acquisition", "Label.Depreciation", "Label.Period", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5()};
            this.WRT_SIZES = new short[]{100, 120, 200, 120, 120, 80, 20, 200, 85, 85, 85, 85, 85};
            this.WRT_TYPES = new String[]{null, null, null, null, null, null, "text", null, null, null, null, null, null};
            this.WRT_TRANSFORMERS = new Transformer[]{null, null, null, DECIMALTRANSFORMER, DECIMALTRANSFORMER, null, new ReasonCodeImageTransformer(), null, null, null, null, null, null};
            if (this.env.getOperationArea().trim().length() == 0) {
                this.WRT_TRANSFORMERS[8] = this.numericIdTransformer;
                this.WRT_TRANSFORMERS[9] = this.numericIdTransformer;
                this.WRT_TRANSFORMERS[10] = this.numericIdTransformer;
                this.WRT_TRANSFORMERS[11] = this.numericIdTransformer;
                this.WRT_TRANSFORMERS[12] = this.numericIdTransformer;
            }
            this.WRT_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true};
            this.WRT_SORTABLE = new boolean[]{false, true, false, true, true, true, true, true, true, true, true, true, true};
            this.WRT_SEARCH_NAMES = new String[]{"documentNr", "assetId", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
            this.WRT_SEARCH_LABELS = new String[]{"Label.Transaction", "Label.Asset", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5()};
        } else {
            this.WRT_NAMES = new String[]{"documentAndSequenceNumber", "assetId", "AssetDescription", "amount1", "amount2", "FACYearAndPeriod", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4"};
            this.WRT_LABELS = new String[]{"Label.TransNbrShort", "Label.Asset", "Label.Description", "Label.Acquisition", "Label.Depreciation", "Label.Period", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4()};
            this.WRT_SIZES = new short[]{100, 120, 200, 120, 120, 80, 20, 200, 85, 85, 85, 85};
            this.WRT_TYPES = new String[]{null, null, null, null, null, null, "text", null, null, null, null, null};
            this.WRT_TRANSFORMERS = new Transformer[]{null, null, null, DECIMALTRANSFORMER, DECIMALTRANSFORMER, null, new ReasonCodeImageTransformer(), null, null, null, null, null};
            if (this.env.getOperationArea().trim().length() == 0) {
                this.WRT_TRANSFORMERS[8] = this.numericIdTransformer;
                this.WRT_TRANSFORMERS[9] = this.numericIdTransformer;
                this.WRT_TRANSFORMERS[10] = this.numericIdTransformer;
                this.WRT_TRANSFORMERS[11] = this.numericIdTransformer;
            }
            this.WRT_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true};
            this.WRT_SORTABLE = new boolean[]{false, true, false, true, true, true, true, true, true, true, true, true};
            this.WRT_SEARCH_NAMES = new String[]{"documentNr", "assetId", "reasonCode", "description", "finDimId1", "finDimId2", "finDimId3", "finDimId4"};
            this.WRT_SEARCH_LABELS = new String[]{"Label.Transaction", "Label.Asset", "Label.ReasonCode", "Label.TransactionDescription", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4()};
        }
    }

    private class TransactionTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = -748776720413050958L;

        private TransactionTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            Transaction transaction = (Transaction)row.getObject();
            if (AssetBO.isIdNumeric(MassTransactionUpdateAdapter.this.company, "C".equals(transaction.getCora()))) {
                OutputField field = (OutputField)row.getUIOBjectByName(OutputField.class, "assetId");
                field.setValue((String)MassTransactionUpdateAdapter.this.numericIdTransformer.transform(transaction.getAssetId()));
                field.setType("number");
            }
            ContextMenu menu = new ContextMenu();
            for (int i = 0; i < rowActions.length; ++i) {
                if (rowActions[i] == null) continue;
                ContextAction rowAction = new ContextAction(rowActions[i].getName());
                rowAction.setAdapter(rowActions[i].getPageid());
                rowAction.setMethod(rowActions[i].getMethod());
                menu.addContextMenuItem(rowAction);
            }
            row.setContextMenu(menu);
        }
    }
}

