/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.TextArea;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.MemoBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.Memo;
import nl.ibs.fac.db.TotalEstimationTransaction;
import nl.ibs.fac.gov.boadapters.CreditBO;

public class MemoAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -3897447591251704096L;
    public static final String PAGE = MemoAdapter.class.getName();
    public static final String RETURNPAGE = "MemoAdapterReturnPage";
    public static final String TABLE = "Table";
    private boolean editable;
    private Company company;
    private Asset asset;
    private Credit credit;
    private TotalEstimationTransaction transaction;
    protected Window memoWindow;
    private Action deleteMemo;
    private ReferenceField idDesc = new ReferenceField("Label.Asset");
    private TextArea text = new TextArea();
    private Memo memo;

    public MemoAdapter(ESPProcess process, DataObject object, boolean editable) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.editable = editable;
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.createMemoWindow();
    }

    protected void createMemoWindow() throws Exception {
        if (this.editable) {
            this.memoWindow = new Window();
            this.memoWindow.setLabel("Title.EditMemo");
        } else {
            this.memoWindow = new Window();
            this.memoWindow.setLabel("Label.Memo");
        }
        this.memoWindow.setTop("10%");
        this.memoWindow.setRight("15%");
        Panel group = new Panel();
        this.idDesc.setReadonly(true);
        this.idDesc.setLength(10);
        this.idDesc.setDescriptionLength(50);
        group.addUIObject((UIObject)this.idDesc);
        this.text.setMandatory(true);
        this.text.setDiscardLabel(true);
        this.text.setHeight(12);
        this.text.setLength(100);
        this.text.setMaxLength(2048);
        if (!this.editable) {
            this.text.setReadonly(true);
        }
        group.addUIObject((UIObject)this.text);
        this.memoWindow.add(group);
        FloatBar bar = new FloatBar();
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("saveMemo");
        ok.setValidationEnabled(true);
        bar.addAction(ok);
        this.deleteMemo = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("deleteMemo");
        bar.addAction(this.deleteMemo);
        if (this.editable) {
            this.memoWindow.add(bar);
        }
    }

    public DataObject show(DataObject object) throws Exception {
        this.asset = null;
        this.credit = null;
        this.transaction = null;
        Object selectedItem = TableHelper.getSelectedItem((DataObject)object);
        if (selectedItem instanceof Asset) {
            this.asset = (Asset)selectedItem;
            this.idDesc.setValue(AssetBO.unFormatId(this.company, this.asset.getId(), false));
            this.idDesc.setDescription(this.asset.getDescription());
            this.memo = (Memo)MemoBO.get(this.asset)[0];
        }
        if (selectedItem instanceof Credit) {
            this.credit = (Credit)selectedItem;
            this.idDesc.setLabel("Label.Credit");
            this.idDesc.setValue(CreditBO.unFormatId(this.company, this.credit.getId()));
            this.idDesc.setDescription(this.credit.getDescription());
            this.memo = (Memo)MemoBO.get(this.credit)[0];
        }
        if (selectedItem instanceof TotalEstimationTransaction) {
            this.transaction = (TotalEstimationTransaction)selectedItem;
            this.idDesc.setLabel("Label.Transaction");
            this.idDesc.setValue("" + this.transaction.getInternalNumber());
            this.idDesc.setDescription(this.transaction.getDescription());
            this.memo = (Memo)MemoBO.get(this.transaction)[0];
        }
        if (this.memo != null) {
            this.text.setValueAsString(this.memo.getMemo());
            this.deleteMemo.setEnabled(true);
        } else {
            this.text.setValue();
            this.deleteMemo.setEnabled(false);
        }
        this.memoWindow.removeUIObjects(Message.class, false);
        object.addUIObject((UIObject)this.memoWindow);
        return object;
    }

    public DataObject saveMemo(DataObject object) throws Exception {
        String txt = this.text.getValue().trim();
        String message = null;
        if (this.memo == null) {
            Object[] result;
            if (this.asset != null) {
                result = MemoBO.create(this.asset, txt);
                message = (String)result[1];
            }
            if (this.credit != null) {
                result = MemoBO.create(this.credit, txt);
                message = (String)result[1];
            }
            if (this.transaction != null) {
                result = MemoBO.create(this.transaction, txt);
                message = (String)result[1];
            }
        } else {
            if (this.asset != null) {
                message = MemoBO.update(this.asset, this.memo, txt);
            }
            if (this.credit != null) {
                message = MemoBO.update(this.credit, this.memo, txt);
            }
            if (this.transaction != null) {
                message = MemoBO.update(this.transaction, this.memo, txt);
            }
        }
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        ODBTable table = (ODBTable)this.getProcess().getAttribute(TABLE);
        if (this.asset != null) {
            table.setPointer("id", (Object)this.asset.getId(), true);
        }
        if (this.credit != null) {
            table.setPointer("id", (Object)this.credit.getId(), true);
        }
        table.reload();
        return this.close(object);
    }

    public DataObject deleteMemo(DataObject object) throws Exception {
        String message = null;
        if (this.asset != null) {
            message = MemoBO.delete(this.asset, this.memo);
        }
        if (this.credit != null) {
            message = MemoBO.delete(this.credit, this.memo);
        }
        if (this.transaction != null) {
            message = MemoBO.delete(this.transaction, this.memo);
        }
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        ODBTable table = (ODBTable)this.getProcess().getAttribute(TABLE);
        if (this.asset != null) {
            table.setPointer("id", (Object)this.asset.getId(), true);
        }
        if (this.credit != null) {
            table.setPointer("id", (Object)this.credit.getId(), true);
        }
        table.reload();
        return this.close(object);
    }

    private DataObject close(DataObject object) throws Exception {
        this.memoWindow.closeWindow(object);
        if (this.transaction == null) {
            object.addUIObject((UIObject)new RedirectAction((String)this.getProcess().getAttribute(RETURNPAGE), "show", this.getProcess().getProcessId()));
        }
        return object;
    }
}

