/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.adapters.AssetDimensionPanels;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.FinancialDimensionHistoryBO;
import nl.ibs.fac.bp.MovementBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.FinancialDimensionHistory;

public class MovementAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -8114617457905075384L;
    public static final String PAGE = MovementAdapter.class.getName();
    public static final String RETURNPAGE = "MovementAdapterReturnPage";
    public static final String RETURNMETHOD = "MovementAdapterReturnMethod";
    private Company company;
    private AssetDimensionPanels panels;
    private FieldGroup finDimensionPanel;
    private BookYearPeriodGrid activationPeriod;
    private BookYearPeriodGrid financialBookPeriod;
    private FloatBar fbMove;
    private String[] originalIds = new String[5];
    private String[] originalDsc = new String[5];
    private String[] fids = new String[5];
    private String[] ids = new String[5];
    private String[] dsc = new String[5];
    private String[] historicalIds = new String[5];
    private int limitYear;
    private int limitPeriod;
    private Asset asset;
    private AssetType assetType;
    private Window window;
    private int movementBookYear;
    private int movementPeriod;
    private int financialYear;
    private int financialPeriod;
    private Field description = new Field("Label.Description");
    private MovementBP businessProcess;

    public MovementAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.businessProcess = new MovementBP(this.company, this.numberOfPeriods);
        this.panels = new AssetDimensionPanels(this.loginHelper, this.dbData, this.env, this.company, false);
        this.activationPeriod = new BookYearPeriodGrid("Label.FACStartPeriod", this.bookYear, this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.activationPeriod.setMandatory(true);
        this.financialBookPeriod = new BookYearPeriodGrid("Label.BookPeriod", false);
        Action movementOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("move");
        movementOK.setDefault(true);
        movementOK.setValidationEnabled(true);
        this.fbMove = new FloatBar();
        this.fbMove.addAction(movementOK);
        this.fbMove.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("close"));
    }

    public DataObject movementForm(DataObject object) throws Exception {
        this.asset = (Asset)this.getProcess().getAttribute("assetToMove");
        String message = this.businessProcess.hasNotPostedTransactions(this.asset);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        String[] yps = this.businessProcess.retrieveYearsAndPeriods(this.asset);
        this.activationPeriod.setValues(yps[0], yps[1]);
        this.financialBookPeriod.setValues(yps[2], yps[3]);
        this.assetType = (AssetType)this.getProcess().getAttribute("assetToMoveAssetType");
        this.finDimensionPanel = this.panels.initializeFINDimensionPanel(this.asset, this.assetType, null, null);
        this.limitYear = 0;
        this.limitPeriod = 0;
        this.saveOriginalValues();
        FieldGroup fgMove = new FieldGroup();
        fgMove.add((ESPGridLayout)this.activationPeriod);
        fgMove.add((ESPGridLayout)this.financialBookPeriod);
        ESPGridLayout grid = new ESPGridLayout();
        grid.setColumnWidths(new short[]{198, 0});
        grid.setPaddingBottom(0);
        grid.setPaddingTop(0);
        Label label = new Label("Label.Description");
        grid.add((UIObject)label, 0, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.description.setDiscardLabel(true);
        this.description.setValue();
        this.description.setLength(30);
        this.description.setMaxLength(30);
        grid.add((UIObject)this.description, 0, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        fgMove.add(grid);
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "close");
        this.window.setLabel("Title.EditFinancialDimensions");
        this.window.setTop("10%");
        this.window.setRight("15%");
        this.window.add(this.finDimensionPanel);
        this.window.add(fgMove);
        this.window.add(this.fbMove);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject move(DataObject object) throws Exception {
        this.panels.validateDimensionForm();
        boolean error = this.validateForMove(object);
        if (error) {
            return object;
        }
        String message = this.businessProcess.move(this.asset, this.movementBookYear, this.movementPeriod, this.financialYear, this.financialPeriod, this.fids, this.description.getValue().trim(), this.loginHelper.getUser(), this.limitYear, this.limitPeriod, -1, 0);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.getProcess().setAttribute("NewFinDimIds", (Object)this.ids);
        this.getProcess().setAttribute("NewFinDimDescriptions", (Object)this.dsc);
        return this.close(object);
    }

    private boolean validateForMove(DataObject object) throws Exception {
        FinancialDimensionHistory historicalDimensions;
        boolean error = false;
        String[] errors = null;
        this.movementBookYear = this.activationPeriod.getBookYear().getIntValue();
        this.movementPeriod = this.activationPeriod.getPeriod().getIntValue();
        errors = this.businessProcess.validateFACYearAndPeriod(this.asset, this.movementBookYear, this.movementPeriod);
        if (errors != null) {
            error = true;
            this.addErrors(object, errors);
            this.activationPeriod.setInvalidTag();
        }
        this.financialYear = this.financialBookPeriod.getBookYear().getIntValue();
        this.financialPeriod = this.financialBookPeriod.getPeriod().getIntValue();
        errors = this.businessProcess.validateFINYearAndPeriod(this.financialYear, this.financialPeriod, Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax));
        if (errors != null) {
            error = true;
            this.addErrors(object, errors);
            this.financialBookPeriod.setInvalidTag();
        }
        for (int i = 0; i < 5; ++i) {
            this.fids[i] = "";
            this.ids[i] = "";
            this.dsc[i] = "";
        }
        if (this.panels.financialDimension[0] != null) {
            this.fillUpArrays(this.panels.financialDimension[0], 0);
        }
        if (this.panels.financialDimension[1] != null) {
            this.fillUpArrays(this.panels.financialDimension[1], 1);
        }
        if (this.panels.financialDimension[2] != null) {
            this.fillUpArrays(this.panels.financialDimension[2], 2);
        }
        if (this.panels.financialDimension[3] != null) {
            this.fillUpArrays(this.panels.financialDimension[3], 3);
        }
        if (this.panels.financialDimension[4] != null) {
            this.fillUpArrays(this.panels.financialDimension[4], 4);
        }
        boolean dimensionsChanged = false;
        int changeCounter = 0;
        int changeIndex = 9;
        for (int i = 0; i < 5; ++i) {
            if (this.originalIds[i].equals(this.ids[i])) continue;
            dimensionsChanged = true;
            ++changeCounter;
            changeIndex = i;
        }
        if (!dimensionsChanged && PeriodHelper.isBefore(this.movementBookYear, this.movementPeriod, this.asset.getFinDimYearFrom(), this.asset.getFinDimPeriodFrom()) && (historicalDimensions = FinancialDimensionHistoryBO.getLast(this.asset, this.movementBookYear, this.movementPeriod)) != null) {
            this.historicalIds[0] = historicalDimensions.getFinDimId1();
            this.historicalIds[1] = historicalDimensions.getFinDimId2();
            this.historicalIds[2] = historicalDimensions.getFinDimId3();
            this.historicalIds[3] = historicalDimensions.getFinDimId4();
            this.historicalIds[4] = historicalDimensions.getFinDimId5();
            for (int i = 0; i < 5; ++i) {
                if (this.historicalIds[i].equals(this.fids[i])) continue;
                dimensionsChanged = true;
                ++changeCounter;
                changeIndex = i;
                this.limitYear = this.asset.getFinDimYearFrom();
                this.limitPeriod = this.asset.getFinDimPeriodFrom();
            }
        }
        if (!dimensionsChanged) {
            object.addUIObject((UIObject)new Message("NoDimensionsionsChanged", "error"));
            error = true;
        }
        if (!error && this.description.getValue().trim().equals("")) {
            if (changeCounter > 1) {
                this.description.setValue(object.translate("Label.MiscDimsChanged", object.getLocale()));
            } else {
                this.description.setValue(object.translate("Label.Change.short", object.getLocale()) + " " + this.panels.finTexts[changeIndex]);
            }
        }
        return error;
    }

    private void addErrors(DataObject object, String[] errors) throws Exception {
        for (int i = 0; i < errors.length; ++i) {
            if (errors[i] == null || errors[i].trim().length() <= 0) continue;
            object.addUIObject((UIObject)new Message(errors[i], "error"));
        }
    }

    private void saveOriginalValues() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.originalIds[i] = "";
        }
        if (this.panels.financialDimension[0] != null) {
            this.originalIds[0] = this.panels.financialDimension[0].getValue();
            this.originalDsc[0] = this.panels.financialDimension[0].getDescription();
        }
        if (this.panels.financialDimension[1] != null) {
            this.originalIds[1] = this.panels.financialDimension[1].getValue();
            this.originalDsc[1] = this.panels.financialDimension[1].getDescription();
        }
        if (this.panels.financialDimension[2] != null) {
            this.originalIds[2] = this.panels.financialDimension[2].getValue();
            this.originalDsc[2] = this.panels.financialDimension[2].getDescription();
        }
        if (this.panels.financialDimension[3] != null) {
            this.originalIds[3] = this.panels.financialDimension[3].getValue();
            this.originalDsc[4] = this.panels.financialDimension[3].getDescription();
        }
        if (this.panels.financialDimension[4] != null) {
            this.originalIds[4] = this.panels.financialDimension[4].getValue();
            this.originalDsc[4] = this.panels.financialDimension[4].getDescription();
        }
    }

    private void fillUpArrays(FinancialReferenceField financialDimension, int index) throws Exception {
        this.fids[index] = financialDimension.getFormattedId();
        this.ids[index] = financialDimension.getValue().trim();
        this.dsc[index] = financialDimension.getDescription().trim();
    }

    public DataObject close(DataObject object) throws Exception {
        this.window.closeWindow(object);
        object.addUIObject((UIObject)new RedirectAction(this.getProcess().getAttribute(RETURNPAGE).toString(), this.getProcess().getAttribute(RETURNMETHOD).toString(), this.getProcess().getProcessId()));
        return object;
    }
}

