/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FormattedField;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.UserErrorMessage;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.queries.AssetQuery;

public class ParentReferenceField
extends ODBQueryReferenceField
implements FormattedField {
    private static final long serialVersionUID = 8429229144404438836L;
    private static final String[] NAMES = new String[]{"id", "description"};
    private String[] labels = new String[]{"Label.ParentAsset", "Label.Description"};
    private static final short[] SIZES = new short[]{100, 500};
    private Transformer transformer = null;
    private Company company;
    private boolean credit;
    private Asset parentAsset;

    public ParentReferenceField(Company company, boolean credit) throws Exception {
        super("", "upper", (ODBQuery)new AssetQuery(company.getDBData(), company.getId(), new Boolean(true), new Boolean(false), false, null, false, credit), Asset.class);
        this.company = company;
        this.credit = credit;
        this.setName(((Object)((Object)this)).getClass().getName());
        if (credit) {
            this.labels[0] = "Label.ParentCredit";
        }
        this.setLabel(this.labels[0]);
        this.setHelpId(this.labels[0]);
        this.setTableFields(NAMES);
        this.setTableHeaderLabels(this.labels);
        this.setValueField(NAMES[0]);
        this.setDescriptionField(NAMES[1]);
        this.setTableKeys(new String[]{NAMES[0]});
        this.setTableHeaderSizes(SIZES);
        this.setLength(10);
        this.setMaxLength(10);
        this.setDescriptionLength(40);
        this.setSearchFields(NAMES);
        this.setSearchFieldLabels(this.labels);
        if (AssetBO.isIdNumeric(company, credit)) {
            this.setType("number");
            this.setTableColumnTypes(new String[]{"number", null});
            this.transformer = new NumericIdTransformer();
            this.setTableTransformers(new Transformer[]{this.transformer, null});
        }
    }

    protected boolean selectedValueExecuteHook(DataObject object) {
        Asset asset = (Asset)this.getSelectedObject();
        try {
            if (this.transformer != null) {
                this.setValue((String)this.transformer.transform((Object)asset.getId()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public Field setValue(Asset parent) throws Exception {
        if (parent == null) {
            this.setValue();
            this.setDescription("");
            this.parentAsset = null;
            return this;
        }
        this.setDescription(parent.getDescription());
        String value = parent.getId();
        if (this.transformer != null) {
            return super.setValue((String)this.transformer.transform((Object)value));
        }
        return super.setValue(value);
    }

    public void validate() throws Exception {
        super.validate();
        if (this.getValue().trim().length() == 0) {
            this.setDescription("");
            return;
        }
        Object[] result = AssetBO.get(this.company, this.getValue().trim(), this.credit);
        if (result[1] != null) {
            this.setInvalidTag();
            throw new UserErrorMessage((String)result[1]);
        }
        this.parentAsset = (Asset)result[0];
        if (this.parentAsset.getSubAsset()) {
            this.setInvalidTag();
            if (this.credit) {
                throw new UserErrorMessage("Credit_is_not_a_parentCredit");
            }
            throw new UserErrorMessage("Asset_is_not_a_parentAsset");
        }
        this.setDescription(this.parentAsset.getDescription());
    }

    public Asset getParentAsset() {
        return this.parentAsset;
    }

    public String getFormattedId() throws Exception {
        return AssetBO.formatId(this.company, this.getValue(), this.credit);
    }
}

