/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigInteger;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.CalendarYearCorrectionEnum;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.VoucherDateHandlingEnum;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.ProcessParametersBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.ProcessParameters;

public class ProcessParametersAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 1823568004316955323L;
    public static final String PAGE = ProcessParametersAdapter.class.getName();
    public static final String RETURNPAGE = "ProcessParametersAdapterReturnPage";
    public static final String RETURNMETHOD = "ProcessParametersAdapterReturnMethod";
    private Company company;
    private ProcessParameters parameters;
    private Window window;
    private TabbedPanel tabbedPanel;
    private CheckBox chbDefaultValueInBookPeriod = new CheckBox("Label.FillBookPeriodBeforehand");
    private CheckBox chbJournalizeCurrentAssets = new CheckBox("Label.JournalizeCurrentAssets");
    private CheckBox chbDifferentAcquisitionValueForAP2 = new CheckBox("Label.DifferentAcquisitionValueForAP2");
    private CheckBox chbAutoUpdateBlockedPeriods = new CheckBox("Label.AutomaticUpdateBlockedPeriods");
    private CheckBox chbUse445Correction = new CheckBox("Label.Use445Correction");
    private CheckBox chbDepreciateBeyondEconomicLife = new CheckBox("Label.DepreciateBeyondEconomicLife");
    private CheckBox chbTestCompany = new CheckBox("Label.RemovalSustained");
    private CheckBox chbUseCorrectionCodeDC = new CheckBox("Label.UseCorrectionCodeDC");
    private ComboBox cobStandardVoucherDate;
    private FieldGroup fgGovernment;
    private CheckBox chbBookValueRegistration = new CheckBox("Label.BookValueRegistration", false);
    private VoucherDateHandlingChangeAction voucherDateHandlingChangeAction;
    private VoucherDateHandlingChangeActionDIR voucherDateHandlingChangeActionDIR;
    private CheckBox chbWarningForDifferentType = new CheckBox("Label.WarningDifferentMainAccounts");
    private CheckBox chbWarningForDifferentDimensions = new CheckBox("Label.WarningDifferentDimensions");
    private CheckBox chbAutoConfirmIFT = new CheckBox("Label.AutomaticConfirmation");
    private CheckBox chbAssetIdInDescription = new CheckBox("Label.AssetIdInDescription");
    private CheckBox chbAssetDescriptionInDescription = new CheckBox("Label.AssetDescriptionInDescription");
    private ComboBox cobVoucherDateIFTT;
    private CheckBox chbUseRCTableForMOV_IC = new CheckBox("Label.UseRCTableForMOV_IC");
    private CheckBox chbSummarizeOnKey = new CheckBox("Label.SummarizeFinancialTransactions");
    private CheckBox chbFullInterestIn1stPeriod = new CheckBox("Label.FullInterestInFirstPeriod");
    private ComboBox cobVoucherDateDIR;
    private NumberField startMonth = new NumberField("Label.DifferentStartPeriod", 2, true);
    private ComboBox calendarYearCorrection;
    FieldGroup floatBar = new FieldGroup();

    public ProcessParametersAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.tabbedPanel = new TabbedPanel();
        Tab tab1 = new Tab("Label.Common");
        Tab tab2 = new Tab("Label.AllocataIFTs");
        Tab tab3 = new Tab("Label.PeriodicalDepreciationAndInterest");
        this.tabbedPanel.add(tab1);
        this.tabbedPanel.add(tab2);
        this.tabbedPanel.add(tab3);
        FieldGroup fg1 = new FieldGroup();
        FieldGroup fg2 = new FieldGroup();
        FieldGroup fg3 = new FieldGroup();
        fg1.forceBorder(false);
        fg2.forceBorder(false);
        fg3.forceBorder(false);
        this.fgGovernment = new FieldGroup("Gem. overheid");
        tab1.add(fg1);
        tab1.add(this.fgGovernment);
        tab2.add(fg2);
        tab3.add(fg3);
        fg1.add(this.chbTestCompany);
        fg1.add(this.chbDefaultValueInBookPeriod);
        fg1.add(this.chbJournalizeCurrentAssets);
        fg1.add(this.chbUseRCTableForMOV_IC);
        fg1.add(this.chbDifferentAcquisitionValueForAP2);
        fg1.add(this.chbUseCorrectionCodeDC);
        fg1.add(this.chbAssetDescriptionInDescription);
        this.cobStandardVoucherDate = EnumHelper.createComboBox("Label.VoucherDate", VoucherDateHandlingEnum.getCollection(), false);
        this.cobStandardVoucherDate.removeOption(this.cobStandardVoucherDate.getOptionByValue("0"));
        this.cobStandardVoucherDate.removeOption(this.cobStandardVoucherDate.getOptionByValue("3"));
        this.cobStandardVoucherDate.removeOption(this.cobStandardVoucherDate.getOptionByValue("4"));
        if (this.env != null && this.env.getOperationArea().length() == 0) {
            this.voucherDateHandlingChangeAction = new VoucherDateHandlingChangeAction();
            this.cobStandardVoucherDate.add((Action)this.voucherDateHandlingChangeAction);
        } else {
            this.cobStandardVoucherDate.removeOption(this.cobStandardVoucherDate.getOptionByValue("5"));
        }
        fg1.add(this.cobStandardVoucherDate);
        this.fgGovernment.add(this.chbBookValueRegistration);
        fg2.add(this.chbWarningForDifferentType);
        fg2.add(this.chbAutoConfirmIFT);
        fg2.add(this.chbAssetIdInDescription);
        this.cobVoucherDateIFTT = EnumHelper.createComboBox("Label.VoucherDate", VoucherDateHandlingEnum.getCollection(), false);
        this.cobVoucherDateIFTT.removeOption(this.cobVoucherDateIFTT.getOptionByValue("1"));
        this.cobVoucherDateIFTT.removeOption(this.cobVoucherDateIFTT.getOptionByValue("2"));
        this.cobVoucherDateIFTT.removeOption(this.cobVoucherDateIFTT.getOptionByValue("4"));
        this.cobVoucherDateIFTT.removeOption(this.cobVoucherDateIFTT.getOptionByValue("5"));
        fg2.add(this.cobVoucherDateIFTT);
        fg3.add(this.chbUse445Correction);
        fg3.add(this.chbDepreciateBeyondEconomicLife);
        fg3.add(this.chbAutoUpdateBlockedPeriods);
        fg3.add(this.chbSummarizeOnKey);
        fg3.add(this.chbFullInterestIn1stPeriod);
        this.cobVoucherDateDIR = EnumHelper.createComboBox("Label.VoucherDate", VoucherDateHandlingEnum.getCollection(), false);
        this.cobVoucherDateDIR.removeOption(this.cobVoucherDateDIR.getOptionByValue("1"));
        this.cobVoucherDateDIR.removeOption(this.cobVoucherDateDIR.getOptionByValue("2"));
        this.cobVoucherDateDIR.removeOption(this.cobVoucherDateDIR.getOptionByValue("3"));
        this.cobVoucherDateDIR.removeOption(this.cobVoucherDateDIR.getOptionByValue("5"));
        this.voucherDateHandlingChangeActionDIR = new VoucherDateHandlingChangeActionDIR();
        this.cobVoucherDateDIR.add((Action)this.voucherDateHandlingChangeActionDIR);
        fg3.add(this.cobVoucherDateDIR);
        this.startMonth.setMinValue(new BigInteger("0"), true);
        this.startMonth.setMaxValue(new BigInteger("12"), true);
        fg3.add((Field)this.startMonth);
        this.calendarYearCorrection = EnumHelper.createComboBox("Label.CalendarYearCorrection", CalendarYearCorrectionEnum.getCollection(), true);
        fg3.add(this.calendarYearCorrection);
        FloatBar fb = new FloatBar();
        Action ok = new Action("Button.OK", null, null, this.getProcessAdapterPageName(PAGE), "update");
        ok.setDefault(true);
        ok.setValidationEnabled(true);
        fb.addAction(ok);
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("close"));
        this.floatBar.forceBorder(false);
        this.floatBar.add(fb);
    }

    public DataObject show(DataObject object) throws Exception {
        String companyId = (String)object.getSessionAttribute("ActiveCompany");
        this.company = (Company)CompanyBO.get(this.dbData, companyId)[0];
        this.parameters = (ProcessParameters)ProcessParametersBO.get(this.dbData, companyId)[0];
        if (!this.governmentActivated) {
            this.fgGovernment.setHidden(true);
        } else {
            this.chbBookValueRegistration.setValue(this.parameters.getGLBookValueRegistration());
        }
        this.chbTestCompany.setValue(this.parameters.getIsTestCompany());
        this.chbDefaultValueInBookPeriod.setValue(this.parameters.getDefaultValueInBookPeriod());
        this.chbJournalizeCurrentAssets.setValue(this.parameters.getJournalizeCurrentAssets());
        if (this.company.getAccountingPrinciple2Usage() != 0) {
            this.chbDifferentAcquisitionValueForAP2.setValue(this.parameters.getUseDifferentAcquisitionValues());
            this.chbDifferentAcquisitionValueForAP2.setHidden(false);
        } else {
            this.chbDifferentAcquisitionValueForAP2.setValue(false);
            this.chbDifferentAcquisitionValueForAP2.setHidden(true);
        }
        if (!this.governmentActivated && this.company.getNumberOfPeriods() == 12) {
            this.chbUse445Correction.setValue(this.parameters.getUse445Correction());
        } else {
            this.chbUse445Correction.setValue(false);
            this.chbUse445Correction.setHidden(true);
        }
        this.chbAutoUpdateBlockedPeriods.setValue(this.parameters.getAutoUpdateBlockedPeriods());
        this.chbUseCorrectionCodeDC.setValue(this.parameters.getUseCorrectionCodeDC());
        this.cobStandardVoucherDate.setSelectedOptionValue("" + this.parameters.getStandardVoucherDate());
        this.chbWarningForDifferentType.setValue(this.parameters.getWarningForDifferentType());
        this.chbWarningForDifferentDimensions.setValue(this.parameters.getWarningForDifferentDimensions());
        this.chbAutoConfirmIFT.setValue(this.parameters.getAutoConfirmIFT());
        this.chbAssetIdInDescription.setValue(this.parameters.getAssetIdInDescription());
        this.chbAssetDescriptionInDescription.setValue(this.parameters.getAssetDescriptionInDescription());
        this.cobVoucherDateIFTT.setSelectedOptionValue("" + this.parameters.getVoucherDateIFTT());
        this.chbUseRCTableForMOV_IC.setValue(this.parameters.getUseRCTableForMOVIC());
        this.chbFullInterestIn1stPeriod.setValue(this.parameters.getFullInterestIn1stPeriod());
        if (!this.governmentActivated) {
            this.chbDepreciateBeyondEconomicLife.setValue(this.parameters.getDepreciateBeyondEconomicLife());
        } else {
            this.chbDepreciateBeyondEconomicLife.setValue(false);
            this.chbDepreciateBeyondEconomicLife.setHidden(true);
        }
        this.chbSummarizeOnKey.setValue(this.parameters.getSummarizeOnKey());
        if (this.company.getNumberOfPeriods() == 12) {
            this.cobVoucherDateDIR.setSelectedOptionValue("" + this.parameters.getVoucherDateDIR());
            this.startMonth.setValue((long)this.parameters.getStartMonth());
            if (this.parameters.getCalendarYearCorrection() > 0) {
                this.calendarYearCorrection.setSelectedOptionValue("" + this.parameters.getCalendarYearCorrection());
            } else {
                this.calendarYearCorrection.setSelectedOptionValue("");
            }
            this.cobVoucherDateDIR.setReadonly(false);
            this.startMonth.setHidden(false);
            this.calendarYearCorrection.setHidden(false);
        } else {
            this.cobVoucherDateDIR.setReadonly(true);
            this.startMonth.setHidden(true);
            this.calendarYearCorrection.setHidden(true);
        }
        if (this.env.getOperationArea().length() == 0) {
            this.voucherDateHandlingChangeAction.execute(object);
        }
        this.voucherDateHandlingChangeActionDIR.execute(object);
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "close");
        this.window.setLabel("Label.ProcessProperties");
        Panel panel = new Panel();
        this.tabbedPanel.setActiveTab(0);
        panel.addUIObject((UIObject)this.tabbedPanel);
        this.window.add(panel);
        this.window.add(this.floatBar);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject update(DataObject object) throws Exception {
        int yearCorrection = 0;
        if ("" != this.calendarYearCorrection.getSelectedOptionValue()) {
            yearCorrection = Integer.parseInt(this.calendarYearCorrection.getSelectedOptionValue());
        }
        ProcessParametersBO.update(this.dbData, this.parameters, this.chbDefaultValueInBookPeriod.getValueAsBoolean(), this.chbJournalizeCurrentAssets.getValueAsBoolean(), this.chbAutoUpdateBlockedPeriods.getValueAsBoolean(), this.chbUseCorrectionCodeDC.getValueAsBoolean(), Integer.parseInt(this.cobStandardVoucherDate.getSelectedOptionValue()), this.chbWarningForDifferentType.getValueAsBoolean(), this.chbWarningForDifferentDimensions.getValueAsBoolean(), this.chbAutoConfirmIFT.getValueAsBoolean(), this.chbAssetIdInDescription.getValueAsBoolean(), Integer.parseInt(this.cobVoucherDateIFTT.getSelectedOptionValue()), this.chbSummarizeOnKey.getValueAsBoolean(), Integer.parseInt(this.cobVoucherDateDIR.getSelectedOptionValue()), this.startMonth.getIntValue(), this.chbFullInterestIn1stPeriod.getValueAsBoolean(), this.chbDifferentAcquisitionValueForAP2.getValueAsBoolean(), yearCorrection, this.chbUseRCTableForMOV_IC.getValueAsBoolean(), this.chbUse445Correction.getValueAsBoolean(), this.chbTestCompany.getValueAsBoolean(), this.chbDepreciateBeyondEconomicLife.getValueAsBoolean(), this.chbAssetDescriptionInDescription.getValueAsBoolean());
        if (this.governmentActivated) {
            ProcessParameters pp = this.company.getProcessParameters();
            pp.setGLBookValueRegistration(this.chbBookValueRegistration.getValueAsBoolean());
        }
        return this.close(object);
    }

    public DataObject close(DataObject object) throws Exception {
        this.window.closeWindow(object);
        object.addUIObject((UIObject)new RedirectAction((String)this.getProcess().getAttribute(RETURNPAGE), (String)this.getProcess().getAttribute(RETURNMETHOD), this.getProcess().getProcessId()));
        return object;
    }

    private class VoucherDateHandlingChangeActionDIR
    extends Action {
        private static final long serialVersionUID = 6006175016869032809L;

        public boolean execute(DataObject dataObject) throws Exception {
            if ("4".equals(ProcessParametersAdapter.this.cobVoucherDateDIR.getValue())) {
                ProcessParametersAdapter.this.startMonth.setHidden(false);
                ProcessParametersAdapter.this.calendarYearCorrection.setHidden(false);
                return true;
            }
            ProcessParametersAdapter.this.startMonth.setValue("0");
            ProcessParametersAdapter.this.startMonth.setHidden(true);
            ProcessParametersAdapter.this.calendarYearCorrection.setSelectedOptionValue("");
            ProcessParametersAdapter.this.calendarYearCorrection.setHidden(true);
            return true;
        }
    }

    private class VoucherDateHandlingChangeAction
    extends Action {
        private static final long serialVersionUID = 6006175016869032809L;

        public boolean execute(DataObject dataObject) throws Exception {
            if ("5".equals(ProcessParametersAdapter.this.cobStandardVoucherDate.getValue())) {
                ProcessParametersAdapter.this.cobVoucherDateIFTT.setSelectedOptionValue("0");
                ProcessParametersAdapter.this.cobVoucherDateIFTT.setReadonly(true);
                ProcessParametersAdapter.this.cobVoucherDateDIR.setSelectedOptionValue("0");
                ProcessParametersAdapter.this.cobVoucherDateDIR.setReadonly(true);
                ProcessParametersAdapter.this.voucherDateHandlingChangeActionDIR.execute(dataObject);
                return true;
            }
            ProcessParametersAdapter.this.cobVoucherDateIFTT.setReadonly(false);
            if (ProcessParametersAdapter.this.company.getNumberOfPeriods() == 12) {
                ProcessParametersAdapter.this.cobVoucherDateDIR.setReadonly(false);
            }
            ProcessParametersAdapter.this.voucherDateHandlingChangeActionDIR.execute(dataObject);
            return true;
        }
    }
}

